/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.ApplicationKt;
import app.termora.I18n;
import app.termora.NativeStringComparator;
import app.termora.sftp.FileSystemViewTableModel;
import app.termora.sftp.NativeFileIcons;
import com.formdev.flatlaf.util.SystemInfo;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001c0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0014\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\fH\u0016J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010)R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lapp/termora/sftp/FileSystemViewTableModel;", "Ljavax/swing/table/DefaultTableModel;", "<init>", "()V", "value", "", "hasParent", "getHasParent", "()Z", "getValueAt", "", "row", "", "column", "getFileType", "", "file", "Lorg/apache/commons/vfs2/FileObject;", "getFileIcon", "Ljavax/swing/Icon;", "width", "height", "getLastModifiedTime", "getAttrs", "getFilePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "getDataVector", "Ljava/util/Vector;", "getColumnCount", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "getFileObject", "getPathNames", "getColumnName", "isCellEditable", "reload", "", "dir", "useFileHiding", "(Lorg/apache/commons/vfs2/FileObject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "termora"})
public final class FileSystemViewTableModel
extends DefaultTableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasParent;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_FILE_SIZE = 2;
    public static final int COLUMN_LAST_MODIFIED_TIME = 3;
    public static final int COLUMN_ATTRS = 4;
    public static final int COLUMN_OWNER = 5;
    private static final Logger log = LoggerFactory.getLogger(FileSystemViewTableModel.class);

    public final boolean getHasParent() {
        return this.hasParent;
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        FileObject file = this.getFileObject(row);
        boolean isParentRow = this.hasParent && row == 0;
        try {
            if (file.getType() == FileType.IMAGINARY) {
                return "";
            }
            String string = switch (column) {
                case 0 -> {
                    if (isParentRow) {
                        yield "..";
                    }
                    yield file.getName().getBaseName();
                }
                case 2 -> {
                    if (isParentRow || file.isFolder()) {
                        yield "";
                    }
                    yield ApplicationKt.formatBytes(file.getContent().getSize());
                }
                case 1 -> {
                    if (isParentRow) {
                        yield "";
                    }
                    yield this.getFileType(file);
                }
                case 3 -> {
                    if (isParentRow) {
                        yield "";
                    }
                    yield this.getLastModifiedTime(file);
                }
                case 4 -> {
                    if (isParentRow) {
                        yield "";
                    }
                    yield this.getAttrs(file);
                }
                case 5 -> "";
                default -> "";
            };
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        catch (Exception e) {
            if (file.getFileSystem() instanceof LocalFileSystem && ExceptionUtils.getRootCause((Throwable)e) instanceof NoSuchFileException) {
                SwingUtilities.invokeLater(() -> FileSystemViewTableModel.getValueAt$lambda$0(this, row));
                return "";
            }
            if (log.isWarnEnabled()) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            return "";
        }
    }

    private final String getFileType(FileObject file) {
        String string;
        if (SystemInfo.isWindows) {
            String string2 = file.getName().getBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBaseName(...)");
            string = (String)NativeFileIcons.getIcon$default(NativeFileIcons.INSTANCE, string2, file.isFile(), 0, 0, 12, null).getSecond();
        } else if (file.isSymbolicLink()) {
            string = I18n.INSTANCE.getString("termora.transport.table.type.symbolic-link");
        } else {
            String string3 = file.getName().getBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getBaseName(...)");
            string = (String)NativeFileIcons.getIcon$default(NativeFileIcons.INSTANCE, string3, file.isFile(), 0, 0, 12, null).getSecond();
        }
        return string;
    }

    @NotNull
    public final Icon getFileIcon(@NotNull FileObject file, int width, int height) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (SystemInfo.isWindows) {
            String string = file.getName().getBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
            icon = (Icon)NativeFileIcons.INSTANCE.getIcon(string, file.isFile(), width, height).getFirst();
        } else {
            String string = file.getName().getBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
            icon = (Icon)NativeFileIcons.getIcon$default(NativeFileIcons.INSTANCE, string, file.isFile(), 0, 0, 12, null).getFirst();
        }
        return icon;
    }

    public static /* synthetic */ Icon getFileIcon$default(FileSystemViewTableModel fileSystemViewTableModel, FileObject fileObject, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 16;
        }
        if ((n3 & 4) != 0) {
            n2 = 16;
        }
        return fileSystemViewTableModel.getFileIcon(fileObject, n, n2);
    }

    @NotNull
    public final Icon getFileIcon(int row) {
        return FileSystemViewTableModel.getFileIcon$default(this, this.getFileObject(row), 0, 0, 6, null);
    }

    @NotNull
    public final String getLastModifiedTime(@NotNull FileObject file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getContent().getLastModifiedTime() < 1L) {
            return "-";
        }
        String string = DateFormatUtils.format((Date)new Date(file.getContent().getLastModifiedTime()), (String)"yyyy/MM/dd HH:mm");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String getAttrs(FileObject file) {
        if (file.getFileSystem() instanceof LocalFileSystem) {
            return "";
        }
        String string = PosixFilePermissions.toString(this.getFilePermissions(file));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Set<PosixFilePermission> getFilePermissions(@NotNull FileObject file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = (Integer)file.getContent().getAttribute("PosixFilePermissions");
        if (n == null) {
            return SetsKt.emptySet();
        }
        int permissions = n;
        return Companion.fromSftpPermissions(permissions);
    }

    @NotNull
    public Vector<Vector<Object>> getDataVector() {
        Vector<Vector<Object>> vector = super.getDataVector();
        Intrinsics.checkNotNullExpressionValue(vector, (String)"getDataVector(...)");
        return vector;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        Class clazz;
        if (columnIndex == 0) {
            clazz = String.class;
        } else {
            Class<?> clazz2 = super.getColumnClass(columnIndex);
            clazz = clazz2;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"getColumnClass(...)");
        }
        return clazz;
    }

    @NotNull
    public final FileObject getFileObject(int row) {
        Object object = super.getValueAt(row, 0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.commons.vfs2.FileObject");
        return (FileObject)object;
    }

    @NotNull
    public final Set<String> getPathNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = this.hasParent && i == 0 ? names.add("..") : names.add(this.getFileObject(i).getName().getBaseName());
        }
        return names;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return switch (column) {
            case 0 -> I18n.INSTANCE.getString("termora.transport.table.filename");
            case 2 -> I18n.INSTANCE.getString("termora.transport.table.size");
            case 1 -> I18n.INSTANCE.getString("termora.transport.table.type");
            case 3 -> I18n.INSTANCE.getString("termora.transport.table.modified-time");
            case 4 -> I18n.INSTANCE.getString("termora.transport.table.permissions");
            case 5 -> I18n.INSTANCE.getString("termora.transport.table.owner");
            default -> "";
        };
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reload(@NotNull FileObject var1_1, boolean var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof reload.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FileSystemViewTableModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reload(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (FileSystemViewTableModel.log.isDebugEnabled()) {
                    FileSystemViewTableModel.log.debug("Reloading {} , useFileHiding {}", (Object)dir, (Object)Boxing.boxBoolean((boolean)(useFileHiding != false)));
                }
                files = new ArrayList<E>();
                $continuation.L$0 = dir;
                $continuation.L$1 = files;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dir, useFileHiding != false, (List<FileObject>)files, null){
                    int label;
                    final /* synthetic */ FileObject $dir;
                    final /* synthetic */ boolean $useFileHiding;
                    final /* synthetic */ List<FileObject> $files;
                    {
                        this.$dir = $dir;
                        this.$useFileHiding = $useFileHiding;
                        this.$files = $files;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$dir.refresh();
                                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.$dir.getChildren());
                                while (iterator2.hasNext()) {
                                    FileObject file = (FileObject)iterator2.next();
                                    if (this.$useFileHiding && file.isHidden()) continue;
                                    Intrinsics.checkNotNull((Object)file);
                                    this.$files.add(file);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                files = (List)$continuation.L$1;
                dir = (FileObject)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = ((Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        FileObject it = (FileObject)a;
                        boolean bl = false;
                        boolean bl2 = !it.isFolder();
                        it = (FileObject)b;
                        Comparable comparable = Boolean.valueOf(bl2);
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.isFolder()));
                    }
                }).thenComparing((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, reload$lambda$3(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)I)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, reload$lambda$2(org.apache.commons.vfs2.FileObject org.apache.commons.vfs2.FileObject ), (Lorg/apache/commons/vfs2/FileObject;Lorg/apache/commons/vfs2/FileObject;)Ljava/lang/Integer;)()));
                Intrinsics.checkNotNullExpressionValue(v1, (String)"thenComparing(...)");
                CollectionsKt.sortWith((List)files, v1);
                v2 = this.hasParent = dir.getParent() != null;
                if (this.hasParent) {
                    files.addFirst(dir.getParent());
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<FileObject>)files, null){
                    int label;
                    final /* synthetic */ FileSystemViewTableModel this$0;
                    final /* synthetic */ List<FileObject> $files;
                    {
                        this.this$0 = $receiver;
                        this.$files = $files;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$forEach$iv;
                                ResultKt.throwOnFailure((Object)object);
                                while (this.this$0.getRowCount() > 0) {
                                    this.this$0.removeRow(0);
                                }
                                Iterable iterable = this.$files;
                                FileSystemViewTableModel fileSystemViewTableModel = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    FileObject it = (FileObject)element$iv;
                                    boolean bl = false;
                                    Object[] objectArray = new FileObject[]{it};
                                    fileSystemViewTableModel.addRow(objectArray);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void getValueAt$lambda$0(FileSystemViewTableModel this$0, int $row) {
        this$0.removeRow($row);
    }

    private static final int reload$lambda$2(FileObject a, FileObject b) {
        NativeStringComparator nativeStringComparator = NativeStringComparator.Companion.getInstance();
        String string = a.getName().getBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        String string2 = b.getName().getBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBaseName(...)");
        return nativeStringComparator.compare(string, string2);
    }

    private static final int reload$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/sftp/FileSystemViewTableModel$Companion;", "", "<init>", "()V", "COLUMN_NAME", "", "COLUMN_TYPE", "COLUMN_FILE_SIZE", "COLUMN_LAST_MODIFIED_TIME", "COLUMN_ATTRS", "COLUMN_OWNER", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "fromSftpPermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "sftpPermissions", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<PosixFilePermission> fromSftpPermissions(int sftpPermissions) {
            Set result = new LinkedHashSet();
            String string = Integer.toString(sftpPermissions, CharsKt.checkRadix((int)8));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String octalPermissions = string;
            if (octalPermissions.length() < 3) {
                return result;
            }
            String permissionBits = StringsKt.takeLast((String)octalPermissions, (int)3);
            int owner = CharsKt.digitToInt((char)permissionBits.charAt(0));
            int group = CharsKt.digitToInt((char)permissionBits.charAt(1));
            int others = CharsKt.digitToInt((char)permissionBits.charAt(2));
            if ((owner & 4) != 0) {
                result.add(PosixFilePermission.OWNER_READ);
            }
            if ((owner & 2) != 0) {
                result.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((owner & 1) != 0) {
                result.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((group & 4) != 0) {
                result.add(PosixFilePermission.GROUP_READ);
            }
            if ((group & 2) != 0) {
                result.add(PosixFilePermission.GROUP_WRITE);
            }
            if ((group & 1) != 0) {
                result.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if ((others & 4) != 0) {
                result.add(PosixFilePermission.OTHERS_READ);
            }
            if ((others & 2) != 0) {
                result.add(PosixFilePermission.OTHERS_WRITE);
            }
            if ((others & 1) != 0) {
                result.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

