/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Application;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.TermoraFrameKt;
import app.termora.actions.AnActionEvent;
import app.termora.sftp.FileSystemProvider;
import app.termora.sftp.FileSystemViewPanel;
import app.termora.sftp.FileSystemViewTable;
import app.termora.sftp.FileSystemViewTableModel;
import app.termora.sftp.PosixFilePermissionDialog;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPKitKt;
import app.termora.sftp.SFTPPanel;
import app.termora.sftp.Transport;
import app.termora.sftp.TransportListener;
import app.termora.sftp.TransportManager;
import app.termora.sftp.TransportStatus;
import app.termora.vfs2.VFSWalker;
import app.termora.vfs2.sftp.MySftpFileObject;
import app.termora.vfs2.sftp.MySftpFileSystem;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.sshd.client.session.ClientSession;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 ]2\u00020\u00012\u00020\u0002:\u0003]^_B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020'H\u0002J\u0016\u00102\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002J\u0018\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002052\u0006\u00108\u001a\u000205H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:042\u0006\u0010;\u001a\u00020:H\u0002J\u0010\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020>H\u0002J \u0010?\u001a\u00020'2\f\u0010@\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0002\u0010A\u001a\u00020>H\u0002J \u0010B\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0002\u0010A\u001a\u00020>H\u0002J\u0016\u0010C\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002J8\u0010D\u001a\u00020'2\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\b\b\u0002\u0010E\u001a\u00020>2\n\b\u0002\u0010F\u001a\u0004\u0018\u0001052\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u0002052\u0006\u0010K\u001a\u000205H\u0002J6\u0010L\u001a\u00020'2\u0006\u0010/\u001a\u0002052\u0006\u0010M\u001a\u00020N2\u0006\u0010E\u001a\u00020>2\b\u0010F\u001a\u0004\u0018\u0001052\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u001dH\u0002J\u001e\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u0002052\f\u0010R\u001a\b\u0012\u0004\u0012\u0002050SH\u0002J4\u0010T\u001a\u00020>2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010U\u001a\u0004\u0018\u0001052\u0006\u0010G\u001a\u00020\u001d2\b\u0010F\u001a\u0004\u0018\u0001052\u0006\u0010V\u001a\u00020WH\u0002J \u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u0002052\u0006\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020\\H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\fR\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\n \u0015*\u0004\u0018\u00010!0!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lapp/termora/sftp/FileSystemViewTable;", "Ljavax/swing/JTable;", "Lapp/termora/Disposable;", "fileSystemProvider", "Lapp/termora/sftp/FileSystemProvider;", "transportManager", "Lapp/termora/sftp/TransportManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lapp/termora/sftp/FileSystemProvider;Lapp/termora/sftp/TransportManager;Lkotlinx/coroutines/CoroutineScope;)V", "sftp", "Lapp/termora/Database$SFTP;", "Lapp/termora/Database;", "getSftp", "()Lapp/termora/Database$SFTP;", "model", "Lapp/termora/sftp/FileSystemViewTableModel;", "table", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "sftpPanel", "Lapp/termora/sftp/SFTPPanel;", "getSftpPanel", "()Lapp/termora/sftp/SFTPPanel;", "fileSystemViewPanel", "Lapp/termora/sftp/FileSystemViewPanel;", "getFileSystemViewPanel", "()Lapp/termora/sftp/FileSystemViewPanel;", "actionManager", "Lorg/jdesktop/swingx/action/ActionManager;", "getActionManager", "()Lorg/jdesktop/swingx/action/ActionManager;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initViews", "", "initEvents", "showContextMenu", "rows", "", "e", "Ljava/awt/event/MouseEvent;", "changePermission", "file", "Lapp/termora/vfs2/sftp/MySftpFileObject;", "renameSelection", "editFiles", "files", "", "Lorg/apache/commons/vfs2/FileObject;", "listenFileChange", "localPath", "remotePath", "parseCommand", "", "command", "newFolderOrFile", "isFile", "", "deletePaths", "paths", "rm", "deleteSftpPaths", "deleteRecursively", "transfer", "fromLocalSystem", "targetWorkdir", "target", "askTransfer", "Lapp/termora/sftp/FileSystemViewTable$AskTransfer;", "sourceFile", "targetFile", "doTransfer", "action", "Lapp/termora/sftp/FileSystemViewTable$AskTransfer$Action;", "walk", "Ljava/nio/file/FileVisitResult;", "dir", "visitor", "Ljava/nio/file/FileVisitor;", "addTransport", "sourceWorkdir", "transport", "Lapp/termora/sftp/Transport;", "createTransport", "source", "isDirectory", "parentId", "", "Companion", "AskTransfer", "FileSystemTableRowTransferable", "termora"})
@SourceDebugExtension(value={"SMAP\nFileSystemViewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemViewTable.kt\napp/termora/sftp/FileSystemViewTable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1013:1\n11258#2:1014\n11593#2,3:1015\n1740#3,3:1018\n1563#3:1022\n1634#3,3:1023\n1869#3,2:1026\n1#4:1021\n*S KotlinDebug\n*F\n+ 1 FileSystemViewTable.kt\napp/termora/sftp/FileSystemViewTable\n*L\n277#1:1014\n277#1:1015,3\n291#1:1018,3\n697#1:1022\n697#1:1023,3\n369#1:1026,2\n*E\n"})
public final class FileSystemViewTable
extends JTable
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemProvider fileSystemProvider;
    @NotNull
    private final TransportManager transportManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FileSystemViewTableModel model;
    @NotNull
    private final FileSystemViewTable table;
    @NotNull
    private final AtomicBoolean isDisposed;
    private static final Logger log = LoggerFactory.getLogger(FileSystemViewTable.class);

    public FileSystemViewTable(@NotNull FileSystemProvider fileSystemProvider, @NotNull TransportManager transportManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        Intrinsics.checkNotNullParameter((Object)transportManager, (String)"transportManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileSystemProvider = fileSystemProvider;
        this.transportManager = transportManager;
        this.coroutineScope = coroutineScope;
        this.model = new FileSystemViewTableModel();
        this.table = this;
        this.isDisposed = new AtomicBoolean(false);
        this.initViews();
        this.initEvents();
    }

    private final Database.SFTP getSftp() {
        return Database.Companion.getDatabase().getSftp();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final SFTPPanel getSftpPanel() {
        Container container = SwingUtilities.getAncestorOfClass(SFTPPanel.class, this);
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type app.termora.sftp.SFTPPanel");
        return (SFTPPanel)container;
    }

    private final FileSystemViewPanel getFileSystemViewPanel() {
        Container container = SwingUtilities.getAncestorOfClass(FileSystemViewPanel.class, this);
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type app.termora.sftp.FileSystemViewPanel");
        return (FileSystemViewPanel)container;
    }

    private final ActionManager getActionManager() {
        return ActionManager.getInstance();
    }

    private final void initViews() {
        super.setModel(this.model);
        super.getTableHeader().setReorderingAllowed(false);
        super.setDragEnabled(true);
        super.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        super.setCellSelectionEnabled(false);
        super.setRowSelectionAllowed(true);
        super.setRowHeight(UIManager.getInt("Table.rowHeight"));
        super.setAutoResizeMode(0);
        super.setFillsViewportHeight(true);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"showHorizontalLines", (Object)true), TuplesKt.to((Object)"showVerticalLines", (Object)true), TuplesKt.to((Object)"cellMargins", (Object)new Insets(0, 4, 0, 4))};
        super.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])pairArray));
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setForeground(null);
                Component c2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(column == 0 ? FileSystemViewTable.access$getModel$p(this.this$0).getFileIcon(row) : null);
                this.setForeground(!isSelected && FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(row).isHidden() ? UIManager.getColor("textInactiveText") : this.getForeground());
                Intrinsics.checkNotNull((Object)c2);
                return c2;
            }
        });
        this.columnModel.getColumn(0).setPreferredWidth(250);
        this.columnModel.getColumn(3).setPreferredWidth(130);
    }

    private final void initEvents() {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isRightMouseButton(e)) {
                    int r = FileSystemViewTable.access$getTable$p(this.this$0).rowAtPoint(e.getPoint());
                    if (r >= 0 && r < FileSystemViewTable.access$getTable$p(this.this$0).getRowCount()) {
                        if (!FileSystemViewTable.access$getTable$p(this.this$0).isRowSelected(r)) {
                            FileSystemViewTable.access$getTable$p(this.this$0).setRowSelectionInterval(r, r);
                        }
                    } else {
                        FileSystemViewTable.access$getTable$p(this.this$0).clearSelection();
                    }
                    int[] rows = FileSystemViewTable.access$getTable$p(this.this$0).getSelectedRows();
                    if (!FileSystemViewTable.access$getTable$p(this.this$0).hasFocus()) {
                        FileSystemViewTable.access$getTable$p(this.this$0).requestFocusInWindow();
                    }
                    Intrinsics.checkNotNull((Object)rows);
                    FileSystemViewTable.access$showContextMenu(this.this$0, ArraysKt.sortedArray((int[])rows), e);
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    int row = FileSystemViewTable.access$getTable$p(this.this$0).getSelectedRow();
                    if (row <= 0 || row >= FileSystemViewTable.access$getTable$p(this.this$0).getRowCount()) {
                        return;
                    }
                    FileObject file = FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(row);
                    if (file.isFolder()) {
                        return;
                    }
                    FileSystemViewTable.transfer$default(this.this$0, CollectionsKt.listOf((Object)file), false, null, null, 14, null);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SystemInfo.isMacOS && e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int[] rows = this.this$0.getSelectedRows();
                    Intrinsics.checkNotNull((Object)rows);
                    if (ArraysKt.contains((int[])rows, (int)0)) {
                        return;
                    }
                    int[] nArray = rows;
                    FileSystemViewTable fileSystemViewTable = this.this$0;
                    boolean $i$f$map = false;
                    void var7_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(FileSystemViewTable.access$getModel$p(fileSystemViewTable).getFileObject((int)it));
                    }
                    List files = (List)destination$iv$iv;
                    FileSystemViewTable.access$deletePaths(this.this$0, files, false);
                } else if (!SystemInfo.isMacOS && e.getKeyCode() == 116) {
                    FileSystemViewTable.access$getFileSystemViewPanel(this.this$0).reload(true);
                } else if (!SystemInfo.isMacOS && e.getKeyCode() == 113) {
                    FileSystemViewTable.access$renameSelection(this.this$0);
                }
            }
        });
        this.table.setTransferHandler(new TransferHandler(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean canImport(TransferHandler.TransferSupport support) {
                Intrinsics.checkNotNullParameter((Object)support, (String)"support");
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                JTable.DropLocation dropLocation2 = dropLocation instanceof JTable.DropLocation ? (JTable.DropLocation)dropLocation : null;
                if (dropLocation2 == null) {
                    return false;
                }
                JTable.DropLocation dropLocation3 = dropLocation2;
                if (!dropLocation3.isInsertRow() && dropLocation3.getColumn() != 0) {
                    return false;
                }
                if (!dropLocation3.isInsertRow() && FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(dropLocation3.getRow()).isFile()) {
                    return false;
                }
                if (!dropLocation3.isInsertRow() && FileSystemViewTable.access$getModel$p(this.this$0).getHasParent() && dropLocation3.getRow() == 0) {
                    return false;
                }
                if (support.isDataFlavorSupported(FileSystemTableRowTransferable.Companion.getDataFlavor())) {
                    Object data = support.getTransferable().getTransferData(FileSystemTableRowTransferable.Companion.getDataFlavor());
                    return data instanceof FileSystemTableRowTransferable && !Intrinsics.areEqual((Object)((FileSystemTableRowTransferable)data).getSource(), (Object)FileSystemViewTable.access$getTable$p(this.this$0));
                }
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return !(FileSystemViewTable.access$getFileSystemProvider$p(this.this$0).getFileSystem() instanceof LocalFileSystem);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean importData(TransferHandler.TransferSupport support) {
                Intrinsics.checkNotNullParameter((Object)support, (String)"support");
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                JTable.DropLocation dropLocation2 = dropLocation instanceof JTable.DropLocation ? (JTable.DropLocation)dropLocation : null;
                if (dropLocation2 == null) {
                    return false;
                }
                JTable.DropLocation dropLocation3 = dropLocation2;
                if (!dropLocation3.isInsertRow() && dropLocation3.getColumn() != 0) {
                    return false;
                }
                if (!dropLocation3.isInsertRow() && FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(dropLocation3.getRow()).isFile()) {
                    return false;
                }
                FileObject targetWorkdir = null;
                if (!dropLocation3.isInsertRow()) {
                    targetWorkdir = FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(dropLocation3.getRow());
                }
                if (support.isDataFlavorSupported(FileSystemTableRowTransferable.Companion.getDataFlavor())) {
                    Object data = support.getTransferable().getTransferData(FileSystemTableRowTransferable.Companion.getDataFlavor());
                    if (!(data instanceof FileSystemTableRowTransferable)) {
                        return false;
                    }
                    FileSystemViewTable.transfer$default(((FileSystemTableRowTransferable)data).getSource(), ((FileSystemTableRowTransferable)data).getFiles(), false, targetWorkdir, null, 8, null);
                    return true;
                }
                if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Object object = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                    List files = (List)object;
                    if (files.isEmpty()) {
                        return false;
                    }
                    Iterable $this$filterIsInstance$iv = files;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof File)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        File file = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(VFS.getManager().resolveFile(it.toURI()));
                    }
                    List paths = (List)destination$iv$iv;
                    if (paths.isEmpty()) {
                        return false;
                    }
                    FileSystemViewPanel localTarget = FileSystemViewTable.access$getSftpPanel(this.this$0).getLocalTarget();
                    FileSystemViewTable fileSystemViewTable = localTarget.getData(SFTPDataProviders.INSTANCE.getFileSystemViewTable());
                    if (fileSystemViewTable == null) {
                        return false;
                    }
                    FileSystemViewTable table = fileSystemViewTable;
                    FileSystemViewTable.access$transfer(table, paths, true, targetWorkdir, FileSystemViewTable.access$getFileSystemViewPanel(this.this$0));
                    return true;
                }
                return false;
            }

            public int getSourceActions(JComponent c2) {
                return 1;
            }

            /*
             * WARNING - void declaration
             */
            protected Transferable createTransferable(JComponent c2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int it;
                void $this$filterTo$iv$iv;
                int[] nArray = FileSystemViewTable.access$getTable$p(this.this$0).getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                Object $this$filter$iv = nArray;
                boolean $i$f$filter = false;
                int[] nArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    it = element$iv$iv;
                    boolean bl = false;
                    if (!(it != 0)) continue;
                    destination$iv$iv.add((int)element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                FileSystemViewTable fileSystemViewTable = this.this$0;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(FileSystemViewTable.access$getModel$p(fileSystemViewTable).getFileObject(it));
                }
                List files = (List)destination$iv$iv2;
                if (files.isEmpty()) {
                    return null;
                }
                return new FileSystemTableRowTransferable(FileSystemViewTable.access$getTable$p(this.this$0), files);
            }
        });
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                int row;
                int i;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                char c2 = e.getKeyChar();
                int count = FileSystemViewTable.access$getModel$p(this.this$0).getRowCount();
                for (i = row = this.this$0.getSelectedRow() + 1; i < count; ++i) {
                    if (!this.navigate(i, c2)) continue;
                    return;
                }
                for (i = 0; i < count; ++i) {
                    if (!this.navigate(i, c2)) continue;
                    return;
                }
            }

            private final boolean navigate(int row, char c2) {
                String name = FileSystemViewTable.access$getModel$p(this.this$0).getFileObject(row).getName().getBaseName();
                Intrinsics.checkNotNull((Object)name);
                if (StringsKt.startsWith((CharSequence)name, (char)c2, (boolean)true)) {
                    this.this$0.clearSelection();
                    this.this$0.addRowSelectionInterval(row, row);
                    FileSystemViewTable.access$getTable$p(this.this$0).scrollRectToVisible(FileSystemViewTable.access$getTable$p(this.this$0).getCellRect(row, 0, true));
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final void showContextMenu(int[] rows, MouseEvent e) {
        block10: {
            $this$map$iv = rows;
            $i$f$map = false;
            var6_7 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            var10_13 = ((void)$this$mapTo$iv$iv).length;
            for (var9_11 = 0; var9_11 < var10_13; ++var9_11) {
                var12_17 = item$iv$iv = $this$mapTo$iv$iv[var9_11];
                var18_23 = destination$iv$iv;
                $i$a$-map-FileSystemViewTable$showContextMenu$files$1 = false;
                var18_23.add(this.model.getFileObject((int)it));
            }
            files = (List)destination$iv$iv;
            hasParent = ArraysKt.contains((int[])rows, (int)0);
            fileSystem = this.fileSystemProvider.getFileSystem();
            popupMenu = new FlatPopupMenu();
            newMenu = new JMenu(I18n.INSTANCE.getString("termora.transport.table.contextmenu.new"));
            newFolder = newMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.new.folder"));
            newFile = newMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.new.file"));
            transfer = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.transfer"));
            edit = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.edit"));
            v0 = edit;
            if (!(fileSystem instanceof MySftpFileSystem)) ** GOTO lbl-1000
            it = files;
            var18_23 = v0;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v1 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (FileObject)element$iv;
                    $i$a$-all-FileSystemViewTable$showContextMenu$1 = false;
                    if (it.isFile()) continue;
                    v1 = false;
                    break block10;
                }
                v1 = true;
            }
        }
        var19_30 = v1;
        v0 = var18_23;
        if (var19_30) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.setEnabled(v2);
        popupMenu.addSeparator();
        copyPath = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.copy-path"));
        if (fileSystem instanceof LocalFileSystem) {
            $i$f$all = new Object[]{SystemInfo.isMacOS != false ? I18n.INSTANCE.getString("termora.finder") : (SystemInfo.isWindows != false ? I18n.INSTANCE.getString("termora.explorer") : I18n.INSTANCE.getString("termora.folder"))};
            popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.open-in-folder", $i$f$all)).addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, showContextMenu$lambda$2(java.util.List java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((List)files));
        }
        popupMenu.addSeparator();
        rename = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.rename"));
        delete = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.delete"));
        rmrf = popupMenu.add(new JMenuItem("rm -rf", (Icon)Icons.INSTANCE.getWarningIntroduction()));
        rmrf.setVisible(fileSystem instanceof MySftpFileSystem);
        permission = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.change-permissions"));
        permission.setEnabled(false);
        if (fileSystem instanceof MySftpFileSystem && rows.length == 0 == false) {
            permission.setEnabled(true);
        }
        popupMenu.addSeparator();
        refresh = popupMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.refresh"));
        popupMenu.add(refresh);
        popupMenu.addSeparator();
        popupMenu.add((JMenuItem)newMenu);
        newFolder.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewTable.access$newFolderOrFile(this.this$0, false);
            }
        });
        newFile.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewTable.access$newFolderOrFile(this.this$0, true);
            }
        });
        rename.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewTable.access$renameSelection(this.this$0);
            }
        });
        delete.addActionListener(new AbstractAction(this, files){
            final /* synthetic */ FileSystemViewTable this$0;
            final /* synthetic */ List<FileObject> $files;
            {
                this.this$0 = $receiver;
                this.$files = $files;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewTable.access$deletePaths(this.this$0, this.$files, false);
            }
        });
        rmrf.addActionListener(new AbstractAction(this, files){
            final /* synthetic */ FileSystemViewTable this$0;
            final /* synthetic */ List<FileObject> $files;
            {
                this.this$0 = $receiver;
                this.$files = $files;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewTable.access$deletePaths(this.this$0, this.$files, true);
            }
        });
        copyPath.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, showContextMenu$lambda$4(java.util.List app.termora.sftp.FileSystemViewTable java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((List)files, (FileSystemViewTable)this));
        edit.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, showContextMenu$lambda$5(java.util.List app.termora.sftp.FileSystemViewTable java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((List)files, (FileSystemViewTable)this));
        permission.addActionListener(new AbstractAction(files, this){
            final /* synthetic */ List<FileObject> $files;
            final /* synthetic */ FileSystemViewTable this$0;
            {
                this.$files = $files;
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileObject last = (FileObject)CollectionsKt.last(this.$files);
                if (!(last instanceof MySftpFileObject)) {
                    return;
                }
                FileSystemViewTable.access$changePermission(this.this$0, (MySftpFileObject)last);
            }
        });
        refresh.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, showContextMenu$lambda$6(app.termora.sftp.FileSystemViewTable java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((FileSystemViewTable)this));
        transfer.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, showContextMenu$lambda$7(app.termora.sftp.FileSystemViewTable java.util.List java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((FileSystemViewTable)this, (List)files));
        if (rows.length == 0 || hasParent) {
            transfer.setEnabled(false);
            rename.setEnabled(false);
            delete.setEnabled(false);
            edit.setEnabled(false);
            rmrf.setEnabled(false);
            copyPath.setEnabled(false);
            permission.setEnabled(false);
        } else {
            transfer.setEnabled(this.getSftpPanel().canTransfer(this.table));
        }
        popupMenu.show((Component)this.table, e.getX(), e.getY());
    }

    private final void changePermission(MySftpFileObject file) {
        Window window = SwingUtilities.getWindowAncestor(this.table);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        PosixFilePermissionDialog dialog = new PosixFilePermissionDialog(window, this.model.getFilePermissions((FileObject)file));
        Set<PosixFilePermission> set = dialog.open();
        if (set == null) {
            return;
        }
        Set<PosixFilePermission> permissions = set;
        boolean isIncludeSubdirectories = dialog.isIncludeSubdirectories();
        if (this.getFileSystemViewPanel().requestLoading()) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, permissions, isIncludeSubdirectories, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FileSystemViewTable this$0;
                final /* synthetic */ MySftpFileObject $file;
                final /* synthetic */ Set<PosixFilePermission> $permissions;
                final /* synthetic */ boolean $isIncludeSubdirectories;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$permissions = $permissions;
                    this.$isIncludeSubdirectories = $isIncludeSubdirectories;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object4;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            object2 = $this$launch;
                            Object object5 = this.$file;
                            Object object6 = this.$permissions;
                            boolean bl = this.$isIncludeSubdirectories;
                            try {
                                boolean bl2 = false;
                                object5.setPosixFilePermissions((Set<? extends PosixFilePermission>)object6);
                                if (bl && object5.isFolder()) {
                                    object5.refresh();
                                    VFSWalker.INSTANCE.walk((FileObject)object5, new FileVisitor<FileObject>((Set<? extends PosixFilePermission>)object6){
                                        final /* synthetic */ Set<PosixFilePermission> $permissions;
                                        {
                                            this.$permissions = $permissions;
                                        }

                                        public FileVisitResult preVisitDirectory(FileObject dir, BasicFileAttributes attrs) {
                                            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                                            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                            dir.refresh();
                                            if (dir instanceof MySftpFileObject) {
                                                ((MySftpFileObject)dir).setPosixFilePermissions(this.$permissions);
                                            }
                                            return FileVisitResult.CONTINUE;
                                        }

                                        public FileVisitResult visitFile(FileObject file, BasicFileAttributes attrs) {
                                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                            if (file instanceof MySftpFileObject) {
                                                ((MySftpFileObject)file).setPosixFilePermissions(this.$permissions);
                                            }
                                            return FileVisitResult.CONTINUE;
                                        }

                                        public FileVisitResult visitFileFailed(FileObject file, IOException exc) {
                                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                            Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                                            return FileVisitResult.TERMINATE;
                                        }

                                        public FileVisitResult postVisitDirectory(FileObject dir, IOException exc) {
                                            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                                            return FileVisitResult.CONTINUE;
                                        }
                                    });
                                }
                                object4 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable throwable) {
                                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object2 = object4;
                            object5 = this.this$0;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable == null) break;
                            Object it = object6 = throwable;
                            boolean bl3 = false;
                            this.L$0 = object2;
                            this.label = 1;
                            Object object7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((FileSystemViewTable)object5, (Throwable)it, null){
                                int label;
                                final /* synthetic */ FileSystemViewTable this$0;
                                final /* synthetic */ Throwable $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Component component = FileSystemViewTable.access$getOwner(this.this$0);
                                            String string = ExceptionUtils.getMessage((Throwable)this.$it);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                                            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, component, string, null, 0, 0L, 20, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (object7 == object3) {
                                return object3;
                            }
                            break;
                        }
                        case 1: {
                            void $result;
                            boolean bl = false;
                            object2 = this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object7 = $result;
                            break;
                        }
                    }
                    Object c2 = object2;
                    FileSystemViewTable.access$getFileSystemViewPanel(this.this$0).stopLoading();
                    if (Result.isSuccess-impl((Object)c2)) {
                        FileSystemViewTable.access$getFileSystemViewPanel(this.this$0).reload(true);
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void renameSelection() {
        int index = this.getSelectedRow();
        if (index < 0) {
            return;
        }
        FileObject file = this.model.getFileObject(index);
        OptionPane optionPane = OptionPane.INSTANCE;
        Window window = this.getOwner();
        String string = file.getName().getBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        String string2 = string;
        String string3 = I18n.INSTANCE.getString("termora.transport.table.contextmenu.rename");
        String string4 = OptionPane.showInputDialog$default(optionPane, window, string3, string2, null, 8, null);
        if (string4 == null) {
            return;
        }
        String text = string4;
        if (StringsKt.isBlank((CharSequence)text) || Intrinsics.areEqual((Object)text, (Object)file.getName().getBaseName())) {
            return;
        }
        if (this.model.getPathNames().contains(text)) {
            Object[] objectArray = new Object[]{text};
            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, this.getOwner(), I18n.INSTANCE.getString("termora.transport.file-already-exists", objectArray), null, 0, 0L, 20, null);
            return;
        }
        FileSystemViewPanel fileSystemViewPanel = this.getFileSystemViewPanel();
        FileObject fileObject = file.getParent().resolveFile(text);
        Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
        fileSystemViewPanel.renameTo(file, fileObject);
    }

    private final void editFiles(List<? extends FileObject> files) {
        if (files.isEmpty()) {
            return;
        }
        if (SystemInfo.isLinux && StringsKt.isBlank((CharSequence)this.getSftp().getEditCommand())) {
            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, this.getOwner(), I18n.INSTANCE.getString("termora.transport.table.contextmenu.edit-command"), null, 1, 0L, 20, null);
            Action action = this.getActionManager().getAction((Object)"SettingAction");
            if (action != null) {
                action.actionPerformed(new AnActionEvent((Object)this, "", new EventObject(this)));
            }
            return;
        }
        for (FileObject fileObject : files) {
            Transport transport2;
            Path dir = Application.createSubTemporaryDir$default(Application.INSTANCE, null, 1, null);
            String[] stringArray = new String[]{fileObject.getName().getBaseName()};
            Path path = Paths.get(((Object)dir.toAbsolutePath()).toString(), stringArray);
            FileSystemManager fileSystemManager = VFS.getManager();
            Intrinsics.checkNotNull((Object)path);
            FileObject target = fileSystemManager.resolveFile("file://" + ((Object)path.toAbsolutePath()).toString());
            Transport $this$editFiles_u24lambda_u248 = transport2 = this.createTransport(fileObject, false, 0L);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)target);
            $this$editFiles_u24lambda_u248.setTarget(target);
            Transport newTransport = transport2;
            this.transportManager.addTransportListener(new TransportListener(newTransport, this, target, fileObject){
                final /* synthetic */ Transport $newTransport;
                final /* synthetic */ FileSystemViewTable this$0;
                final /* synthetic */ FileObject $target;
                final /* synthetic */ FileObject $file;
                {
                    this.$newTransport = $newTransport;
                    this.this$0 = $receiver;
                    this.$target = $target;
                    this.$file = $file;
                }

                public void onTransportChanged(Transport transport2) {
                    Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
                    if (!Intrinsics.areEqual((Object)transport2, (Object)this.$newTransport)) {
                        return;
                    }
                    if (transport2.getStatus() != TransportStatus.Done && transport2.getStatus() != TransportStatus.Failed) {
                        return;
                    }
                    FileSystemViewTable.access$getTransportManager$p(this.this$0).removeTransportListener(this);
                    if (transport2.getStatus() != TransportStatus.Done) {
                        return;
                    }
                    FileObject fileObject = this.$target;
                    Intrinsics.checkNotNull((Object)fileObject);
                    FileSystemViewTable.access$listenFileChange(this.this$0, fileObject, this.$file);
                }
            });
            this.transportManager.addTransport(newTransport);
        }
    }

    private final void listenFileChange(FileObject localPath, FileObject remotePath) {
        block6: {
            try {
                Process process;
                String p = SFTPKitKt.absolutePathString(localPath);
                if (!StringsKt.isBlank((CharSequence)this.getSftp().getEditCommand())) {
                    Object[] objectArray = new Object[]{p};
                    String string = MessageFormat.format(this.getSftp().getEditCommand(), objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    process = new ProcessBuilder(this.parseCommand(string)).start();
                    break block6;
                }
                if (SystemInfo.isMacOS) {
                    String[] stringArray = new String[]{"open", "-a", "TextEdit", p};
                    process = new ProcessBuilder(stringArray).start();
                    break block6;
                }
                if (SystemInfo.isWindows) {
                    String[] stringArray = new String[]{"notepad", p};
                    process = new ProcessBuilder(stringArray).start();
                    break block6;
                }
                return;
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
        }
        Ref.LongRef lastModifiedTime = new Ref.LongRef();
        lastModifiedTime.element = localPath.getContent().getLastModifiedTime();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, localPath, lastModifiedTime, remotePath, null){
            int label;
            final /* synthetic */ FileSystemViewTable this$0;
            final /* synthetic */ FileObject $localPath;
            final /* synthetic */ Ref.LongRef $lastModifiedTime;
            final /* synthetic */ FileObject $remotePath;
            {
                this.this$0 = $receiver;
                this.$localPath = $localPath;
                this.$lastModifiedTime = $lastModifiedTime;
                this.$remotePath = $remotePath;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)FileSystemViewTable.access$getCoroutineScope$p(this.this$0))) {
                            if (FileSystemViewTable.access$isDisposed$p(this.this$0).get()) break block2;
                            this.$localPath.refresh();
                            if (!this.$localPath.exists()) break block2;
                            nowModifiedTime = this.$localPath.getContent().getLastModifiedTime();
                            if (nowModifiedTime == this.$lastModifiedTime.element) ** GOTO lbl32
                            this.$lastModifiedTime.element = nowModifiedTime;
                            if (FileSystemViewTable.access$getLog$cp().isDebugEnabled()) {
                                FileSystemViewTable.access$getLog$cp().debug("Listening to file {} changes", (Object)SFTPKitKt.absolutePathString(this.$localPath));
                            }
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, this.$localPath, this.$remotePath, null){
                                int label;
                                final /* synthetic */ FileSystemViewTable this$0;
                                final /* synthetic */ FileObject $localPath;
                                final /* synthetic */ FileObject $remotePath;
                                {
                                    this.this$0 = $receiver;
                                    this.$localPath = $localPath;
                                    this.$remotePath = $remotePath;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Transport transport2 = FileSystemViewTable.access$createTransport(this.this$0, this.$localPath, false, 0L);
                                            FileObject fileObject = this.$remotePath;
                                            Transport $this$invokeSuspend_u24lambda_u240 = transport2;
                                            TransportManager transportManager = FileSystemViewTable.access$getTransportManager$p(this.this$0);
                                            boolean bl = false;
                                            $this$invokeSuspend_u24lambda_u240.setTarget(fileObject);
                                            return Boxing.boxBoolean((boolean)transportManager.addTransport(transport2));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v0 != var4_2) goto lbl20
lbl19:
                            // 1 sources

                            return var4_2;
lbl20:
                            // 1 sources

                            ** GOTO lbl32
                        }
                        break;
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                        }
                        catch (Exception e) {
                            if (!FileSystemViewTable.access$getLog$cp().isErrorEnabled()) break;
                            FileSystemViewTable.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                            break;
                        }
lbl32:
                        // 3 sources

                        this.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                        if (v1 != var4_2) ** GOTO lbl5
                        return var4_2;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl5
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final List<String> parseCommand(String command) {
        List result = new ArrayList();
        Matcher matcher = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(command);
        while (matcher.find()) {
            boolean bl;
            if (matcher.group(1) != null) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                bl = result.add(string);
                continue;
            }
            String string = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            bl = result.add(StringsKt.replace$default((String)string, (String)"\\\\ ", (String)" ", (boolean)false, (int)4, null));
        }
        return result;
    }

    private final void newFolderOrFile(boolean isFile) {
        String name = isFile ? I18n.INSTANCE.getString("termora.transport.table.contextmenu.new.file") : I18n.INSTANCE.getString("termora.welcome.contextmenu.new.folder.name");
        String string = OptionPane.showInputDialog$default(OptionPane.INSTANCE, this.getOwner(), name, name, null, 8, null);
        if (string == null) {
            return;
        }
        String text = string;
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        if (this.model.getPathNames().contains(text)) {
            Object[] objectArray = new Object[]{text};
            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, this.getOwner(), I18n.INSTANCE.getString("termora.transport.file-already-exists", objectArray), null, 0, 0L, 20, null);
            return;
        }
        this.getFileSystemViewPanel().newFolderOrFile(text, isFile);
    }

    private final void deletePaths(List<? extends FileObject> paths, boolean rm) {
        if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this), I18n.INSTANCE.getString(rm ? "termora.transport.table.contextmenu.rm-warning" : "termora.transport.table.contextmenu.delete-warning"), null, 0, rm ? 0 : 2, null, null, null, null, 492, null) != 0) {
            return;
        }
        if (!this.getFileSystemViewPanel().requestLoading()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paths, rm, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileSystemViewTable this$0;
            final /* synthetic */ List<FileObject> $paths;
            final /* synthetic */ boolean $rm;
            {
                this.this$0 = $receiver;
                this.$paths = $paths;
                this.$rm = $rm;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope coroutineScope = $this$launch = (CoroutineScope)this.L$0;
                        Serializable serializable = this.this$0;
                        List<FileObject> list = this.$paths;
                        boolean bl = this.$rm;
                        try {
                            boolean bl2 = false;
                            if (FileSystemViewTable.access$getFileSystemProvider$p((FileSystemViewTable)serializable).getFileSystem() instanceof MySftpFileSystem) {
                                FileSystemViewTable.access$deleteSftpPaths((FileSystemViewTable)serializable, list, bl);
                            } else {
                                FileSystemViewTable.access$deleteRecursively((FileSystemViewTable)serializable, list);
                            }
                            object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        Object object4 = object3;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
                        if (throwable != null) {
                            Serializable it = serializable = throwable;
                            boolean bl3 = false;
                            if (FileSystemViewTable.access$getLog$cp().isErrorEnabled()) {
                                FileSystemViewTable.access$getLog$cp().error(((Throwable)it).getMessage(), (Throwable)it);
                            }
                        }
                        this.label = 1;
                        Object object5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ FileSystemViewTable this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        FileSystemViewTable.access$getFileSystemViewPanel(this.this$0).stopLoading();
                                        FileSystemViewPanel.reload$default(FileSystemViewTable.access$getFileSystemViewPanel(this.this$0), false, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object5 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object5 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static /* synthetic */ void deletePaths$default(FileSystemViewTable fileSystemViewTable, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        fileSystemViewTable.deletePaths(list, bl);
    }

    private final void deleteSftpPaths(List<? extends FileObject> files, boolean rm) {
        if (rm) {
            FileSystem fileSystem = this.fileSystemProvider.getFileSystem();
            Intrinsics.checkNotNull((Object)fileSystem, (String)"null cannot be cast to non-null type app.termora.vfs2.sftp.MySftpFileSystem");
            ClientSession session = ((MySftpFileSystem)fileSystem).getClientSession();
            for (FileObject fileObject : files) {
                session.executeRemoteCommand("rm -rf '" + SFTPKitKt.absolutePathString(fileObject) + "'", OutputStream.nullOutputStream(), Charsets.UTF_8);
            }
        } else {
            this.deleteRecursively(files);
        }
    }

    static /* synthetic */ void deleteSftpPaths$default(FileSystemViewTable fileSystemViewTable, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        fileSystemViewTable.deleteSftpPaths(list, bl);
    }

    private final void deleteRecursively(List<? extends FileObject> files) {
        for (FileObject fileObject : files) {
            fileObject.deleteAll();
            fileObject.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transfer(List<? extends FileObject> files, boolean fromLocalSystem, FileObject targetWorkdir, FileSystemViewPanel target) {
        TermoraFrameKt.assertEventDispatchThread();
        FileSystemViewPanel fileSystemViewPanel = target;
        if (fileSystemViewPanel == null && (fileSystemViewPanel = this.getSftpPanel().getTarget(this.table)) == null) {
            return;
        }
        FileSystemViewPanel target2 = fileSystemViewPanel;
        FileSystemViewTable fileSystemViewTable = target2.getData(SFTPDataProviders.INSTANCE.getFileSystemViewTable());
        if (fileSystemViewTable == null) {
            return;
        }
        FileSystemViewTable table = fileSystemViewTable;
        boolean isApplyAll = false;
        Ref.ObjectRef lastAction = new Ref.ObjectRef();
        lastAction.element = AskTransfer.Action.Overwrite;
        for (FileObject fileObject : files) {
            if (!isApplyAll && (targetWorkdir == null || Intrinsics.areEqual((Object)target2.getWorkdir(), (Object)targetWorkdir))) {
                Object v2;
                block8: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)table.model.getRowCount());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(table.model.getFileObject((int)it));
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    for (Object e : iterable2) {
                        FileObject it = (FileObject)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName().getBaseName(), (Object)fileObject.getName().getBaseName())) continue;
                        v2 = e;
                        break block8;
                    }
                    v2 = null;
                }
                FileObject targetAttr = v2;
                if (targetAttr != null) {
                    AskTransfer askTransfer2 = this.askTransfer(fileObject, targetAttr);
                    if (askTransfer2.getOption() != 0) continue;
                    if (askTransfer2.getAction() == AskTransfer.Action.Skip) {
                        if (askTransfer2.getApplyAll()) break;
                        continue;
                    }
                    lastAction.element = askTransfer2.getAction();
                    isApplyAll = askTransfer2.getApplyAll();
                }
            }
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, fileObject, (Ref.ObjectRef<AskTransfer.Action>)lastAction, fromLocalSystem, targetWorkdir, target2, null){
                int label;
                final /* synthetic */ FileSystemViewTable this$0;
                final /* synthetic */ FileObject $file;
                final /* synthetic */ Ref.ObjectRef<AskTransfer.Action> $lastAction;
                final /* synthetic */ boolean $fromLocalSystem;
                final /* synthetic */ FileObject $targetWorkdir;
                final /* synthetic */ FileSystemViewPanel $target;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$lastAction = $lastAction;
                    this.$fromLocalSystem = $fromLocalSystem;
                    this.$targetWorkdir = $targetWorkdir;
                    this.$target = $target;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                FileSystemViewTable.access$doTransfer(this.this$0, this.$file, (AskTransfer.Action)((Object)this.$lastAction.element), this.$fromLocalSystem, this.$targetWorkdir, this.$target);
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                if (!FileSystemViewTable.access$getLog$cp().isErrorEnabled()) return Unit.INSTANCE;
                                FileSystemViewTable.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    static /* synthetic */ void transfer$default(FileSystemViewTable fileSystemViewTable, List list, boolean bl, FileObject fileObject, FileSystemViewPanel fileSystemViewPanel, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            fileObject = null;
        }
        if ((n & 8) != 0) {
            fileSystemViewPanel = null;
        }
        fileSystemViewTable.transfer(list, bl, fileObject, fileSystemViewPanel);
    }

    private final AskTransfer askTransfer(FileObject sourceFile, FileObject targetFile) {
        Object object;
        Icon targetIcon;
        String formMargin = "7dlu";
        FormLayout layout = new FormLayout("left:pref, " + formMargin + ", default:grow, 2dlu, left:pref", "pref, 12dlu, pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref, 16dlu, pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref");
        int iconSize = 36;
        Icon icon = SystemInfo.isWindows ? this.model.getFileIcon(targetFile, iconSize, iconSize) : (targetIcon = targetFile.isFolder() ? (Icon)new FlatSVGIcon(Icons.INSTANCE.getFolder().getName(), iconSize, iconSize) : (Icon)new FlatSVGIcon(Icons.INSTANCE.getFile().getName(), iconSize, iconSize));
        Icon sourceIcon = SystemInfo.isWindows ? this.model.getFileIcon(sourceFile, iconSize, iconSize) : (sourceFile.isFolder() ? (Icon)new FlatSVGIcon(Icons.INSTANCE.getFolder().getName(), iconSize, iconSize) : (Icon)new FlatSVGIcon(Icons.INSTANCE.getFile().getName(), iconSize, iconSize));
        String sourceModified = (String)StringUtils.defaultIfBlank((CharSequence)this.model.getLastModifiedTime(sourceFile), (CharSequence)"-");
        String targetModified = (String)StringUtils.defaultIfBlank((CharSequence)this.model.getLastModifiedTime(targetFile), (CharSequence)"-");
        JComboBox<AskTransfer.Action> actionsComBoBox = new JComboBox<AskTransfer.Action>();
        actionsComBoBox.addItem(AskTransfer.Action.Overwrite);
        actionsComBoBox.addItem(AskTransfer.Action.Append);
        actionsComBoBox.addItem(AskTransfer.Action.Skip);
        actionsComBoBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object text;
                Object object = value;
                if (object == null || (object = object.toString()) == null) {
                    object = text = "";
                }
                if (value == AskTransfer.Action.Overwrite) {
                    text = I18n.INSTANCE.getString("termora.transport.sftp.already-exists.overwrite");
                } else if (value == AskTransfer.Action.Skip) {
                    text = I18n.INSTANCE.getString("termora.transport.sftp.already-exists.skip");
                } else if (value == AskTransfer.Action.Append) {
                    text = I18n.INSTANCE.getString("termora.transport.sftp.already-exists.append");
                }
                Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                return component;
            }
        });
        JCheckBox applyAllCheckbox = new JCheckBox(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.apply-all"));
        Box box = Box.createHorizontalBox();
        box.add(actionsComBoBox);
        box.add(Box.createHorizontalStrut(8));
        box.add(applyAllCheckbox);
        box.add(Box.createHorizontalGlue());
        Box ttBox = Box.createVerticalBox();
        ttBox.add(new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.message1")));
        ttBox.add(new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.message2")));
        FlatSVGIcon warningIcon = new FlatSVGIcon(Icons.INSTANCE.getWarningIntroduction().getName(), iconSize, iconSize);
        int rows = 0;
        rows = 1;
        int step = 2;
        FormBuilder $this$askTransfer_u24lambda_u2411 = object = FormBuilder.create().layout(layout).add((Component)new JLabel((Icon)warningIcon)).xy(1, rows).add((Component)ttBox).xyw(3, rows, 3);
        boolean bl = false;
        FormBuilder $this$askTransfer_u24lambda_u2412 = object = object.add((Component)new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.name") + ":")).xy(1, rows += step).add(sourceFile.getName().getBaseName(), new Object[0]).xyw(3, rows, 3);
        boolean bl2 = false;
        FormBuilder $this$askTransfer_u24lambda_u2413 = object = object.addSeparator("", new Object[0]).xyw(1, rows += step, 5);
        boolean bl3 = false;
        FormBuilder $this$askTransfer_u24lambda_u2414 = object = object.add(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.destination") + ":", new Object[0]).xy(1, rows += step);
        boolean bl4 = false;
        FormBuilder $this$askTransfer_u24lambda_u2415 = object = object.add((Component)new JLabel(targetIcon)).xy(1, rows += step, "center, fill").add(targetModified, new Object[0]).xyw(3, rows, 3);
        boolean bl5 = false;
        FormBuilder $this$askTransfer_u24lambda_u2416 = object = object.add(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.source") + ":", new Object[0]).xy(1, rows += step);
        boolean bl6 = false;
        FormBuilder $this$askTransfer_u24lambda_u2417 = object = object.add((Component)new JLabel(sourceIcon)).xy(1, rows += step, "center, fill").add(sourceModified, new Object[0]).xyw(3, rows, 3);
        boolean bl7 = false;
        FormBuilder $this$askTransfer_u24lambda_u2418 = object = object.addSeparator("", new Object[0]).xyw(1, rows += step, 5);
        boolean bl8 = false;
        FormBuilder $this$askTransfer_u24lambda_u2419 = object = object.add((Component)new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.already-exists.actions") + ":")).xy(1, rows += step).add((Component)box).xyw(3, rows, 3);
        boolean bl9 = false;
        rows += step;
        JPanel panel2 = object.build();
        panel2.putClientProperty("SKIP_requestFocusInWindow", true);
        object = OptionPane.INSTANCE;
        Window window = this.getOwner();
        Intrinsics.checkNotNull((Object)panel2);
        JPanel jPanel = panel2;
        String string = sourceFile.getName().getBaseName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
        String string2 = string;
        int n = OptionPane.showConfirmDialog$default((OptionPane)object, window, jPanel, string2, 2, -1, null, null, 0, FileSystemViewTable::askTransfer$lambda$20, 96, null);
        Object object2 = actionsComBoBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type app.termora.sftp.FileSystemViewTable.AskTransfer.Action");
        return new AskTransfer(n, (AskTransfer.Action)((Object)object2), applyAllCheckbox.isSelected());
    }

    /*
     * WARNING - void declaration
     */
    private final void doTransfer(FileObject file, AskTransfer.Action action, boolean fromLocalSystem, FileObject targetWorkdir, FileSystemViewPanel target) {
        SFTPPanel sftpPanel = this.getSftpPanel();
        FileSystemViewPanel fileSystemViewPanel = target;
        if (fileSystemViewPanel == null && (fileSystemViewPanel = sftpPanel.getTarget(this.table)) == null) {
            return;
        }
        FileSystemViewPanel target2 = fileSystemViewPanel;
        doTransfer.adder.1 adder2 = new Object(action, this, sftpPanel, fromLocalSystem, file, target2, targetWorkdir){
            final /* synthetic */ AskTransfer.Action $action;
            final /* synthetic */ FileSystemViewTable this$0;
            final /* synthetic */ SFTPPanel $sftpPanel;
            final /* synthetic */ boolean $fromLocalSystem;
            final /* synthetic */ FileObject $file;
            final /* synthetic */ FileSystemViewPanel $target;
            final /* synthetic */ FileObject $targetWorkdir;
            {
                this.$action = $action;
                this.this$0 = $receiver;
                this.$sftpPanel = $sftpPanel;
                this.$fromLocalSystem = $fromLocalSystem;
                this.$file = $file;
                this.$target = $target;
                this.$targetWorkdir = $targetWorkdir;
            }

            public final boolean add(Transport transport2) {
                Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
                if (this.$action == AskTransfer.Action.Append) {
                    transport2.setMode(StandardOpenOption.APPEND);
                } else {
                    transport2.setMode(StandardOpenOption.TRUNCATE_EXISTING);
                }
                return FileSystemViewTable.access$addTransport(this.this$0, this.$sftpPanel, this.$fromLocalSystem ? this.$file.getParent() : null, this.$target, this.$targetWorkdir, transport2);
            }
        };
        if (file.isFile()) {
            void $this$doTransfer_u24lambda_u2421;
            Transport transport2;
            Transport transport3 = transport2 = this.createTransport(file, false, 0L);
            var var13_13 = adder2;
            boolean bl = false;
            $this$doTransfer_u24lambda_u2421.scanned();
            var13_13.add(transport2);
            return;
        }
        ArrayDeque queue = new ArrayDeque();
        Ref.BooleanRef isTerminate = new Ref.BooleanRef();
        try {
            this.walk(file, new FileVisitor<FileObject>(this, (ArrayDeque<Transport>)queue, adder2, isTerminate){
                final /* synthetic */ FileSystemViewTable this$0;
                final /* synthetic */ ArrayDeque<Transport> $queue;
                final /* synthetic */ doTransfer.adder.1 $adder;
                final /* synthetic */ Ref.BooleanRef $isTerminate;
                {
                    this.this$0 = $receiver;
                    this.$queue = $queue;
                    this.$adder = $adder;
                    this.$isTerminate = $isTerminate;
                }

                public FileVisitResult preVisitDirectory(FileObject dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Transport transport2 = (Transport)this.$queue.lastOrNull();
                    Object object = FileSystemViewTable.access$createTransport(this.this$0, dir, true, transport2 != null ? transport2.getId() : 0L);
                    Ref.BooleanRef booleanRef = this.$queue;
                    Transport $this$preVisitDirectory_u24lambda_u240 = object;
                    boolean bl = false;
                    booleanRef.addLast((Object)$this$preVisitDirectory_u24lambda_u240);
                    Transport transport3 = object;
                    if (this.$adder.add(transport3)) {
                        return FileVisitResult.CONTINUE;
                    }
                    object = FileVisitResult.TERMINATE;
                    booleanRef = this.$isTerminate;
                    Object $this$preVisitDirectory_u24lambda_u241 = object;
                    boolean bl2 = false;
                    booleanRef.element = true;
                    return object;
                }

                public FileVisitResult visitFile(FileObject file, BasicFileAttributes attrs) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (this.$queue.isEmpty()) {
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                    Transport $this$visitFile_u24lambda_u242 = object = FileSystemViewTable.access$createTransport(this.this$0, file, false, ((Transport)this.$queue.last()).getId());
                    boolean bl = false;
                    $this$visitFile_u24lambda_u242.scanned();
                    Transport transport2 = object;
                    if (this.$adder.add(transport2)) {
                        return FileVisitResult.CONTINUE;
                    }
                    object = FileVisitResult.TERMINATE;
                    Ref.BooleanRef booleanRef = this.$isTerminate;
                    Object $this$visitFile_u24lambda_u243 = object;
                    boolean bl2 = false;
                    booleanRef.element = true;
                    return object;
                }

                public FileVisitResult visitFileFailed(FileObject file, IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(FileObject dir, IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    ((Transport)this.$queue.removeLast()).scanned();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            SwingUtilities.invokeLater(() -> FileSystemViewTable.doTransfer$lambda$22(this, e));
            isTerminate.element = true;
        }
        if (isTerminate.element) {
            while (!((Collection)queue).isEmpty()) {
                ((Transport)queue.removeLast()).scanned();
            }
        }
    }

    static /* synthetic */ void doTransfer$default(FileSystemViewTable fileSystemViewTable, FileObject fileObject, AskTransfer.Action action, boolean bl, FileObject fileObject2, FileSystemViewPanel fileSystemViewPanel, int n, Object object) {
        if ((n & 0x10) != 0) {
            fileSystemViewPanel = null;
        }
        fileSystemViewTable.doTransfer(fileObject, action, bl, fileObject2, fileSystemViewPanel);
    }

    private final FileVisitResult walk(FileObject dir, FileVisitor<FileObject> visitor) {
        return VFSWalker.INSTANCE.walk(dir, visitor);
    }

    private final boolean addTransport(SFTPPanel sftpPanel, FileObject sourceWorkdir, FileSystemViewPanel target, FileObject targetWorkdir, Transport transport2) {
        boolean bl;
        try {
            bl = sftpPanel.addTransport(this.table, sourceWorkdir, target, targetWorkdir, transport2);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    private final Transport createTransport(FileObject source, boolean isDirectory, long parentId) {
        Transport transport2 = new Transport(0L, isDirectory, parentId, source, source, null, 33, null);
        if (transport2.isFile()) {
            transport2.getFilesize().addAndGet(source.getContent().getSize());
        }
        return transport2;
    }

    private static final void showContextMenu$lambda$2(List $files, ActionEvent it) {
        Application.INSTANCE.browseInFolder(new File(SFTPKitKt.absolutePathString((FileObject)CollectionsKt.last((List)$files))));
    }

    private static final void showContextMenu$lambda$4(List $files, FileSystemViewTable this$0, ActionEvent it) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = $files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileObject it2 = (FileObject)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = sb.append(SFTPKitKt.absolutePathString(it2));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        this$0.getToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
    }

    private static final void showContextMenu$lambda$5(List $files, FileSystemViewTable this$0, ActionEvent it) {
        if (!((Collection)$files).isEmpty()) {
            this$0.editFiles($files);
        }
    }

    private static final void showContextMenu$lambda$6(FileSystemViewTable this$0, ActionEvent it) {
        FileSystemViewPanel.reload$default(this$0.getFileSystemViewPanel(), false, 1, null);
    }

    private static final void showContextMenu$lambda$7(FileSystemViewTable this$0, List $files, ActionEvent it) {
        FileSystemViewTable.transfer$default(this$0, $files, false, null, null, 14, null);
    }

    private static final Unit askTransfer$lambda$20(JDialog it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setSize(new Dimension(Math.max(UIManager.getInt("Dialog.width") - 220, it.getWidth()), it.getHeight()));
        it.setLocationRelativeTo(it.getOwner());
        return Unit.INSTANCE;
    }

    private static final void doTransfer$lambda$22(FileSystemViewTable this$0, Exception $e) {
        Component component = this$0.getOwner();
        String string = ExceptionUtils.getRootCauseMessage((Throwable)$e);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootCauseMessage(...)");
        OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, component, string, null, 0, 0L, 20, null);
    }

    public static final /* synthetic */ FileSystemViewTableModel access$getModel$p(FileSystemViewTable $this) {
        return $this.model;
    }

    public static final /* synthetic */ FileSystemViewTable access$getTable$p(FileSystemViewTable $this) {
        return $this.table;
    }

    public static final /* synthetic */ void access$showContextMenu(FileSystemViewTable $this, int[] rows, MouseEvent e) {
        $this.showContextMenu(rows, e);
    }

    public static final /* synthetic */ void access$deletePaths(FileSystemViewTable $this, List paths, boolean rm) {
        $this.deletePaths(paths, rm);
    }

    public static final /* synthetic */ FileSystemViewPanel access$getFileSystemViewPanel(FileSystemViewTable $this) {
        return $this.getFileSystemViewPanel();
    }

    public static final /* synthetic */ void access$renameSelection(FileSystemViewTable $this) {
        $this.renameSelection();
    }

    public static final /* synthetic */ FileSystemProvider access$getFileSystemProvider$p(FileSystemViewTable $this) {
        return $this.fileSystemProvider;
    }

    public static final /* synthetic */ SFTPPanel access$getSftpPanel(FileSystemViewTable $this) {
        return $this.getSftpPanel();
    }

    public static final /* synthetic */ void access$transfer(FileSystemViewTable $this, List files, boolean fromLocalSystem, FileObject targetWorkdir, FileSystemViewPanel target) {
        $this.transfer(files, fromLocalSystem, targetWorkdir, target);
    }

    public static final /* synthetic */ void access$newFolderOrFile(FileSystemViewTable $this, boolean isFile) {
        $this.newFolderOrFile(isFile);
    }

    public static final /* synthetic */ void access$changePermission(FileSystemViewTable $this, MySftpFileObject file) {
        $this.changePermission(file);
    }

    public static final /* synthetic */ Window access$getOwner(FileSystemViewTable $this) {
        return $this.getOwner();
    }

    public static final /* synthetic */ TransportManager access$getTransportManager$p(FileSystemViewTable $this) {
        return $this.transportManager;
    }

    public static final /* synthetic */ void access$listenFileChange(FileSystemViewTable $this, FileObject localPath, FileObject remotePath) {
        $this.listenFileChange(localPath, remotePath);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(FileSystemViewTable $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ AtomicBoolean access$isDisposed$p(FileSystemViewTable $this) {
        return $this.isDisposed;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ Transport access$createTransport(FileSystemViewTable $this, FileObject source, boolean isDirectory, long parentId) {
        return $this.createTransport(source, isDirectory, parentId);
    }

    public static final /* synthetic */ void access$deleteSftpPaths(FileSystemViewTable $this, List files, boolean rm) {
        $this.deleteSftpPaths(files, rm);
    }

    public static final /* synthetic */ void access$deleteRecursively(FileSystemViewTable $this, List files) {
        $this.deleteRecursively(files);
    }

    public static final /* synthetic */ void access$doTransfer(FileSystemViewTable $this, FileObject file, AskTransfer.Action action, boolean fromLocalSystem, FileObject targetWorkdir, FileSystemViewPanel target) {
        $this.doTransfer(file, action, fromLocalSystem, targetWorkdir, target);
    }

    public static final /* synthetic */ boolean access$addTransport(FileSystemViewTable $this, SFTPPanel sftpPanel, FileObject sourceWorkdir, FileSystemViewPanel target, FileObject targetWorkdir, Transport transport2) {
        return $this.addTransport(sftpPanel, sourceWorkdir, target, targetWorkdir, transport2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lapp/termora/sftp/FileSystemViewTable$AskTransfer;", "", "option", "", "action", "Lapp/termora/sftp/FileSystemViewTable$AskTransfer$Action;", "applyAll", "", "<init>", "(ILapp/termora/sftp/FileSystemViewTable$AskTransfer$Action;Z)V", "getOption", "()I", "getAction", "()Lapp/termora/sftp/FileSystemViewTable$AskTransfer$Action;", "getApplyAll", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Action", "termora"})
    private static final class AskTransfer {
        private final int option;
        @NotNull
        private final Action action;
        private final boolean applyAll;

        public AskTransfer(int option, @NotNull Action action, boolean applyAll) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            this.option = option;
            this.action = action;
            this.applyAll = applyAll;
        }

        public final int getOption() {
            return this.option;
        }

        @NotNull
        public final Action getAction() {
            return this.action;
        }

        public final boolean getApplyAll() {
            return this.applyAll;
        }

        public final int component1() {
            return this.option;
        }

        @NotNull
        public final Action component2() {
            return this.action;
        }

        public final boolean component3() {
            return this.applyAll;
        }

        @NotNull
        public final AskTransfer copy(int option, @NotNull Action action, boolean applyAll) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            return new AskTransfer(option, action, applyAll);
        }

        public static /* synthetic */ AskTransfer copy$default(AskTransfer askTransfer2, int n, Action action, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = askTransfer2.option;
            }
            if ((n2 & 2) != 0) {
                action = askTransfer2.action;
            }
            if ((n2 & 4) != 0) {
                bl = askTransfer2.applyAll;
            }
            return askTransfer2.copy(n, action, bl);
        }

        @NotNull
        public String toString() {
            return "AskTransfer(option=" + this.option + ", action=" + this.action + ", applyAll=" + this.applyAll + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.option);
            result = result * 31 + this.action.hashCode();
            result = result * 31 + Boolean.hashCode(this.applyAll);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AskTransfer)) {
                return false;
            }
            AskTransfer askTransfer2 = (AskTransfer)other;
            if (this.option != askTransfer2.option) {
                return false;
            }
            if (this.action != askTransfer2.action) {
                return false;
            }
            return this.applyAll == askTransfer2.applyAll;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lapp/termora/sftp/FileSystemViewTable$AskTransfer$Action;", "", "<init>", "(Ljava/lang/String;I)V", "Overwrite", "Append", "Skip", "termora"})
        public static final class Action
        extends Enum<Action> {
            public static final /* enum */ Action Overwrite = new Action();
            public static final /* enum */ Action Append = new Action();
            public static final /* enum */ Action Skip = new Action();
            private static final /* synthetic */ Action[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Action[] values() {
                return (Action[])$VALUES.clone();
            }

            public static Action valueOf(String value) {
                return Enum.valueOf(Action.class, value);
            }

            @NotNull
            public static EnumEntries<Action> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = actionArray = new Action[]{Action.Overwrite, Action.Append, Action.Skip};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/sftp/FileSystemViewTable$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lapp/termora/sftp/FileSystemViewTable$FileSystemTableRowTransferable;", "Ljava/awt/datatransfer/Transferable;", "source", "Lapp/termora/sftp/FileSystemViewTable;", "files", "", "Lorg/apache/commons/vfs2/FileObject;", "<init>", "(Lapp/termora/sftp/FileSystemViewTable;Ljava/util/List;)V", "getSource", "()Lapp/termora/sftp/FileSystemViewTable;", "getFiles", "()Ljava/util/List;", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "", "Companion", "termora"})
    private static final class FileSystemTableRowTransferable
    implements Transferable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FileSystemViewTable source;
        @NotNull
        private final List<FileObject> files;
        @NotNull
        private static final DataFlavor dataFlavor = new DataFlavor(FileSystemTableRowTransferable.class, "TableRowTransferable");

        public FileSystemTableRowTransferable(@NotNull FileSystemViewTable source, @NotNull List<? extends FileObject> files) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.source = source;
            this.files = files;
        }

        @NotNull
        public final FileSystemViewTable getSource() {
            return this.source;
        }

        @NotNull
        public final List<FileObject> getFiles() {
            return this.files;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{dataFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
            return Intrinsics.areEqual((Object)flavor, (Object)dataFlavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@Nullable DataFlavor flavor) {
            if (!Intrinsics.areEqual((Object)flavor, (Object)dataFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/sftp/FileSystemViewTable$FileSystemTableRowTransferable$Companion;", "", "<init>", "()V", "dataFlavor", "Ljava/awt/datatransfer/DataFlavor;", "getDataFlavor", "()Ljava/awt/datatransfer/DataFlavor;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFlavor getDataFlavor() {
                return dataFlavor;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

