/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.SshClients;
import app.termora.TermoraFrameKt;
import app.termora.actions.DataProvider;
import app.termora.sftp.BookmarkButton;
import app.termora.sftp.FileSystemProvider;
import app.termora.sftp.FileSystemViewNav;
import app.termora.sftp.FileSystemViewTable;
import app.termora.sftp.FileSystemViewTableModel;
import app.termora.sftp.SFTPDataProviders;
import app.termora.sftp.SFTPKitKt;
import app.termora.sftp.Transport;
import app.termora.sftp.TransportListener;
import app.termora.sftp.TransportManager;
import app.termora.sftp.TransportStatus;
import app.termora.terminal.DataKey;
import app.termora.vfs2.sftp.MySftpFileSystem;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.jdesktop.swingx.JXBusyLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002ijB'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010@\u001a\u00020!H\u0002J\b\u0010A\u001a\u00020!H\u0002J\u0012\u0010B\u001a\u00020!2\b\b\u0002\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020FH\u0002J\b\u0010H\u001a\u00020FH\u0002J\b\u0010I\u001a\u00020FH\u0002J\b\u0010J\u001a\u00020KH\u0002J \u0010L\u001a\u00020!2\u0006\u0010M\u001a\u0002072\u000e\b\u0002\u0010N\u001a\b\u0012\u0004\u0012\u00020D0 H\u0002J\u0010\u0010O\u001a\u00020!2\u0006\u00101\u001a\u00020.H\u0002J\u0016\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020.2\u0006\u0010R\u001a\u00020.J\u0016\u0010S\u001a\u00020!2\u0006\u0010M\u001a\u0002072\u0006\u0010T\u001a\u000209J\u001e\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020.2\u0006\u0010T\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010WJ\u0006\u0010X\u001a\u000209J\u0006\u0010Y\u001a\u00020!J\u0010\u0010Z\u001a\u00020!2\b\b\u0002\u0010[\u001a\u000209J\b\u0010\\\u001a\u00020.H\u0002J\u0006\u0010]\u001a\u00020.J\u0016\u0010^\u001a\u00020!2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\b\u0010_\u001a\u00020!H\u0002J\b\u0010`\u001a\u00020!H\u0016J'\u0010a\u001a\u0004\u0018\u0001Hb\"\b\b\u0000\u0010b*\u00020c2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002Hb0eH\u0016\u00a2\u0006\u0002\u0010fJ\b\u0010g\u001a\u00020\bH\u0016J\u0010\u0010h\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00060\u0012R\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00060\u0017R\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\n &*\u0004\u0018\u00010%0%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010:\u001a\u0002092\u0006\u00108\u001a\u0002098B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0011\u0010?\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b?\u0010<\u00a8\u0006k"}, d2={"Lapp/termora/sftp/FileSystemViewPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "Lapp/termora/actions/DataProvider;", "Lapp/termora/sftp/FileSystemProvider;", "host", "Lapp/termora/Host;", "fileSystem", "Lorg/apache/commons/vfs2/FileSystem;", "transportManager", "Lapp/termora/sftp/TransportManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lapp/termora/Host;Lorg/apache/commons/vfs2/FileSystem;Lapp/termora/sftp/TransportManager;Lkotlinx/coroutines/CoroutineScope;)V", "getHost", "()Lapp/termora/Host;", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "sftp", "Lapp/termora/Database$SFTP;", "getSftp", "()Lapp/termora/Database$SFTP;", "table", "Lapp/termora/sftp/FileSystemViewTable;", "disposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "nextReloadTicks", "", "Ljava/util/function/Consumer;", "", "[Ljava/util/function/Consumer;", "isLoading", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "loadingPanel", "Lapp/termora/sftp/FileSystemViewPanel$LoadingPanel;", "layeredPane", "Lapp/termora/sftp/FileSystemViewPanel$LayeredPane;", "homeDirectory", "Lorg/apache/commons/vfs2/FileObject;", "nav", "Lapp/termora/sftp/FileSystemViewNav;", "workdir", "model", "Lapp/termora/sftp/FileSystemViewTableModel;", "getModel", "()Lapp/termora/sftp/FileSystemViewTableModel;", "showHiddenFilesKey", "", "value", "", "useFileHiding", "getUseFileHiding", "()Z", "setUseFileHiding", "(Z)V", "isDisposed", "initViews", "initEvents", "enterTableSelectionFolder", "row", "", "createRefreshButton", "Ljavax/swing/JButton;", "createHiddenFilesButton", "createHomeFolderButton", "createBookmarkButton", "createParentFolderButton", "Ljavax/swing/AbstractButton;", "nextReloadTickSelection", "name", "consumer", "changeWorkdir", "renameTo", "oldPath", "newPath", "newFolderOrFile", "isFile", "doNewFolderOrFile", "path", "(Lorg/apache/commons/vfs2/FileObject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestLoading", "stopLoading", "reload", "rememberSelection", "getHomeDirectory", "getWorkdir", "registerNextReloadTick", "triggerNextReloadTicks", "dispose", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "getFileSystem", "setFileSystem", "LoadingPanel", "LayeredPane", "termora"})
public final class FileSystemViewPanel
extends JPanel
implements Disposable,
DataProvider,
FileSystemProvider {
    @NotNull
    private final Host host;
    @NotNull
    private FileSystem fileSystem;
    @NotNull
    private final TransportManager transportManager;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FileSystemViewTable table;
    @NotNull
    private final AtomicBoolean disposed;
    @NotNull
    private Consumer<Unit>[] nextReloadTicks;
    @NotNull
    private final AtomicBoolean isLoading;
    @NotNull
    private final LoadingPanel loadingPanel;
    @NotNull
    private final LayeredPane layeredPane;
    @NotNull
    private final FileObject homeDirectory;
    @NotNull
    private final FileSystemViewNav nav;
    @NotNull
    private FileObject workdir;
    @NotNull
    private final String showHiddenFilesKey;

    public FileSystemViewPanel(@NotNull Host host, @NotNull FileSystem fileSystem, @NotNull TransportManager transportManager, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)transportManager, (String)"transportManager");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(new BorderLayout());
        this.host = host;
        this.fileSystem = fileSystem;
        this.transportManager = transportManager;
        this.coroutineScope = coroutineScope;
        this.table = new FileSystemViewTable(this, this.transportManager, this.coroutineScope);
        this.disposed = new AtomicBoolean(false);
        this.nextReloadTicks = new Consumer[0];
        this.isLoading = new AtomicBoolean(false);
        this.loadingPanel = new LoadingPanel();
        this.layeredPane = new LayeredPane();
        this.homeDirectory = this.getHomeDirectory();
        this.nav = new FileSystemViewNav(this, this.homeDirectory);
        this.workdir = this.homeDirectory;
        this.showHiddenFilesKey = "termora.transport.host." + this.host.getId() + ".show-hidden-files";
        this.initViews();
        this.initEvents();
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    private final Database.SFTP getSftp() {
        return Database.Companion.getDatabase().getSftp();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final FileSystemViewTableModel getModel() {
        TableModel tableModel2 = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type app.termora.sftp.FileSystemViewTableModel");
        return (FileSystemViewTableModel)tableModel2;
    }

    private final boolean getUseFileHiding() {
        return Boolean.parseBoolean(this.getProperties().getString(this.showHiddenFilesKey, "true"));
    }

    private final void setUseFileHiding(boolean value) {
        this.getProperties().putString(this.showHiddenFilesKey, String.valueOf(value));
    }

    public final boolean isDisposed() {
        return this.disposed.get();
    }

    private final void initViews() {
        FlatToolBar toolbar = new FlatToolBar();
        toolbar.add((Component)this.createHomeFolderButton());
        toolbar.add(Box.createHorizontalStrut(2));
        toolbar.add((Component)this.nav);
        toolbar.add((Component)this.createBookmarkButton());
        toolbar.add((Component)this.createParentFolderButton());
        toolbar.add((Component)this.createHiddenFilesButton());
        toolbar.add((Component)this.createRefreshButton());
        this.add((Component)toolbar, "North");
        this.add((Component)this.layeredPane, "Center");
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()));
        Component component = scrollPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component, n);
        Component component2 = this.loadingPanel;
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component2, n2);
    }

    private final void initEvents() {
        Disposer.register(this, this.table);
        this.nav.addActionListener(arg_0 -> FileSystemViewPanel.initEvents$lambda$0(this, arg_0));
        this.table.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    FileSystemViewPanel.enterTableSelectionFolder$default(this.this$0, 0, 1, null);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    FileSystemViewPanel.enterTableSelectionFolder$default(this.this$0, 0, 1, null);
                }
            }
        });
        TransportListener listener2 = new TransportListener(this){
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTransportChanged(Transport transport2) {
                Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
                FileObject fileObject = transport2.getTarget().getParent();
                if (fileObject == null) {
                    return;
                }
                FileObject path = fileObject;
                if (!Intrinsics.areEqual((Object)path.getFileSystem(), (Object)FileSystemViewPanel.access$getFileSystem$p(this.this$0))) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)path.getName().getPath(), (Object)FileSystemViewPanel.access$getWorkdir$p(this.this$0).getName().getPath())) {
                    return;
                }
                this.this$0.reload(true);
            }

            public void dispose() {
                FileSystemViewPanel.access$getTransportManager$p(this.this$0).removeTransportListener(this);
            }
        };
        this.transportManager.addTransportListener(listener2);
        Disposer.register(this, (Disposable)((Object)listener2));
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeWorkdir(this.homeDirectory);
        } else {
            SwingUtilities.invokeLater(() -> FileSystemViewPanel.initEvents$lambda$1(this));
        }
    }

    private final void enterTableSelectionFolder(int row) {
        if (row < 0 || this.isLoading.get()) {
            return;
        }
        FileObject file = this.getModel().getFileObject(row);
        if (file.isFile()) {
            return;
        }
        FileObject workdir = this.getWorkdir();
        if (row == 0 && this.getModel().getHasParent()) {
            FileName workdirName = workdir.getName();
            String string = workdirName.getBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseName(...)");
            FileSystemViewPanel.nextReloadTickSelection$default(this, string, null, 2, null);
        }
        this.changeWorkdir(file);
    }

    static /* synthetic */ void enterTableSelectionFolder$default(FileSystemViewPanel fileSystemViewPanel, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = fileSystemViewPanel.table.getSelectedRow();
        }
        fileSystemViewPanel.enterTableSelectionFolder(n);
    }

    private final JButton createRefreshButton() {
        JButton button = new JButton((Icon)((Object)Icons.INSTANCE.getRefresh()));
        button.addActionListener(arg_0 -> FileSystemViewPanel.createRefreshButton$lambda$2(this, arg_0));
        return button;
    }

    private final JButton createHiddenFilesButton() {
        JButton button = new JButton((Icon)((Object)(this.getUseFileHiding() ? Icons.INSTANCE.getEyeClose() : Icons.INSTANCE.getEye())));
        button.addActionListener(new AbstractAction(this, button){
            final /* synthetic */ FileSystemViewPanel this$0;
            final /* synthetic */ JButton $button;
            {
                this.this$0 = $receiver;
                this.$button = $button;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewPanel.access$setUseFileHiding(this.this$0, !FileSystemViewPanel.access$getUseFileHiding(this.this$0));
                this.$button.setIcon(FileSystemViewPanel.access$getUseFileHiding(this.this$0) ? (Icon)((Object)Icons.INSTANCE.getEyeClose()) : (Icon)((Object)Icons.INSTANCE.getEye()));
                this.this$0.reload(true);
            }
        });
        return button;
    }

    private final JButton createHomeFolderButton() {
        JButton button = new JButton((Icon)((Object)Icons.INSTANCE.getHomeFolder()));
        button.addActionListener(arg_0 -> FileSystemViewPanel.createHomeFolderButton$lambda$3(this, arg_0));
        return button;
    }

    private final JButton createBookmarkButton() {
        BookmarkButton bookmarkBtn = new BookmarkButton();
        bookmarkBtn.setName("Host." + this.host.getId() + ".Bookmarks");
        bookmarkBtn.addActionListener(arg_0 -> FileSystemViewPanel.createBookmarkButton$lambda$4(bookmarkBtn, this, arg_0));
        this.nav.addActionListener(new AbstractAction(bookmarkBtn, this){
            final /* synthetic */ BookmarkButton $bookmarkBtn;
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.$bookmarkBtn = $bookmarkBtn;
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$bookmarkBtn.setBookmark(this.$bookmarkBtn.getBookmarks().contains(SFTPKitKt.absolutePathString(FileSystemViewPanel.access$getNav$p(this.this$0).getSelectedPath())));
            }
        });
        return bookmarkBtn;
    }

    private final AbstractButton createParentFolderButton() {
        JButton button = new JButton((Icon)((Object)Icons.INSTANCE.getUp()));
        button.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (FileSystemViewPanel.access$getModel(this.this$0).getRowCount() < 1) {
                    return;
                }
                if (FileSystemViewPanel.access$getModel(this.this$0).getHasParent()) {
                    FileSystemViewPanel.access$enterTableSelectionFolder(this.this$0, 0);
                }
            }
        });
        this.addPropertyChangeListener("workdir", arg_0 -> FileSystemViewPanel.createParentFolderButton$lambda$5(button, this, arg_0));
        return button;
    }

    private final void nextReloadTickSelection(String name, Consumer<Integer> consumer) {
        this.registerNextReloadTick(arg_0 -> FileSystemViewPanel.nextReloadTickSelection$lambda$7(this, name, consumer, arg_0));
    }

    static /* synthetic */ void nextReloadTickSelection$default(FileSystemViewPanel fileSystemViewPanel, String string, Consumer consumer, int n, Object object) {
        if ((n & 2) != 0) {
            consumer = FileSystemViewPanel::nextReloadTickSelection$lambda$6;
        }
        fileSystemViewPanel.nextReloadTickSelection(string, consumer);
    }

    private final void changeWorkdir(FileObject workdir) {
        TermoraFrameKt.assertEventDispatchThread();
        this.nav.changeSelectedPath(workdir);
    }

    public final void renameTo(@NotNull FileObject oldPath, @NotNull FileObject newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, oldPath, newPath, null){
            int label;
            final /* synthetic */ FileSystemViewPanel this$0;
            final /* synthetic */ FileObject $oldPath;
            final /* synthetic */ FileObject $newPath;
            {
                this.this$0 = $receiver;
                this.$oldPath = $oldPath;
                this.$newPath = $newPath;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!this.this$0.requestLoading()) ** GOTO lbl30
                        try {
                            this.$oldPath.moveTo(this.$newPath);
                            this.this$0.stopLoading();
                            ** GOTO lbl30
                        }
                        catch (Exception e) {
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, e, null){
                                int label;
                                final /* synthetic */ FileSystemViewPanel this$0;
                                final /* synthetic */ Exception $e;
                                {
                                    this.this$0 = $receiver;
                                    this.$e = $e;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Component component = SwingUtilities.getWindowAncestor(FileSystemViewPanel.access$getOwner(this.this$0));
                                            String string = ExceptionUtils.getMessage((Throwable)this.$e);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                                            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, component, string, null, 0, 0L, 20, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v0 != var3_2) goto lbl17
lbl16:
                            // 1 sources

                            return var3_2;
lbl17:
                            // 1 sources

                            ** GOTO lbl30
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl30
                        {
                            catch (Throwable var2_4) {
                                throw var2_4;
                            }
                        }
                        finally {
                            this.this$0.stopLoading();
                        }
lbl30:
                        // 4 sources

                        v1 = this.$newPath.getName().getBaseName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBaseName(...)");
                        FileSystemViewPanel.nextReloadTickSelection$default(this.this$0, v1, null, 2, null);
                        FileSystemViewPanel.reload$default(this.this$0, false, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void newFolderOrFile(@NotNull String name, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, name, isFile, null){
            int label;
            final /* synthetic */ FileSystemViewPanel this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $isFile;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$isFile = $isFile;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!this.this$0.requestLoading()) break;
                        FileObject fileObject = this.this$0.getWorkdir().resolveFile(this.$name);
                        Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
                        this.label = 1;
                        Object object3 = FileSystemViewPanel.access$doNewFolderOrFile(this.this$0, fileObject, this.$isFile, (Continuation)this);
                        if (object3 != object2) break;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.this$0.stopLoading();
                    }
                }
                FileSystemViewPanel.nextReloadTickSelection$default(this.this$0, this.$name, null, 2, null);
                FileSystemViewPanel.reload$default(this.this$0, false, 1, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object doNewFolderOrFile(FileObject path, boolean isFile, Continuation<? super Unit> $completion) {
        if (path.exists()) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, path, null){
                int label;
                final /* synthetic */ FileSystemViewPanel this$0;
                final /* synthetic */ FileObject $path;
                {
                    this.this$0 = $receiver;
                    this.$path = $path;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Object[] objectArray = new Object[]{this.$path.getName()};
                            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, FileSystemViewPanel.access$getOwner(this.this$0), I18n.INSTANCE.getString("termora.transport.file-already-exists", objectArray), null, 0, 0L, 20, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends Unit>>, Object>(isFile, path, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $isFile;
            final /* synthetic */ FileObject $path;
            final /* synthetic */ FileSystemViewPanel this$0;
            {
                this.$isFile = $isFile;
                this.$path = $path;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object4;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                        object2 = $this$withContext;
                        boolean bl = this.$isFile;
                        Object object5 = this.$path;
                        try {
                            boolean bl2 = false;
                            if (bl) {
                                object5.createFile();
                            } else {
                                object5.createFolder();
                            }
                            object4 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable bl2) {
                            object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                        }
                        object2 = object4;
                        FileSystemViewPanel fileSystemViewPanel = this.this$0;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                        if (throwable == null) break;
                        Object it = object5 = throwable;
                        boolean bl3 = false;
                        this.L$0 = object2;
                        this.label = 1;
                        Object object6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Throwable)it, fileSystemViewPanel, null){
                            int label;
                            final /* synthetic */ Throwable $it;
                            final /* synthetic */ FileSystemViewPanel this$0;
                            {
                                this.$it = $it;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        if (this.$it instanceof Exception) {
                                            Component component = FileSystemViewPanel.access$getOwner(this.this$0);
                                            String string = ExceptionUtils.getMessage((Throwable)this.$it);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                                            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, component, string, null, 0, 0L, 20, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (object6 == object3) {
                            return object3;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        object2 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object6 = $result;
                        break;
                    }
                }
                return Result.box-impl((Object)object2);
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean requestLoading() {
        if (this.isLoading.compareAndSet(false, true)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.loadingPanel.start();
            } else {
                SwingUtilities.invokeLater(() -> FileSystemViewPanel.requestLoading$lambda$8(this));
            }
            return true;
        }
        return false;
    }

    public final void stopLoading() {
        if (this.isLoading.compareAndSet(true, false)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.loadingPanel.stop();
            } else {
                SwingUtilities.invokeLater(() -> FileSystemViewPanel.stopLoading$lambda$9(this));
            }
        }
    }

    public final void reload(boolean rememberSelection) {
        if (!this.requestLoading()) {
            return;
        }
        if (this.fileSystem instanceof MySftpFileSystem) {
            this.loadingPanel.start();
        }
        FileObject oldWorkdir = this.workdir;
        FileObject path = this.nav.getSelectedPath();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(rememberSelection, this, path, oldWorkdir, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $rememberSelection;
            final /* synthetic */ FileSystemViewPanel this$0;
            final /* synthetic */ FileObject $path;
            final /* synthetic */ FileObject $oldWorkdir;
            {
                this.$rememberSelection = $rememberSelection;
                this.this$0 = $receiver;
                this.$path = $path;
                this.$oldWorkdir = $oldWorkdir;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[SWITCH], 12[CASE]], but top level block is 5[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void reload$default(FileSystemViewPanel fileSystemViewPanel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        fileSystemViewPanel.reload(bl);
    }

    private final FileObject getHomeDirectory() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem instanceof MySftpFileSystem) {
            Host host = (Host)((MySftpFileSystem)fileSystem).getClientSession().getAttribute(SshClients.INSTANCE.getHOST_KEY());
            if (host == null) {
                FileObject fileObject = ((MySftpFileSystem)fileSystem).resolveFile(((MySftpFileSystem)fileSystem).getDefaultDir());
                Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
                return fileObject;
            }
            Host host2 = host;
            String defaultDirectory = host2.getOptions().getSftpDefaultDirectory();
            if (!StringsKt.isBlank((CharSequence)defaultDirectory)) {
                FileObject fileObject = ((MySftpFileSystem)fileSystem).resolveFile(defaultDirectory);
                Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
                return fileObject;
            }
            FileObject fileObject = ((MySftpFileSystem)fileSystem).resolveFile(((MySftpFileSystem)fileSystem).getDefaultDir());
            Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
            return fileObject;
        }
        if (!StringsKt.isBlank((CharSequence)this.getSftp().getDefaultDirectory())) {
            FileObject resolveFile;
            FileObject fileObject = resolveFile = fileSystem instanceof LocalFileSystem && SystemInfo.isWindows ? VFS.getManager().resolveFile("file://" + this.getSftp().getDefaultDirectory()) : fileSystem.resolveFile("file://" + this.getSftp().getDefaultDirectory());
            if (resolveFile.exists()) {
                FileSystem fileSystem2 = resolveFile.getFileSystem();
                Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getFileSystem(...)");
                this.setFileSystem(fileSystem2);
                Intrinsics.checkNotNull((Object)resolveFile);
                return resolveFile;
            }
        }
        FileObject fileObject = fileSystem.resolveFile("file://" + SystemUtils.USER_HOME);
        Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
        return fileObject;
    }

    @NotNull
    public final FileObject getWorkdir() {
        return this.workdir;
    }

    private final void registerNextReloadTick(Consumer<Unit> consumer) {
        this.nextReloadTicks = (Consumer[])ArraysKt.plus((Object[])this.nextReloadTicks, arg_0 -> FileSystemViewPanel.registerNextReloadTick$lambda$10(consumer, arg_0));
    }

    private final void triggerNextReloadTicks() {
        for (Consumer<Unit> nextReloadTick : this.nextReloadTicks) {
            nextReloadTick.accept(Unit.INSTANCE);
        }
        this.nextReloadTicks = new Consumer[0];
    }

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            List<Transport> rootChildren = this.transportManager.getTransports(0L);
            for (Transport child : rootChildren) {
                if (!Intrinsics.areEqual((Object)child.getSource().getFileSystem(), (Object)this.fileSystem) && !Intrinsics.areEqual((Object)child.getTarget().getFileSystem(), (Object)this.fileSystem)) continue;
                child.changeStatus(TransportStatus.Failed);
            }
            this.fileSystem.getFileSystemManager().getFilesCache().clear(this.fileSystem);
        }
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Object object;
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        if (Intrinsics.areEqual(dataKey, SFTPDataProviders.INSTANCE.getFileSystemViewTable())) {
            FileSystemViewTable fileSystemViewTable = this.table;
            Intrinsics.checkNotNull((Object)fileSystemViewTable, (String)"null cannot be cast to non-null type T of app.termora.sftp.FileSystemViewPanel.getData");
            object = fileSystemViewTable;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void setFileSystem(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    private static final void initEvents$lambda$0(FileSystemViewPanel this$0, ActionEvent it) {
        FileSystemViewPanel.reload$default(this$0, false, 1, null);
    }

    private static final void initEvents$lambda$1(FileSystemViewPanel this$0) {
        this$0.changeWorkdir(this$0.homeDirectory);
    }

    private static final void createRefreshButton$lambda$2(FileSystemViewPanel this$0, ActionEvent it) {
        this$0.reload(true);
    }

    private static final void createHomeFolderButton$lambda$3(FileSystemViewPanel this$0, ActionEvent it) {
        this$0.nav.changeSelectedPath(this$0.homeDirectory);
    }

    private static final void createBookmarkButton$lambda$4(BookmarkButton $bookmarkBtn, FileSystemViewPanel this$0, ActionEvent e) {
        CharSequence charSequence = e.getActionCommand();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if ($bookmarkBtn.isBookmark()) {
                $bookmarkBtn.deleteBookmark(SFTPKitKt.absolutePathString(this$0.workdir));
            } else {
                $bookmarkBtn.addBookmark(SFTPKitKt.absolutePathString(this$0.workdir));
            }
            $bookmarkBtn.setBookmark(!$bookmarkBtn.isBookmark());
        } else if (this$0.fileSystem instanceof LocalFileSystem && SystemUtils.IS_OS_WINDOWS) {
            FileObject file = VFS.getManager().resolveFile("file://" + e.getActionCommand());
            if (!StringUtils.equals((CharSequence)file.getFileSystem().getRootURI(), (CharSequence)this$0.fileSystem.getRootURI())) {
                FileSystem fileSystem = file.getFileSystem();
                Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getFileSystem(...)");
                this$0.fileSystem = fileSystem;
            }
            Intrinsics.checkNotNull((Object)file);
            this$0.changeWorkdir(file);
        } else {
            FileObject fileObject = this$0.fileSystem.resolveFile(e.getActionCommand());
            Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
            this$0.changeWorkdir(fileObject);
        }
    }

    private static final void createParentFolderButton$lambda$5(JButton $button, FileSystemViewPanel this$0, PropertyChangeEvent it) {
        $button.setEnabled(this$0.getModel().getRowCount() > 0 && this$0.getModel().getHasParent());
    }

    private static final void nextReloadTickSelection$lambda$6(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void nextReloadTickSelection$lambda$7(FileSystemViewPanel this$0, String $name, Consumer $consumer, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = this$0.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this$0.getModel().getFileObject(i).getName().getBaseName(), (Object)$name)) continue;
            this$0.table.addRowSelectionInterval(i, i);
            this$0.table.scrollRectToVisible(this$0.table.getCellRect(i, 0, true));
            $consumer.accept(i);
            break;
        }
    }

    private static final void requestLoading$lambda$8(FileSystemViewPanel this$0) {
        this$0.loadingPanel.start();
    }

    private static final void stopLoading$lambda$9(FileSystemViewPanel this$0) {
        this$0.loadingPanel.stop();
    }

    private static final void registerNextReloadTick$lambda$10(Consumer $consumer, Unit t) {
        TermoraFrameKt.assertEventDispatchThread();
        $consumer.accept(t);
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(FileSystemViewPanel $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ FileObject access$getWorkdir$p(FileSystemViewPanel $this) {
        return $this.workdir;
    }

    public static final /* synthetic */ TransportManager access$getTransportManager$p(FileSystemViewPanel $this) {
        return $this.transportManager;
    }

    public static final /* synthetic */ void access$setUseFileHiding(FileSystemViewPanel $this, boolean value) {
        $this.setUseFileHiding(value);
    }

    public static final /* synthetic */ boolean access$getUseFileHiding(FileSystemViewPanel $this) {
        return $this.getUseFileHiding();
    }

    public static final /* synthetic */ FileSystemViewNav access$getNav$p(FileSystemViewPanel $this) {
        return $this.nav;
    }

    public static final /* synthetic */ FileSystemViewTableModel access$getModel(FileSystemViewPanel $this) {
        return $this.getModel();
    }

    public static final /* synthetic */ void access$enterTableSelectionFolder(FileSystemViewPanel $this, int row) {
        $this.enterTableSelectionFolder(row);
    }

    public static final /* synthetic */ Window access$getOwner(FileSystemViewPanel $this) {
        return $this.getOwner();
    }

    public static final /* synthetic */ Object access$doNewFolderOrFile(FileSystemViewPanel $this, FileObject path, boolean isFile, Continuation $completion) {
        return $this.doNewFolderOrFile(path, isFile, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ FileSystemViewTable access$getTable$p(FileSystemViewPanel $this) {
        return $this.table;
    }

    public static final /* synthetic */ void access$triggerNextReloadTicks(FileSystemViewPanel $this) {
        $this.triggerNextReloadTicks();
    }

    public static final /* synthetic */ LoadingPanel access$getLoadingPanel$p(FileSystemViewPanel $this) {
        return $this.loadingPanel;
    }

    public static final /* synthetic */ void access$setWorkdir$p(FileSystemViewPanel $this, FileObject fileObject) {
        $this.workdir = fileObject;
    }

    public static final /* synthetic */ void access$firePropertyChange(FileSystemViewPanel $this, String p0, Object p1, Object p2) {
        $this.firePropertyChange(p0, p1, p2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lapp/termora/sftp/FileSystemViewPanel$LayeredPane;", "Ljavax/swing/JLayeredPane;", "<init>", "()V", "doLayout", "", "termora"})
    private static final class LayeredPane
    extends JLayeredPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                int w = this.getWidth();
                int h = this.getHeight();
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getComponents());
                while (iterator2.hasNext()) {
                    Component c2 = (Component)iterator2.next();
                    c2.setBounds(0, 0, w, h);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/sftp/FileSystemViewPanel$LoadingPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "busyLabel", "Lorg/jdesktop/swingx/JXBusyLabel;", "start", "", "stop", "termora"})
    private static final class LoadingPanel
    extends JPanel {
        @NotNull
        private final JXBusyLabel busyLabel = new JXBusyLabel();

        public LoadingPanel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(50, 0, 0, 0));
            this.add((Component)this.busyLabel, "Center");
            this.addMouseListener(new MouseAdapter(){});
            this.setVisible(false);
        }

        public final void start() {
            this.busyLabel.setBusy(true);
            this.setVisible(true);
        }

        public final void stop() {
            this.busyLabel.setBusy(false);
            this.setVisible(false);
        }
    }
}

