/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Icons;
import app.termora.TermoraFrameKt;
import app.termora.sftp.FileSystemProvider;
import app.termora.sftp.FileSystemViewNav;
import app.termora.sftp.NativeFileIcons;
import app.termora.sftp.SFTPKitKt;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0018\u0018\u0000 &2\u00020\u0001:\u0004&'()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010%\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006*"}, d2={"Lapp/termora/sftp/FileSystemViewNav;", "Ljavax/swing/JPanel;", "fileSystemProvider", "Lapp/termora/sftp/FileSystemProvider;", "homeDirectory", "Lorg/apache/commons/vfs2/FileObject;", "<init>", "(Lapp/termora/sftp/FileSystemProvider;Lorg/apache/commons/vfs2/FileObject;)V", "fileSystemView", "Ljavax/swing/filechooser/FileSystemView;", "kotlin.jvm.PlatformType", "textField", "Lapp/termora/sftp/FileSystemViewNav$MyFlatTextField;", "popupLastTime", "", "history", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "layeredPane", "Lapp/termora/sftp/FileSystemViewNav$LayeredPane;", "downBtn", "Ljavax/swing/JButton;", "comboBox", "app/termora/sftp/FileSystemViewNav$comboBox$1", "Lapp/termora/sftp/FileSystemViewNav$comboBox$1;", "initViews", "", "formatDisplayPath", "file", "initEvents", "showComboBoxPopup", "addActionListener", "l", "Ljava/awt/event/ActionListener;", "getSelectedPath", "changeSelectedPath", "updateUI", "Companion", "IndentIcon", "MyFlatTextField", "LayeredPane", "termora"})
public final class FileSystemViewNav
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemProvider fileSystemProvider;
    @NotNull
    private final FileObject homeDirectory;
    private final FileSystemView fileSystemView;
    @NotNull
    private final MyFlatTextField textField;
    private long popupLastTime;
    @NotNull
    private final LinkedHashSet<String> history;
    @NotNull
    private final LayeredPane layeredPane;
    @NotNull
    private final JButton downBtn;
    @NotNull
    private final comboBox.1 comboBox;
    @NotNull
    private static final String PATH = "path";
    private static final Logger log = LoggerFactory.getLogger(FileSystemViewNav.class);

    public FileSystemViewNav(@NotNull FileSystemProvider fileSystemProvider, @NotNull FileObject homeDirectory) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        Intrinsics.checkNotNullParameter((Object)homeDirectory, (String)"homeDirectory");
        super(new BorderLayout());
        this.fileSystemProvider = fileSystemProvider;
        this.homeDirectory = homeDirectory;
        this.fileSystemView = FileSystemView.getFileSystemView();
        this.textField = new MyFlatTextField();
        this.history = new LinkedHashSet();
        this.layeredPane = new LayeredPane();
        this.downBtn = new JButton((Icon)((Object)Icons.INSTANCE.getChevronDown()));
        this.comboBox = new JComboBox<FileObject>(){

            public Point getLocationOnScreen() {
                Point point = super.getLocationOnScreen();
                --point.y;
                Intrinsics.checkNotNull((Object)point);
                return point;
            }
        };
        this.initViews();
        this.initEvents();
    }

    private final void initViews() {
        block5: {
            this.comboBox.setEnabled(false);
            this.comboBox.putClientProperty("JComboBox.isTableCellEditor", true);
            this.textField.setLeadingIcon(NativeFileIcons.INSTANCE.getFolderIcon());
            this.textField.setTrailingComponent(this.downBtn);
            this.textField.setText(SFTPKitKt.absolutePathString(this.homeDirectory));
            this.textField.putClientProperty(PATH, this.homeDirectory);
            Object object = new Pair[]{TuplesKt.to((Object)"toolbar.hoverBackground", (Object)UIManager.getColor("Button.background")), TuplesKt.to((Object)"toolbar.pressedBackground", (Object)UIManager.getColor("Button.background"))};
            this.downBtn.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])object));
            this.comboBox.setRenderer(new DefaultListCellRenderer(this){
                private final IndentIcon indentIcon;
                final /* synthetic */ FileSystemViewNav this$0;
                {
                    this.this$0 = $receiver;
                    this.indentIcon = new IndentIcon();
                }

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c2 = super.getListCellRendererComponent(list, value instanceof FileObject ? FileSystemViewNav.access$formatDisplayPath(this.this$0, (FileObject)value) : String.valueOf(value), index, isSelected, cellHasFocus);
                    this.indentIcon.setDepth(0);
                    this.indentIcon.setIcon(NativeFileIcons.INSTANCE.getFolderIcon());
                    this.setIcon(this.indentIcon);
                    Intrinsics.checkNotNull((Object)c2);
                    return c2;
                }
            });
            Component component = this.comboBox;
            Integer n = JLayeredPane.DEFAULT_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            this.layeredPane.add(component, n);
            Component component2 = (Component)((Object)this.textField);
            Integer n2 = JLayeredPane.PALETTE_LAYER;
            Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
            this.layeredPane.add(component2, n2);
            this.add((Component)this.layeredPane, "Center");
            if (SystemInfo.isWindows && this.fileSystemProvider.getFileSystem() instanceof LocalFileSystem) {
                try {
                    object = ArrayIteratorKt.iterator((Object[])this.fileSystemView.getRoots());
                    while (object.hasNext()) {
                        File root = (File)object.next();
                        this.history.add(root.getAbsolutePath());
                    }
                    for (Path rootDirectory : FileSystems.getDefault().getRootDirectories()) {
                        Intrinsics.checkNotNull((Object)rootDirectory);
                        this.history.add(((Object)rootDirectory.toAbsolutePath()).toString());
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private final String formatDisplayPath(FileObject file) {
        return SFTPKitKt.absolutePathString(file);
    }

    private final void initEvents() {
        ItemListener itemListener = arg_0 -> FileSystemViewNav.initEvents$lambda$0(this, arg_0);
        this.comboBox.addPopupMenuListener(new PopupMenuListener(this, itemListener){
            final /* synthetic */ FileSystemViewNav this$0;
            final /* synthetic */ ItemListener $itemListener;
            {
                this.this$0 = $receiver;
                this.$itemListener = $itemListener;
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewNav.access$getComboBox$p(this.this$0).addItemListener(this.$itemListener);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileSystemViewNav.access$setPopupLastTime$p(this.this$0, System.currentTimeMillis());
                FileSystemViewNav.access$getComboBox$p(this.this$0).removeItemListener(this.$itemListener);
                FileSystemViewNav.access$getComboBox$p(this.this$0).setEnabled(false);
                FileSystemViewNav.access$getTextField$p(this.this$0).requestFocusInWindow();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewNav this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = FileSystemViewNav.access$getTextField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (StringsKt.isBlank((CharSequence)text)) {
                    return;
                }
                if (FileSystemViewNav.access$getHistory$p(this.this$0).contains(text)) {
                    return;
                }
                FileSystemViewNav.access$getHistory$p(this.this$0).add(text);
            }
        });
        this.downBtn.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewNav this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (System.currentTimeMillis() - FileSystemViewNav.access$getPopupLastTime$p(this.this$0) < 250L) {
                    return;
                }
                FileSystemViewNav.access$getComboBox$p(this.this$0).setEnabled(true);
                FileSystemViewNav.access$getComboBox$p(this.this$0).requestFocusInWindow();
                FileSystemViewNav.access$showComboBoxPopup(this.this$0);
            }
        });
        this.textField.addActionListener(new AbstractAction(this){
            final /* synthetic */ FileSystemViewNav this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String string = FileSystemViewNav.access$getTextField$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    if (StringsKt.isBlank((CharSequence)name)) {
                        return;
                    }
                    FileSystem fileSystem = FileSystemViewNav.access$getFileSystemProvider$p(this.this$0).getFileSystem();
                    try {
                        if (fileSystem instanceof LocalFileSystem && SystemUtils.IS_OS_WINDOWS) {
                            FileObject file = VFS.getManager().resolveFile("file://" + name);
                            if (!StringUtils.equals((CharSequence)file.getFileSystem().getRootURI(), (CharSequence)FileSystemViewNav.access$getFileSystemProvider$p(this.this$0).getFileSystem().getRootURI())) {
                                FileSystemProvider fileSystemProvider = FileSystemViewNav.access$getFileSystemProvider$p(this.this$0);
                                FileSystem fileSystem2 = file.getFileSystem();
                                Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getFileSystem(...)");
                                fileSystemProvider.setFileSystem(fileSystem2);
                            }
                            Intrinsics.checkNotNull((Object)file);
                            this.this$0.changeSelectedPath(file);
                        } else {
                            FileObject fileObject = fileSystem.resolveFile(name);
                            Intrinsics.checkNotNullExpressionValue((Object)fileObject, (String)"resolveFile(...)");
                            this.this$0.changeSelectedPath(fileObject);
                        }
                    }
                    catch (Exception e2) {
                        if (!FileSystemViewNav.access$getLog$cp().isErrorEnabled()) break block6;
                        FileSystemViewNav.access$getLog$cp().error(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        });
    }

    private final void showComboBoxPopup() {
        this.comboBox.removeAllItems();
        FileSystem fileSystem = this.fileSystemProvider.getFileSystem();
        Iterator iterator2 = this.history.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String text = (String)iterator3.next();
            FileObject path = SystemInfo.isWindows && fileSystem instanceof LocalFileSystem ? VFS.getManager().resolveFile("file://" + text) : fileSystem.resolveFile(text);
            this.comboBox.addItem(path);
            if (!Intrinsics.areEqual((Object)text, (Object)this.textField.getText())) continue;
            this.comboBox.setSelectedItem(path);
        }
        this.comboBox.showPopup();
    }

    public final void addActionListener(@NotNull ActionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listenerList.add(ActionListener.class, (EventListener)l);
    }

    @NotNull
    public final FileObject getSelectedPath() {
        Object object = this.textField.getClientProperty(PATH);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.commons.vfs2.FileObject");
        return (FileObject)object;
    }

    public final void changeSelectedPath(@NotNull FileObject file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TermoraFrameKt.assertEventDispatchThread();
        this.textField.setText(this.formatDisplayPath(file));
        this.textField.putClientProperty(PATH, file);
        FileSystem fileSystem = this.fileSystemProvider.getFileSystem();
        if (SystemInfo.isWindows && fileSystem instanceof LocalFileSystem && !StringUtils.equals((CharSequence)((LocalFileSystem)fileSystem).getRootURI(), (CharSequence)file.getFileSystem().getRootURI())) {
            FileSystem fileSystem2 = file.getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getFileSystem(...)");
            this.fileSystemProvider.setFileSystem(fileSystem2);
        }
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.listenerList.getListeners(ActionListener.class));
        while (iterator2.hasNext()) {
            ActionListener listener2 = (ActionListener)iterator2.next();
            listener2.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    @Override
    public void updateUI() {
        block0: {
            super.updateUI();
            JButton jButton = this.downBtn;
            if (jButton == null) break block0;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolbar.hoverBackground", (Object)UIManager.getColor("Button.background")), TuplesKt.to((Object)"toolbar.pressedBackground", (Object)UIManager.getColor("Button.background"))};
            jButton.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])pairArray));
        }
    }

    private static final void initEvents$lambda$0(FileSystemViewNav this$0, ItemEvent e) {
        Object item;
        if (e.getStateChange() == 1 && (item = this$0.comboBox.getSelectedItem()) instanceof FileObject) {
            this$0.changeSelectedPath((FileObject)item);
        }
    }

    public static final /* synthetic */ String access$formatDisplayPath(FileSystemViewNav $this, FileObject file) {
        return $this.formatDisplayPath(file);
    }

    public static final /* synthetic */ comboBox.1 access$getComboBox$p(FileSystemViewNav $this) {
        return $this.comboBox;
    }

    public static final /* synthetic */ void access$setPopupLastTime$p(FileSystemViewNav $this, long l) {
        $this.popupLastTime = l;
    }

    public static final /* synthetic */ MyFlatTextField access$getTextField$p(FileSystemViewNav $this) {
        return $this.textField;
    }

    public static final /* synthetic */ LinkedHashSet access$getHistory$p(FileSystemViewNav $this) {
        return $this.history;
    }

    public static final /* synthetic */ long access$getPopupLastTime$p(FileSystemViewNav $this) {
        return $this.popupLastTime;
    }

    public static final /* synthetic */ void access$showComboBoxPopup(FileSystemViewNav $this) {
        $this.showComboBoxPopup();
    }

    public static final /* synthetic */ FileSystemProvider access$getFileSystemProvider$p(FileSystemViewNav $this) {
        return $this.fileSystemProvider;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/sftp/FileSystemViewNav$Companion;", "", "<init>", "()V", "PATH", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lapp/termora/sftp/FileSystemViewNav$IndentIcon;", "Ljavax/swing/Icon;", "<init>", "()V", "space", "", "getSpace", "()I", "depth", "getDepth", "setDepth", "(I)V", "icon", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "termora"})
    public static final class IndentIcon
    implements Icon {
        private final int space;
        private int depth;
        @NotNull
        private Icon icon = NativeFileIcons.INSTANCE.getFolderIcon();

        public IndentIcon() {
            this.space = 10;
        }

        public final int getSpace() {
            return this.space;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final void setIcon(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"<set-?>");
            this.icon = icon;
        }

        @Override
        public void paintIcon(@NotNull Component c2, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (c2.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c2, g, x + this.depth * this.space, y);
            } else {
                this.icon.paintIcon(c2, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * this.space;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lapp/termora/sftp/FileSystemViewNav$LayeredPane;", "Ljavax/swing/JLayeredPane;", "<init>", "()V", "doLayout", "", "termora"})
    private static final class LayeredPane
    extends JLayeredPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getComponents());
                while (iterator2.hasNext()) {
                    Component c2 = (Component)iterator2.next();
                    c2.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lapp/termora/sftp/FileSystemViewNav$MyFlatTextField;", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "<init>", "()V", "fireActionPerformed", "", "termora"})
    public static final class MyFlatTextField
    extends FlatTextField {
        public void fireActionPerformed() {
            super.fireActionPerformed();
        }
    }
}

