/*
 * Decompiled with CFR 0.152.
 */
package app.termora.sftp;

import app.termora.Application;
import app.termora.Database;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TermoraFrameKt;
import app.termora.sftp.BookmarksDialog;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eJ\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0014R\u001f\u0010\u0004\u001a\u00060\u0005R\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lapp/termora/sftp/BookmarkButton;", "Ljavax/swing/JButton;", "<init>", "()V", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "properties$delegate", "Lkotlin/Lazy;", "arrowWidth", "", "arrowSize", "button", "value", "", "isBookmark", "()Z", "setBookmark", "(Z)V", "showBookmarks", "", "e", "Ljava/awt/event/MouseEvent;", "addBookmark", "text", "", "deleteBookmark", "getBookmarks", "", "paintComponent", "g", "Ljava/awt/Graphics;", "isSelected", "fireActionPerformed", "event", "Ljava/awt/event/ActionEvent;", "termora"})
@SourceDebugExtension(value={"SMAP\nBookmarkButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkButton.kt\napp/termora/sftp/BookmarkButton\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n205#2:165\n205#2:166\n222#2:168\n205#2:169\n1#3:167\n*S KotlinDebug\n*F\n+ 1 BookmarkButton.kt\napp/termora/sftp/BookmarkButton\n*L\n104#1:165\n112#1:166\n123#1:168\n74#1:169\n*E\n"})
public final class BookmarkButton
extends JButton {
    @NotNull
    private final Lazy properties$delegate = LazyKt.lazy(BookmarkButton::properties_delegate$lambda$0);
    private final int arrowWidth;
    private final int arrowSize;
    @NotNull
    private final BookmarkButton button = this;
    private boolean isBookmark;

    public BookmarkButton() {
        super((Icon)((Object)Icons.INSTANCE.getBookmarks()));
        this.arrowWidth = 16;
        this.arrowSize = 6;
        final int oldWidth = this.getPreferredSize().width;
        this.setPreferredSize(new Dimension(oldWidth + this.arrowWidth, this.getPreferredSize().height));
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getX() < oldWidth) {
                        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getActionListeners());
                        while (iterator2.hasNext()) {
                            ActionListener listener2 = (ActionListener)iterator2.next();
                            listener2.actionPerformed(new ActionEvent(button, 1001, ""));
                        }
                    } else {
                        this.showBookmarks(e);
                    }
                }
            }
        });
        this.setBookmark(false);
    }

    private final Database.Properties getProperties() {
        Lazy lazy = this.properties$delegate;
        return (Database.Properties)lazy.getValue();
    }

    public final boolean isBookmark() {
        return this.isBookmark;
    }

    public final void setBookmark(boolean value) {
        this.isBookmark = value;
        this.setIcon(value ? (Icon)((Object)Icons.INSTANCE.getBookmarksOff()) : (Icon)((Object)Icons.INSTANCE.getBookmarks()));
    }

    private final void showBookmarks(MouseEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        List<String> bookmarks = this.getBookmarks();
        popupMenu.add(I18n.INSTANCE.getString("termora.transport.bookmarks")).addActionListener(arg_0 -> BookmarkButton.showBookmarks$lambda$1(this, bookmarks, arg_0));
        if (!((Collection)bookmarks).isEmpty()) {
            popupMenu.addSeparator();
            for (String bookmark : bookmarks) {
                popupMenu.add(bookmark).addActionListener(arg_0 -> BookmarkButton.showBookmarks$lambda$2(this, bookmark, arg_0));
            }
        }
        popupMenu.show(e.getComponent(), -(popupMenu.getPreferredSize().width / 2 - this.getWidth() / 2), this.getHeight() + 2);
    }

    public final void addBookmark(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermoraFrameKt.assertEventDispatchThread();
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        List bookmarks = CollectionsKt.toMutableList((Collection)this.getBookmarks());
        bookmarks.add(text);
        Database.Properties properties = this.getProperties();
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), (Object)bookmarks));
    }

    public final void deleteBookmark(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermoraFrameKt.assertEventDispatchThread();
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        List bookmarks = CollectionsKt.toMutableList((Collection)this.getBookmarks());
        bookmarks.removeIf(arg_0 -> BookmarkButton.deleteBookmark$lambda$4(arg_0 -> BookmarkButton.deleteBookmark$lambda$3(text, arg_0), arg_0));
        Database.Properties properties = this.getProperties();
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), (Object)bookmarks));
    }

    @NotNull
    public final List<String> getBookmarks() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return CollectionsKt.emptyList();
        }
        Database.Properties properties = this.getProperties();
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String text = properties.getString(string, "[]");
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Object $this$getBookmarks_u24lambda_u245;
            Object object = this;
            try {
                $this$getBookmarks_u24lambda_u245 = object;
                boolean bl = false;
                Json this_$iv = Application.INSTANCE.getOhMyJson();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $this$getBookmarks_u24lambda_u245 = Result.constructor-impl((Object)((List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), text)));
            }
            catch (Throwable bl) {
                $this$getBookmarks_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$getBookmarks_u24lambda_u245;
            if (Result.isSuccess-impl((Object)object)) {
                List it = (List)object;
                boolean bl = false;
                return it;
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        int x = this.getPreferredSize().width - this.arrowWidth;
        ((Graphics2D)g).setColor(DynamicColor.Companion.getBorderColor());
        g.drawLine(x + 1, 4, x + 1, this.getPreferredSize().height - 2);
        ((Graphics2D)g).setColor(FlatLaf.isLafDark() ? new Color(206, 208, 214) : new Color(108, 112, 126));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FlatUIUtils.paintArrow((Graphics2D)g2d, (int)x, (int)(this.getPreferredSize().height / 2 - this.arrowSize), (int)this.arrowWidth, (int)this.arrowWidth, (int)5, (boolean)false, (int)this.arrowSize, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    protected void fireActionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private static final Database.Properties properties_delegate$lambda$0() {
        return Database.Companion.getDatabase().getProperties();
    }

    private static final void showBookmarks$lambda$1(BookmarkButton this$0, List $bookmarks, ActionEvent it) {
        Window window = SwingUtilities.getWindowAncestor(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        List<String> list = new BookmarksDialog(window, $bookmarks).open();
        Database.Properties properties = this$0.getProperties();
        String string = this$0.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json this_$iv = Application.INSTANCE.getOhMyJson();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), list));
    }

    private static final void showBookmarks$lambda$2(BookmarkButton this$0, String $bookmark, ActionEvent it) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this$0.getActionListeners());
        while (iterator2.hasNext()) {
            ActionListener listener2 = (ActionListener)iterator2.next();
            listener2.actionPerformed(new ActionEvent(this$0.button, 1001, $bookmark));
        }
    }

    private static final boolean deleteBookmark$lambda$3(String $text, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)$text, (Object)it);
    }

    private static final boolean deleteBookmark$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

