/*
 * Decompiled with CFR 0.152.
 */
package app.termora.native.osx;

import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lapp/termora/native/osx/NativeMacLibrary;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNSWindow", "", "window", "Ljava/awt/Window;", "(Ljava/awt/Window;)Ljava/lang/Long;", "setControlsVisible", "", "visible", "", "termora"})
public final class NativeMacLibrary {
    @NotNull
    public static final NativeMacLibrary INSTANCE = new NativeMacLibrary();
    private static final Logger log = LoggerFactory.getLogger(NativeMacLibrary.class);

    private NativeMacLibrary() {
    }

    @Nullable
    public final Long getNSWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            Field field = Component.class.getDeclaredField("peer");
            if (field == null) {
                return null;
            }
            Field peerField = field;
            peerField.setAccessible(true);
            Object object = peerField.get(window);
            if (object == null) {
                return null;
            }
            Object peer = object;
            Field field2 = peer.getClass().getDeclaredField("platformWindow");
            if (field2 == null) {
                return null;
            }
            Field platformWindowField = field2;
            platformWindowField.setAccessible(true);
            Object platformWindow = platformWindowField.get(peer);
            Field field3 = Class.forName("sun.lwawt.macosx.CFRetainedResource").getDeclaredField("ptr");
            if (field3 == null) {
                return null;
            }
            Field ptrField = field3;
            ptrField.setAccessible(true);
            Object object2 = ptrField.get(platformWindow);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
            return (Long)object2;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public final void setControlsVisible(@NotNull Window window, boolean visible) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Long l = this.getNSWindow(window);
            if (l == null) {
                return;
            }
            ID nsWindow = new ID(l.longValue());
            try {
                Foundation.executeOnMainThread((boolean)true, (boolean)true, () -> NativeMacLibrary.setControlsVisible$lambda$0(nsWindow, visible));
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final void setControlsVisible$lambda$0(ID $nsWindow, boolean $visible) {
        for (int i = 0; i < 3; ++i) {
            Object[] objectArray = new Object[]{i};
            ID button = Foundation.invoke((ID)$nsWindow, (String)"standardWindowButton:", (Object[])objectArray);
            objectArray = new Object[]{!$visible};
            Foundation.invoke((ID)button, (String)"setHidden:", (Object[])objectArray);
        }
    }
}

