/*
 * Decompiled with CFR 0.152.
 */
package app.termora.native.osx;

import app.termora.ApplicationScope;
import app.termora.native.KeyStorage;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lapp/termora/native/osx/MacOSKeyStorage;", "Lapp/termora/native/KeyStorage;", "<init>", "()V", "setPassword", "", "serviceName", "", "username", "password", "getPassword", "getPasswords", "", "Lkotlin/Pair;", "deletePassword", "Companion", "Security", "termora"})
public final class MacOSKeyStorage
implements KeyStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int errSecItemNotFound = -25300;
    private static final int errSecSuccess;
    @NotNull
    private static final Lazy<CoreFoundation> coreFoundation$delegate;
    @NotNull
    private static final Lazy<Security> security$delegate;
    @NotNull
    private static final Lazy<NativeLibrary> nativeLibrary$delegate;
    @NotNull
    private static final Lazy<Pointer> kCFTypeDictionaryKeyCallBacks$delegate;
    @NotNull
    private static final Lazy<Pointer> kCFTypeDictionaryValueCallBacks$delegate;
    @NotNull
    private static final Lazy<Pointer> kCFBooleanTrue$delegate;

    private MacOSKeyStorage() {
    }

    @Override
    public boolean setPassword(@NotNull String serviceName, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.deletePassword(serviceName, username);
        CoreFoundation.CFMutableDictionaryRef query = MacOSKeyStorage.Companion.getCoreFoundation().CFDictionaryCreateMutable(MacOSKeyStorage.Companion.getCoreFoundation().CFAllocatorGetDefault(), new CoreFoundation.CFIndex(0L), MacOSKeyStorage.Companion.getKCFTypeDictionaryKeyCallBacks(), MacOSKeyStorage.Companion.getKCFTypeDictionaryValueCallBacks());
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClass()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClassGenericPassword()));
        CoreFoundation.CFStringRef cfServiceName = CoreFoundation.CFStringRef.createCFString((String)serviceName);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrService()), (PointerType)cfServiceName);
        CoreFoundation.CFStringRef cfUsername = CoreFoundation.CFStringRef.createCFString((String)username);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrAccount()), (PointerType)cfUsername);
        String string = password;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        Memory passwordMemory = new Memory((long)bytes.length);
        passwordMemory.write(0L, bytes, 0, bytes.length);
        CoreFoundation.CFDataRef cfPassword = MacOSKeyStorage.Companion.getCoreFoundation().CFDataCreate(MacOSKeyStorage.Companion.getCoreFoundation().CFAllocatorGetDefault(), (Pointer)passwordMemory, new CoreFoundation.CFIndex(passwordMemory.size()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecValueData()), (PointerType)cfPassword);
        Security security = MacOSKeyStorage.Companion.getSecurity();
        Intrinsics.checkNotNull((Object)query);
        int code = security.SecItemAdd((CoreFoundation.CFDictionaryRef)query, null);
        cfUsername.release();
        cfServiceName.release();
        cfPassword.release();
        query.release();
        return errSecSuccess == code;
    }

    @Override
    @Nullable
    public String getPassword(@NotNull String serviceName, @NotNull String username) {
        Pointer cfPassword;
        Pointer cfAccount;
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        CoreFoundation.CFMutableDictionaryRef query = MacOSKeyStorage.Companion.getCoreFoundation().CFDictionaryCreateMutable(MacOSKeyStorage.Companion.getCoreFoundation().CFAllocatorGetDefault(), new CoreFoundation.CFIndex(0L), null, null);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClass()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClassGenericPassword()));
        CoreFoundation.CFStringRef cfServiceName = CoreFoundation.CFStringRef.createCFString((String)serviceName);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrService()), (PointerType)cfServiceName);
        CoreFoundation.CFStringRef cfUsername = CoreFoundation.CFStringRef.createCFString((String)username);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrAccount()), (PointerType)cfUsername);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecReturnData()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecReturnRef()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecReturnAttributes()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchLimit()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchLimitOne()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchCaseInsensitive()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        String password = null;
        CoreFoundation.CFDictionaryRef cfDictionary = null;
        PointerByReference result = new PointerByReference();
        Security security = MacOSKeyStorage.Companion.getSecurity();
        Intrinsics.checkNotNull((Object)query);
        CoreFoundation.CFDictionaryRef cFDictionaryRef = (CoreFoundation.CFDictionaryRef)query;
        Pointer pointer = result.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        int code = security.SecItemCopyMatching(cFDictionaryRef, pointer);
        if (code == errSecSuccess && (cfAccount = (cfDictionary = new CoreFoundation.CFDictionaryRef(result.getValue())).getValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrAccount()))) != null && !Intrinsics.areEqual((Object)cfAccount, (Object)Pointer.NULL) && Intrinsics.areEqual((Object)new CoreFoundation.CFStringRef(cfAccount).stringValue(), (Object)username) && (cfPassword = cfDictionary.getValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecValueData()))) != null && !Intrinsics.areEqual((Object)cfPassword, (Object)Pointer.NULL)) {
            password = new CoreFoundation.CFDataRef(cfPassword).getBytePtr().getString(0L);
        }
        CoreFoundation.CFDictionaryRef cFDictionaryRef2 = cfDictionary;
        if (cFDictionaryRef2 != null) {
            cFDictionaryRef2.release();
        }
        cfServiceName.release();
        query.release();
        return password;
    }

    @NotNull
    public final List<Pair<String, String>> getPasswords(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        CoreFoundation.CFMutableDictionaryRef query = MacOSKeyStorage.Companion.getCoreFoundation().CFDictionaryCreateMutable(MacOSKeyStorage.Companion.getCoreFoundation().CFAllocatorGetDefault(), new CoreFoundation.CFIndex(0L), null, null);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClass()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClassGenericPassword()));
        CoreFoundation.CFStringRef cfServiceName = CoreFoundation.CFStringRef.createCFString((String)serviceName);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrService()), (PointerType)cfServiceName);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecReturnRef()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecReturnAttributes()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchLimit()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchLimitAll()));
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecMatchCaseInsensitive()), (PointerType)new CoreFoundation.CFBooleanRef(MacOSKeyStorage.Companion.getKCFBooleanTrue()));
        CoreFoundation.CFArrayRef cfArray = null;
        PointerByReference result = new PointerByReference();
        Security security = MacOSKeyStorage.Companion.getSecurity();
        Intrinsics.checkNotNull((Object)query);
        CoreFoundation.CFDictionaryRef cFDictionaryRef = (CoreFoundation.CFDictionaryRef)query;
        Pointer pointer = result.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        int code = security.SecItemCopyMatching(cFDictionaryRef, pointer);
        List list = new ArrayList();
        if (code == errSecSuccess) {
            CoreFoundation.CFDictionaryRef cfDictionary;
            Pointer cfAccount;
            cfArray = new CoreFoundation.CFArrayRef(result.getValue());
            int n = cfArray.getCount();
            for (int i = 0; i < n && (cfAccount = (cfDictionary = new CoreFoundation.CFDictionaryRef(cfArray.getValueAtIndex(i))).getValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrAccount()))) != null && !Intrinsics.areEqual((Object)cfAccount, (Object)Pointer.NULL); ++i) {
                String username = new CoreFoundation.CFStringRef(cfAccount).stringValue();
                String string = new CoreFoundation.CFStringRef(cfAccount).stringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
                String password = this.getPassword(serviceName, string);
                if (password == null) continue;
                list.add(new Pair((Object)username, (Object)password));
            }
        }
        CoreFoundation.CFArrayRef cFArrayRef = cfArray;
        if (cFArrayRef != null) {
            cFArrayRef.release();
        }
        cfServiceName.release();
        query.release();
        return list;
    }

    @Override
    public boolean deletePassword(@NotNull String serviceName, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        CoreFoundation.CFMutableDictionaryRef query = MacOSKeyStorage.Companion.getCoreFoundation().CFDictionaryCreateMutable(MacOSKeyStorage.Companion.getCoreFoundation().CFAllocatorGetDefault(), new CoreFoundation.CFIndex(0L), MacOSKeyStorage.Companion.getKCFTypeDictionaryKeyCallBacks(), MacOSKeyStorage.Companion.getKCFTypeDictionaryValueCallBacks());
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClass()), (PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecClassGenericPassword()));
        CoreFoundation.CFStringRef cfServiceName = CoreFoundation.CFStringRef.createCFString((String)serviceName);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrService()), (PointerType)cfServiceName);
        CoreFoundation.CFStringRef cfUsername = CoreFoundation.CFStringRef.createCFString((String)username);
        query.setValue((PointerType)new CoreFoundation.CFTypeRef(Security.Companion.getKSecAttrAccount()), (PointerType)cfUsername);
        Security security = MacOSKeyStorage.Companion.getSecurity();
        Intrinsics.checkNotNull((Object)query);
        int code = security.SecItemDelete((CoreFoundation.CFDictionaryRef)query);
        cfUsername.release();
        cfServiceName.release();
        query.release();
        return code == errSecItemNotFound || code == errSecSuccess;
    }

    private static final CoreFoundation coreFoundation_delegate$lambda$0() {
        return CoreFoundation.INSTANCE;
    }

    private static final Security security_delegate$lambda$1() {
        return Security.Companion.getInstance();
    }

    private static final NativeLibrary nativeLibrary_delegate$lambda$2() {
        return Native.getNativeLibrary((Library)((Library)MacOSKeyStorage.Companion.getCoreFoundation()));
    }

    private static final Pointer kCFTypeDictionaryKeyCallBacks_delegate$lambda$3() {
        Pointer pointer = MacOSKeyStorage.Companion.getNativeLibrary().getGlobalVariableAddress("kCFTypeDictionaryKeyCallBacks");
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
        return MacOSKeyStorage.Companion.getPointer(pointer);
    }

    private static final Pointer kCFTypeDictionaryValueCallBacks_delegate$lambda$4() {
        Pointer pointer = MacOSKeyStorage.Companion.getNativeLibrary().getGlobalVariableAddress("kCFTypeDictionaryValueCallBacks");
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
        return MacOSKeyStorage.Companion.getPointer(pointer);
    }

    private static final Pointer kCFBooleanTrue_delegate$lambda$5() {
        Pointer pointer = MacOSKeyStorage.Companion.getNativeLibrary().getGlobalVariableAddress("kCFBooleanTrue");
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
        return MacOSKeyStorage.Companion.getPointer(pointer);
    }

    public /* synthetic */ MacOSKeyStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        coreFoundation$delegate = LazyKt.lazy(MacOSKeyStorage::coreFoundation_delegate$lambda$0);
        security$delegate = LazyKt.lazy(MacOSKeyStorage::security_delegate$lambda$1);
        nativeLibrary$delegate = LazyKt.lazy(MacOSKeyStorage::nativeLibrary_delegate$lambda$2);
        kCFTypeDictionaryKeyCallBacks$delegate = LazyKt.lazy(MacOSKeyStorage::kCFTypeDictionaryKeyCallBacks_delegate$lambda$3);
        kCFTypeDictionaryValueCallBacks$delegate = LazyKt.lazy(MacOSKeyStorage::kCFTypeDictionaryValueCallBacks_delegate$lambda$4);
        kCFBooleanTrue$delegate = LazyKt.lazy(MacOSKeyStorage::kCFBooleanTrue_delegate$lambda$5);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0014\u001a\n \u000b*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R#\u0010\u0019\u001a\n \u000b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001b\u0010\u001cR#\u0010\u001e\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0013\u001a\u0004\b\u001f\u0010 R#\u0010\"\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0013\u001a\u0004\b#\u0010 R#\u0010%\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0013\u001a\u0004\b&\u0010 \u00a8\u0006("}, d2={"Lapp/termora/native/osx/MacOSKeyStorage$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/native/osx/MacOSKeyStorage;", "errSecItemNotFound", "", "errSecSuccess", "pointer", "Lcom/sun/jna/Pointer;", "kotlin.jvm.PlatformType", "getPointer", "(Lcom/sun/jna/Pointer;)Lcom/sun/jna/Pointer;", "coreFoundation", "Lcom/sun/jna/platform/mac/CoreFoundation;", "getCoreFoundation", "()Lcom/sun/jna/platform/mac/CoreFoundation;", "coreFoundation$delegate", "Lkotlin/Lazy;", "security", "Lapp/termora/native/osx/MacOSKeyStorage$Security;", "getSecurity", "()Lapp/termora/native/osx/MacOSKeyStorage$Security;", "security$delegate", "nativeLibrary", "Lcom/sun/jna/NativeLibrary;", "getNativeLibrary", "()Lcom/sun/jna/NativeLibrary;", "nativeLibrary$delegate", "kCFTypeDictionaryKeyCallBacks", "getKCFTypeDictionaryKeyCallBacks", "()Lcom/sun/jna/Pointer;", "kCFTypeDictionaryKeyCallBacks$delegate", "kCFTypeDictionaryValueCallBacks", "getKCFTypeDictionaryValueCallBacks", "kCFTypeDictionaryValueCallBacks$delegate", "kCFBooleanTrue", "getKCFBooleanTrue", "kCFBooleanTrue$delegate", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MacOSKeyStorage getInstance() {
            return (MacOSKeyStorage)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(MacOSKeyStorage.class), Companion::getInstance$lambda$0);
        }

        private final Pointer getPointer(Pointer $this$pointer) {
            return $this$pointer.getPointer(0L);
        }

        private final CoreFoundation getCoreFoundation() {
            Lazy lazy = coreFoundation$delegate;
            return (CoreFoundation)lazy.getValue();
        }

        private final Security getSecurity() {
            Lazy lazy = security$delegate;
            return (Security)lazy.getValue();
        }

        private final NativeLibrary getNativeLibrary() {
            Lazy lazy = nativeLibrary$delegate;
            return (NativeLibrary)lazy.getValue();
        }

        private final Pointer getKCFTypeDictionaryKeyCallBacks() {
            Lazy lazy = kCFTypeDictionaryKeyCallBacks$delegate;
            return (Pointer)lazy.getValue();
        }

        private final Pointer getKCFTypeDictionaryValueCallBacks() {
            Lazy lazy = kCFTypeDictionaryValueCallBacks$delegate;
            return (Pointer)lazy.getValue();
        }

        private final Pointer getKCFBooleanTrue() {
            Lazy lazy = kCFBooleanTrue$delegate;
            return (Pointer)lazy.getValue();
        }

        private static final MacOSKeyStorage getInstance$lambda$0() {
            return new MacOSKeyStorage(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lapp/termora/native/osx/MacOSKeyStorage$Security;", "Lcom/sun/jna/Library;", "SecItemAdd", "", "attributes", "Lcom/sun/jna/platform/mac/CoreFoundation$CFDictionaryRef;", "result", "Lcom/sun/jna/platform/mac/CoreFoundation$CFTypeRef;", "SecItemDelete", "SecItemCopyMatching", "query", "Lcom/sun/jna/Pointer;", "Companion", "termora"})
    private static interface Security
    extends Library {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public int SecItemAdd(@NotNull CoreFoundation.CFDictionaryRef var1, @Nullable CoreFoundation.CFTypeRef var2);

        public int SecItemDelete(@NotNull CoreFoundation.CFDictionaryRef var1);

        public int SecItemCopyMatching(@NotNull CoreFoundation.CFDictionaryRef var1, @NotNull Pointer var2);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b%\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR#\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR#\u0010\u0010\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0015\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0016\u0010\u0013R#\u0010\u0018\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\n\u001a\u0004\b\u0019\u0010\u0013R#\u0010\u001b\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\n\u001a\u0004\b\u001c\u0010\u0013R#\u0010\u001e\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\n\u001a\u0004\b\u001f\u0010\u0013R#\u0010!\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b\"\u0010\u0013R#\u0010$\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\n\u001a\u0004\b%\u0010\u0013R#\u0010'\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\n\u001a\u0004\b(\u0010\u0013R#\u0010*\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\n\u001a\u0004\b+\u0010\u0013R#\u0010-\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\n\u001a\u0004\b.\u0010\u0013R#\u00100\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\n\u001a\u0004\b1\u0010\u0013R#\u00103\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\n\u001a\u0004\b4\u0010\u0013\u00a8\u00066"}, d2={"Lapp/termora/native/osx/MacOSKeyStorage$Security$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/native/osx/MacOSKeyStorage$Security;", "kotlin.jvm.PlatformType", "getInstance", "()Lapp/termora/native/osx/MacOSKeyStorage$Security;", "instance$delegate", "Lkotlin/Lazy;", "nativeLibrary", "Lcom/sun/jna/NativeLibrary;", "getNativeLibrary", "()Lcom/sun/jna/NativeLibrary;", "nativeLibrary$delegate", "kSecAttrService", "Lcom/sun/jna/Pointer;", "getKSecAttrService", "()Lcom/sun/jna/Pointer;", "kSecAttrService$delegate", "kSecClass", "getKSecClass", "kSecClass$delegate", "kSecAttrAccount", "getKSecAttrAccount", "kSecAttrAccount$delegate", "kSecValueData", "getKSecValueData", "kSecValueData$delegate", "kSecClassGenericPassword", "getKSecClassGenericPassword", "kSecClassGenericPassword$delegate", "kSecReturnAttributes", "getKSecReturnAttributes", "kSecReturnAttributes$delegate", "kSecReturnRef", "getKSecReturnRef", "kSecReturnRef$delegate", "kSecReturnData", "getKSecReturnData", "kSecReturnData$delegate", "kSecMatchCaseInsensitive", "getKSecMatchCaseInsensitive", "kSecMatchCaseInsensitive$delegate", "kSecMatchLimit", "getKSecMatchLimit", "kSecMatchLimit$delegate", "kSecMatchLimitOne", "getKSecMatchLimitOne", "kSecMatchLimitOne$delegate", "kSecMatchLimitAll", "getKSecMatchLimitAll", "kSecMatchLimitAll$delegate", "termora"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Lazy<Security> instance$delegate;
            @NotNull
            private static final Lazy<NativeLibrary> nativeLibrary$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecAttrService$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecClass$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecAttrAccount$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecValueData$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecClassGenericPassword$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecReturnAttributes$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecReturnRef$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecReturnData$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecMatchCaseInsensitive$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecMatchLimit$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecMatchLimitOne$delegate;
            @NotNull
            private static final Lazy<Pointer> kSecMatchLimitAll$delegate;

            private Companion() {
            }

            public final Security getInstance() {
                Lazy<Security> lazy = instance$delegate;
                return (Security)lazy.getValue();
            }

            private final NativeLibrary getNativeLibrary() {
                Lazy<NativeLibrary> lazy = nativeLibrary$delegate;
                return (NativeLibrary)lazy.getValue();
            }

            public final Pointer getKSecAttrService() {
                Lazy<Pointer> lazy = kSecAttrService$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecClass() {
                Lazy<Pointer> lazy = kSecClass$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecAttrAccount() {
                Lazy<Pointer> lazy = kSecAttrAccount$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecValueData() {
                Lazy<Pointer> lazy = kSecValueData$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecClassGenericPassword() {
                Lazy<Pointer> lazy = kSecClassGenericPassword$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecReturnAttributes() {
                Lazy<Pointer> lazy = kSecReturnAttributes$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecReturnRef() {
                Lazy<Pointer> lazy = kSecReturnRef$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecReturnData() {
                Lazy<Pointer> lazy = kSecReturnData$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecMatchCaseInsensitive() {
                Lazy<Pointer> lazy = kSecMatchCaseInsensitive$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecMatchLimit() {
                Lazy<Pointer> lazy = kSecMatchLimit$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecMatchLimitOne() {
                Lazy<Pointer> lazy = kSecMatchLimitOne$delegate;
                return (Pointer)lazy.getValue();
            }

            public final Pointer getKSecMatchLimitAll() {
                Lazy<Pointer> lazy = kSecMatchLimitAll$delegate;
                return (Pointer)lazy.getValue();
            }

            private static final Security instance_delegate$lambda$0() {
                return (Security)Native.load((String)"Security", Security.class);
            }

            private static final NativeLibrary nativeLibrary_delegate$lambda$1() {
                return Native.getNativeLibrary((Library)$$INSTANCE.getInstance());
            }

            private static final Pointer kSecAttrService_delegate$lambda$2() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecAttrService");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecClass_delegate$lambda$3() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecClass");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecAttrAccount_delegate$lambda$4() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecAttrAccount");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecValueData_delegate$lambda$5() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecValueData");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecClassGenericPassword_delegate$lambda$6() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecClassGenericPassword");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecReturnAttributes_delegate$lambda$7() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecReturnAttributes");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecReturnRef_delegate$lambda$8() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecReturnRef");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecReturnData_delegate$lambda$9() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecReturnData");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecMatchCaseInsensitive_delegate$lambda$10() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecMatchCaseInsensitive");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecMatchLimit_delegate$lambda$11() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecMatchLimit");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecMatchLimitOne_delegate$lambda$12() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecMatchLimitOne");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            private static final Pointer kSecMatchLimitAll_delegate$lambda$13() {
                Pointer pointer = $$INSTANCE.getNativeLibrary().getGlobalVariableAddress("kSecMatchLimitAll");
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getGlobalVariableAddress(...)");
                return MacOSKeyStorage.Companion.getPointer(pointer);
            }

            static {
                $$INSTANCE = new Companion();
                instance$delegate = LazyKt.lazy(Companion::instance_delegate$lambda$0);
                nativeLibrary$delegate = LazyKt.lazy(Companion::nativeLibrary_delegate$lambda$1);
                kSecAttrService$delegate = LazyKt.lazy(Companion::kSecAttrService_delegate$lambda$2);
                kSecClass$delegate = LazyKt.lazy(Companion::kSecClass_delegate$lambda$3);
                kSecAttrAccount$delegate = LazyKt.lazy(Companion::kSecAttrAccount_delegate$lambda$4);
                kSecValueData$delegate = LazyKt.lazy(Companion::kSecValueData_delegate$lambda$5);
                kSecClassGenericPassword$delegate = LazyKt.lazy(Companion::kSecClassGenericPassword_delegate$lambda$6);
                kSecReturnAttributes$delegate = LazyKt.lazy(Companion::kSecReturnAttributes_delegate$lambda$7);
                kSecReturnRef$delegate = LazyKt.lazy(Companion::kSecReturnRef_delegate$lambda$8);
                kSecReturnData$delegate = LazyKt.lazy(Companion::kSecReturnData_delegate$lambda$9);
                kSecMatchCaseInsensitive$delegate = LazyKt.lazy(Companion::kSecMatchCaseInsensitive_delegate$lambda$10);
                kSecMatchLimit$delegate = LazyKt.lazy(Companion::kSecMatchLimit_delegate$lambda$11);
                kSecMatchLimitOne$delegate = LazyKt.lazy(Companion::kSecMatchLimitOne_delegate$lambda$12);
                kSecMatchLimitAll$delegate = LazyKt.lazy(Companion::kSecMatchLimitAll_delegate$lambda$13);
            }
        }
    }
}

