/*
 * Decompiled with CFR 0.152.
 */
package app.termora.macro;

import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.DeleteDataManager;
import app.termora.macro.Macro;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lapp/termora/macro/MacroManager;", "", "<init>", "()V", "macros", "", "", "Lapp/termora/macro/Macro;", "database", "Lapp/termora/Database;", "getDatabase", "()Lapp/termora/Database;", "getMacros", "", "addMacro", "", "macro", "removeMacro", "id", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroManager.kt\napp/termora/macro/MacroManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1208#2,2:49\n1236#2,4:51\n1056#2:55\n*S KotlinDebug\n*F\n+ 1 MacroManager.kt\napp/termora/macro/MacroManager\n*L\n24#1:49,2\n24#1:51,4\n28#1:55\n*E\n"})
public final class MacroManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Macro> macros = new LinkedHashMap();
    private static final Logger log = LoggerFactory.getLogger(MacroManager.class);

    /*
     * WARNING - void declaration
     */
    private MacroManager() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.getDatabase().getMacros();
        Map<String, Macro> map = this.macros;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Macro macro = (Macro)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        map.putAll(destination$iv$iv);
    }

    private final Database getDatabase() {
        return Database.Companion.getDatabase();
    }

    @NotNull
    public final List<Macro> getMacros() {
        Iterable $this$sortedBy$iv = this.macros.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Macro it = (Macro)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreated());
                it = (Macro)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCreated()));
            }
        });
    }

    public final void addMacro(@NotNull Macro macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        this.getDatabase().addMacro(macro);
        this.macros.put(macro.getId(), macro);
        if (log.isDebugEnabled()) {
            log.debug("Added macro " + macro.getId());
        }
    }

    public final void removeMacro(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.getDatabase().removeMacro(id);
        this.macros.remove(id);
        DeleteDataManager.removeMacro$default(DeleteDataManager.Companion.getInstance(), id, 0L, 2, null);
        if (log.isDebugEnabled()) {
            log.debug("Removed macro " + id);
        }
    }

    public /* synthetic */ MacroManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/macro/MacroManager$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/macro/MacroManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MacroManager getInstance() {
            return (MacroManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(MacroManager.class), Companion::getInstance$lambda$0);
        }

        private static final MacroManager getInstance$lambda$0() {
            return new MacroManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

