/*
 * Decompiled with CFR 0.152.
 */
package app.termora.macro;

import app.termora.ApplicationScope;
import app.termora.I18n;
import app.termora.actions.AnAction;
import app.termora.findeverywhere.ActionFindEverywhereResult;
import app.termora.findeverywhere.FindEverywhereProvider;
import app.termora.findeverywhere.FindEverywhereResult;
import app.termora.macro.Macro;
import app.termora.macro.MacroAction;
import app.termora.macro.MacroManager;
import app.termora.macro.MacroPlaybackAction;
import app.termora.macro.MacroStartRecordingAction;
import app.termora.macro.MacroStopRecordingAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lapp/termora/macro/MacroFindEverywhereProvider;", "Lapp/termora/findeverywhere/FindEverywhereProvider;", "<init>", "()V", "macroManager", "Lapp/termora/macro/MacroManager;", "getMacroManager", "()Lapp/termora/macro/MacroManager;", "find", "", "Lapp/termora/findeverywhere/FindEverywhereResult;", "pattern", "", "group", "toggleMacroAction", "Lapp/termora/actions/AnAction;", "macroAction", "Lapp/termora/macro/MacroAction;", "MacroFindEverywhereResult", "termora"})
@SourceDebugExtension(value={"SMAP\nMacroFindEverywhereProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroFindEverywhereProvider.kt\napp/termora/macro/MacroFindEverywhereProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1068#2:79\n*S KotlinDebug\n*F\n+ 1 MacroFindEverywhereProvider.kt\napp/termora/macro/MacroFindEverywhereProvider\n*L\n45#1:79\n*E\n"})
public final class MacroFindEverywhereProvider
implements FindEverywhereProvider {
    private final MacroManager getMacroManager() {
        return MacroManager.Companion.getInstance();
    }

    @Override
    @NotNull
    public List<FindEverywhereResult> find(@NotNull String pattern) {
        MacroPlaybackAction playbackAction;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Action action = ActionManager.getInstance().getAction((Object)"MacroAction");
        if (action == null) {
            return CollectionsKt.emptyList();
        }
        Action macroAction = action;
        if (!(macroAction instanceof MacroAction)) {
            return CollectionsKt.emptyList();
        }
        List results = new ArrayList();
        AnAction toggleAction = this.toggleMacroAction((MacroAction)((Object)macroAction));
        if (toggleAction != null) {
            results.add(new ActionFindEverywhereResult(toggleAction){
                final /* synthetic */ AnAction $toggleAction;
                {
                    this.$toggleAction = $toggleAction;
                    super((Action)((Object)$toggleAction));
                }

                public Icon getIcon(boolean isSelected) {
                    if (this.$toggleAction instanceof MacroStopRecordingAction) {
                        Icon icon = ((MacroStopRecordingAction)this.$toggleAction).getSmallIcon();
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getSmallIcon(...)");
                        return icon;
                    }
                    return super.getIcon(isSelected);
                }
            });
        }
        if ((playbackAction = new MacroPlaybackAction()).isEnabled()) {
            results.add(new ActionFindEverywhereResult((Action)((Object)playbackAction)));
        }
        Iterable $this$sortedByDescending$iv = this.getMacroManager().getMacros();
        boolean $i$f$sortedByDescending = false;
        List macros = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Macro it = (Macro)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSort());
                it = (Macro)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
            }
        });
        int n = Math.min(macros.size(), 10);
        for (int i = 0; i < n; ++i) {
            results.add(new MacroFindEverywhereResult((Macro)macros.get(i), (MacroAction)((Object)macroAction)));
        }
        return results;
    }

    @Override
    @NotNull
    public String group() {
        return I18n.INSTANCE.getString("termora.macro");
    }

    private final AnAction toggleMacroAction(MacroAction macroAction) {
        AnAction action = macroAction.isRecording() ? (AnAction)new MacroStopRecordingAction(null, 1, null) : (AnAction)new MacroStartRecordingAction(null, 1, null);
        return action.isEnabled() ? action : null;
    }

    @Override
    public int order() {
        return FindEverywhereProvider.DefaultImpls.order(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lapp/termora/macro/MacroFindEverywhereProvider$MacroFindEverywhereResult;", "Lapp/termora/findeverywhere/FindEverywhereResult;", "macro", "Lapp/termora/macro/Macro;", "macroAction", "Lapp/termora/macro/MacroAction;", "<init>", "(Lapp/termora/macro/Macro;Lapp/termora/macro/MacroAction;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "toString", "", "termora"})
    private static final class MacroFindEverywhereResult
    implements FindEverywhereResult {
        @NotNull
        private final Macro macro;
        @NotNull
        private final MacroAction macroAction;

        public MacroFindEverywhereResult(@NotNull Macro macro, @NotNull MacroAction macroAction) {
            Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
            Intrinsics.checkNotNullParameter((Object)((Object)macroAction), (String)"macroAction");
            this.macro = macro;
            this.macroAction = macroAction;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object source = e.getSource();
            if (source instanceof Component) {
                this.macroAction.runMacro(ApplicationScope.Companion.forWindowScope((Component)source), this.macro);
            }
        }

        @NotNull
        public String toString() {
            return this.macro.getName();
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return FindEverywhereResult.DefaultImpls.getIcon(this, isSelected);
        }

        @Override
        @NotNull
        public String getText(boolean isSelected) {
            return FindEverywhereResult.DefaultImpls.getText(this, isSelected);
        }
    }
}

