/*
 * Decompiled with CFR 0.152.
 */
package app.termora.macro;

import app.termora.AES;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.PtyHostTerminalTab;
import app.termora.TerminalTab;
import app.termora.TerminalTabbedManager;
import app.termora.WindowScope;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.macro.Macro;
import app.termora.macro.MacroDialog;
import app.termora.macro.MacroManager;
import app.termora.macro.MacroPlaybackAction;
import app.termora.macro.MacroPtyConnector;
import app.termora.macro.MacroStartRecordingAction;
import app.termora.macro.MacroStopRecordingAction;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lapp/termora/macro/MacroAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "value", "", "isRecording", "()Z", "macroManager", "Lapp/termora/macro/MacroManager;", "getMacroManager", "()Lapp/termora/macro/MacroManager;", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "isSelected", "startRecording", "stopRecording", "runMacro", "windowScope", "Lapp/termora/WindowScope;", "macro", "Lapp/termora/macro/Macro;", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nMacroAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroAction.kt\napp/termora/macro/MacroAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1068#2:117\n*S KotlinDebug\n*F\n+ 1 MacroAction.kt\napp/termora/macro/MacroAction\n*L\n46#1:117\n*E\n"})
public final class MacroAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isRecording;
    private static final Logger log = LoggerFactory.getLogger(MacroAction.class);

    public MacroAction() {
        super(I18n.INSTANCE.getString("termora.macro"), (Icon)((Object)Icons.INSTANCE.getRec()));
        this.setStateAction();
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    private final MacroManager getMacroManager() {
        return MacroManager.Companion.getInstance();
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Object source = evt.getSource();
        if (!(source instanceof JComponent)) {
            return;
        }
        WindowScope windowScope = evt.getData(DataProviders.INSTANCE.getWindowScope());
        if (windowScope == null) {
            return;
        }
        WindowScope windowScope2 = windowScope;
        this.setSelected(this.isRecording);
        FlatPopupMenu menu = new FlatPopupMenu();
        JMenuItem startRecord = menu.add((Action)((Object)new MacroStartRecordingAction((Icon)((Object)Icons.INSTANCE.getEmpty()))));
        startRecord.setEnabled(!this.isRecording);
        JMenuItem stopRecord = menu.add((Action)((Object)new MacroStopRecordingAction((Icon)((Object)Icons.INSTANCE.getEmpty()))));
        stopRecord.setEnabled(this.isRecording);
        Iterable $this$sortedByDescending$iv = this.getMacroManager().getMacros();
        boolean $i$f$sortedByDescending = false;
        List macros = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Macro it = (Macro)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSort());
                it = (Macro)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
            }
        });
        menu.add((Action)((Object)new MacroPlaybackAction()));
        if (!((Collection)macros).isEmpty()) {
            menu.addSeparator();
            int count = Math.min(macros.size(), 10);
            for (int i = 0; i < count; ++i) {
                Macro macro = (Macro)macros.get(i);
                menu.add(macro.getName()).addActionListener(arg_0 -> MacroAction.actionPerformed$lambda$1(this, windowScope2, macro, arg_0));
            }
        }
        menu.addSeparator();
        menu.add(I18n.INSTANCE.getString("termora.macro.manager")).addActionListener(arg_0 -> MacroAction.actionPerformed$lambda$2(source, arg_0));
        int width = menu.getPreferredSize().width;
        menu.show((Component)source, -(width / 2) + ((JComponent)source).getWidth() / 2, ((JComponent)source).getHeight());
    }

    public boolean isSelected() {
        return this.isRecording;
    }

    public final void startRecording() {
        this.setSelected(true);
        this.isRecording = true;
        this.setSmallIcon((Icon)((Object)Icons.INSTANCE.getStop()));
    }

    public final void stopRecording() {
        this.setSelected(false);
        this.isRecording = false;
        this.setSmallIcon((Icon)((Object)Icons.INSTANCE.getRec()));
        byte[] bytes = MacroPtyConnector.Companion.getRecodingByteArray();
        if (bytes.length == 0) {
            return;
        }
        String string = AES.INSTANCE.encodeBase64String(bytes);
        String string2 = DateFormatUtils.format((Date)new Date(), (String)I18n.INSTANCE.getString("termora.date-format"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Macro macro = new Macro(null, string, string2, 0L, 0L, 0L, 57, null);
        this.getMacroManager().addMacro(macro);
    }

    public final void runMacro(@NotNull WindowScope windowScope, @NotNull Macro macro) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
            Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
            TerminalTabbedManager terminalTabbedManager = (TerminalTabbedManager)windowScope.get(Reflection.getOrCreateKotlinClass(TerminalTabbedManager.class));
            TerminalTab terminalTab = terminalTabbedManager.getSelectedTerminalTab();
            if (terminalTab == null) {
                return;
            }
            TerminalTab tab = terminalTab;
            if (!(tab instanceof PtyHostTerminalTab)) {
                return;
            }
            this.getMacroManager().addMacro(Macro.copy$default(macro, null, null, null, 0L, System.currentTimeMillis(), 0L, 47, null));
            try {
                ((PtyHostTerminalTab)tab).getPtyConnector().write(macro.getMacroByteArray());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error("Unable to write macro " + macro.getName(), (Throwable)e);
            }
        }
    }

    private static final void actionPerformed$lambda$1(MacroAction this$0, WindowScope $windowScope, Macro $macro, ActionEvent it) {
        this$0.runMacro($windowScope, $macro);
    }

    private static final void actionPerformed$lambda$2(Object $source, ActionEvent it) {
        Window window = SwingUtilities.getWindowAncestor((Component)$source);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        new MacroDialog(window).setVisible(true);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/macro/MacroAction$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

