/*
 * Decompiled with CFR 0.152.
 */
package app.termora.keymgr;

import app.termora.Application;
import app.termora.DialogWrapper;
import app.termora.DynamicColor;
import app.termora.Host;
import app.termora.HostKt;
import app.termora.HostTreeNode;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.NewHostTreeDialog;
import app.termora.OptionPane;
import app.termora.OutlineTextField;
import app.termora.Protocol;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.KeyManagerPanel;
import app.termora.keymgr.KeyPairTableModel;
import app.termora.keymgr.OhKeyPair;
import app.termora.keymgr.OhKeyPairKeyPairProvider;
import app.termora.keymgr.SSHCopyIdDialog;
import app.termora.native.FileChooser;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.extras.components.FlatTable;
import com.formdev.flatlaf.extras.components.FlatTextArea;
import com.formdev.flatlaf.icons.FlatFileViewFileIcon;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/keymgr/KeyManagerPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "keyPairTable", "Lcom/formdev/flatlaf/extras/components/FlatTable;", "getKeyPairTable", "()Lcom/formdev/flatlaf/extras/components/FlatTable;", "keyPairTableModel", "Lapp/termora/keymgr/KeyPairTableModel;", "getKeyPairTableModel", "()Lapp/termora/keymgr/KeyPairTableModel;", "generateBtn", "Ljavax/swing/JButton;", "importBtn", "exportBtn", "editBtn", "deleteBtn", "sshCopyIdBtn", "initView", "", "initEvents", "sshCopyId", "evt", "Lapp/termora/actions/AnActionEvent;", "exportKeyPairs", "file", "Ljava/io/File;", "keyPairs", "", "Lapp/termora/keymgr/OhKeyPair;", "GenerateKeyDialog", "ImportKeyDialog", "termora"})
@SourceDebugExtension(value={"SMAP\nKeyManagerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyManagerPanel.kt\napp/termora/keymgr/KeyManagerPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,662:1\n1869#2,2:663\n1#3:665\n11258#4:666\n11593#4,3:667\n384#5,7:670\n384#5,7:677\n*S KotlinDebug\n*F\n+ 1 KeyManagerPanel.kt\napp/termora/keymgr/KeyManagerPanel\n*L\n72#1:663,2\n199#1:666\n199#1:667,3\n230#1:670,7\n231#1:677,7\n*E\n"})
public final class KeyManagerPanel
extends JPanel {
    @NotNull
    private final FlatTable keyPairTable = new FlatTable();
    @NotNull
    private final KeyPairTableModel keyPairTableModel = new KeyPairTableModel();
    @NotNull
    private final JButton generateBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.generate"));
    @NotNull
    private final JButton importBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.import"));
    @NotNull
    private final JButton exportBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.export"));
    @NotNull
    private final JButton editBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.edit"));
    @NotNull
    private final JButton deleteBtn = new JButton(I18n.INSTANCE.getString("termora.remove"));
    @NotNull
    private final JButton sshCopyIdBtn = new JButton("ssh-copy-id");

    public KeyManagerPanel() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
    }

    @NotNull
    public final FlatTable getKeyPairTable() {
        return this.keyPairTable;
    }

    @NotNull
    public final KeyPairTableModel getKeyPairTableModel() {
        return this.keyPairTableModel;
    }

    private final void initView() {
        JScrollPane $this$initView_u24lambda_u241;
        JScrollPane jScrollPane;
        this.exportBtn.setEnabled(false);
        this.editBtn.setEnabled(false);
        this.sshCopyIdBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.keyPairTableModel.addColumn(I18n.INSTANCE.getString("termora.keymgr.table.name"));
        this.keyPairTableModel.addColumn(I18n.INSTANCE.getString("termora.keymgr.table.type"));
        this.keyPairTableModel.addColumn(I18n.INSTANCE.getString("termora.keymgr.table.length"));
        this.keyPairTableModel.addColumn(I18n.INSTANCE.getString("termora.keymgr.table.remark"));
        this.keyPairTable.setModel((TableModel)this.keyPairTableModel);
        this.keyPairTable.setFillsViewportHeight(true);
        Iterable $this$forEach$iv = KeyManager.Companion.getInstance().getOhKeyPairs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OhKeyPair it = (OhKeyPair)element$iv;
            boolean bl = false;
            Object[] objectArray = new OhKeyPair[]{it};
            this.keyPairTableModel.addRow(objectArray);
        }
        String formMargin = "4dlu";
        FormLayout layout = new FormLayout("default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref, 16dlu, pref");
        int rows = 0;
        rows = 1;
        int step = 2;
        JScrollPane bl = jScrollPane = new JScrollPane((Component)this.keyPairTable);
        KeyManagerPanel keyManagerPanel = this;
        boolean bl2 = false;
        $this$initView_u24lambda_u241.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        keyManagerPanel.add((Component)jScrollPane, "Center");
        $this$initView_u24lambda_u241 = jScrollPane = FormBuilder.create().layout(layout).padding(new EmptyBorder(0, 12, 0, 0)).add((Component)this.generateBtn).xy(1, rows);
        keyManagerPanel = this;
        boolean bl3 = false;
        JScrollPane $this$initView_u24lambda_u242 = jScrollPane = jScrollPane.add(this.editBtn).xy(1, rows += step);
        boolean bl4 = false;
        JScrollPane $this$initView_u24lambda_u243 = jScrollPane = jScrollPane.add(this.importBtn).xy(1, rows += step);
        boolean bl5 = false;
        JScrollPane $this$initView_u24lambda_u244 = jScrollPane = jScrollPane.add(this.exportBtn).xy(1, rows += step);
        boolean bl6 = false;
        JScrollPane $this$initView_u24lambda_u245 = jScrollPane = jScrollPane.add(this.deleteBtn).xy(1, rows += step);
        boolean bl7 = false;
        JScrollPane $this$initView_u24lambda_u246 = jScrollPane = jScrollPane.add(this.sshCopyIdBtn).xy(1, rows += step);
        boolean bl8 = false;
        rows += step;
        keyManagerPanel.add((Component)jScrollPane.build(), "East");
        this.setBorder(BorderFactory.createEmptyBorder(SystemInfo.isWindows || SystemInfo.isLinux ? 6 : 0, 12, 12, 12));
    }

    private final void initEvents() {
        this.generateBtn.addActionListener(arg_0 -> KeyManagerPanel.initEvents$lambda$8(this, arg_0));
        this.deleteBtn.addActionListener(arg_0 -> KeyManagerPanel.initEvents$lambda$9(this, arg_0));
        this.importBtn.addActionListener(arg_0 -> KeyManagerPanel.initEvents$lambda$10(this, arg_0));
        this.editBtn.addActionListener(arg_0 -> KeyManagerPanel.initEvents$lambda$11(this, arg_0));
        this.exportBtn.addActionListener(new AbstractAction(this){
            final /* synthetic */ KeyManagerPanel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent e) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int[] nArray = this.this$0.getKeyPairTable().getSelectedRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                int[] nArray2 = nArray;
                KeyManagerPanel keyManagerPanel = this.this$0;
                boolean $i$f$map = false;
                void var6_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(keyManagerPanel.getKeyPairTableModel().getOhKeyPair((int)it));
                }
                List keyPairs = (List)destination$iv$iv;
                if (keyPairs.isEmpty()) {
                    return;
                }
                FileChooser fileChooser = new FileChooser();
                fileChooser.setFileSelectionMode(0);
                fileChooser.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"Zip files", (Object)CollectionsKt.listOf((Object)"zip")));
                fileChooser.showSaveDialog(SwingUtilities.getWindowAncestor(this.this$0), "key-export.zip").thenAccept(arg_0 -> initEvents.5.actionPerformed$lambda$3(arg_0 -> initEvents.5.actionPerformed$lambda$2(this.this$0, keyPairs, arg_0), arg_0));
            }

            private static final void actionPerformed$lambda$2$lambda$1(KeyManagerPanel this$0, File $file, List $keyPairs) {
                KeyManagerPanel.access$exportKeyPairs(this$0, $file, $keyPairs);
            }

            private static final Unit actionPerformed$lambda$2(KeyManagerPanel this$0, List $keyPairs, File file) {
                if (file != null) {
                    SwingUtilities.invokeLater(() -> initEvents.5.actionPerformed$lambda$2$lambda$1(this$0, file, $keyPairs));
                }
                return Unit.INSTANCE;
            }

            private static final void actionPerformed$lambda$3(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
        this.sshCopyIdBtn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ KeyManagerPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                KeyManagerPanel.access$sshCopyId(this.this$0, evt);
            }
        }));
        this.keyPairTable.getSelectionModel().addListSelectionListener(arg_0 -> KeyManagerPanel.initEvents$lambda$12(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void sshCopyId(AnActionEvent evt) {
        void $this$mapTo$iv$iv;
        int[] nArray = this.keyPairTable.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        int[] $this$map$iv = nArray;
        boolean $i$f$map = false;
        int[] nArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.keyPairTableModel.getOhKeyPair((int)it));
        }
        List keyPairs = (List)destination$iv$iv;
        List publicKeys = new ArrayList();
        for (OhKeyPair keyPair : keyPairs) {
            PublicKey publicKey = OhKeyPairKeyPairProvider.Companion.generateKeyPair(keyPair).getPublic();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OpenSSHKeyPairResourceWriter.INSTANCE.writePublicKey(publicKey, keyPair.getName(), (OutputStream)baos);
            publicKeys.add(new Pair((Object)keyPair.getName(), (Object)baos.toString(Charsets.UTF_8)));
        }
        if (publicKeys.isEmpty()) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        Window owner = window;
        NewHostTreeDialog hostTreeDialog = new NewHostTreeDialog(owner);
        hostTreeDialog.setFilter(KeyManagerPanel::sshCopyId$lambda$14);
        hostTreeDialog.setTreeName("KeyManagerPanel.SSHCopyIdTree");
        hostTreeDialog.setVisible(true);
        List<Host> hosts = hostTreeDialog.getHosts();
        if (hosts.isEmpty()) {
            return;
        }
        new SSHCopyIdDialog(owner, hosts, publicKeys).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void exportKeyPairs(File file, List<OhKeyPair> keyPairs) {
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream fis = (FileOutputStream)closeable;
            boolean bl = false;
            Map names = new LinkedHashMap();
            Closeable closeable2 = new ZipOutputStream(fis);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                for (OhKeyPair keyPair : keyPairs) {
                    Object object;
                    void $this$getOrPut$iv;
                    Object object2;
                    void $this$getOrPut$iv2;
                    Map map = names;
                    Object key$iv = keyPair.getName() + ".pub";
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Integer answer$iv = 0;
                        $this$getOrPut$iv2.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    int pubNameCount = ((Number)object2).intValue();
                    key$iv = names;
                    String key$iv2 = keyPair.getName();
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
                    if (value$iv2 == null) {
                        boolean bl4 = false;
                        Integer answer$iv = 0;
                        $this$getOrPut$iv.put(key$iv2, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv2;
                    }
                    int priNameCount = ((Number)object).intValue();
                    KeyPair kp = OhKeyPairKeyPairProvider.Companion.generateKeyPair(keyPair);
                    PublicKey publicKey = kp.getPublic();
                    PrivateKey privateKey = kp.getPrivate();
                    zos.putNextEntry(new ZipEntry(keyPair.getName() + (String)(pubNameCount > 0 ? "." + pubNameCount : new String()) + ".pub"));
                    OpenSSHKeyPairResourceWriter.INSTANCE.writePublicKey(publicKey, null, (OutputStream)zos);
                    zos.closeEntry();
                    zos.putNextEntry(new ZipEntry(keyPair.getName() + (String)(priNameCount > 0 ? "." + priNameCount : new String())));
                    OpenSSHKeyPairResourceWriter.INSTANCE.writePrivateKey(new KeyPair(publicKey, privateKey), null, null, (OutputStream)zos);
                    zos.closeEntry();
                    names.put(keyPair.getName() + ".pub", pubNameCount + 1);
                    names.put(keyPair.getName(), priNameCount + 1);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        OptionPane.INSTANCE.openFileInFolder(window, file, I18n.INSTANCE.getString("termora.settings.sync.export-done-open-folder"), I18n.INSTANCE.getString("termora.settings.sync.export-done"));
    }

    private static final void initEvents$lambda$8(KeyManagerPanel this$0, ActionEvent it) {
        Window owner = SwingUtilities.getWindowAncestor(this$0);
        Intrinsics.checkNotNull((Object)owner);
        GenerateKeyDialog dialog = new GenerateKeyDialog(owner, null, false, 6, null);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        if (!Intrinsics.areEqual((Object)dialog.getOhKeyPair(), (Object)OhKeyPair.Companion.getEmpty())) {
            OhKeyPair keyPair = dialog.getOhKeyPair();
            KeyManager.Companion.getInstance().addOhKeyPair(keyPair);
            Object[] objectArray = new OhKeyPair[]{keyPair};
            this$0.keyPairTableModel.addRow(objectArray);
        }
    }

    private static final void initEvents$lambda$9(KeyManagerPanel this$0, ActionEvent it) {
        if (this$0.keyPairTable.getSelectedRowCount() > 0 && OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
            int[] nArray = this$0.keyPairTable.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
            List rows = CollectionsKt.reversed((Iterable)ArraysKt.sorted((int[])nArray));
            Iterator iterator2 = rows.iterator();
            while (iterator2.hasNext()) {
                int row = ((Number)iterator2.next()).intValue();
                String id = this$0.keyPairTableModel.getOhKeyPair(row).getId();
                KeyManager.Companion.getInstance().removeOhKeyPair(id);
                this$0.keyPairTableModel.removeRow(row);
            }
        }
    }

    private static final void initEvents$lambda$10(KeyManagerPanel this$0, ActionEvent it) {
        Window window = SwingUtilities.getWindowAncestor(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        ImportKeyDialog dialog = new ImportKeyDialog(window);
        dialog.setVisible(true);
        if (!Intrinsics.areEqual((Object)dialog.getOhKeyPair(), (Object)OhKeyPair.Companion.getEmpty())) {
            KeyManager.Companion.getInstance().addOhKeyPair(dialog.getOhKeyPair());
            Object[] objectArray = new OhKeyPair[]{dialog.getOhKeyPair()};
            this$0.keyPairTableModel.addRow(objectArray);
        }
    }

    private static final void initEvents$lambda$11(KeyManagerPanel this$0, ActionEvent it) {
        int row = this$0.keyPairTable.getSelectedRow();
        if (row >= 0) {
            Window owner = SwingUtilities.getWindowAncestor(this$0);
            OhKeyPair ohKeyPair = this$0.keyPairTableModel.getOhKeyPair(row);
            Intrinsics.checkNotNull((Object)owner);
            GenerateKeyDialog dialog = new GenerateKeyDialog(owner, ohKeyPair, true);
            dialog.setLocationRelativeTo(owner);
            dialog.setTitle(ohKeyPair.getName());
            dialog.setVisible(true);
            ohKeyPair = dialog.getOhKeyPair();
            if (!Intrinsics.areEqual((Object)ohKeyPair, (Object)OhKeyPair.Companion.getEmpty())) {
                KeyManager.Companion.getInstance().addOhKeyPair(ohKeyPair);
                this$0.keyPairTableModel.setValueAt(ohKeyPair, row, 0);
                this$0.keyPairTableModel.fireTableRowsUpdated(row, row);
            }
        }
    }

    private static final void initEvents$lambda$12(KeyManagerPanel this$0, ListSelectionEvent it) {
        this$0.exportBtn.setEnabled(this$0.keyPairTable.getSelectedRowCount() > 0);
        this$0.editBtn.setEnabled(this$0.exportBtn.isEnabled());
        this$0.deleteBtn.setEnabled(this$0.exportBtn.isEnabled());
        this$0.sshCopyIdBtn.setEnabled(this$0.exportBtn.isEnabled());
    }

    private static final Boolean sshCopyId$lambda$14(HostTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHost().getProtocol() == Protocol.SSH;
    }

    public static final /* synthetic */ void access$exportKeyPairs(KeyManagerPanel $this, File file, List keyPairs) {
        $this.exportKeyPairs(file, keyPairs);
    }

    public static final /* synthetic */ void access$sshCopyId(KeyManagerPanel $this, AnActionEvent evt) {
        $this.sshCopyId(evt);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001eH\u0014J\b\u0010$\u001a\u00020\"H\u0014J\b\u0010%\u001a\u00020\"H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/termora/keymgr/KeyManagerPanel$GenerateKeyDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "ohKeyPair", "Lapp/termora/keymgr/OhKeyPair;", "editable", "", "<init>", "(Ljava/awt/Window;Lapp/termora/keymgr/OhKeyPair;Z)V", "getOhKeyPair", "()Lapp/termora/keymgr/OhKeyPair;", "setOhKeyPair", "(Lapp/termora/keymgr/OhKeyPair;)V", "getEditable", "()Z", "formMargin", "", "typeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "lengthComboBox", "", "nameTextField", "Lapp/termora/OutlineTextField;", "remarkTextField", "publicKeyTextArea", "Lcom/formdev/flatlaf/extras/components/FlatTextArea;", "savePublicKeyBtn", "Ljavax/swing/JButton;", "okAction", "Ljavax/swing/AbstractAction;", "createCenterPanel", "Ljavax/swing/JComponent;", "initEvents", "", "createOkAction", "doCancelAction", "doOKAction", "termora"})
    @SourceDebugExtension(value={"SMAP\nKeyManagerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyManagerPanel.kt\napp/termora/keymgr/KeyManagerPanel$GenerateKeyDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,662:1\n1#2:663\n*E\n"})
    private static final class GenerateKeyDialog
    extends DialogWrapper {
        @NotNull
        private OhKeyPair ohKeyPair;
        private final boolean editable;
        @NotNull
        private final String formMargin;
        @NotNull
        private final FlatComboBox<String> typeComboBox;
        @NotNull
        private final FlatComboBox<Integer> lengthComboBox;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField remarkTextField;
        @NotNull
        private final FlatTextArea publicKeyTextArea;
        @NotNull
        private final JButton savePublicKeyBtn;
        @NotNull
        private final AbstractAction okAction;

        public GenerateKeyDialog(@NotNull Window owner, @NotNull OhKeyPair ohKeyPair, boolean editable) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)ohKeyPair, (String)"ohKeyPair");
            super(owner);
            this.ohKeyPair = ohKeyPair;
            this.editable = editable;
            this.formMargin = "7dlu";
            this.typeComboBox = new FlatComboBox();
            this.lengthComboBox = new FlatComboBox();
            this.nameTextField = new OutlineTextField(32);
            this.remarkTextField = new OutlineTextField(0, 1, null);
            this.publicKeyTextArea = new FlatTextArea();
            this.savePublicKeyBtn = new JButton(I18n.INSTANCE.getString("termora.save"));
            this.okAction = super.createOkAction();
            this.setModal(true);
            this.setTitle(I18n.INSTANCE.getString("termora.keymgr.title"));
            this.typeComboBox.addItem((Object)"RSA");
            this.typeComboBox.addItem((Object)"ED25519");
            this.lengthComboBox.addItem((Object)1024);
            this.lengthComboBox.addItem((Object)2048);
            this.lengthComboBox.addItem((Object)3072);
            this.lengthComboBox.addItem((Object)4096);
            this.lengthComboBox.addItem((Object)8192);
            this.lengthComboBox.setSelectedItem((Object)2048);
            this.nameTextField.setText(this.typeComboBox.getSelectedItem() + "_" + this.lengthComboBox.getSelectedItem());
            this.publicKeyTextArea.setRows(6);
            this.publicKeyTextArea.setLineWrap(true);
            this.publicKeyTextArea.setWrapStyleWord(false);
            this.publicKeyTextArea.setEditable(false);
            this.publicKeyTextArea.setAutoscrolls(false);
            this.publicKeyTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.savePublicKeyBtn.setEnabled(false);
            this.initEvents();
            if (this.editable) {
                this.typeComboBox.setEnabled(false);
                this.lengthComboBox.setEnabled(false);
                this.typeComboBox.setSelectedItem((Object)this.ohKeyPair.getType());
                this.lengthComboBox.setSelectedItem((Object)this.ohKeyPair.getLength());
                this.nameTextField.setText(this.ohKeyPair.getName());
                this.remarkTextField.setText(this.ohKeyPair.getRemark());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                KeyPair keyPair = OhKeyPairKeyPairProvider.Companion.generateKeyPair(this.ohKeyPair);
                OpenSSHKeyPairResourceWriter.INSTANCE.writePublicKey(keyPair.getPublic(), null, (OutputStream)baos);
                this.publicKeyTextArea.setText(baos.toString());
                this.savePublicKeyBtn.setEnabled(true);
            } else {
                final ItemListener itemListener = arg_0 -> GenerateKeyDialog._init_$lambda$0(this, arg_0);
                this.typeComboBox.addItemListener(itemListener);
                this.lengthComboBox.addItemListener(itemListener);
                this.nameTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (Character.isDefined(e.getKeyChar())) {
                            typeComboBox.removeItemListener(itemListener);
                            lengthComboBox.removeItemListener(itemListener);
                        }
                    }
                });
            }
            this.init();
            this.pack();
            this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 300, this.getSize().height));
        }

        public /* synthetic */ GenerateKeyDialog(Window window, OhKeyPair ohKeyPair, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                ohKeyPair = OhKeyPair.Companion.getEmpty();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(window, ohKeyPair, bl);
        }

        @NotNull
        public final OhKeyPair getOhKeyPair() {
            return this.ohKeyPair;
        }

        public final void setOhKeyPair(@NotNull OhKeyPair ohKeyPair) {
            Intrinsics.checkNotNullParameter((Object)ohKeyPair, (String)"<set-?>");
            this.ohKeyPair = ohKeyPair;
        }

        public final boolean getEditable() {
            return this.editable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected JComponent createCenterPanel() {
            void $this$createCenterPanel_u24lambda_u245;
            Object object;
            FormLayout layout = new FormLayout("left:pref, " + this.formMargin + ", default:grow", "pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref");
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$createCenterPanel_u24lambda_u241 = object = FormBuilder.create().layout(layout).padding("2dlu, " + this.formMargin + ", " + this.formMargin + ", " + this.formMargin, new Object[0]).add(I18n.INSTANCE.getString("termora.keymgr.table.type") + ":", new Object[0]).xy(1, rows).add((Component)this.typeComboBox).xy(3, rows);
            boolean bl = false;
            FormBuilder $this$createCenterPanel_u24lambda_u242 = object = object.add(I18n.INSTANCE.getString("termora.keymgr.table.length") + ":", new Object[0]).xy(1, rows += step).add((Component)this.lengthComboBox).xy(3, rows);
            boolean bl2 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u243 = object = object.add(I18n.INSTANCE.getString("termora.keymgr.table.name") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.nameTextField)).xy(3, rows);
            boolean bl3 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u244 = object = object.add(I18n.INSTANCE.getString("termora.keymgr.table.remark") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.remarkTextField)).xy(3, rows);
            boolean bl4 = false;
            FormBuilder formBuilder = object.add("PublicKey:", new Object[0]).xy(1, rows += step);
            $this$createCenterPanel_u24lambda_u244 = object = new JScrollPane((Component)this.publicKeyTextArea);
            FormBuilder formBuilder2 = formBuilder;
            boolean bl5 = false;
            $this$createCenterPanel_u24lambda_u245.setBorder((Border)new FlatTextBorder());
            Object $this$createCenterPanel_u24lambda_u246 = object = formBuilder2.add((Component)object).xy(3, rows);
            boolean bl6 = false;
            Object $this$createCenterPanel_u24lambda_u247 = object = object.add((Component)this.savePublicKeyBtn).xyw(1, rows += step, 3, "right, fill");
            boolean bl7 = false;
            rows += step;
            JPanel jPanel = object.build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        private final void initEvents() {
            this.savePublicKeyBtn.addActionListener(arg_0 -> GenerateKeyDialog.initEvents$lambda$11(this, arg_0));
            this.typeComboBox.addItemListener(arg_0 -> GenerateKeyDialog.initEvents$lambda$12(this, arg_0));
        }

        @Override
        @NotNull
        protected AbstractAction createOkAction() {
            if (!this.editable) {
                this.okAction.putValue("Name", I18n.INSTANCE.getString("termora.keymgr.generate"));
            }
            return this.okAction;
        }

        @Override
        protected void doCancelAction() {
            this.ohKeyPair = OhKeyPair.Companion.getEmpty();
            super.doCancelAction();
        }

        @Override
        protected void doOKAction() {
            if (Intrinsics.areEqual((Object)this.ohKeyPair, (Object)OhKeyPair.Companion.getEmpty())) {
                String string = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string)) {
                    this.nameTextField.setOutline("error");
                    this.nameTextField.requestFocusInWindow();
                    return;
                }
                String keyType = Intrinsics.areEqual((Object)this.typeComboBox.getSelectedItem(), (Object)"RSA") ? "ssh-rsa" : "ssh-ed25519";
                Object object = this.lengthComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                KeyPair keyPair = KeyUtils.generateKeyPair((String)keyType, (int)((Integer)object));
                UUID uUID = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                String string2 = HostKt.toSimpleString(uUID);
                String string3 = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                String string4 = string3;
                String string5 = this.remarkTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                String string6 = string5;
                Object object2 = this.typeComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                String string7 = (String)object2;
                Object object3 = this.lengthComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)object3;
                String string8 = Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"encodeBase64String(...)");
                String string9 = string8;
                String string10 = Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"encodeBase64String(...)");
                String string11 = string10;
                long l = System.currentTimeMillis();
                this.ohKeyPair = new OhKeyPair(string2, string9, string11, string7, string4, string6, n, l, 0L, 256, null);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OpenSSHKeyPairResourceWriter.INSTANCE.writePublicKey(keyPair.getPublic(), null, (OutputStream)baos);
                this.savePublicKeyBtn.setEnabled(true);
                this.publicKeyTextArea.setText(baos.toString());
                this.lengthComboBox.setEnabled(false);
                this.typeComboBox.setEnabled(false);
                this.okAction.putValue("Name", I18n.INSTANCE.getString("termora.confirm"));
            } else {
                String string = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string12 = this.remarkTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getText(...)");
                this.ohKeyPair = OhKeyPair.copy$default(this.ohKeyPair, null, null, null, null, string, string12, 0, 0L, 0L, 463, null);
                if (!this.editable && ((CharSequence)this.ohKeyPair.getRemark()).length() == 0) {
                    this.ohKeyPair = OhKeyPair.copy$default(this.ohKeyPair, null, null, null, null, null, "Create on " + DateFormatUtils.format((Date)new Date(), (String)I18n.INSTANCE.getString("termora.date-format")), 0, 0L, 0L, 479, null);
                }
                super.doOKAction();
            }
        }

        private static final void _init_$lambda$0(GenerateKeyDialog this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                this$0.nameTextField.setText(this$0.typeComboBox.getSelectedItem() + "_" + this$0.lengthComboBox.getSelectedItem());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit initEvents$lambda$11$lambda$9(GenerateKeyDialog this$0, File file) {
            if (file != null) {
                Closeable closeable = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    IOUtils.write((String)this$0.publicKeyTextArea.getText(), (OutputStream)it, (Charset)StandardCharsets.UTF_8);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return Unit.INSTANCE;
        }

        private static final void initEvents$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void initEvents$lambda$11(GenerateKeyDialog this$0, ActionEvent it) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"All Files", (Object)CollectionsKt.listOf((Object)"*")));
            fileChooser.showSaveDialog(this$0, this$0.nameTextField.getText() + ".pub").thenAccept(arg_0 -> GenerateKeyDialog.initEvents$lambda$11$lambda$10(arg_0 -> GenerateKeyDialog.initEvents$lambda$11$lambda$9(this$0, arg_0), arg_0));
        }

        private static final void initEvents$lambda$12(GenerateKeyDialog this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                this$0.lengthComboBox.removeAllItems();
                if (Intrinsics.areEqual((Object)this$0.typeComboBox.getSelectedItem(), (Object)"ED25519")) {
                    this$0.lengthComboBox.addItem((Object)256);
                } else if (Intrinsics.areEqual((Object)this$0.typeComboBox.getSelectedItem(), (Object)"RSA")) {
                    this$0.lengthComboBox.addItem((Object)1024);
                    this$0.lengthComboBox.addItem((Object)2048);
                    this$0.lengthComboBox.addItem((Object)3072);
                    this$0.lengthComboBox.addItem((Object)4096);
                    this$0.lengthComboBox.addItem((Object)8192);
                    this$0.lengthComboBox.setSelectedItem((Object)2048);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0011H\u0014J\b\u0010$\u001a\u00020\u001eH\u0014J\b\u0010%\u001a\u00020\u001eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lapp/termora/keymgr/KeyManagerPanel$ImportKeyDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "formMargin", "", "fileTextField", "Lapp/termora/OutlineTextField;", "typeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "lengthComboBox", "", "nameTextField", "remarkTextField", "okAction", "Ljavax/swing/AbstractAction;", "fileBtn", "Ljavax/swing/JButton;", "textBtn", "ohKeyPair", "Lapp/termora/keymgr/OhKeyPair;", "getOhKeyPair", "()Lapp/termora/keymgr/OhKeyPair;", "setOhKeyPair", "(Lapp/termora/keymgr/OhKeyPair;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "import", "", "importText", "importKeyFile", "file", "Ljava/io/File;", "createOkAction", "doCancelAction", "doOKAction", "termora"})
    @SourceDebugExtension(value={"SMAP\nKeyManagerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyManagerPanel.kt\napp/termora/keymgr/KeyManagerPanel$ImportKeyDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,662:1\n1#2:663\n*E\n"})
    private static final class ImportKeyDialog
    extends DialogWrapper {
        @NotNull
        private final String formMargin;
        @NotNull
        private final OutlineTextField fileTextField;
        @NotNull
        private final FlatComboBox<String> typeComboBox;
        @NotNull
        private final FlatComboBox<Integer> lengthComboBox;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField remarkTextField;
        @NotNull
        private final AbstractAction okAction;
        @NotNull
        private final JButton fileBtn;
        @NotNull
        private final JButton textBtn;
        @NotNull
        private OhKeyPair ohKeyPair;

        public ImportKeyDialog(@NotNull Window owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner);
            this.formMargin = "7dlu";
            this.fileTextField = new OutlineTextField(0, 1, null);
            this.typeComboBox = new FlatComboBox();
            this.lengthComboBox = new FlatComboBox();
            this.nameTextField = new OutlineTextField(32);
            this.remarkTextField = new OutlineTextField(0, 1, null);
            this.okAction = super.createOkAction();
            this.fileBtn = new JButton((Icon)new FlatFileViewFileIcon());
            this.textBtn = new JButton((Icon)((Object)Icons.INSTANCE.getDbPrimitive()));
            this.ohKeyPair = OhKeyPair.Companion.getEmpty();
            this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 300, UIManager.getInt("Dialog.height") - 200));
            this.setModal(true);
            this.setTitle(I18n.INSTANCE.getString("termora.keymgr.import"));
            this.setLocationRelativeTo(null);
            this.typeComboBox.setEnabled(false);
            this.lengthComboBox.setEnabled(false);
            this.fileTextField.setEditable(false);
            this.init();
            this.pack();
            this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 300, this.getSize().height));
            this.setLocationRelativeTo(null);
        }

        @NotNull
        public final OhKeyPair getOhKeyPair() {
            return this.ohKeyPair;
        }

        public final void setOhKeyPair(@NotNull OhKeyPair ohKeyPair) {
            Intrinsics.checkNotNullParameter((Object)ohKeyPair, (String)"<set-?>");
            this.ohKeyPair = ohKeyPair;
        }

        @Override
        @NotNull
        protected JComponent createCenterPanel() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, " + this.formMargin + ", default:grow", "pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin);
            this.fileBtn.addActionListener(arg_0 -> ImportKeyDialog.createCenterPanel$lambda$0(this, arg_0));
            this.textBtn.addActionListener(arg_0 -> ImportKeyDialog.createCenterPanel$lambda$1(this, arg_0));
            JToolBar box = new JToolBar();
            box.add(this.textBtn);
            box.add(Box.createHorizontalStrut(2));
            box.add(this.fileBtn);
            this.fileTextField.setTrailingComponent(box);
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = FormBuilder.create().layout(layout).padding("2dlu, " + this.formMargin + ", " + this.formMargin + ", " + this.formMargin, new Object[0]).add("File:", new Object[0]).xy(1, rows).add((Component)((Object)this.fileTextField)).xy(3, rows);
            boolean bl = false;
            FormBuilder $this$createCenterPanel_u24lambda_u243 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.keymgr.table.type") + ":", new Object[0]).xy(1, rows += step).add((Component)this.typeComboBox).xy(3, rows);
            boolean bl2 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u244 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.keymgr.table.length") + ":", new Object[0]).xy(1, rows += step).add((Component)this.lengthComboBox).xy(3, rows);
            boolean bl3 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u245 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.keymgr.table.name") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.nameTextField)).xy(3, rows);
            boolean bl4 = false;
            FormBuilder $this$createCenterPanel_u24lambda_u246 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.keymgr.table.remark") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.remarkTextField)).xy(3, rows);
            boolean bl5 = false;
            rows += step;
            JPanel jPanel = formBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        private final void import() {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setAllowsMultiSelection(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.showOpenDialog(this).thenAccept(arg_0 -> ImportKeyDialog.import$lambda$9(arg_0 -> ImportKeyDialog.import$lambda$8(this, arg_0), arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void importText() {
            FlatTextArea textarea = new FlatTextArea();
            textarea.setRows(20);
            textarea.setWrapStyleWord(false);
            textarea.setLineWrap(true);
            textarea.setColumns(40);
            OptionPane optionPane = OptionPane.INSTANCE;
            JScrollPane jScrollPane = new JScrollPane(textarea){
                final /* synthetic */ FlatTextArea $textarea;
                {
                    this.$textarea = $textarea;
                    super((Component)$textarea);
                }

                public boolean requestFocusInWindow() {
                    return this.$textarea.requestFocusInWindow();
                }
            };
            if (OptionPane.showConfirmDialog$default(optionPane, this, jScrollPane, "Private Key", 2, -1, null, null, null, null, 480, null) != 0) {
                return;
            }
            String string = textarea.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                return;
            }
            Path tmpFile = Files.createTempFile(Application.INSTANCE.getName() + "-", new String(), new FileAttribute[0]);
            Intrinsics.checkNotNull((Object)tmpFile);
            String string2 = textarea.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            PathsKt.writeText$default((Path)tmpFile, (CharSequence)string2, null, (OpenOption[])new OpenOption[0], (int)2, null);
            try {
                File file = tmpFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                this.importKeyFile(file);
            }
            finally {
                PathUtils.deleteFile((Path)tmpFile);
            }
        }

        private final void importKeyFile(File file) {
            long length = file.length();
            if (file.isDirectory() || length < 1L || length >= 0x100000L) {
                OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, this, I18n.INSTANCE.getString("termora.keymgr.import.error"), null, 0, 0L, 20, null);
                return;
            }
            try {
                FileKeyPairProvider provider = new FileKeyPairProvider(file.toPath());
                provider.setPasswordFinder((arg_0, arg_1, arg_2) -> ImportKeyDialog.importKeyFile$lambda$10(this, arg_0, arg_1, arg_2));
                Iterable iterable = provider.loadKeys(null);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"loadKeys(...)");
                KeyPair keyPair = (KeyPair)CollectionsKt.firstOrNull((Iterable)iterable);
                if (keyPair == null) {
                    throw new IllegalStateException("Failed to load the key file");
                }
                KeyPair keyPair2 = keyPair;
                String keyType = KeyUtils.getKeyType((KeyPair)keyPair2);
                if (!Intrinsics.areEqual((Object)keyType, (Object)"ssh-rsa") && !Intrinsics.areEqual((Object)keyType, (Object)"ssh-ed25519")) {
                    throw new UnsupportedOperationException("Key type:" + keyType + ". Only RSA/ED25519 keys are supported.");
                }
                this.nameTextField.setText((String)StringUtils.defaultIfBlank((CharSequence)this.nameTextField.getText(), (CharSequence)file.getName()));
                this.fileTextField.setText(file.getAbsolutePath());
                if (Intrinsics.areEqual((Object)keyType, (Object)"ssh-rsa")) {
                    this.typeComboBox.addItem((Object)"RSA");
                } else {
                    this.typeComboBox.addItem((Object)"ED25519");
                }
                this.lengthComboBox.addItem((Object)KeyUtils.getKeySize((Key)keyPair2.getPrivate()));
                String string = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                String string3 = this.remarkTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                String string4 = string3;
                String string5 = Base64.encodeBase64String((byte[])keyPair2.getPrivate().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeBase64String(...)");
                String string6 = string5;
                String string7 = Base64.encodeBase64String((byte[])keyPair2.getPublic().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"encodeBase64String(...)");
                String string8 = string7;
                long l = System.currentTimeMillis();
                Object object = this.typeComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String string9 = (String)object;
                UUID uUID = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                String string10 = HostKt.toSimpleString(uUID);
                Object object2 = this.lengthComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)object2;
                this.ohKeyPair = new OhKeyPair(string10, string8, string6, string9, string2, string4, n, l, 0L, 256, null);
            }
            catch (Exception e) {
                Component component = this;
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, component, string, null, 0, 0L, 20, null);
            }
        }

        @Override
        @NotNull
        protected AbstractAction createOkAction() {
            this.okAction.putValue("Name", I18n.INSTANCE.getString("termora.keymgr.import"));
            return this.okAction;
        }

        @Override
        protected void doCancelAction() {
            this.ohKeyPair = OhKeyPair.Companion.getEmpty();
            super.doCancelAction();
        }

        @Override
        protected void doOKAction() {
            if (Intrinsics.areEqual((Object)this.ohKeyPair, (Object)OhKeyPair.Companion.getEmpty())) {
                this.import();
                return;
            }
            String string = this.nameTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.nameTextField.setOutline("error");
                this.nameTextField.requestFocusInWindow();
                return;
            }
            String string2 = this.nameTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = this.remarkTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            this.ohKeyPair = OhKeyPair.copy$default(this.ohKeyPair, null, null, null, null, string2, string3, 0, 0L, 0L, 463, null);
            if (((CharSequence)this.ohKeyPair.getRemark()).length() == 0) {
                this.ohKeyPair = OhKeyPair.copy$default(this.ohKeyPair, null, null, null, null, null, "Import on " + DateFormatUtils.format((Date)new Date(), (String)I18n.INSTANCE.getString("termora.date-format")), 0, 0L, 0L, 479, null);
            }
            super.doOKAction();
        }

        private static final void createCenterPanel$lambda$0(ImportKeyDialog this$0, ActionEvent it) {
            this$0.import();
        }

        private static final void createCenterPanel$lambda$1(ImportKeyDialog this$0, ActionEvent it) {
            this$0.importText();
        }

        private static final void import$lambda$8$lambda$7(ImportKeyDialog this$0, List $files) {
            Intrinsics.checkNotNull((Object)$files);
            this$0.importKeyFile((File)CollectionsKt.first((List)$files));
        }

        private static final Unit import$lambda$8(ImportKeyDialog this$0, List files) {
            Intrinsics.checkNotNull((Object)files);
            if (!((Collection)files).isEmpty()) {
                SwingUtilities.invokeLater(() -> ImportKeyDialog.import$lambda$8$lambda$7(this$0, files));
            }
            return Unit.INSTANCE;
        }

        private static final void import$lambda$9(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final String importKeyFile$lambda$10(ImportKeyDialog this$0, SessionContext sessionContext, NamedResource namedResource, int n) {
            String string = OptionPane.showInputDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.new-host.general.password"), null, null, 12, null);
            if (string == null) {
                string = new String();
            }
            return string;
        }
    }
}

