/*
 * Decompiled with CFR 0.152.
 */
package app.termora.keymap;

import app.termora.Database;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.actions.ActionManager;
import app.termora.keymap.KeyShortcut;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.keymap.KeymapTableModel;
import app.termora.keymap.Shortcut;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000e0\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lapp/termora/keymap/KeymapPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "model", "Lapp/termora/keymap/KeymapTableModel;", "table", "Ljavax/swing/JTable;", "keymapManager", "Lapp/termora/keymap/KeymapManager;", "getKeymapManager", "()Lapp/termora/keymap/KeymapManager;", "keymapModel", "Ljavax/swing/DefaultComboBoxModel;", "", "keymapComboBox", "Ljavax/swing/JComboBox;", "kotlin.jvm.PlatformType", "copyBtn", "Ljavax/swing/JButton;", "renameBtn", "deleteBtn", "database", "Lapp/termora/Database;", "getDatabase", "()Lapp/termora/Database;", "allowKeyCodes", "", "", "initView", "", "initEvents", "copyKeymap", "keymap", "Lapp/termora/keymap/Keymap;", "cloneKeymap", "name", "getCurrentKeymap", "recordKeyShortcut", "row", "e", "Ljava/awt/event/KeyEvent;", "isCombinationKey", "", "keyStroke", "Ljavax/swing/KeyStroke;", "termora"})
public final class KeymapPanel
extends JPanel {
    @NotNull
    private final KeymapTableModel model = new KeymapTableModel();
    @NotNull
    private final JTable table = new JTable(this.model);
    @NotNull
    private final DefaultComboBoxModel<String> keymapModel = new DefaultComboBoxModel();
    @NotNull
    private final JComboBox<String> keymapComboBox = new JComboBox(this.keymapModel);
    @NotNull
    private final JButton copyBtn = new JButton((Icon)((Object)Icons.INSTANCE.getCopy()));
    @NotNull
    private final JButton renameBtn = new JButton((Icon)((Object)Icons.INSTANCE.getEdit()));
    @NotNull
    private final JButton deleteBtn = new JButton((Icon)((Object)Icons.INSTANCE.getDelete()));
    @NotNull
    private final Set<Integer> allowKeyCodes = new LinkedHashSet();

    public KeymapPanel() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
        this.keymapComboBox.setSelectedItem(null);
        this.keymapComboBox.setSelectedItem(this.getKeymapManager().getActiveKeymap().getName());
    }

    private final KeymapManager getKeymapManager() {
        return KeymapManager.Companion.getInstance();
    }

    private final Database getDatabase() {
        return Database.Companion.getDatabase();
    }

    private final void initView() {
        Iterator<Keymap> $this$initView_u24lambda_u240;
        Pair[] i2;
        for (int i2 = 48; i2 < 91; ++i2) {
            this.allowKeyCodes.add(i2);
        }
        this.allowKeyCodes.add(61);
        this.allowKeyCodes.add(45);
        this.copyBtn.setToolTipText(I18n.INSTANCE.getString("termora.welcome.contextmenu.copy"));
        this.renameBtn.setToolTipText(I18n.INSTANCE.getString("termora.welcome.contextmenu.rename"));
        this.deleteBtn.setToolTipText(I18n.INSTANCE.getString("termora.remove"));
        this.table.getSelectionModel().setSelectionMode(0);
        Pair[] pairArray = i2 = new DefaultTableCellRenderer();
        Class<Object> clazz = Object.class;
        JTable jTable = this.table;
        boolean bl = false;
        ((JLabel)((Object)$this$initView_u24lambda_u240)).setHorizontalAlignment(0);
        Unit unit = Unit.INSTANCE;
        jTable.setDefaultRenderer(clazz, (TableCellRenderer)i2);
        i2 = new Pair[]{TuplesKt.to((Object)"showHorizontalLines", (Object)true), TuplesKt.to((Object)"showVerticalLines", (Object)true)};
        this.table.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])i2));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        this.table.setBackground(UIManager.getColor("window"));
        for (Keymap keymap : this.getKeymapManager().getKeymaps()) {
            this.keymapModel.addElement(keymap.getName());
        }
        FlatToolBar box = new FlatToolBar();
        box.add((Component)this.keymapComboBox);
        box.add(Box.createHorizontalStrut(2));
        box.add((Component)this.copyBtn);
        box.add((Component)this.renameBtn);
        box.add((Component)this.deleteBtn);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.add((Component)box, "North");
        this.add((Component)scrollPane, "Center");
    }

    private final void initEvents() {
        this.table.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ KeymapPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = KeymapPanel.access$getTable$p(this.this$0).getSelectedRow();
                if (row < 0) {
                    return;
                }
                KeymapPanel.access$recordKeyShortcut(this.this$0, row, e);
            }
        });
        this.copyBtn.addActionListener(arg_0 -> KeymapPanel.initEvents$lambda$1(this, arg_0));
        this.keymapComboBox.addItemListener(arg_0 -> KeymapPanel.initEvents$lambda$2(this, arg_0));
        this.renameBtn.addActionListener(arg_0 -> KeymapPanel.initEvents$lambda$3(this, arg_0));
        this.deleteBtn.addActionListener(arg_0 -> KeymapPanel.initEvents$lambda$4(this, arg_0));
    }

    private final void copyKeymap(Keymap keymap) {
        String name = keymap.getName() + " Copy";
        for (int i = 0; i < Integer.MAX_VALUE && this.getKeymapManager().getKeymap(name) != null; ++i) {
            name = keymap.getName() + " Copy(" + (i + 1) + ")";
        }
        this.getKeymapManager().addKeymap(this.cloneKeymap(name, keymap));
        this.keymapModel.insertElementAt(name, 0);
        this.keymapComboBox.setSelectedItem(name);
    }

    private final Keymap cloneKeymap(String name, Keymap keymap) {
        Keymap newKeymap = new Keymap(name, null, false, 0L, 8, null);
        for (Map.Entry<Shortcut, List<String>> e : keymap.getShortcuts().entrySet()) {
            for (String actionId : e.getValue()) {
                newKeymap.addShortcut(actionId, e.getKey());
            }
        }
        return newKeymap;
    }

    private final Keymap getCurrentKeymap() {
        KeymapManager keymapManager = this.getKeymapManager();
        Object object = this.keymapComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return keymapManager.getKeymap((String)object);
    }

    private final void recordKeyShortcut(int row, KeyEvent e) {
        Action action = this.model.getAction(row);
        if (action == null) {
            return;
        }
        Action action2 = action;
        Object object = action2.getValue("ActionCommandKey");
        if (object == null) {
            return;
        }
        String actionId = object.toString();
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        if (Intrinsics.areEqual((Object)actionId, (Object)"SwitchTabAction") && keyStroke.getKeyCode() != 8) {
            if (keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 18) {
                return;
            }
        } else {
            Intrinsics.checkNotNull((Object)keyStroke);
            if (!(!this.isCombinationKey(keyStroke) && keyStroke.getKeyCode() == 8 || this.isCombinationKey(keyStroke) && this.allowKeyCodes.contains(keyStroke.getKeyCode()))) {
                return;
            }
        }
        Keymap keymap = this.getCurrentKeymap();
        if (keymap == null) {
            return;
        }
        Keymap keymap2 = keymap;
        if (keymap2.isReadonly()) {
            this.copyKeymap(keymap2);
            Keymap keymap3 = this.getCurrentKeymap();
            if (keymap3 == null) {
                return;
            }
            keymap2 = keymap3;
        }
        e.consume();
        Intrinsics.checkNotNull((Object)keyStroke);
        KeyShortcut keyShortcut = new KeyShortcut(keyStroke);
        if (e.getKeyCode() == 8) {
            keymap2.removeAllActionShortcuts(actionId);
        } else {
            List actionIds = CollectionsKt.toMutableList((Collection)keymap2.getActionIds(keyShortcut));
            actionIds.removeIf(arg_0 -> KeymapPanel.recordKeyShortcut$lambda$6(arg_0 -> KeymapPanel.recordKeyShortcut$lambda$5(actionId, arg_0), arg_0));
            if (!((Collection)actionIds).isEmpty()) {
                for (String id : actionIds) {
                    Object text;
                    Action duplicateAction;
                    if (ActionManager.Companion.getInstance().getAction(id) == null || duplicateAction.getValue("ShortDescription") == null) continue;
                    Object[] objectArray = new Object[]{KeyShortcut.Companion.toHumanText(keyStroke), text};
                    OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this), I18n.INSTANCE.getString("termora.settings.keymap.already-exists", objectArray), null, 0, 0L, 20, null);
                }
                return;
            }
            keymap2.removeAllActionShortcuts(actionId);
            if (Intrinsics.areEqual((Object)actionId, (Object)"SwitchTabAction")) {
                for (int i = 49; i < 58; ++i) {
                    KeyStroke keyStroke2 = KeyStroke.getKeyStroke(i, keyStroke.getModifiers());
                    Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"getKeyStroke(...)");
                    keymap2.addShortcut(actionId, new KeyShortcut(keyStroke2));
                }
            } else {
                keymap2.addShortcut(actionId, keyShortcut);
            }
        }
        this.model.fireTableRowsUpdated(row, row);
        this.getKeymapManager().addKeymap(keymap2);
    }

    private final boolean isCombinationKey(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        return (modifiers & 0x80) != 0 || (modifiers & 0x40) != 0 || (modifiers & 0x200) != 0 || (modifiers & 0x100) != 0 || (modifiers & 0x2000) != 0;
    }

    private static final void initEvents$lambda$1(KeymapPanel this$0, ActionEvent it) {
        Keymap keymap = this$0.getCurrentKeymap();
        if (keymap != null) {
            this$0.copyKeymap(keymap);
        }
    }

    private static final void initEvents$lambda$2(KeymapPanel this$0, ItemEvent it) {
        if (it.getStateChange() == 1 && this$0.keymapComboBox.getSelectedItem() != null) {
            Keymap keymap = this$0.getCurrentKeymap();
            this$0.deleteBtn.setEnabled(!(keymap != null ? keymap.isReadonly() : true));
            this$0.renameBtn.setEnabled(this$0.deleteBtn.isEnabled());
            Database.Properties properties = this$0.getDatabase().getProperties();
            Object object = this$0.keymapComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            properties.putString("Keymap.Active", (String)object);
            this$0.model.fireTableDataChanged();
        }
    }

    private static final void initEvents$lambda$3(KeymapPanel this$0, ActionEvent it) {
        Keymap keymap = this$0.getCurrentKeymap();
        int index = this$0.keymapComboBox.getSelectedIndex();
        if (keymap != null && !keymap.isReadonly() && index >= 0) {
            Component component = SwingUtilities.getWindowAncestor(this$0);
            String string = this$0.renameBtn.getToolTipText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolTipText(...)");
            String text = OptionPane.showInputDialog$default(OptionPane.INSTANCE, component, string, keymap.getName(), null, 8, null);
            CharSequence charSequence = text;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)text, (Object)keymap.getName())) {
                this$0.getKeymapManager().removeKeymap(keymap.getName());
                Keymap newKeymap = this$0.cloneKeymap(text, keymap);
                this$0.getKeymapManager().addKeymap(newKeymap);
                this$0.keymapModel.removeElementAt(index);
                this$0.keymapModel.insertElementAt(text, index);
                this$0.keymapModel.setSelectedItem(newKeymap.getName());
            }
        }
    }

    private static final void initEvents$lambda$4(KeymapPanel this$0, ActionEvent it) {
        Keymap keymap = this$0.getCurrentKeymap();
        int index = this$0.keymapComboBox.getSelectedIndex();
        if (keymap != null && !keymap.isReadonly() && index >= 0 && OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
            this$0.getKeymapManager().removeKeymap(keymap.getName());
            this$0.keymapModel.removeElementAt(index);
        }
    }

    private static final boolean recordKeyShortcut$lambda$5(String $actionId, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$actionId);
    }

    private static final boolean recordKeyShortcut$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JTable access$getTable$p(KeymapPanel $this) {
        return $this.table;
    }

    public static final /* synthetic */ void access$recordKeyShortcut(KeymapPanel $this, int row, KeyEvent e) {
        $this.recordKeyShortcut(row, e);
    }
}

