/*
 * Decompiled with CFR 0.152.
 */
package app.termora.keymap;

import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.DeleteDataManager;
import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.SwingUtils;
import app.termora.actions.AnActionEvent;
import app.termora.keymap.KeyShortcut;
import app.termora.keymap.Keymap;
import app.termora.keymap.MacOSKeymap;
import app.termora.keymap.WindowsKeymap;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0010J\b\u0010%\u001a\u00020\"H\u0016R\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u000bR\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lapp/termora/keymap/KeymapManager;", "Lapp/termora/Disposable;", "<init>", "()V", "keymapKeyEventDispatcher", "Lapp/termora/keymap/KeymapManager$KeymapKeyEventDispatcher;", "database", "Lapp/termora/Database;", "getDatabase", "()Lapp/termora/Database;", "properties", "Lapp/termora/Database$Properties;", "getProperties", "()Lapp/termora/Database$Properties;", "keymaps", "Ljava/util/LinkedHashMap;", "", "Lapp/termora/keymap/Keymap;", "Lkotlin/collections/LinkedHashMap;", "activeKeymap", "getActiveKeymap", "()Ljava/lang/String;", "keyboardFocusManager", "Ljava/awt/KeyboardFocusManager;", "kotlin.jvm.PlatformType", "getKeyboardFocusManager", "()Ljava/awt/KeyboardFocusManager;", "keyboardFocusManager$delegate", "Lkotlin/Lazy;", "getKeymap", "name", "getKeymaps", "", "addKeymap", "", "keymap", "removeKeymap", "dispose", "Companion", "KeymapKeyEventDispatcher", "termora"})
public final class KeymapManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeymapKeyEventDispatcher keymapKeyEventDispatcher;
    @NotNull
    private final LinkedHashMap<String, Keymap> keymaps;
    @NotNull
    private final Lazy keyboardFocusManager$delegate;
    private static final Logger log = LoggerFactory.getLogger(KeymapManager.class);

    private KeymapManager() {
        block3: {
            this.keymapKeyEventDispatcher = new KeymapKeyEventDispatcher();
            this.keymaps = new LinkedHashMap();
            this.keyboardFocusManager$delegate = LazyKt.lazy(KeymapManager::keyboardFocusManager_delegate$lambda$0);
            this.getKeyboardFocusManager().addKeyEventDispatcher(this.keymapKeyEventDispatcher);
            try {
                for (Keymap keymap : this.getDatabase().getKeymaps()) {
                    ((Map)this.keymaps).put(keymap.getName(), keymap);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Keymap it = MacOSKeymap.Companion.getInstance();
        boolean bl = false;
        ((Map)this.keymaps).put(it.getName(), it);
        it = WindowsKeymap.Companion.getInstance();
        boolean bl2 = false;
        ((Map)this.keymaps).put(it.getName(), it);
    }

    private final Database getDatabase() {
        return Database.Companion.getDatabase();
    }

    private final Database.Properties getProperties() {
        return this.getDatabase().getProperties();
    }

    private final String getActiveKeymap() {
        return this.getProperties().getString("Keymap.Active");
    }

    private final KeyboardFocusManager getKeyboardFocusManager() {
        Lazy lazy = this.keyboardFocusManager$delegate;
        return (KeyboardFocusManager)lazy.getValue();
    }

    @NotNull
    public final Keymap getActiveKeymap() {
        Keymap keymap;
        String name = this.getActiveKeymap();
        if (name != null && (keymap = this.getKeymap(name)) != null) {
            return keymap;
        }
        return SystemInfo.isMacOS ? (Keymap)MacOSKeymap.Companion.getInstance() : (Keymap)WindowsKeymap.Companion.getInstance();
    }

    @Nullable
    public final Keymap getKeymap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.keymaps.get(name);
    }

    @NotNull
    public final List<Keymap> getKeymaps() {
        Collection<Keymap> collection = this.keymaps.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void addKeymap(@NotNull Keymap keymap) {
        Intrinsics.checkNotNullParameter((Object)keymap, (String)"keymap");
        this.keymaps.putFirst(keymap.getName(), keymap);
        this.getDatabase().addKeymap(keymap);
    }

    public final void removeKeymap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.keymaps.remove(name);
        this.getDatabase().removeKeymap(name);
        DeleteDataManager.removeKeymap$default(DeleteDataManager.Companion.getInstance(), name, 0L, 2, null);
    }

    @Override
    public void dispose() {
        this.getKeyboardFocusManager().removeKeyEventDispatcher(this.keymapKeyEventDispatcher);
    }

    private static final KeyboardFocusManager keyboardFocusManager_delegate$lambda$0() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager();
    }

    public /* synthetic */ KeymapManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/keymap/KeymapManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/keymap/KeymapManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeymapManager getInstance() {
            return (KeymapManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(KeymapManager.class), Companion::getInstance$lambda$0);
        }

        private static final KeymapManager getInstance$lambda$0() {
            return new KeymapManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lapp/termora/keymap/KeymapManager$KeymapKeyEventDispatcher;", "Ljava/awt/KeyEventDispatcher;", "<init>", "(Lapp/termora/keymap/KeymapManager;)V", "dispatchKeyEvent", "", "e", "Ljava/awt/event/KeyEvent;", "termora"})
    private final class KeymapKeyEventDispatcher
    implements KeyEventDispatcher {
        @Override
        public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.isConsumed() || e.getID() != 401 || e.getModifiersEx() == 0) {
                return false;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            Object component = e.getSource();
            if (component instanceof JComponent && ((JComponent)component).getConditionForKeyStroke(keyStroke) != -1) {
                return false;
            }
            Keymap shortcuts = KeymapManager.this.getActiveKeymap();
            Intrinsics.checkNotNull((Object)keyStroke);
            List<String> actionIds = shortcuts.getActionIds(new KeyShortcut(keyStroke));
            if (actionIds.isEmpty()) {
                return false;
            }
            Window focusedWindow = KeymapManager.this.getKeyboardFocusManager().getFocusedWindow();
            if (focusedWindow instanceof DialogWrapper ? !((DialogWrapper)focusedWindow).getProcessGlobalKeymap() : focusedWindow instanceof JDialog) {
                return false;
            }
            Component c2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (c2 instanceof Container) {
                List<JPopupMenu> list = SwingUtils.getDescendantsOfType(JPopupMenu.class, (Container)c2, true);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDescendantsOfType(...)");
                List<JPopupMenu> popups = list;
                if (!((Collection)popups).isEmpty()) {
                    return false;
                }
            }
            Object object = e.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            AnActionEvent evt = new AnActionEvent(object, "", e);
            for (String actionId : actionIds) {
                Action action;
                if (ActionManager.getInstance().getAction((Object)actionId) == null || !action.isEnabled()) continue;
                action.actionPerformed(evt);
                if (!evt.isConsumed()) continue;
                return true;
            }
            return false;
        }
    }
}

