/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.DeleteDataManager;
import app.termora.TerminalPanelFactory;
import app.termora.highlight.KeywordHighlight;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\fR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/termora/highlight/KeywordHighlightManager;", "", "<init>", "()V", "database", "Lapp/termora/Database;", "getDatabase", "()Lapp/termora/Database;", "database$delegate", "Lkotlin/Lazy;", "keywordHighlights", "", "", "Lapp/termora/highlight/KeywordHighlight;", "addKeywordHighlight", "", "keywordHighlight", "removeKeywordHighlight", "id", "getKeywordHighlights", "", "getKeywordHighlight", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nKeywordHighlightManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordHighlightManager.kt\napp/termora/highlight/KeywordHighlightManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1208#2,2:57\n1236#2,4:59\n1056#2:63\n*S KotlinDebug\n*F\n+ 1 KeywordHighlightManager.kt\napp/termora/highlight/KeywordHighlightManager\n*L\n24#1:57,2\n24#1:59,4\n50#1:63\n*E\n"})
public final class KeywordHighlightManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy database$delegate = LazyKt.lazy(KeywordHighlightManager::database_delegate$lambda$0);
    @NotNull
    private final Map<String, KeywordHighlight> keywordHighlights = new LinkedHashMap();
    private static final Logger log = LoggerFactory.getLogger(KeywordHighlightManager.class);

    /*
     * WARNING - void declaration
     */
    private KeywordHighlightManager() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.getDatabase().getKeywordHighlights();
        Map<String, KeywordHighlight> map = this.keywordHighlights;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KeywordHighlight keywordHighlight = (KeywordHighlight)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        map.putAll(destination$iv$iv);
    }

    private final Database getDatabase() {
        Lazy lazy = this.database$delegate;
        return (Database)lazy.getValue();
    }

    public final void addKeywordHighlight(@NotNull KeywordHighlight keywordHighlight) {
        Intrinsics.checkNotNullParameter((Object)keywordHighlight, (String)"keywordHighlight");
        this.getDatabase().addKeywordHighlight(keywordHighlight);
        this.keywordHighlights.put(keywordHighlight.getId(), keywordHighlight);
        TerminalPanelFactory.Companion.getInstance().repaintAll();
        if (log.isDebugEnabled()) {
            log.debug("Keyword highlighter added. {}", (Object)keywordHighlight);
        }
    }

    public final void removeKeywordHighlight(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.getDatabase().removeKeywordHighlight(id);
        this.keywordHighlights.remove(id);
        TerminalPanelFactory.Companion.getInstance().repaintAll();
        DeleteDataManager.removeKeywordHighlight$default(DeleteDataManager.Companion.getInstance(), id, 0L, 2, null);
        if (log.isDebugEnabled()) {
            log.debug("Keyword highlighter removed. {}", (Object)id);
        }
    }

    @NotNull
    public final List<KeywordHighlight> getKeywordHighlights() {
        Iterable $this$sortedBy$iv = this.keywordHighlights.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KeywordHighlight it = (KeywordHighlight)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSort());
                it = (KeywordHighlight)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
            }
        });
    }

    @Nullable
    public final KeywordHighlight getKeywordHighlight(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.keywordHighlights.get(id);
    }

    private static final Database database_delegate$lambda$0() {
        return Database.Companion.getDatabase();
    }

    public /* synthetic */ KeywordHighlightManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/highlight/KeywordHighlightManager$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/highlight/KeywordHighlightManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeywordHighlightManager getInstance() {
            return (KeywordHighlightManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(KeywordHighlightManager.class), Companion::getInstance$lambda$0);
        }

        private static final KeywordHighlightManager getInstance$lambda$0() {
            return new KeywordHighlightManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

