/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.TerminalFactory;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.highlight.KeywordHighlightTableModel;
import app.termora.highlight.KeywordHighlightView;
import app.termora.highlight.NewKeywordHighlightDialog;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import com.formdev.flatlaf.extras.components.FlatTable;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0014J\n\u0010#\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lapp/termora/highlight/KeywordHighlightDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "model", "Lapp/termora/highlight/KeywordHighlightTableModel;", "table", "Lcom/formdev/flatlaf/extras/components/FlatTable;", "keywordHighlightManager", "Lapp/termora/highlight/KeywordHighlightManager;", "getKeywordHighlightManager", "()Lapp/termora/highlight/KeywordHighlightManager;", "keywordHighlightManager$delegate", "Lkotlin/Lazy;", "terminal", "Lapp/termora/terminal/Terminal;", "getTerminal", "()Lapp/termora/terminal/Terminal;", "terminal$delegate", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "colorPalette$delegate", "addBtn", "Ljavax/swing/JButton;", "editBtn", "deleteBtn", "initView", "", "initEvents", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "termora"})
@SourceDebugExtension(value={"SMAP\nKeywordHighlightDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordHighlightDialog.kt\napp/termora/highlight/KeywordHighlightDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class KeywordHighlightDialog
extends DialogWrapper {
    @NotNull
    private final KeywordHighlightTableModel model;
    @NotNull
    private final FlatTable table;
    @NotNull
    private final Lazy keywordHighlightManager$delegate;
    @NotNull
    private final Lazy terminal$delegate;
    @NotNull
    private final Lazy colorPalette$delegate;
    @NotNull
    private final JButton addBtn;
    @NotNull
    private final JButton editBtn;
    @NotNull
    private final JButton deleteBtn;

    public KeywordHighlightDialog(@NotNull Window owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.model = new KeywordHighlightTableModel();
        this.table = new FlatTable();
        this.keywordHighlightManager$delegate = LazyKt.lazy(KeywordHighlightDialog::keywordHighlightManager_delegate$lambda$0);
        this.terminal$delegate = LazyKt.lazy(KeywordHighlightDialog::terminal_delegate$lambda$1);
        this.colorPalette$delegate = LazyKt.lazy(() -> KeywordHighlightDialog.colorPalette_delegate$lambda$2(this));
        this.addBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.add"));
        this.editBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.edit"));
        this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.remove"));
        this.setSize(new Dimension(UIManager.getInt("Dialog.width"), UIManager.getInt("Dialog.height")));
        this.setModal(true);
        this.setTitle(I18n.INSTANCE.getString("termora.highlight"));
        this.initView();
        this.initEvents();
        this.init();
        this.setLocationRelativeTo(null);
    }

    private final KeywordHighlightManager getKeywordHighlightManager() {
        Lazy lazy = this.keywordHighlightManager$delegate;
        return (KeywordHighlightManager)lazy.getValue();
    }

    private final Terminal getTerminal() {
        Lazy lazy = this.terminal$delegate;
        return (Terminal)lazy.getValue();
    }

    private final ColorPalette getColorPalette() {
        Lazy lazy = this.colorPalette$delegate;
        return (ColorPalette)lazy.getValue();
    }

    private final void initView() {
        this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.keyword"));
        this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.preview"));
        this.model.addColumn(I18n.INSTANCE.getString("termora.highlight.description"));
        this.table.setFillsViewportHeight(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setModel((TableModel)this.model);
        this.editBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){
            {
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (value instanceof KeywordHighlight) {
                    this.setText(((KeywordHighlight)value).getKeyword());
                    super.setSelected(((KeywordHighlight)value).getEnabled());
                }
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                return this;
            }
        });
        this.table.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(this){
            private final KeywordHighlightView keywordHighlightView;
            final /* synthetic */ KeywordHighlightDialog this$0;
            {
                this.this$0 = $receiver;
                this.keywordHighlightView = new KeywordHighlightView(0, 0, 2, null);
                this.keywordHighlightView.setBorder(null);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (value instanceof KeywordHighlight) {
                    this.keywordHighlightView.setKeywordHighlight((KeywordHighlight)value, KeywordHighlightDialog.access$getColorPalette(this.this$0));
                    if (isSelected) {
                        this.keywordHighlightView.setBackgroundColor(table.getSelectionBackground());
                    }
                    return this.keywordHighlightView;
                }
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
                return component;
            }
        });
    }

    private final void initEvents() {
        this.table.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ KeywordHighlightDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int row = KeywordHighlightDialog.access$getTable$p(this.this$0).rowAtPoint(e.getPoint());
                    int column = KeywordHighlightDialog.access$getTable$p(this.this$0).columnAtPoint(e.getPoint());
                    if (row >= 0 && column == 0) {
                        KeywordHighlight keywordHighlight = KeywordHighlightDialog.access$getModel$p(this.this$0).getKeywordHighlight(row);
                        KeywordHighlightDialog.access$getKeywordHighlightManager(this.this$0).addKeywordHighlight(KeywordHighlight.copy$default(keywordHighlight, null, null, null, false, false, 0, 0, false, false, false, false, !keywordHighlight.getEnabled(), 0L, 0L, 14335, null));
                        KeywordHighlightDialog.access$getModel$p(this.this$0).fireTableCellUpdated(row, column);
                    }
                }
            }
        });
        this.addBtn.addActionListener(arg_0 -> KeywordHighlightDialog.initEvents$lambda$3(this, arg_0));
        this.editBtn.addActionListener(arg_0 -> KeywordHighlightDialog.initEvents$lambda$4(this, arg_0));
        this.deleteBtn.addActionListener(arg_0 -> KeywordHighlightDialog.initEvents$lambda$5(this, arg_0));
        this.table.getSelectionModel().addListSelectionListener(arg_0 -> KeywordHighlightDialog.initEvents$lambda$6(this, arg_0));
        Disposer.register(this.getDisposable(), new Disposable(this){
            final /* synthetic */ KeywordHighlightDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                KeywordHighlightDialog.access$getTerminal(this.this$0).close();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        FormBuilder formBuilder;
        void $this$createCenterPanel_u24lambda_u247;
        JScrollPane jScrollPane;
        JPanel panel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = jScrollPane = new JScrollPane((Component)this.table);
        JPanel jPanel = panel2;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u247.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        jPanel.add((Component)jScrollPane, "Center");
        int rows = 0;
        rows = 1;
        int step = 2;
        String formMargin = "4dlu";
        FormLayout layout = new FormLayout("default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref");
        FormBuilder formBuilder2 = formBuilder = FormBuilder.create().layout(layout).padding(new EmptyBorder(0, 12, 0, 0)).add((Component)this.addBtn).xy(1, rows);
        jPanel = panel2;
        boolean bl2 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u248 = formBuilder = formBuilder.add((Component)this.editBtn).xy(1, rows += step);
        boolean bl3 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u249 = formBuilder = formBuilder.add((Component)this.deleteBtn).xy(1, rows += step);
        boolean bl4 = false;
        rows += step;
        jPanel.add((Component)formBuilder.build(), "East");
        panel2.setBorder(BorderFactory.createEmptyBorder(SystemInfo.isWindows || SystemInfo.isLinux ? 6 : 0, 12, 12, 12));
        return panel2;
    }

    @Override
    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    private static final KeywordHighlightManager keywordHighlightManager_delegate$lambda$0() {
        return KeywordHighlightManager.Companion.getInstance();
    }

    private static final Terminal terminal_delegate$lambda$1() {
        return TerminalFactory.Companion.getInstance().createTerminal();
    }

    private static final ColorPalette colorPalette_delegate$lambda$2(KeywordHighlightDialog this$0) {
        return this$0.getTerminal().getTerminalModel().getColorPalette();
    }

    private static final void initEvents$lambda$3(KeywordHighlightDialog this$0, ActionEvent it) {
        NewKeywordHighlightDialog dialog = new NewKeywordHighlightDialog((Window)this$0, this$0.getColorPalette());
        dialog.setLocationRelativeTo(this$0);
        dialog.setVisible(true);
        KeywordHighlight keywordHighlight = dialog.getKeywordHighlight();
        if (keywordHighlight != null) {
            this$0.getKeywordHighlightManager().addKeywordHighlight(keywordHighlight);
            this$0.model.fireTableRowsInserted(this$0.model.getRowCount() - 1, this$0.model.getRowCount());
        }
    }

    private static final void initEvents$lambda$4(KeywordHighlightDialog this$0, ActionEvent it) {
        int row = this$0.table.getSelectedRow();
        if (row > -1) {
            KeywordHighlight keywordHighlight = this$0.model.getKeywordHighlight(row);
            NewKeywordHighlightDialog dialog = new NewKeywordHighlightDialog((Window)this$0, this$0.getColorPalette());
            dialog.setLocationRelativeTo(this$0);
            dialog.getKeywordTextField().setText(keywordHighlight.getKeyword());
            dialog.getDescriptionTextField().setText(keywordHighlight.getDescription());
            if (keywordHighlight.getTextColor() <= 16) {
                if (keywordHighlight.getTextColor() == 0) {
                    dialog.getTextColor().setColor(new Color(this$0.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())));
                } else {
                    dialog.getTextColor().setColor(new Color(this$0.getColorPalette().getXTerm256Color(keywordHighlight.getTextColor())));
                }
                dialog.getTextColor().setColorIndex(keywordHighlight.getTextColor());
            } else {
                dialog.getTextColor().setColor(new Color(keywordHighlight.getTextColor()));
                dialog.getTextColor().setColorIndex(-1);
            }
            if (keywordHighlight.getBackgroundColor() <= 16) {
                if (keywordHighlight.getBackgroundColor() == 0) {
                    dialog.getBackgroundColor().setColor(new Color(this$0.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
                } else {
                    dialog.getBackgroundColor().setColor(new Color(this$0.getColorPalette().getXTerm256Color(keywordHighlight.getBackgroundColor())));
                }
                dialog.getBackgroundColor().setColorIndex(keywordHighlight.getBackgroundColor());
            } else {
                dialog.getBackgroundColor().setColor(new Color(keywordHighlight.getBackgroundColor()));
                dialog.getBackgroundColor().setColorIndex(-1);
            }
            dialog.getBoldCheckBox().setSelected(keywordHighlight.getBold());
            dialog.getItalicCheckBox().setSelected(keywordHighlight.getItalic());
            dialog.getUnderlineCheckBox().setSelected(keywordHighlight.getUnderline());
            dialog.getLineThroughCheckBox().setSelected(keywordHighlight.getLineThrough());
            dialog.getMatchCaseBtn().setSelected(keywordHighlight.getMatchCase());
            dialog.getRegexBtn().setSelected(keywordHighlight.getRegex());
            dialog.setVisible(true);
            KeywordHighlight value = dialog.getKeywordHighlight();
            if (value != null) {
                keywordHighlight = KeywordHighlight.copy$default(value, keywordHighlight.getId(), null, null, false, false, 0, 0, false, false, false, false, false, keywordHighlight.getSort(), 0L, 12286, null);
                this$0.getKeywordHighlightManager().addKeywordHighlight(keywordHighlight);
                this$0.model.fireTableRowsUpdated(row, row);
            }
        }
    }

    private static final void initEvents$lambda$5(KeywordHighlightDialog this$0, ActionEvent it) {
        if (this$0.table.getSelectedRowCount() > 0 && OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
            int[] nArray = this$0.table.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
            List rows = CollectionsKt.reversed((Iterable)ArraysKt.sorted((int[])nArray));
            Iterator iterator2 = rows.iterator();
            while (iterator2.hasNext()) {
                int row = ((Number)iterator2.next()).intValue();
                String id = this$0.model.getKeywordHighlight(row).getId();
                this$0.getKeywordHighlightManager().removeKeywordHighlight(id);
                this$0.model.fireTableRowsDeleted(row, row);
            }
        }
    }

    private static final void initEvents$lambda$6(KeywordHighlightDialog this$0, ListSelectionEvent it) {
        this$0.editBtn.setEnabled(this$0.table.getSelectedRowCount() > 0);
        this$0.deleteBtn.setEnabled(this$0.editBtn.isEnabled());
    }

    public static final /* synthetic */ ColorPalette access$getColorPalette(KeywordHighlightDialog $this) {
        return $this.getColorPalette();
    }

    public static final /* synthetic */ FlatTable access$getTable$p(KeywordHighlightDialog $this) {
        return $this.table;
    }

    public static final /* synthetic */ KeywordHighlightTableModel access$getModel$p(KeywordHighlightDialog $this) {
        return $this.model;
    }

    public static final /* synthetic */ KeywordHighlightManager access$getKeywordHighlightManager(KeywordHighlightDialog $this) {
        return $this.getKeywordHighlightManager();
    }

    public static final /* synthetic */ Terminal access$getTerminal(KeywordHighlightDialog $this) {
        return $this.getTerminal();
    }
}

