/*
 * Decompiled with CFR 0.152.
 */
package app.termora.addons.zmodem;

import app.termora.I18n;
import app.termora.native.FileChooser;
import app.termora.terminal.PtyConnectorDelegate;
import app.termora.terminal.StreamPtyConnector;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zmodem.FileCopyStreamEvent;
import zmodem.ZModem;
import zmodem.util.CustomFile;
import zmodem.util.EmptyFileAdapter;
import zmodem.util.FileAdapter;
import zmodem.xfer.zm.util.ZModemCharacter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lapp/termora/addons/zmodem/ZModemPtyConnectorAdaptor;", "Lapp/termora/terminal/PtyConnectorDelegate;", "terminal", "Lapp/termora/terminal/Terminal;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "pty", "Lapp/termora/terminal/StreamPtyConnector;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/StreamPtyConnector;)V", "prefix", "", "zmodem", "Lapp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$ZModemProcessor;", "read", "", "buffer", "indexOf", "a", "b", "write", "", "", "offset", "len", "Companion", "ZModemInputStream", "ZModemProcessor", "termora"})
public final class ZModemPtyConnectorAdaptor
extends PtyConnectorDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final StreamPtyConnector pty;
    @NotNull
    private final char[] prefix;
    @Nullable
    private volatile ZModemProcessor zmodem;
    private static final Logger log = LoggerFactory.getLogger(ZModemPtyConnectorAdaptor.class);

    public ZModemPtyConnectorAdaptor(@NotNull Terminal terminal, @NotNull TerminalPanel terminalPanel, @NotNull StreamPtyConnector pty) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)pty, (String)"pty");
        super(pty);
        this.terminal = terminal;
        this.terminalPanel = terminalPanel;
        this.pty = pty;
        char[] cArray = new char[]{(char)ZModemCharacter.ZPAD.value(), (char)ZModemCharacter.ZPAD.value(), (char)ZModemCharacter.ZDLE.value()};
        this.prefix = cArray;
    }

    @Override
    public int read(@NotNull char[] buffer) {
        int i;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.zmodem != null) {
            ZModemProcessor zModemProcessor = this.zmodem;
            if (zModemProcessor != null) {
                zModemProcessor.process();
            }
            this.zmodem = null;
        }
        if ((i = this.pty.read(buffer)) < 1) {
            return i;
        }
        char[] cArray = Arrays.copyOfRange(buffer, 0, i);
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOfRange(...)");
        int e = this.indexOf(cArray, this.prefix);
        if (e == -1) {
            return i;
        }
        char[] zmodemFrame = Arrays.copyOfRange(buffer, e, i);
        boolean bl = zmodemFrame.length > 5 && zmodemFrame[5] == '0';
        InputStream inputStream = this.pty.getInput();
        String string = CharBuffer.wrap(zmodemFrame).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.zmodem = new ZModemProcessor(bl, this.terminalPanel, this.terminal, new ZModemInputStream(inputStream, byArray), this.pty.getOutput());
        return e;
    }

    private final int indexOf(char[] a, char[] b) {
        if (a.length < b.length) {
            return -1;
        }
        int i = 0;
        int n = a.length - b.length;
        if (i <= n) {
            while (true) {
                char[] range;
                if (Arrays.equals(range = Arrays.copyOfRange(a, i, i + b.length), b)) {
                    return i;
                }
                if (i == n) break;
                ++i;
            }
        }
        return -1;
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.zmodem != null) {
            if (buffer[offset] == 3) {
                ZModemProcessor zModemProcessor = this.zmodem;
                if (zModemProcessor != null) {
                    zModemProcessor.cancel();
                }
            }
            return;
        }
        this.pty.write(buffer, offset, len);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lapp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$ZModemInputStream;", "Ljava/io/InputStream;", "input", "buffer", "", "<init>", "(Ljava/io/InputStream;[B)V", "index", "", "read", "termora"})
    private static final class ZModemInputStream
    extends InputStream {
        @NotNull
        private final InputStream input;
        @NotNull
        private final byte[] buffer;
        private int index;

        public ZModemInputStream(@NotNull InputStream input2, @NotNull byte[] buffer) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.input = input2;
            this.buffer = buffer;
        }

        @Override
        public int read() {
            if (this.index < this.buffer.length) {
                int n = this.index;
                this.index = n + 1;
                return this.buffer[this.index - 1];
            }
            return this.input.read();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u001fH\u0016J \u0010\u001e\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0006\u0010\"\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lapp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$ZModemProcessor;", "Lorg/apache/commons/net/io/CopyStreamListener;", "sz", "", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "<init>", "(ZLapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;Ljava/io/InputStream;Ljava/io/OutputStream;)V", "zmodem", "Lzmodem/ZModem;", "lastRefreshTime", "", "process", "", "receive", "send", "refreshProgress", "event", "Lzmodem/FileCopyStreamEvent;", "openFilesDialog", "", "Ljava/io/File;", "fileSelectionMode", "", "bytesTransferred", "Lorg/apache/commons/net/io/CopyStreamEvent;", "totalBytesTransferred", "streamSize", "cancel", "termora"})
    @SourceDebugExtension(value={"SMAP\nZModemPtyConnectorAdaptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZModemPtyConnectorAdaptor.kt\napp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$ZModemProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1563#2:272\n1634#2,3:273\n*S KotlinDebug\n*F\n+ 1 ZModemPtyConnectorAdaptor.kt\napp/termora/addons/zmodem/ZModemPtyConnectorAdaptor$ZModemProcessor\n*L\n165#1:272\n165#1:273,3\n*E\n"})
    private static final class ZModemProcessor
    implements CopyStreamListener {
        private final boolean sz;
        @NotNull
        private final TerminalPanel terminalPanel;
        @NotNull
        private final Terminal terminal;
        @NotNull
        private final ZModem zmodem;
        private long lastRefreshTime;

        public ZModemProcessor(boolean sz, @NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal, @NotNull InputStream input2, @NotNull OutputStream output) {
            Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.sz = sz;
            this.terminalPanel = terminalPanel;
            this.terminal = terminal;
            this.zmodem = new ZModem(input2, output);
        }

        public final void process() {
            if (this.sz) {
                this.receive();
            } else {
                this.send();
            }
        }

        private final void receive() {
            this.zmodem.receive(new Supplier<FileAdapter>(this){
                final /* synthetic */ ZModemProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public FileAdapter get() {
                    try {
                        File file = (File)CollectionsKt.firstOrNull((List)ZModemProcessor.access$openFilesDialog(this.this$0, 1));
                        if (file != null) {
                            FileUtils.forceMkdir((File)file);
                        }
                        return file == null ? (FileAdapter)EmptyFileAdapter.Companion.getInstance() : (FileAdapter)new CustomFile(file);
                    }
                    catch (Exception e) {
                        if (ZModemPtyConnectorAdaptor.access$getLog$cp().isErrorEnabled()) {
                            ZModemPtyConnectorAdaptor.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                        }
                        return EmptyFileAdapter.Companion.getInstance();
                    }
                }
            }, this);
        }

        private final void send() {
            this.zmodem.send(() -> ZModemProcessor.send$lambda$1(this), this);
        }

        private final void refreshProgress(FileCopyStreamEvent event) {
            String string;
            int width = 24;
            boolean skip = event.getSkip();
            boolean completed = (long)event.getBytesTransferred() >= event.getTotalBytesTransferred();
            double rate = (double)event.getBytesTransferred() * 1.0 / (double)event.getTotalBytesTransferred() * 100.0;
            if (completed) {
                string = "100";
            } else {
                String string2 = "%.2f";
                Object[] objectArray = new Object[]{Math.min(rate, 99.99)};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            String progress = string;
            int total = event.getRemaining() + event.getIndex() - 1;
            StringBuilder sb = new StringBuilder();
            sb.append('\r');
            sb.append('\u001b').append("[0J");
            sb.append('[').append('\u001b').append("[35m").append(event.getIndex());
            sb.append('\u001b').append("[39m").append('/');
            sb.append('\u001b').append("[35m").append(total).append('\u001b').append("[39m").append(']');
            sb.append('\t');
            sb.append(StringUtils.abbreviate((String)StringUtils.rightPad((String)event.getFilename(), (int)width), (int)width));
            sb.append('\t');
            sb.append(StringUtils.abbreviate((String)StringUtils.rightPad((String)(event.getBytesTransferred() + "/" + event.getTotalBytesTransferred()), (int)width), (int)width));
            sb.append('\t');
            StringBuilder stringBuilder = event.getSkip() ? sb.append("[" + I18n.INSTANCE.getString("termora.addons.zmodem.skip") + "]") : sb.append(progress).append('%');
            if (completed && event.getRemaining() > 1 || event.getSkip()) {
                sb.append('\n');
                sb.append('\r');
            }
            if (completed && total == event.getIndex()) {
                sb.append('\n');
                sb.append('\r');
            }
            if (completed || skip) {
                SwingUtilities.invokeLater(() -> ZModemProcessor.refreshProgress$lambda$2(this, sb));
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastRefreshTime > 100L) {
                this.lastRefreshTime = now;
                SwingUtilities.invokeLater(() -> ZModemProcessor.refreshProgress$lambda$3(this, sb));
            }
        }

        private final List<File> openFilesDialog(int fileSelectionMode) {
            CompletableFuture future = new CompletableFuture();
            SwingUtilities.invokeAndWait(() -> ZModemProcessor.openFilesDialog$lambda$4(this, fileSelectionMode, future));
            Object t = future.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return (List)t;
        }

        public void bytesTransferred(@NotNull CopyStreamEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof FileCopyStreamEvent)) {
                return;
            }
            this.refreshProgress((FileCopyStreamEvent)event);
        }

        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        public final void cancel() {
            this.zmodem.cancel();
        }

        /*
         * WARNING - void declaration
         */
        private static final List send$lambda$1(ZModemProcessor this$0) {
            List files;
            block3: {
                files = new ArrayList();
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this$0.openFilesDialog(0);
                    List list = files;
                    boolean $i$f$map = false;
                    void var4_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        File file = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new CustomFile((File)it));
                    }
                    list.addAll((List)destination$iv$iv);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return files;
        }

        private static final void refreshProgress$lambda$2(ZModemProcessor this$0, StringBuilder $sb) {
            Terminal terminal = this$0.terminal;
            String string = $sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            terminal.write(string);
        }

        private static final void refreshProgress$lambda$3(ZModemProcessor this$0, StringBuilder $sb) {
            Terminal terminal = this$0.terminal;
            String string = $sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            terminal.write(string);
        }

        private static final void openFilesDialog$lambda$4(ZModemProcessor this$0, int $fileSelectionMode, CompletableFuture $future) {
            File file;
            Window owner = SwingUtilities.getWindowAncestor(this$0.terminalPanel);
            FileChooser chooser = new FileChooser();
            chooser.setFileSelectionMode($fileSelectionMode);
            chooser.setAllowsMultiSelection($fileSelectionMode == 0);
            boolean bl = SystemInfo.isMacOS || $fileSelectionMode == 0 ? $future.complete(chooser.showOpenDialog(owner).get()) : ((file = chooser.showSaveDialog(owner, new String()).get()) == null ? $future.complete(CollectionsKt.emptyList()) : $future.complete(CollectionsKt.listOf((Object)file)));
        }

        public static final /* synthetic */ List access$openFilesDialog(ZModemProcessor $this, int fileSelectionMode) {
            return $this.openFilesDialog(fileSelectionMode);
        }
    }
}

