/*
 * Decompiled with CFR 0.152.
 */
package app.termora.actions;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.TermoraRestarter;
import app.termora.UpdaterManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.AppUpdateAction;
import com.formdev.flatlaf.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.WinReg;
import io.github.g00fy2.versioncompare.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jdesktop.swingx.JXEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/termora/actions/AppUpdateAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "updaterManager", "Lapp/termora/UpdaterManager;", "getUpdaterManager", "()Lapp/termora/UpdaterManager;", "isRemindMeNextTime", "", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "scheduleUpdate", "checkUpdate", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadLatestPkg", "latestVersion", "Lapp/termora/UpdaterManager$LatestVersion;", "(Lapp/termora/UpdaterManager$LatestVersion;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setLatestPkgFile", "file", "Ljava/io/File;", "getLatestPkgFile", "showUpdateDialog", "updateSelf", "isAppInstalled", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nAppUpdateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUpdateAction.kt\napp/termora/actions/AppUpdateAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class AppUpdateAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)));
    private boolean isRemindMeNextTime;
    private static final Logger log = LoggerFactory.getLogger(AppUpdateAction.class);
    @NotNull
    private static final String PKG_FILE_KEY = "pkgFile";

    private AppUpdateAction() {
        super("", (Icon)((Object)Icons.INSTANCE.getIdeUpdate()));
        this.setEnabled(false);
        this.scheduleUpdate();
    }

    private final UpdaterManager getUpdaterManager() {
        return UpdaterManager.Companion.getInstance();
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.showUpdateDialog();
    }

    private final void scheduleUpdate() {
        Timer timer;
        long l = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES));
        long l2 = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.HOURS));
        String string = "check-update-timer";
        boolean bl = true;
        Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
        timer2.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ AppUpdateAction this$0;
            {
                this.this$0 = appUpdateAction;
            }

            public void run() {
                TimerTask $this$scheduleUpdate_u24lambda_u240 = this;
                boolean bl = false;
                if (!AppUpdateAction.access$isRemindMeNextTime$p(this.this$0)) {
                    BuildersKt.launch$default((CoroutineScope)AppUpdateAction.access$getCoroutineScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                        int label;
                        final /* synthetic */ AppUpdateAction this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = AppUpdateAction.access$checkUpdate(this.this$0, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        }, l, l2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkUpdate(Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkUpdate.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ AppUpdateAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AppUpdateAction.access$checkUpdate(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Application.INSTANCE.isUnknownVersion()) {
                    return Unit.INSTANCE;
                }
                latestVersion = this.getUpdaterManager().fetchLatestVersion();
                if (latestVersion.isSelf()) {
                    return Unit.INSTANCE;
                }
                newVersion = new Version(latestVersion.getVersion());
                if (newVersion.compareTo(version = new Version(Application.INSTANCE.getVersion())) <= 0) {
                    return Unit.INSTANCE;
                }
                $continuation.label = 1;
                v0 = this.downloadLatestPkg(latestVersion, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var8_4) goto lbl26
lbl25:
                // 1 sources

                return var8_4;
lbl26:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    if (!AppUpdateAction.log.isErrorEnabled()) ** GOTO lbl36
                    AppUpdateAction.log.error(e.getMessage(), (Throwable)e);
                }
lbl36:
                // 4 sources

                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ AppUpdateAction this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.setEnabled(true);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object downloadLatestPkg(UpdaterManager.LatestVersion latestVersion, Continuation<? super Unit> $completion) {
        Object object;
        ResponseBody body;
        Object v0;
        Object object22;
        String filename;
        block11: {
            if (SystemInfo.isLinux) {
                return Unit.INSTANCE;
            }
            super.putValue(PKG_FILE_KEY, null);
            String arch = SystemInfo.isAARCH64 ? "aarch64" : "x86-64";
            String osName = SystemInfo.isWindows ? "windows" : "osx";
            String suffix = SystemInfo.isWindows ? "exe" : "dmg";
            filename = "termora-" + latestVersion.getVersion() + "-" + osName + "-" + arch + "." + suffix;
            Iterable iterable = latestVersion.getAssets();
            for (Object object22 : iterable) {
                UpdaterManager.Asset it = (UpdaterManager.Asset)object22;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)filename)) continue;
                v0 = object22;
                break block11;
            }
            v0 = null;
        }
        UpdaterManager.Asset asset = v0;
        if (asset == null) {
            return Unit.INSTANCE;
        }
        UpdaterManager.Asset asset2 = asset;
        OkHttpClient.Builder builder2 = Application.INSTANCE.getHttpClient().newBuilder().callTimeout(15L, TimeUnit.MINUTES).readTimeout(15L, TimeUnit.MINUTES);
        ProxySelector proxySelector = ProxySelector.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)proxySelector, (String)"getDefault(...)");
        Response response = builder2.proxySelector(proxySelector).build().newCall(new Request.Builder().url(asset2.getDownloadUrl()).build()).execute();
        if (!response.isSuccessful()) {
            if (log.isErrorEnabled()) {
                log.warn("Failed to download latest version " + latestVersion.getVersion() + ", response code " + response.code());
            }
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            return Unit.INSTANCE;
        }
        ResponseBody responseBody = body = response.body();
        InputStream input2 = responseBody != null ? responseBody.byteStream() : null;
        object22 = new String[]{UUID.randomUUID() + "-" + filename};
        File file = FileUtils.getFile((File)Application.INSTANCE.getTemporaryDir(), object22);
        Intrinsics.checkNotNull((Object)file);
        FileOutputStream output = new FileOutputStream(file);
        Closeable[] closeableArray = this;
        try {
            Closeable[] $this$downloadLatestPkg_u24lambda_u242 = closeableArray;
            boolean bl = false;
            object = Result.constructor-impl((Object)Boxing.boxInt((int)IOUtils.copy((InputStream)input2, (OutputStream)output)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        boolean downloaded = Result.isSuccess-impl((Object)object);
        closeableArray = new Closeable[]{input2, output, body, response};
        IOUtils.closeQuietly((Closeable[])closeableArray);
        if (!downloaded) {
            if (log.isErrorEnabled()) {
                log.error("Failed to download latest version to " + filename);
            }
            return Unit.INSTANCE;
        }
        if (log.isInfoEnabled()) {
            log.info("Successfully downloaded latest version to " + file);
        }
        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((AppUpdateAction)this, file, null){
            int label;
            final /* synthetic */ AppUpdateAction this$0;
            final /* synthetic */ File $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        File file = this.$file;
                        Intrinsics.checkNotNull((Object)file);
                        AppUpdateAction.access$setLatestPkgFile(this.this$0, file);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object3;
        }
        return Unit.INSTANCE;
    }

    private final void setLatestPkgFile(File file) {
        this.putValue(PKG_FILE_KEY, file);
    }

    private final File getLatestPkgFile() {
        Object object = this.getValue(PKG_FILE_KEY);
        return object instanceof File ? (File)object : null;
    }

    private final void showUpdateDialog() {
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        UpdaterManager.LatestVersion lastVersion = this.getUpdaterManager().getLastVersion();
        JXEditorPane editorPane = new JXEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setText(lastVersion.getHtmlBody());
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(AppUpdateAction::showUpdateDialog$lambda$3);
        editorPane.setBackground((Color)new DynamicColor("window"));
        JScrollPane scrollPane = new JScrollPane((Component)editorPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setPreferredSize(new Dimension(UIManager.getInt("Dialog.width") - 100, UIManager.getInt("Dialog.height") - 100));
        OptionPane optionPane = OptionPane.INSTANCE;
        String string = I18n.INSTANCE.getString("termora.update.title");
        Object object = new Object[]{I18n.INSTANCE.getString("termora.update.update"), I18n.INSTANCE.getString("termora.update.ignore"), I18n.INSTANCE.getString("termora.cancel")};
        Object[] objectArray = object;
        object = I18n.INSTANCE.getString("termora.update.update");
        int option = OptionPane.showConfirmDialog$default(optionPane, owner, scrollPane, string, 1, -1, null, objectArray, object, null, 288, null);
        switch (option) {
            case 2: {
                return;
            }
            case 1: {
                this.setEnabled(false);
                this.isRemindMeNextTime = true;
                break;
            }
            case 0: {
                this.updateSelf(lastVersion);
            }
        }
    }

    private final void updateSelf(UpdaterManager.LatestVersion latestVersion) {
        List commands;
        File file = this.getLatestPkgFile();
        if (SystemInfo.isLinux || file == null) {
            this.setEnabled(false);
            URI uRI = URI.create("https://github.com/TermoraDev/termora/releases/tag/" + latestVersion.getVersion());
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (SystemInfo.isMacOS) {
            var5_4 = new String[]{"open", "-n", file.getAbsolutePath()};
            v1 = CollectionsKt.listOf((Object[])var5_4);
        } else if (this.isAppInstalled()) {
            var5_4 = new String[]{file.getAbsolutePath(), "/SILENT", "/AUTOSTART", "/NORESTART", "/FORCECLOSEAPPLICATIONS"};
            v1 = CollectionsKt.listOf((Object[])var5_4);
        } else {
            v1 = commands = CollectionsKt.listOf((Object)file.getAbsolutePath());
        }
        if (log.isInfoEnabled()) {
            log.info("restart {}", (Object)CollectionsKt.joinToString$default((Iterable)commands, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        TermoraRestarter.Companion.getInstance().scheduleRestart(owner, commands);
    }

    private final boolean isAppInstalled() {
        WinReg.HKEYByReference phkKey;
        String keyPath = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + Application.INSTANCE.getName() + "_is1";
        int result = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_LOCAL_MACHINE, keyPath, 0, 131097, phkKey = new WinReg.HKEYByReference());
        if (result == 0) {
            Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            return true;
        }
        return false;
    }

    private static final void showUpdateDialog$lambda$3(HyperlinkEvent it) {
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            URI uRI = it.getURL().toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
            Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
        }
    }

    public /* synthetic */ AppUpdateAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Object access$checkUpdate(AppUpdateAction $this, Continuation $completion) {
        return $this.checkUpdate((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$downloadLatestPkg(AppUpdateAction $this, UpdaterManager.LatestVersion latestVersion, Continuation $completion) {
        return $this.downloadLatestPkg(latestVersion, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setLatestPkgFile(AppUpdateAction $this, File file) {
        $this.setLatestPkgFile(file);
    }

    public static final /* synthetic */ boolean access$isRemindMeNextTime$p(AppUpdateAction $this) {
        return $this.isRemindMeNextTime;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(AppUpdateAction $this) {
        return $this.coroutineScope;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/actions/AppUpdateAction$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PKG_FILE_KEY", "", "getInstance", "Lapp/termora/actions/AppUpdateAction;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppUpdateAction getInstance() {
            return (AppUpdateAction)((Object)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(AppUpdateAction.class), Companion::getInstance$lambda$0));
        }

        private static final AppUpdateAction getInstance$lambda$0() {
            return new AppUpdateAction(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

