/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.BannerPanel;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.DocumentAdaptor;
import app.termora.FilterableHostTreeModel;
import app.termora.Host;
import app.termora.HostTreeNode;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.NewHostTree;
import app.termora.NewHostTreeModel;
import app.termora.OpenHostActionEvent;
import app.termora.Protocol;
import app.termora.TerminalTab;
import app.termora.TreeUtils;
import app.termora.WindowScope;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.findeverywhere.FindEverywhereProvider;
import app.termora.findeverywhere.FindEverywhereResult;
import app.termora.terminal.DataKey;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.components.FlatButton;
import com.formdev.flatlaf.extras.components.FlatTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00019B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\"H\u0002J\b\u0010'\u001a\u00020\"H\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020\u0018H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016J\b\u0010/\u001a\u00020\u0018H\u0016J\b\u00100\u001a\u00020\"H\u0016J\b\u00101\u001a\u00020\"H\u0016J\b\u00102\u001a\u00020\"H\u0016J'\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407H\u0016\u00a2\u0006\u0002\u00108R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00060\nR\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lapp/termora/WelcomePanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "Lapp/termora/TerminalTab;", "Lapp/termora/actions/DataProvider;", "windowScope", "Lapp/termora/WindowScope;", "<init>", "(Lapp/termora/WindowScope;)V", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "rootPanel", "searchTextField", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "hostTree", "Lapp/termora/NewHostTree;", "bannerPanel", "Lapp/termora/BannerPanel;", "toggle", "Lcom/formdev/flatlaf/extras/components/FlatButton;", "fullContent", "", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "hostTreeModel", "Lapp/termora/NewHostTreeModel;", "lastFocused", "Ljava/awt/Component;", "filterableHostTreeModel", "Lapp/termora/FilterableHostTreeModel;", "initView", "", "createSearchPanel", "Ljavax/swing/JComponent;", "createHostPanel", "initEvents", "perform", "getTitle", "", "getIcon", "Ljavax/swing/Icon;", "getJComponent", "canReconnect", "canClose", "canClone", "onLostFocus", "onGrabFocus", "dispose", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "HostFindEverywhereResult", "termora"})
public final class WelcomePanel
extends JPanel
implements Disposable,
TerminalTab,
DataProvider {
    @NotNull
    private final WindowScope windowScope;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final FlatTextField searchTextField;
    @NotNull
    private final NewHostTree hostTree;
    @NotNull
    private final BannerPanel bannerPanel;
    @NotNull
    private final FlatButton toggle;
    private boolean fullContent;
    @NotNull
    private final DataProviderSupport dataProviderSupport;
    @NotNull
    private final NewHostTreeModel hostTreeModel;
    @Nullable
    private Component lastFocused;
    @NotNull
    private final FilterableHostTreeModel filterableHostTreeModel;

    public WelcomePanel(@NotNull WindowScope windowScope) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        super(new BorderLayout());
        this.windowScope = windowScope;
        this.rootPanel = new JPanel(new BorderLayout());
        this.searchTextField = new FlatTextField();
        this.hostTree = new NewHostTree();
        this.bannerPanel = new BannerPanel(0, false, 3, null);
        this.toggle = new FlatButton();
        this.fullContent = Boolean.parseBoolean(this.getProperties().getString("WelcomeFullContent", "false"));
        this.dataProviderSupport = new DataProviderSupport();
        TreeModel treeModel = this.hostTree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type app.termora.NewHostTreeModel");
        this.hostTreeModel = (NewHostTreeModel)treeModel;
        this.filterableHostTreeModel = new FilterableHostTreeModel((JTree)((Object)this.hostTree), (Function0<Boolean>)((Function0)() -> WelcomePanel.filterableHostTreeModel$lambda$0(this)));
        this.initView();
        this.initEvents();
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    private final void initView() {
        this.putClientProperty("JTabbedPane.tabClosable", false);
        this.putClientProperty("SKIP_FIND_EVERYWHERE", true);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createSearchPanel(), "North");
        panel2.add((Component)this.createHostPanel(), "Center");
        if (!this.fullContent) {
            this.rootPanel.add((Component)this.bannerPanel, "North");
        }
        this.rootPanel.add((Component)panel2, "Center");
        this.add((Component)this.rootPanel, "Center");
        this.dataProviderSupport.addData(DataProviders.Welcome.INSTANCE.getHostTree(), this.hostTree);
    }

    private final JComponent createSearchPanel() {
        this.searchTextField.setFocusTraversalKeysEnabled(false);
        this.searchTextField.setPreferredSize(new Dimension(this.searchTextField.getPreferredSize().width, (int)((double)UIManager.getInt("TitleBar.height") * 0.85)));
        int iconSize = (int)((double)this.searchTextField.getPreferredSize().height * 0.65);
        FlatButton newHost = new FlatButton();
        newHost.setIcon((Icon)new FlatSVGIcon(Icons.INSTANCE.getOpenNewTab().getName(), iconSize, iconSize));
        newHost.setFocusable(false);
        newHost.setButtonType(FlatButton.ButtonType.toolBarButton);
        newHost.addActionListener(WelcomePanel::createSearchPanel$lambda$1);
        this.toggle.setIcon((Icon)new FlatSVGIcon(this.fullContent ? Icons.INSTANCE.getCollapseAll().getName() : Icons.INSTANCE.getCollapseAll().getName(), iconSize, iconSize));
        this.toggle.setFocusable(false);
        this.toggle.setButtonType(FlatButton.ButtonType.toolBarButton);
        Box box = Box.createHorizontalBox();
        box.add((Component)this.searchTextField);
        box.add(Box.createHorizontalStrut(4));
        box.add((Component)newHost);
        box.add(Box.createHorizontalStrut(4));
        box.add((Component)this.toggle);
        if (!this.fullContent) {
            box.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        }
        this.toggle.addActionListener(arg_0 -> WelcomePanel.createSearchPanel$lambda$2(this, iconSize, box, arg_0));
        Intrinsics.checkNotNull((Object)box);
        return box;
    }

    private final JComponent createHostPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.hostTree.getActionMap().put("find", (Action)((Object)new AnAction(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                WelcomePanel.access$getSearchTextField$p(this.this$0).requestFocusInWindow();
            }
        }));
        this.hostTree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.hostTree));
        scrollPane.getVerticalScrollBar().setMaximumSize(new Dimension(0, 0));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        scrollPane.getVerticalScrollBar().setMinimumSize(new Dimension(0, 0));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        panel2.add((Component)scrollPane, "Center");
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.hostTree.setModel(this.filterableHostTreeModel);
        TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)this.hostTree), this.getProperties().getString("Welcome.HostTree.state", ""));
        return panel2;
    }

    private final void initEvents() {
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentShown(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!WelcomePanel.access$getSearchTextField$p(this.this$0).hasFocus()) {
                    WelcomePanel.access$getSearchTextField$p(this.this$0).requestFocusInWindow();
                }
                WelcomePanel.access$perform(this.this$0);
                this.this$0.removeComponentListener(this);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WelcomePanel.access$perform(this.this$0);
            }
        });
        FindEverywhereProvider.Companion.getFindEverywhereProviders(this.windowScope).add(new FindEverywhereProvider(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public List<FindEverywhereResult> find(String pattern) {
                void $this$mapTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Host it;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                Iterable $this$map$iv = WelcomePanel.access$getHostTreeModel$p(this.this$0).getRoot().getAllChildren();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<T> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    HostTreeNode hostTreeNode = (HostTreeNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((HostTreeNode)((Object)it)).getHost());
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Host)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getProtocol() != Protocol.Folder)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filter = (List)destination$iv$iv;
                if (!StringsKt.isBlank((CharSequence)pattern)) {
                    $this$filter$iv = filter;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Host)element$iv$iv;
                        boolean bl = false;
                        boolean bl2 = it.getProtocol() == Protocol.SSH ? StringsKt.contains((CharSequence)it.getName(), (CharSequence)pattern, (boolean)true) || StringsKt.contains((CharSequence)it.getHost(), (CharSequence)pattern, (boolean)true) : StringsKt.contains((CharSequence)it.getName(), (CharSequence)pattern, (boolean)true);
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    filter = (List)destination$iv$iv;
                }
                $this$filter$iv = filter;
                WelcomePanel welcomePanel = this.this$0;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Host bl = (Host)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(welcomePanel.new HostFindEverywhereResult((Host)it2));
                }
                return (List)destination$iv$iv2;
            }

            public String group() {
                return I18n.INSTANCE.getString("termora.find-everywhere.groups.open-new-hosts");
            }

            public int order() {
                return -2147483646;
            }
        });
        this.filterableHostTreeModel.addFilter(arg_0 -> WelcomePanel.initEvents$lambda$3(this, arg_0));
        this.searchTextField.getDocument().addDocumentListener(new DocumentAdaptor(this){
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String text = WelcomePanel.access$getSearchTextField$p(this.this$0).getText();
                WelcomePanel.access$getFilterableHostTreeModel$p(this.this$0).refresh();
                Intrinsics.checkNotNull((Object)text);
                if (!StringsKt.isBlank((CharSequence)text)) {
                    WelcomePanel.access$getHostTree$p(this.this$0).expandAll();
                }
            }
        });
        this.searchTextField.addKeyListener((KeyListener)new KeyAdapter(this){
            private final ActionEvent event;
            final /* synthetic */ WelcomePanel this$0;
            {
                this.this$0 = $receiver;
                this.event = new ActionEvent((Object)((Object)WelcomePanel.access$getHostTree$p($receiver)), 1001, "");
            }

            private final Action getOpenHostAction() {
                return ActionManager.getInstance().getAction((Object)"OpenHostAction");
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 40 || e.getKeyCode() == 10 || e.getKeyCode() == 38) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            Action action = WelcomePanel.access$getHostTree$p(this.this$0).getActionMap().get("selectPrevious");
                            if (action != null) {
                                action.actionPerformed(this.event);
                            }
                            break;
                        }
                        case 40: {
                            Action action = WelcomePanel.access$getHostTree$p(this.this$0).getActionMap().get("selectNext");
                            if (action != null) {
                                action.actionPerformed(this.event);
                            }
                            break;
                        }
                        default: {
                            for (HostTreeNode node : WelcomePanel.access$getHostTree$p(this.this$0).getSelectionSimpleTreeNodes(true)) {
                                Action action = this.getOpenHostAction();
                                if (action == null) continue;
                                action.actionPerformed(new OpenHostActionEvent((Object)((Object)WelcomePanel.access$getHostTree$p(this.this$0)), node.getHost(), (EventObject)e));
                            }
                        }
                    }
                    e.consume();
                }
            }
        });
    }

    private final void perform() {
        this.rootPanel.remove(this.bannerPanel);
        if (this.fullContent) {
            this.rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        } else {
            int top = Math.max((int)((double)this.getHeight() * 0.08), 30);
            int left = Math.max((int)((double)this.getWidth() * 0.25), 30);
            this.rootPanel.add((Component)this.bannerPanel, "North");
            this.rootPanel.setBorder(BorderFactory.createEmptyBorder(top, left, top / 2, left));
            SwingUtilities.invokeLater(() -> WelcomePanel.perform$lambda$4(this));
        }
    }

    @Override
    @NotNull
    public String getTitle() {
        return I18n.INSTANCE.getString("termora.title");
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return (Icon)((Object)Icons.INSTANCE.getHomeFolder());
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public boolean canReconnect() {
        return false;
    }

    @Override
    public boolean canClose() {
        return false;
    }

    @Override
    public boolean canClone() {
        return false;
    }

    @Override
    public void onLostFocus() {
        this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void onGrabFocus() {
        SwingUtilities.invokeLater(() -> WelcomePanel.onGrabFocus$lambda$5(this));
    }

    @Override
    public void dispose() {
        this.getProperties().putString("WelcomeFullContent", String.valueOf(this.fullContent));
        this.getProperties().putString("Welcome.HostTree.state", TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)this.hostTree)));
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.dataProviderSupport.getData(dataKey);
    }

    @Override
    public void reconnect() {
        TerminalTab.DefaultImpls.reconnect(this);
    }

    @Override
    public boolean willBeClose() {
        return TerminalTab.DefaultImpls.willBeClose(this);
    }

    @Override
    public void beforeClose() {
        TerminalTab.DefaultImpls.beforeClose(this);
    }

    private static final boolean filterableHostTreeModel$lambda$0(WelcomePanel this$0) {
        String string = this$0.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string);
    }

    private static final void createSearchPanel$lambda$1(ActionEvent e) {
        block0: {
            Action action = ActionManager.getInstance().getAction((Object)"NewHostAction");
            if (action == null) break block0;
            action.actionPerformed(e);
        }
    }

    private static final void createSearchPanel$lambda$2(WelcomePanel this$0, int $iconSize, Box $box, ActionEvent it) {
        this$0.fullContent = !this$0.fullContent;
        this$0.toggle.setIcon((Icon)new FlatSVGIcon(this$0.fullContent ? Icons.INSTANCE.getCollapseAll().getName() : Icons.INSTANCE.getCollapseAll().getName(), $iconSize, $iconSize));
        if (this$0.fullContent) {
            $box.setBorder(BorderFactory.createEmptyBorder());
        } else {
            $box.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        }
        this$0.perform();
    }

    private static final Boolean initEvents$lambda$3(WelcomePanel this$0, HostTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String text = this$0.searchTextField.getText();
        Host host = it.getHost();
        Intrinsics.checkNotNull((Object)text);
        return StringsKt.isBlank((CharSequence)text) || StringsKt.contains((CharSequence)host.getName(), (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)host.getHost(), (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)host.getUsername(), (CharSequence)text, (boolean)true);
    }

    private static final void perform$lambda$4(WelcomePanel this$0) {
        this$0.rootPanel.revalidate();
        this$0.rootPanel.repaint();
    }

    private static final void onGrabFocus$lambda$5(WelcomePanel this$0) {
        block0: {
            Component component = this$0.lastFocused;
            if (component == null) break block0;
            component.requestFocusInWindow();
        }
    }

    public static final /* synthetic */ FlatTextField access$getSearchTextField$p(WelcomePanel $this) {
        return $this.searchTextField;
    }

    public static final /* synthetic */ void access$perform(WelcomePanel $this) {
        $this.perform();
    }

    public static final /* synthetic */ NewHostTreeModel access$getHostTreeModel$p(WelcomePanel $this) {
        return $this.hostTreeModel;
    }

    public static final /* synthetic */ FilterableHostTreeModel access$getFilterableHostTreeModel$p(WelcomePanel $this) {
        return $this.filterableHostTreeModel;
    }

    public static final /* synthetic */ NewHostTree access$getHostTree$p(WelcomePanel $this) {
        return $this.hostTree;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lapp/termora/WelcomePanel$HostFindEverywhereResult;", "Lapp/termora/findeverywhere/FindEverywhereResult;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/WelcomePanel;Lapp/termora/Host;)V", "getHost", "()Lapp/termora/Host;", "showMoreInfo", "", "getShowMoreInfo", "()Z", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getText", "", "termora"})
    private final class HostFindEverywhereResult
    implements FindEverywhereResult {
        @NotNull
        private final Host host;

        public HostFindEverywhereResult(Host host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
        }

        @NotNull
        public final Host getHost() {
            return this.host;
        }

        private final boolean getShowMoreInfo() {
            return Boolean.parseBoolean(WelcomePanel.this.getProperties().getString("HostTree.showMoreInfo", "false"));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Action action = ActionManager.getInstance().getAction((Object)"OpenHostAction");
            if (action != null) {
                Object object = e.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
                action.actionPerformed(new OpenHostActionEvent(object, this.host, (EventObject)e));
            }
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            if (isSelected && !FlatLaf.isLafDark()) {
                return (Icon)((Object)Icons.INSTANCE.getTerminal().getDark());
            }
            return (Icon)((Object)Icons.INSTANCE.getTerminal());
        }

        @Override
        @NotNull
        public String getText(boolean isSelected) {
            if (this.getShowMoreInfo()) {
                String moreInfo;
                Color color = UIManager.getColor(isSelected ? "textHighlightText" : "textInactiveText");
                switch (WhenMappings.$EnumSwitchMapping$0[this.host.getProtocol().ordinal()]) {
                    case 1: {
                        Object object = this.host.getUsername() + "@" + this.host.getHost();
                        break;
                    }
                    case 2: {
                        Object object = this.host.getOptions().getSerialComm().getPort();
                        break;
                    }
                    default: {
                        Object object = moreInfo = "";
                    }
                }
                if (!StringsKt.isBlank((CharSequence)moreInfo)) {
                    return "<html>" + this.host.getName() + "&nbsp;&nbsp;&nbsp;&nbsp;<font color=rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")>" + moreInfo + "</font></html>";
                }
            }
            return this.host.getName();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Protocol.values().length];
                try {
                    nArray[Protocol.SSH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Protocol.Serial.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

