/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import java.io.Closeable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.commonmark.node.BulletList;
import org.commonmark.node.Heading;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.AttributeProviderContext;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lapp/termora/UpdaterManager;", "", "<init>", "()V", "lastVersion", "Lapp/termora/UpdaterManager$LatestVersion;", "getLastVersion", "()Lapp/termora/UpdaterManager$LatestVersion;", "setLastVersion", "(Lapp/termora/UpdaterManager$LatestVersion;)V", "fetchLatestVersion", "Companion", "Asset", "LatestVersion", "termora"})
@SourceDebugExtension(value={"SMAP\nUpdaterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdaterManager.kt\napp/termora/UpdaterManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n1563#3:150\n1634#3,3:151\n1563#3:154\n1634#3,3:155\n*S KotlinDebug\n*F\n+ 1 UpdaterManager.kt\napp/termora/UpdaterManager\n*L\n92#1:150\n92#1:151,3\n93#1:154\n93#1:155,3\n*E\n"})
public final class UpdaterManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LatestVersion lastVersion = LatestVersion.Companion.getSelf();
    private static final Logger log = LoggerFactory.getLogger(UpdaterManager.class);

    private UpdaterManager() {
    }

    @NotNull
    public final LatestVersion getLastVersion() {
        return this.lastVersion;
    }

    public final void setLastVersion(@NotNull LatestVersion latestVersion) {
        Intrinsics.checkNotNullParameter((Object)latestVersion, (String)"<set-?>");
        this.lastVersion = latestVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LatestVersion fetchLatestVersion() {
        try {
            JsonObject it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Response resp;
            Request request = new Request.Builder().get().url("https://api.github.com/repos/TermoraDev/termora/releases/latest").build();
            Response response = Application.INSTANCE.getHttpClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                if (log.isErrorEnabled()) {
                    log.error("Failed to fetch latest version, response was " + response.code());
                }
                return LatestVersion.Companion.getSelf();
            }
            Object object = (Closeable)response;
            Throwable throwable = null;
            try {
                Object object2;
                resp = (Response)object;
                boolean bl = false;
                ResponseBody responseBody = resp.body();
                if (responseBody != null) {
                    Closeable closeable = (Closeable)responseBody;
                    Throwable throwable2 = null;
                    try {
                        Object it2 = (ResponseBody)closeable;
                        boolean bl2 = false;
                        it2 = it2.string();
                        object2 = it2;
                    }
                    catch (Throwable bl2) {
                        throwable2 = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                } else {
                    object2 = null;
                }
                resp = object2;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Response text = resp;
            object = (CharSequence)text;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                return LatestVersion.Companion.getSelf();
            }
            JsonObject json = JsonElementKt.getJsonObject((JsonElement)Application.INSTANCE.getOhMyJson().parseToJsonElement((String)text));
            String version = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"tag_name"))).getContent();
            boolean prerelease = JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"prerelease"))));
            boolean draft = JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"draft"))));
            String name = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"name"))).getContent();
            Date createdDate = Date.from(Instant.parse(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"created_at"))).getContent()));
            Date publishedDate = Date.from(Instant.parse(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"published_at"))).getContent()));
            String body = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"body"))).getContent();
            Iterable $this$map$iv = (Iterable)JsonElementKt.getJsonArray((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)json), (Object)"assets")));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JsonElementKt.getJsonObject((JsonElement)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JsonObject)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Asset(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)it), (Object)"name"))).getContent(), JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)it), (Object)"url"))).getContent(), JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)it), (Object)"browser_download_url"))).getContent(), JsonElementKt.getLong((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)it), (Object)"size"))))));
            }
            List assets = (List)destination$iv$iv;
            Parser parser = Parser.builder().build();
            Node document = parser.parse("# \ud83c\udf89 " + ((Object)StringsKt.trim((CharSequence)name)).toString() + " (" + DateFormatUtils.format((Date)publishedDate, (String)"yyyy-MM-dd") + ") \n" + ((Object)StringsKt.trim((CharSequence)body)).toString());
            HtmlRenderer renderer = HtmlRenderer.builder().attributeProviderFactory(UpdaterManager::fetchLatestVersion$lambda$5).build();
            String string = renderer.render(document);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            String string2 = string;
            Intrinsics.checkNotNull((Object)createdDate);
            Date date = createdDate;
            Intrinsics.checkNotNull((Object)publishedDate);
            Date date2 = publishedDate;
            this.lastVersion = new LatestVersion(version, prerelease, draft, name, date, date2, body, string2, assets);
            return this.lastVersion;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed to get latest version", (Throwable)e);
            }
            return LatestVersion.Companion.getSelf();
        }
    }

    private static final void fetchLatestVersion$lambda$5$lambda$4(Node node, String string, Map attributes) {
        if (attributes != null) {
            if (node instanceof Heading) {
                attributes.put("style", "margin: 5px 0;");
            } else if (node instanceof BulletList) {
                attributes.put("style", "margin: 0 20px;");
            } else if (node instanceof Paragraph) {
                attributes.put("style", "margin: 0;");
            }
        }
    }

    private static final AttributeProvider fetchLatestVersion$lambda$5(AttributeProviderContext it) {
        return UpdaterManager::fetchLatestVersion$lambda$5$lambda$4;
    }

    public /* synthetic */ UpdaterManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lapp/termora/UpdaterManager$Asset;", "", "name", "", "url", "downloadUrl", "size", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getUrl", "getDownloadUrl", "getSize", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "termora"})
    public static final class Asset {
        @NotNull
        private final String name;
        @NotNull
        private final String url;
        @NotNull
        private final String downloadUrl;
        private final long size;

        public Asset(@NotNull String name, @NotNull String url, @NotNull String downloadUrl, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            this.name = name;
            this.url = url;
            this.downloadUrl = downloadUrl;
            this.size = size;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.downloadUrl;
        }

        public final long component4() {
            return this.size;
        }

        @NotNull
        public final Asset copy(@NotNull String name, @NotNull String url, @NotNull String downloadUrl, long size) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            return new Asset(name, url, downloadUrl, size);
        }

        public static /* synthetic */ Asset copy$default(Asset asset, String string, String string2, String string3, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = asset.name;
            }
            if ((n & 2) != 0) {
                string2 = asset.url;
            }
            if ((n & 4) != 0) {
                string3 = asset.downloadUrl;
            }
            if ((n & 8) != 0) {
                l = asset.size;
            }
            return asset.copy(string, string2, string3, l);
        }

        @NotNull
        public String toString() {
            return "Asset(name=" + this.name + ", url=" + this.url + ", downloadUrl=" + this.downloadUrl + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.downloadUrl.hashCode();
            result = result * 31 + Long.hashCode(this.size);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Asset)) {
                return false;
            }
            Asset asset = (Asset)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)asset.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)asset.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.downloadUrl, (Object)asset.downloadUrl)) {
                return false;
            }
            return this.size == asset.size;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/UpdaterManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/UpdaterManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UpdaterManager getInstance() {
            return (UpdaterManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(UpdaterManager.class), Companion::getInstance$lambda$0);
        }

        private static final UpdaterManager getInstance$lambda$0() {
            return new UpdaterManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003Ji\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015\u00a8\u00060"}, d2={"Lapp/termora/UpdaterManager$LatestVersion;", "", "version", "", "prerelease", "", "draft", "name", "createdDate", "Ljava/util/Date;", "publishedDate", "body", "htmlBody", "assets", "", "Lapp/termora/UpdaterManager$Asset;", "<init>", "(Ljava/lang/String;ZZLjava/lang/String;Ljava/util/Date;Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getVersion", "()Ljava/lang/String;", "getPrerelease", "()Z", "getDraft", "getName", "getCreatedDate", "()Ljava/util/Date;", "getPublishedDate", "getBody", "getHtmlBody", "getAssets", "()Ljava/util/List;", "isSelf", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "termora"})
    public static final class LatestVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String version;
        private final boolean prerelease;
        private final boolean draft;
        @NotNull
        private final String name;
        @NotNull
        private final Date createdDate;
        @NotNull
        private final Date publishedDate;
        @NotNull
        private final String body;
        @NotNull
        private final String htmlBody;
        @NotNull
        private final List<Asset> assets;
        @NotNull
        private static final LatestVersion self = new LatestVersion(Application.INSTANCE.getVersion(), false, false, "", new Date(), new Date(), "", "", CollectionsKt.emptyList());

        public LatestVersion(@NotNull String version, boolean prerelease, boolean draft, @NotNull String name, @NotNull Date createdDate, @NotNull Date publishedDate, @NotNull String body, @NotNull String htmlBody, @NotNull List<Asset> assets) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
            Intrinsics.checkNotNullParameter((Object)publishedDate, (String)"publishedDate");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)htmlBody, (String)"htmlBody");
            Intrinsics.checkNotNullParameter(assets, (String)"assets");
            this.version = version;
            this.prerelease = prerelease;
            this.draft = draft;
            this.name = name;
            this.createdDate = createdDate;
            this.publishedDate = publishedDate;
            this.body = body;
            this.htmlBody = htmlBody;
            this.assets = assets;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public final boolean getPrerelease() {
            return this.prerelease;
        }

        public final boolean getDraft() {
            return this.draft;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Date getCreatedDate() {
            return this.createdDate;
        }

        @NotNull
        public final Date getPublishedDate() {
            return this.publishedDate;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final String getHtmlBody() {
            return this.htmlBody;
        }

        @NotNull
        public final List<Asset> getAssets() {
            return this.assets;
        }

        public final boolean isSelf() {
            return Intrinsics.areEqual((Object)this, (Object)self);
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        public final boolean component2() {
            return this.prerelease;
        }

        public final boolean component3() {
            return this.draft;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final Date component5() {
            return this.createdDate;
        }

        @NotNull
        public final Date component6() {
            return this.publishedDate;
        }

        @NotNull
        public final String component7() {
            return this.body;
        }

        @NotNull
        public final String component8() {
            return this.htmlBody;
        }

        @NotNull
        public final List<Asset> component9() {
            return this.assets;
        }

        @NotNull
        public final LatestVersion copy(@NotNull String version, boolean prerelease, boolean draft, @NotNull String name, @NotNull Date createdDate, @NotNull Date publishedDate, @NotNull String body, @NotNull String htmlBody, @NotNull List<Asset> assets) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)createdDate, (String)"createdDate");
            Intrinsics.checkNotNullParameter((Object)publishedDate, (String)"publishedDate");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)htmlBody, (String)"htmlBody");
            Intrinsics.checkNotNullParameter(assets, (String)"assets");
            return new LatestVersion(version, prerelease, draft, name, createdDate, publishedDate, body, htmlBody, assets);
        }

        public static /* synthetic */ LatestVersion copy$default(LatestVersion latestVersion, String string, boolean bl, boolean bl2, String string2, Date date, Date date2, String string3, String string4, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = latestVersion.version;
            }
            if ((n & 2) != 0) {
                bl = latestVersion.prerelease;
            }
            if ((n & 4) != 0) {
                bl2 = latestVersion.draft;
            }
            if ((n & 8) != 0) {
                string2 = latestVersion.name;
            }
            if ((n & 0x10) != 0) {
                date = latestVersion.createdDate;
            }
            if ((n & 0x20) != 0) {
                date2 = latestVersion.publishedDate;
            }
            if ((n & 0x40) != 0) {
                string3 = latestVersion.body;
            }
            if ((n & 0x80) != 0) {
                string4 = latestVersion.htmlBody;
            }
            if ((n & 0x100) != 0) {
                list = latestVersion.assets;
            }
            return latestVersion.copy(string, bl, bl2, string2, date, date2, string3, string4, list);
        }

        @NotNull
        public String toString() {
            return "LatestVersion(version=" + this.version + ", prerelease=" + this.prerelease + ", draft=" + this.draft + ", name=" + this.name + ", createdDate=" + this.createdDate + ", publishedDate=" + this.publishedDate + ", body=" + this.body + ", htmlBody=" + this.htmlBody + ", assets=" + this.assets + ")";
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + Boolean.hashCode(this.prerelease);
            result = result * 31 + Boolean.hashCode(this.draft);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.createdDate.hashCode();
            result = result * 31 + this.publishedDate.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + this.htmlBody.hashCode();
            result = result * 31 + ((Object)this.assets).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatestVersion)) {
                return false;
            }
            LatestVersion latestVersion = (LatestVersion)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)latestVersion.version)) {
                return false;
            }
            if (this.prerelease != latestVersion.prerelease) {
                return false;
            }
            if (this.draft != latestVersion.draft) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)latestVersion.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createdDate, (Object)latestVersion.createdDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publishedDate, (Object)latestVersion.publishedDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)latestVersion.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.htmlBody, (Object)latestVersion.htmlBody)) {
                return false;
            }
            return Intrinsics.areEqual(this.assets, latestVersion.assets);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/UpdaterManager$LatestVersion$Companion;", "", "<init>", "()V", "self", "Lapp/termora/UpdaterManager$LatestVersion;", "getSelf", "()Lapp/termora/UpdaterManager$LatestVersion;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LatestVersion getSelf() {
                return self;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

