/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.Database;
import app.termora.DynamicIcon;
import app.termora.Icons;
import app.termora.SwingUtils;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import app.termora.ToolBarAction;
import app.termora.WindowScope;
import app.termora.actions.ActionManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.MultipleAction;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u00060\tR\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u000f\u001a\u00060\u0010R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lapp/termora/TermoraToolBar;", "", "windowScope", "Lapp/termora/WindowScope;", "frame", "Lapp/termora/TermoraFrame;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/TermoraFrame;)V", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "properties$delegate", "Lkotlin/Lazy;", "toolbar", "Lapp/termora/TermoraToolBar$MyToolBar;", "getToolbar", "()Lapp/termora/TermoraToolBar$MyToolBar;", "toolbar$delegate", "getJToolBar", "Ljavax/swing/JToolBar;", "getAllActions", "", "Lapp/termora/ToolBarAction;", "getActions", "Companion", "MyToolBar", "termora"})
@SourceDebugExtension(value={"SMAP\nTermoraToolBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermoraToolBar.kt\napp/termora/TermoraToolBar\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n222#2:192\n2746#3,3:193\n2746#3,3:197\n1#4:196\n*S KotlinDebug\n*F\n+ 1 TermoraToolBar.kt\napp/termora/TermoraToolBar\n*L\n84#1:192\n89#1:193,3\n95#1:197,3\n*E\n"})
public final class TermoraToolBar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WindowScope windowScope;
    @NotNull
    private final TermoraFrame frame;
    @NotNull
    private final Lazy properties$delegate;
    @NotNull
    private final Lazy toolbar$delegate;

    public TermoraToolBar(@NotNull WindowScope windowScope, @NotNull TermoraFrame frame) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.windowScope = windowScope;
        this.frame = frame;
        this.properties$delegate = LazyKt.lazy(TermoraToolBar::properties_delegate$lambda$0);
        this.toolbar$delegate = LazyKt.lazy(() -> TermoraToolBar.toolbar_delegate$lambda$2(this));
    }

    private final Database.Properties getProperties() {
        Lazy lazy = this.properties$delegate;
        return (Database.Properties)lazy.getValue();
    }

    private final MyToolBar getToolbar() {
        Lazy lazy = this.toolbar$delegate;
        return (MyToolBar)lazy.getValue();
    }

    @NotNull
    public final JToolBar getJToolBar() {
        return this.getToolbar();
    }

    @NotNull
    public final List<ToolBarAction> getAllActions() {
        Object[] objectArray = new ToolBarAction[]{new ToolBarAction("SnippetAction", true), new ToolBarAction("SFTPAction", true), new ToolBarAction("TerminalLogAction", true), new ToolBarAction("MacroAction", true), new ToolBarAction("KeywordHighlightAction", true), new ToolBarAction("KeyManagerAction", true), new ToolBarAction("MultipleAction", true), new ToolBarAction("FindEverywhereAction", true), new ToolBarAction("SettingAction", true)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<ToolBarAction> getActions() {
        Object $this$getActions_u24lambda_u243;
        String text = this.getProperties().getString("Termora.ToolBar.Actions", "");
        List<ToolBarAction> actions = this.getAllActions();
        if (StringsKt.isBlank((CharSequence)text)) {
            return actions;
        }
        Json json = Application.INSTANCE.getOhMyJson();
        try {
            $this$getActions_u24lambda_u243 = json;
            boolean bl = false;
            Json this_$iv = Application.INSTANCE.getOhMyJson();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            $this$getActions_u24lambda_u243 = Result.constructor-impl((Object)((List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(ToolBarAction.Companion.serializer()), text)));
        }
        catch (Throwable bl) {
            $this$getActions_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        json = $this$getActions_u24lambda_u243;
        List list = (List)(Result.isFailure-impl((Object)json) ? null : json);
        if (list == null) {
            return actions;
        }
        List storageActions = CollectionsKt.toMutableList((Collection)list);
        for (ToolBarAction action : actions) {
            boolean bl;
            block8: {
                Iterable $this$none$iv = storageActions;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ToolBarAction it = (ToolBarAction)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)action.getId())) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            storageActions.addFirst(new ToolBarAction(action.getId(), true));
        }
        storageActions.removeIf(arg_0 -> TermoraToolBar.getActions$lambda$7(arg_0 -> TermoraToolBar.getActions$lambda$6(actions, arg_0), arg_0));
        return storageActions;
    }

    private static final Database.Properties properties_delegate$lambda$0() {
        return Database.Companion.getDatabase().getProperties();
    }

    private static final MyToolBar toolbar_delegate$lambda$2(TermoraToolBar this$0) {
        MyToolBar myToolBar;
        MyToolBar $this$toolbar_delegate_u24lambda_u242_u24lambda_u241 = myToolBar = this$0.new MyToolBar();
        boolean bl = false;
        $this$toolbar_delegate_u24lambda_u242_u24lambda_u241.rebuild();
        return myToolBar;
    }

    private static final boolean getActions$lambda$6(List $actions, ToolBarAction e) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Iterable $this$none$iv = $actions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ToolBarAction it = (ToolBarAction)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)e.getId(), (Object)it.getId())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean getActions$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/TermoraToolBar$Companion;", "", "<init>", "()V", "rebuild", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public final void rebuild() {
            for (TermoraFrame frame : TermoraFrameManager.Companion.getInstance().getWindows()) {
                List<MyToolBar> toolbars = SwingUtils.getDescendantsOfClass(MyToolBar.class, frame);
                for (MyToolBar toolbar : toolbars) {
                    toolbar.rebuild();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/TermoraToolBar$MyToolBar;", "Ljavax/swing/JToolBar;", "<init>", "(Lapp/termora/TermoraToolBar;)V", "adjust", "", "rebuild", "termora"})
    private final class MyToolBar
    extends JToolBar {
        public MyToolBar() {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.adjust();
                }
            });
        }

        public final void adjust() {
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                Object object = TermoraToolBar.this.frame.getRootPane().getClientProperty("FlatLaf.fullWindowContent.buttonsBounds");
                Rectangle rectangle = object instanceof Rectangle ? (Rectangle)object : null;
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = rectangle;
                int right = rectangle2.width;
                MyToolBar toolbar = this;
                int n = toolbar.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component c2 = toolbar.getComponent(i);
                    if (!Intrinsics.areEqual((Object)c2.getName(), (Object)"spacing")) continue;
                    if (c2.getWidth() == right) {
                        return;
                    }
                    toolbar.remove(i);
                    break;
                }
                if (right > 0) {
                    Component spacing = Box.createHorizontalStrut(right);
                    spacing.setName("spacing");
                    toolbar.add(spacing);
                }
            }
        }

        public final void rebuild() {
            JToolBar toolbar = this;
            ActionManager actionManager = ActionManager.Companion.getInstance();
            ActionContainerFactory actionContainerFactory = new ActionContainerFactory((ActionMap)((Object)actionManager));
            toolbar.removeAll();
            DynamicIcon dynamicIcon = Icons.INSTANCE.getAdd();
            toolbar.add(actionContainerFactory.createButton((Action)((Object)new AnAction(actionManager, dynamicIcon){
                final /* synthetic */ ActionManager $actionManager;
                {
                    this.$actionManager = $actionManager;
                    super("", (Icon)((Object)$super_call_param$1));
                }

                protected void actionPerformed(AnActionEvent evt) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        Action action = this.$actionManager.getAction("FindEverywhereAction");
                        if (action == null) break block0;
                        action.actionPerformed(evt);
                    }
                }

                public boolean isEnabled() {
                    Action action = this.$actionManager.getAction("FindEverywhereAction");
                    return action != null ? action.isEnabled() : false;
                }
            })));
            toolbar.add(Box.createHorizontalGlue());
            if (SystemInfo.isLinux || SystemInfo.isWindows) {
                toolbar.add(Box.createHorizontalStrut(16));
            }
            AbstractButton updateBtn = actionContainerFactory.createButton(actionManager.getAction("AppUpdateAction"));
            updateBtn.setVisible(updateBtn.isEnabled());
            updateBtn.addChangeListener(arg_0 -> MyToolBar.rebuild$lambda$0(updateBtn, arg_0));
            toolbar.add(updateBtn);
            for (ToolBarAction action : TermoraToolBar.this.getActions()) {
                if (!action.getVisible()) continue;
                Action ac = actionManager.getAction(action.getId());
                if (ac == null) {
                    if (!Intrinsics.areEqual((Object)action.getId(), (Object)"MultipleAction")) continue;
                    toolbar.add(actionContainerFactory.createButton((Action)((Object)MultipleAction.Companion.getInstance(TermoraToolBar.this.windowScope))));
                    continue;
                }
                toolbar.add(actionContainerFactory.createButton(ac));
            }
            if (toolbar instanceof MyToolBar) {
                ((MyToolBar)toolbar).adjust();
            }
            toolbar.revalidate();
            toolbar.repaint();
        }

        private static final void rebuild$lambda$0(AbstractButton $updateBtn, ChangeEvent it) {
            $updateBtn.setVisible($updateBtn.isEnabled());
        }
    }
}

