/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import com.formdev.flatlaf.util.SystemInfo;
import com.github.hstyi.restart4j.Restarter;
import java.awt.Component;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J \u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018J\u0016\u0010\u001c\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001b\u0010\t\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\bR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lapp/termora/TermoraRestarter;", "", "<init>", "()V", "restarting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSupported", "", "()Z", "isLinuxAppImage", "isLinuxAppImage$delegate", "Lkotlin/Lazy;", "startupCommand", "", "getStartupCommand", "()Ljava/lang/String;", "startupCommand$delegate", "macOSApplicationPath", "kotlin.jvm.PlatformType", "getMacOSApplicationPath", "macOSApplicationPath$delegate", "restart", "", "commands", "", "scheduleRestart", "owner", "Ljava/awt/Component;", "doRestart", "checkIsSupported", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nTermoraRestarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermoraRestarter.kt\napp/termora/TermoraRestarter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,155:1\n37#2:156\n36#2,3:157\n*S KotlinDebug\n*F\n+ 1 TermoraRestarter.kt\napp/termora/TermoraRestarter\n*L\n113#1:156\n113#1:157,3\n*E\n"})
public final class TermoraRestarter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean restarting = new AtomicBoolean(false);
    @NotNull
    private final Lazy isLinuxAppImage$delegate = LazyKt.lazy(TermoraRestarter::isLinuxAppImage_delegate$lambda$0);
    @NotNull
    private final Lazy startupCommand$delegate = LazyKt.lazy(TermoraRestarter::startupCommand_delegate$lambda$1);
    @NotNull
    private final Lazy macOSApplicationPath$delegate = LazyKt.lazy(TermoraRestarter::macOSApplicationPath_delegate$lambda$2);
    private static final Logger log = LoggerFactory.getLogger(TermoraRestarter.class);

    private final boolean isSupported() {
        return !this.restarting.get() && this.checkIsSupported();
    }

    private final boolean isLinuxAppImage() {
        Lazy lazy = this.isLinuxAppImage$delegate;
        return (Boolean)lazy.getValue();
    }

    private final String getStartupCommand() {
        Lazy lazy = this.startupCommand$delegate;
        return (String)lazy.getValue();
    }

    private final String getMacOSApplicationPath() {
        Lazy lazy = this.macOSApplicationPath$delegate;
        return (String)lazy.getValue();
    }

    private final void restart(List<String> commands) {
        if (!this.isSupported()) {
            return;
        }
        if (!this.restarting.compareAndSet(false, true)) {
            return;
        }
        SwingUtilities.invokeLater(() -> TermoraRestarter.restart$lambda$3(this, commands));
    }

    public final void scheduleRestart(@Nullable Component owner, @NotNull List<String> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        if (this.isSupported()) {
            OptionPane optionPane = OptionPane.INSTANCE;
            String string = I18n.INSTANCE.getString("termora.settings.restart.message");
            String string2 = I18n.INSTANCE.getString("termora.settings.restart.title");
            Object object = new Object[]{I18n.INSTANCE.getString("termora.settings.restart.title"), I18n.INSTANCE.getString("termora.cancel")};
            Object[] objectArray = object;
            if (OptionPane.showConfirmDialog$default(optionPane, owner, string, string2, 0, 3, null, objectArray, object = I18n.INSTANCE.getString("termora.settings.restart.title"), null, 288, null) == 0) {
                this.restart(commands);
            }
        } else {
            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, owner, I18n.INSTANCE.getString("termora.settings.restart.message"), I18n.INSTANCE.getString("termora.settings.restart.title"), 1, 0L, 16, null);
        }
    }

    public static /* synthetic */ void scheduleRestart$default(TermoraRestarter termoraRestarter, Component component, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        termoraRestarter.scheduleRestart(component, list);
    }

    private final void doRestart(List<String> commands) {
        if (commands.isEmpty()) {
            if (SystemInfo.isMacOS) {
                var2_2 = new String[]{"open", "-n", this.getMacOSApplicationPath()};
                Restarter.restart((String[])var2_2);
            } else if (SystemInfo.isWindows && this.getStartupCommand() != null) {
                var2_2 = new String[]{this.getStartupCommand()};
                Restarter.restart((String[])var2_2);
            } else if (SystemInfo.isLinux) {
                if (this.isLinuxAppImage()) {
                    var2_2 = new String[]{System.getenv("APPIMAGE")};
                    Restarter.restart((String[])var2_2);
                } else if (this.getStartupCommand() != null) {
                    var2_2 = new String[]{this.getStartupCommand()};
                    Restarter.restart((String[])var2_2);
                }
            }
        } else {
            Collection $this$toTypedArray$iv = commands;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Restarter.restart((String[])thisCollection$iv.toArray(new String[0]));
        }
        for (TermoraFrame window : TermoraFrameManager.Companion.getInstance().getWindows()) {
            window.dispose();
        }
    }

    private final boolean checkIsSupported() {
        String appPath = Application.INSTANCE.getAppPath();
        if (StringsKt.isBlank((CharSequence)appPath) || Application.INSTANCE.isUnknownVersion()) {
            if (log.isWarnEnabled()) {
                log.warn("Restart not supported");
            }
            return false;
        }
        if (SystemInfo.isWindows && this.getStartupCommand() == null) {
            if (log.isWarnEnabled()) {
                log.warn("Restart not supported , ProcessHandle#info#command is null.");
            }
            return false;
        }
        if (SystemInfo.isLinux) {
            if (this.isLinuxAppImage()) {
                String[] stringArray;
                String appImage;
                String string = System.getenv("APPIMAGE");
                if (string == null) {
                    string = "";
                }
                return !StringsKt.isBlank((CharSequence)(appImage = string)) && FileUtils.getFile((String[])(stringArray = new String[]{appImage})).exists();
            }
            return this.getStartupCommand() != null;
        }
        if (SystemInfo.isMacOS) {
            return !StringsKt.isBlank((CharSequence)Application.INSTANCE.getAppPath());
        }
        return true;
    }

    private static final boolean isLinuxAppImage_delegate$lambda$0() {
        String string = System.getenv("LinuxAppImage");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private static final String startupCommand_delegate$lambda$1() {
        Optional<String> optional = ProcessHandle.current().info().command();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"command(...)");
        return (String)OptionalsKt.getOrNull(optional);
    }

    private static final String macOSApplicationPath_delegate$lambda$2() {
        return StringUtils.removeEndIgnoreCase((String)Application.INSTANCE.getAppPath(), (String)"/Contents/MacOS/Termora");
    }

    private static final void restart$lambda$3(TermoraRestarter this$0, List $commands) {
        block2: {
            try {
                this$0.doRestart($commands);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final Integer _init_$lambda$4() {
        return (int)ProcessHandle.current().pid();
    }

    private static final void _init_$lambda$5(List commands) {
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (SystemInfo.isLinux) {
            pb.environment().remove("LD_LIBRARY_PATH");
        }
        pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        pb.redirectError(ProcessBuilder.Redirect.DISCARD);
        pb.directory(Paths.get(System.getProperty("user.home"), new String[0]).toFile());
        pb.start();
    }

    static {
        Restarter.setProcessHandler(TermoraRestarter::_init_$lambda$4);
        Restarter.setExecCommandsHandler(TermoraRestarter::_init_$lambda$5);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/TermoraRestarter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/TermoraRestarter;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TermoraRestarter getInstance() {
            return (TermoraRestarter)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(TermoraRestarter.class), Companion::getInstance$lambda$0);
        }

        private static final TermoraRestarter getInstance$lambda$0() {
            return new TermoraRestarter();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

