/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.ApplicationScope;
import app.termora.BackgroundManager;
import app.termora.Database;
import app.termora.Disposer;
import app.termora.MyTabbedPane;
import app.termora.NotifyListener;
import app.termora.TerminalTabbed;
import app.termora.TerminalTabbedManager;
import app.termora.TermoraToolBar;
import app.termora.WelcomePanel;
import app.termora.WindowScope;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.sftp.SFTPTab;
import app.termora.terminal.DataKey;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatRootPaneUI;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.util.SystemInfo;
import com.jetbrains.JBR;
import com.jetbrains.WindowDecorations;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J'\u0010\u001f\u001a\u0004\u0018\u0001H \"\b\b\u0000\u0010 *\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#H\u0016\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001aJ\b\u0010-\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00060\u0014R\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006/"}, d2={"Lapp/termora/TermoraFrame;", "Ljavax/swing/JFrame;", "Lapp/termora/actions/DataProvider;", "<init>", "()V", "id", "", "windowScope", "Lapp/termora/WindowScope;", "tabbedPane", "Lapp/termora/MyTabbedPane;", "toolbar", "Lapp/termora/TermoraToolBar;", "terminalTabbed", "Lapp/termora/TerminalTabbed;", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "welcomePanel", "Lapp/termora/WelcomePanel;", "sftp", "Lapp/termora/Database$SFTP;", "Lapp/termora/Database;", "getSftp", "()Lapp/termora/Database$SFTP;", "notifyListeners", "", "Lapp/termora/NotifyListener;", "[Lapp/termora/NotifyListener;", "initEvents", "", "initView", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "addNotifyListener", "listener", "removeNotifyListener", "addNotify", "GlassPane", "termora"})
@SourceDebugExtension(value={"SMAP\nTermoraFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermoraFrame.kt\napp/termora/TermoraFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,283:1\n1617#2,9:284\n1869#2:293\n1870#2:296\n1626#2:297\n1#3:294\n1#3:295\n13472#4,2:298\n*S KotlinDebug\n*F\n+ 1 TermoraFrame.kt\napp/termora/TermoraFrame\n*L\n198#1:284,9\n198#1:293\n198#1:296\n198#1:297\n198#1:295\n258#1:298,2\n*E\n"})
public final class TermoraFrame
extends JFrame
implements DataProvider {
    @NotNull
    private final String id;
    @NotNull
    private final WindowScope windowScope;
    @NotNull
    private final MyTabbedPane tabbedPane;
    @NotNull
    private final TermoraToolBar toolbar;
    @NotNull
    private final TerminalTabbed terminalTabbed;
    @NotNull
    private final DataProviderSupport dataProviderSupport;
    @NotNull
    private final WelcomePanel welcomePanel;
    @NotNull
    private NotifyListener[] notifyListeners;

    public TermoraFrame() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.windowScope = ApplicationScope.Companion.forWindowScope(this);
        this.tabbedPane = new MyTabbedPane();
        this.toolbar = new TermoraToolBar(this.windowScope, this);
        this.terminalTabbed = new TerminalTabbed(this.windowScope, this.toolbar, this.tabbedPane);
        this.dataProviderSupport = new DataProviderSupport();
        this.welcomePanel = new WelcomePanel(this.windowScope);
        this.notifyListeners = new NotifyListener[0];
        this.initView();
        this.initEvents();
    }

    private final Database.SFTP getSftp() {
        return Database.Companion.getDatabase().getSftp();
    }

    private final void initEvents() {
        if (SystemInfo.isLinux) {
            MouseAdapter mouseAdapter2 = new MouseAdapter(this){
                final /* synthetic */ TermoraFrame this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(MouseEvent e) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        MouseListener mouseListener = this.getMouseHandler();
                        if (mouseListener == null) break block0;
                        mouseListener.mouseClicked(e);
                    }
                }

                public void mousePressed(MouseEvent e) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        MouseListener mouseListener = this.getMouseHandler();
                        if (mouseListener == null) break block0;
                        mouseListener.mousePressed(e);
                    }
                }

                public void mouseDragged(MouseEvent e) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        MouseMotionListener mouseMotionListener = this.getMouseMotionListener();
                        if (mouseMotionListener == null) break block0;
                        mouseMotionListener.mouseDragged(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                    }
                }

                private final MouseListener getMouseHandler() {
                    Object object = this.getHandler();
                    return object instanceof MouseListener ? (MouseListener)object : null;
                }

                private final MouseMotionListener getMouseMotionListener() {
                    Object object = this.getHandler();
                    return object instanceof MouseMotionListener ? (MouseMotionListener)object : null;
                }

                private final Object getHandler() {
                    FlatTitlePane flatTitlePane = this.getTitlePane();
                    if (flatTitlePane == null) {
                        return null;
                    }
                    FlatTitlePane titlePane = flatTitlePane;
                    Field field = titlePane.getClass().getDeclaredField("handler");
                    if (field == null) {
                        return null;
                    }
                    Field handlerField = field;
                    handlerField.setAccessible(true);
                    return handlerField.get(titlePane);
                }

                private final FlatTitlePane getTitlePane() {
                    Object object = TermoraFrame.access$getRootPane$p$s1897599419(this.this$0).getUI();
                    FlatRootPaneUI flatRootPaneUI = object instanceof FlatRootPaneUI ? (FlatRootPaneUI)object : null;
                    if (flatRootPaneUI == null) {
                        return null;
                    }
                    FlatRootPaneUI ui = flatRootPaneUI;
                    Field titlePaneField = ui.getClass().getDeclaredField("titlePane");
                    titlePaneField.setAccessible(true);
                    object = titlePaneField.get(ui);
                    return object instanceof FlatTitlePane ? (FlatTitlePane)object : null;
                }
            };
            this.toolbar.getJToolBar().addMouseListener(mouseAdapter2);
            this.toolbar.getJToolBar().addMouseMotionListener(mouseAdapter2);
        }
        if (SystemInfo.isMacOS && JBR.isWindowDecorationsSupported()) {
            int height = UIManager.getInt("TabbedPane.tabHeight") + this.tabbedPane.getTabAreaInsets().top;
            WindowDecorations.CustomTitleBar customTitleBar = JBR.getWindowDecorations().createCustomTitleBar();
            customTitleBar.setHeight((float)height);
            MouseAdapter mouseAdapter3 = new MouseAdapter(this, customTitleBar){
                final /* synthetic */ TermoraFrame this$0;
                final /* synthetic */ WindowDecorations.CustomTitleBar $customTitleBar;
                {
                    this.this$0 = $receiver;
                    this.$customTitleBar = $customTitleBar;
                }

                private final void hit(MouseEvent e) {
                    int index;
                    if (Intrinsics.areEqual((Object)e.getSource(), (Object)((Object)TermoraFrame.access$getTabbedPane$p(this.this$0))) && (index = TermoraFrame.access$getTabbedPane$p(this.this$0).indexAtLocation(e.getX(), e.getY())) >= 0) {
                        return;
                    }
                    this.$customTitleBar.forceHitTest(false);
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }

                public void mousePressed(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }

                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }

                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }

                public void mouseDragged(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }

                public void mouseMoved(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.hit(e);
                }
            };
            this.terminalTabbed.addMouseListener(mouseAdapter3);
            this.terminalTabbed.addMouseMotionListener(mouseAdapter3);
            this.tabbedPane.addMouseListener(mouseAdapter3);
            this.tabbedPane.addMouseMotionListener(mouseAdapter3);
            this.toolbar.getJToolBar().addMouseListener(mouseAdapter3);
            this.toolbar.getJToolBar().addMouseMotionListener(mouseAdapter3);
            JBR.getWindowDecorations().setCustomTitleBar((Frame)this, customTitleBar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void initView() {
        if (SystemInfo.isMacOS) {
            this.tabbedPane.setTabAreaInsets(new Insets(0, 76, 0, 0));
        } else if (SystemInfo.isWindows) {
            this.tabbedPane.setTabAreaInsets(new Insets(SystemInfo.isWindows_11_orLater ? 1 : 2, 2, 0, 0));
        } else if (SystemInfo.isLinux) {
            this.tabbedPane.setTabAreaInsets(new Insets(1, 2, 0, 0));
        }
        int height = UIManager.getInt("TabbedPane.tabHeight") + this.tabbedPane.getTabAreaInsets().top;
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            this.rootPane.putClientProperty("FlatLaf.fullWindowContent", true);
            this.rootPane.putClientProperty("JRootPane.titleBarShowIcon", false);
            this.rootPane.putClientProperty("JRootPane.titleBarShowTitle", false);
            this.rootPane.putClientProperty("JRootPane.titleBarHeight", height);
        } else if (SystemInfo.isMacOS) {
            this.rootPane.putClientProperty("apple.awt.windowTitleVisible", false);
            this.rootPane.putClientProperty("apple.awt.fullWindowContent", true);
            this.rootPane.putClientProperty("apple.awt.transparentTitleBar", true);
            this.rootPane.putClientProperty("FlatLaf.macOS.windowButtonsSpacing", "medium");
        }
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            void $this$mapNotNullTo$iv$iv;
            Object[] objectArray = new Integer[]{16, 20, 24, 28, 32, 48, 64};
            List sizes = CollectionsKt.listOf((Object[])objectArray);
            ClassLoader loader = TermoraFrame.class.getClassLoader();
            Iterable $this$mapNotNull$iv = sizes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BufferedImage bufferedImage;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                int e = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                InputStream inputStream = loader.getResourceAsStream("icons/termora_" + e + "x" + e + ".png");
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        BufferedImage bufferedImage2 = ImageIO.read(it);
                        bufferedImage = bufferedImage2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    bufferedImage = null;
                }
                if (bufferedImage == null) continue;
                BufferedImage it$iv$iv = bufferedImage;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List images = (List)destination$iv$iv;
            this.setIconImages(images);
        }
        this.setMinimumSize(new Dimension(640, 400));
        TerminalTabbedManager.DefaultImpls.addTerminalTab$default(this.terminalTabbed, this.welcomePanel, false, 2, null);
        if (this.getSftp().getPinTab()) {
            SwingUtilities.invokeLater(() -> TermoraFrame.initView$lambda$2(this));
        }
        GlassPane glassPane = new GlassPane();
        this.rootPane.setGlassPane(glassPane);
        glassPane.setOpaque(false);
        glassPane.setVisible(true);
        Disposer.register(this.windowScope, this.terminalTabbed);
        this.add((Component)this.terminalTabbed, "Center");
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTabbedPane(), this.tabbedPane);
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTermoraFrame(), this);
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getWindowScope(), this.windowScope);
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        T t = this.dataProviderSupport.getData(dataKey);
        if (t == null && (t = this.terminalTabbed.getData(dataKey)) == null) {
            t = this.welcomePanel.getData(dataKey);
        }
        return t;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type app.termora.TermoraFrame");
        TermoraFrame cfr_ignored_0 = (TermoraFrame)other;
        return Intrinsics.areEqual((Object)this.id, (Object)((TermoraFrame)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public final void addNotifyListener(@NotNull NotifyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.notifyListeners = (NotifyListener[])ArraysKt.plus((Object[])this.notifyListeners, (Object)listener2);
    }

    public final void removeNotifyListener(@NotNull NotifyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object[] objectArray = new NotifyListener[]{listener2};
        Object[] objectArray2 = ArrayUtils.removeElements((Object[])this.notifyListeners, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"removeElements(...)");
        this.notifyListeners = (NotifyListener[])objectArray2;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NotifyListener[] $this$forEach$iv = this.notifyListeners;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            NotifyListener element$iv;
            NotifyListener it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.addNotify();
        }
    }

    private static final void initView$lambda$2(TermoraFrame this$0) {
        this$0.terminalTabbed.addTerminalTab(new SFTPTab(), false);
    }

    public static final /* synthetic */ JRootPane access$getRootPane$p$s1897599419(TermoraFrame $this) {
        return $this.rootPane;
    }

    public static final /* synthetic */ MyTabbedPane access$getTabbedPane$p(TermoraFrame $this) {
        return $this.tabbedPane;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/TermoraFrame$GlassPane;", "Ljavax/swing/JComponent;", "<init>", "()V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "contains", "", "x", "", "y", "termora"})
    private static final class GlassPane
    extends JComponent {
        public GlassPane() {
            this.setFocusable(false);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            BufferedImage bufferedImage = BackgroundManager.Companion.getInstance().getBackgroundImage();
            if (bufferedImage == null) {
                return;
            }
            BufferedImage img = bufferedImage;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setComposite(AlphaComposite.getInstance(3, FlatLaf.isLafDark() ? 0.2f : 0.1f));
            g2d.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), null);
            g2d.setComposite(AlphaComposite.getInstance(3));
        }

        @Override
        public boolean contains(int x, int y) {
            return false;
        }
    }
}

