/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.CustomizeToolBarDialog;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicIcon;
import app.termora.Host;
import app.termora.HostDialog;
import app.termora.HostKt;
import app.termora.HostManager;
import app.termora.HostTerminalTab;
import app.termora.I18n;
import app.termora.OpenHostActionEvent;
import app.termora.OptionPane;
import app.termora.Options;
import app.termora.Protocol;
import app.termora.SFTPPtyTerminalTab;
import app.termora.TerminalTab;
import app.termora.TerminalTabDialog;
import app.termora.TerminalTabbedManager;
import app.termora.TermoraFrame;
import app.termora.TermoraToolBar;
import app.termora.WindowScope;
import app.termora.actions.ActionManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.findeverywhere.BasicFilterFindEverywhereProvider;
import app.termora.findeverywhere.FindEverywhereProvider;
import app.termora.findeverywhere.FindEverywhereResult;
import app.termora.terminal.DataKey;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002DEB\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u001a\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020(H\u0002J\b\u00100\u001a\u00020\"H\u0016J \u00101\u001a\u00020\"2\u0006\u0010.\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020\"H\u0016J\u0018\u00108\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020(H\u0016J \u00108\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020(H\u0016J\n\u00109\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0;H\u0016J\u0010\u0010<\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u000fH\u0016J\u0018\u0010=\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J'\u0010>\u001a\u0004\u0018\u0001H?\"\b\b\u0000\u0010?*\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H?0BH\u0016\u00a2\u0006\u0002\u0010CR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00060\u001bR\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lapp/termora/TerminalTabbed;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "Lapp/termora/TerminalTabbedManager;", "Lapp/termora/actions/DataProvider;", "windowScope", "Lapp/termora/WindowScope;", "termoraToolBar", "Lapp/termora/TermoraToolBar;", "tabbedPane", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/TermoraToolBar;Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;)V", "tabs", "", "Lapp/termora/TerminalTab;", "customizeToolBarAWTEventListener", "Lapp/termora/TerminalTabbed$CustomizeToolBarAWTEventListener;", "toolbar", "Ljavax/swing/JToolBar;", "actionManager", "Lapp/termora/actions/ActionManager;", "dataProviderSupport", "Lapp/termora/actions/DataProviderSupport;", "titleProperty", "", "appearance", "Lapp/termora/Database$Appearance;", "Lapp/termora/Database;", "getAppearance", "()Lapp/termora/Database$Appearance;", "iconListener", "Ljava/beans/PropertyChangeListener;", "initView", "", "initEvents", "removeTabAt", "index", "", "disposable", "", "showContextMenu", "tabIndex", "e", "Ljava/awt/event/MouseEvent;", "addTab", "tab", "selected", "refreshTerminalTabs", "openSFTPPtyTab", "Lapp/termora/HostTerminalTab;", "openHostAction", "Ljavax/swing/Action;", "evt", "Ljava/util/EventObject;", "dispose", "addTerminalTab", "getSelectedTerminalTab", "getTerminalTabs", "", "setSelectedTerminalTab", "closeTerminalTab", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "CustomizeToolBarAWTEventListener", "SwitchFindEverywhereResult", "termora"})
public final class TerminalTabbed
extends JPanel
implements Disposable,
TerminalTabbedManager,
DataProvider {
    @NotNull
    private final WindowScope windowScope;
    @NotNull
    private final TermoraToolBar termoraToolBar;
    @NotNull
    private final FlatTabbedPane tabbedPane;
    @NotNull
    private final List<TerminalTab> tabs;
    @NotNull
    private final CustomizeToolBarAWTEventListener customizeToolBarAWTEventListener;
    @NotNull
    private final JToolBar toolbar;
    @NotNull
    private final ActionManager actionManager;
    @NotNull
    private final DataProviderSupport dataProviderSupport;
    @NotNull
    private final String titleProperty;
    @NotNull
    private final PropertyChangeListener iconListener;

    public TerminalTabbed(@NotNull WindowScope windowScope, @NotNull TermoraToolBar termoraToolBar, @NotNull FlatTabbedPane tabbedPane) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)termoraToolBar, (String)"termoraToolBar");
        Intrinsics.checkNotNullParameter((Object)tabbedPane, (String)"tabbedPane");
        super(new BorderLayout());
        this.windowScope = windowScope;
        this.termoraToolBar = termoraToolBar;
        this.tabbedPane = tabbedPane;
        this.tabs = new ArrayList();
        this.customizeToolBarAWTEventListener = new CustomizeToolBarAWTEventListener();
        this.toolbar = this.termoraToolBar.getJToolBar();
        this.actionManager = ActionManager.Companion.getInstance();
        this.dataProviderSupport = new DataProviderSupport();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.titleProperty = HostKt.toSimpleString(uUID);
        this.iconListener = arg_0 -> TerminalTabbed.iconListener$lambda$0(this, arg_0);
        this.initView();
        this.initEvents();
    }

    private final Database.Appearance getAppearance() {
        return Database.Companion.getDatabase().getAppearance();
    }

    private final void initView() {
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setTabsClosable(true);
        this.tabbedPane.setTabType(FlatTabbedPane.TabType.card);
        this.tabbedPane.setTrailingComponent((Component)this.toolbar);
        this.add((Component)this.tabbedPane, "Center");
        this.windowScope.getOrCreate(Reflection.getOrCreateKotlinClass(TerminalTabbedManager.class), () -> TerminalTabbed.initView$lambda$1(this));
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTerminalTabbed(), this);
        this.dataProviderSupport.addData(DataProviders.INSTANCE.getTerminalTabbedManager(), this);
    }

    private final void initEvents() {
        this.tabbedPane.setTabCloseCallback((arg_0, arg_1) -> TerminalTabbed.initEvents$lambda$2(this, arg_0, arg_1));
        this.tabbedPane.addPropertyChangeListener("selectedIndex", arg_0 -> TerminalTabbed.initEvents$lambda$3(this, arg_0));
        this.tabbedPane.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ TerminalTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                int index = TerminalTabbed.access$getTabbedPane$p(this.this$0).indexAtLocation(e.getX(), e.getY());
                if (index < 0) {
                    return;
                }
                TerminalTabbed.access$showContextMenu(this.this$0, index, e);
            }
        });
        this.tabbedPane.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ TerminalTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                int index;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e) && (index = TerminalTabbed.access$getTabbedPane$p(this.this$0).indexAtLocation(e.getX(), e.getY())) > 0) {
                    TerminalTabbed.access$getTabbedPane$p(this.this$0).getComponentAt(index).requestFocusInWindow();
                }
            }
        });
        FindEverywhereProvider.Companion.getFindEverywhereProviders(this.windowScope).add(new BasicFilterFindEverywhereProvider(new FindEverywhereProvider(this){
            final /* synthetic */ TerminalTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            public List<FindEverywhereResult> find(String pattern) {
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                List results = new ArrayList<E>();
                int n = TerminalTabbed.access$getTabbedPane$p(this.this$0).getTabCount();
                for (int i = 0; i < n; ++i) {
                    Component c2 = TerminalTabbed.access$getTabbedPane$p(this.this$0).getComponentAt(i);
                    if (c2 instanceof JComponent && ((JComponent)c2).getClientProperty("SKIP_FIND_EVERYWHERE") != null) continue;
                    String string = TerminalTabbed.access$getTabbedPane$p(this.this$0).getTitleAt(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitleAt(...)");
                    Icon icon = TerminalTabbed.access$getTabbedPane$p(this.this$0).getIconAt(i);
                    Component component = TerminalTabbed.access$getTabbedPane$p(this.this$0).getComponentAt(i);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponentAt(...)");
                    results.add(this.this$0.new SwitchFindEverywhereResult(string, icon, component));
                }
                return results;
            }

            public String group() {
                return I18n.INSTANCE.getString("termora.find-everywhere.groups.opened-hosts");
            }

            public int order() {
                return -2147483647;
            }
        }));
        this.getToolkit().addAWTEventListener(this.customizeToolBarAWTEventListener, 16L);
    }

    private final void removeTabAt(int index, boolean disposable) {
        if (this.tabbedPane.isTabClosable(index).booleanValue()) {
            String string;
            Window window;
            OptionPane optionPane;
            TerminalTab tab = this.tabs.get(index);
            if (disposable && (this.getAppearance().getConfirmTabClose() ? OptionPane.showConfirmDialog$default(optionPane = OptionPane.INSTANCE, window = this.windowScope.getWindow(), string = I18n.INSTANCE.getString("termora.tabbed.tab.close-prompt"), null, 2, 3, null, null, null, null, 484, null) != 0 : !tab.willBeClose())) {
                return;
            }
            if (disposable) {
                try {
                    tab.beforeClose();
                }
                catch (Exception exception) {
                    return;
                }
            }
            tab.onLostFocus();
            tab.removePropertyChangeListener(this.iconListener);
            this.tabbedPane.removeTabAt(index);
            this.tabs.remove(index);
            this.tabs.get(this.tabbedPane.getSelectedIndex()).onGrabFocus();
            this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex()).requestFocusInWindow();
            if (disposable) {
                Disposer.dispose(tab);
            }
        }
    }

    static /* synthetic */ void removeTabAt$default(TerminalTabbed terminalTabbed, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        terminalTabbed.removeTabAt(n, bl);
    }

    private final void showContextMenu(int tabIndex, MouseEvent e) {
        Action openHostAction;
        Component component = this.tabbedPane.getComponentAt(tabIndex);
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent c2 = (JComponent)component;
        TerminalTab tab = this.tabs.get(tabIndex);
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        JMenuItem rename = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.rename"));
        rename.addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$4(tabIndex, this, rename, c2, arg_0));
        JMenuItem clone = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.clone"));
        clone.addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$5(tab, this, arg_0));
        JMenuItem edit = popupMenu.add(I18n.INSTANCE.getString("termora.keymgr.edit"));
        edit.addActionListener((ActionListener)((Object)new AnAction(tab){
            final /* synthetic */ TerminalTab $tab;
            {
                this.$tab = $tab;
            }

            private final HostManager getHostManager() {
                return HostManager.Companion.getInstance();
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                if (this.$tab instanceof HostTerminalTab) {
                    Host host = this.getHostManager().getHost(((HostTerminalTab)this.$tab).getHost().getId());
                    if (host == null) {
                        return;
                    }
                    Host host2 = host;
                    HostDialog dialog = new HostDialog(evt.getWindow(), host2);
                    dialog.setLocationRelativeTo(evt.getWindow());
                    dialog.setVisible(true);
                    Host host3 = dialog.getHost();
                    if (host3 == null) {
                        return;
                    }
                    this.getHostManager().addHost(host3);
                }
            }
        }));
        JMenuItem openInNewWindow = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.open-in-new-window"));
        openInNewWindow.addActionListener((ActionListener)((Object)new AnAction(tabIndex, this, tab){
            final /* synthetic */ int $tabIndex;
            final /* synthetic */ TerminalTabbed this$0;
            final /* synthetic */ TerminalTab $tab;
            {
                this.$tabIndex = $tabIndex;
                this.this$0 = $receiver;
                this.$tab = $tab;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TermoraFrame termoraFrame = evt.getData(DataProviders.INSTANCE.getTermoraFrame());
                if (termoraFrame == null) {
                    return;
                }
                TermoraFrame owner = termoraFrame;
                if (this.$tabIndex > 0) {
                    String title = TerminalTabbed.access$getTabbedPane$p(this.this$0).getTitleAt(this.$tabIndex);
                    TerminalTabbed.access$removeTabAt(this.this$0, this.$tabIndex, false);
                    Dimension dimension = new Dimension(Math.min(this.this$0.getSize().width, 1280), Math.min(this.this$0.getSize().height, 800));
                    TerminalTabDialog dialog = new TerminalTabDialog((Window)owner, dimension, this.$tab);
                    dialog.setTitle(title);
                    Disposer.register(dialog, this.$tab);
                    Disposer.register(this.this$0, dialog);
                    dialog.setVisible(true);
                }
            }
        }));
        if (tab instanceof HostTerminalTab && (openHostAction = this.actionManager.getAction("OpenHostAction")) != null && (((HostTerminalTab)tab).getHost().getProtocol() == Protocol.SSH || ((HostTerminalTab)tab).getHost().getProtocol() == Protocol.SFTPPty)) {
            popupMenu.addSeparator();
            JMenuItem sftpCommand = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.sftp-command"));
            sftpCommand.addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$6(this, tab, openHostAction, arg_0));
        }
        popupMenu.addSeparator();
        JMenuItem close = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.close"));
        close.addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$7(this, tabIndex, arg_0));
        popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.close-other-tabs")).addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$8(this, tabIndex, arg_0));
        popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.close-all-tabs")).addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$9(this, arg_0));
        close.setEnabled(tab.canClose());
        rename.setEnabled(close.isEnabled());
        clone.setEnabled(close.isEnabled());
        edit.setEnabled(tab instanceof HostTerminalTab && !Intrinsics.areEqual((Object)((HostTerminalTab)tab).getHost().getId(), (Object)"local"));
        openInNewWindow.setEnabled(close.isEnabled());
        if (clone.isEnabled() && !tab.canClone()) {
            clone.setEnabled(false);
        }
        if (close.isEnabled()) {
            popupMenu.addSeparator();
            JMenuItem reconnect = popupMenu.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.reconnect"));
            reconnect.addActionListener(arg_0 -> TerminalTabbed.showContextMenu$lambda$10(tabIndex, this, arg_0));
            reconnect.setEnabled(this.tabs.get(tabIndex).canReconnect());
        }
        popupMenu.show((Component)this, e.getX(), e.getY());
    }

    private final void addTab(int index, TerminalTab tab, boolean selected) {
        JComponent c2 = tab.getJComponent();
        Object object = c2.getClientProperty(this.titleProperty);
        if (object == null) {
            object = tab.getTitle();
        }
        String title = object.toString();
        this.tabbedPane.insertTab(title, tab.getIcon(), (Component)c2, "", index);
        c2.putClientProperty(this.titleProperty, title);
        tab.addPropertyChangeListener(this.iconListener);
        this.tabs.add(index, tab);
        if (selected) {
            this.tabbedPane.setSelectedIndex(index);
        }
        this.tabbedPane.setTabClosable(index, tab.canClose());
        Disposer.register(this, tab);
    }

    @Override
    public void refreshTerminalTabs() {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.tabbedPane.setTabClosable(i, this.tabs.get(i).canClose());
        }
    }

    private final void openSFTPPtyTab(HostTerminalTab tab, Action openHostAction, EventObject evt) {
        if (!SFTPPtyTerminalTab.Companion.getCanSupports()) {
            OptionPane.showMessageDialog-9VgGkz4$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this), I18n.INSTANCE.getString("termora.tabbed.contextmenu.sftp-not-install"), null, 0, 0L, 20, null);
            return;
        }
        Host host = tab.getHost();
        if (host.getProtocol() == Protocol.SSH) {
            String string;
            Object object;
            Map envs = MapsKt.toMutableMap(tab.getHost().getOptions().envs());
            Object object2 = tab.getData(DataProviders.INSTANCE.getTerminal());
            String currentDir = object2 != null && (object = object2.getTerminalModel()) != null && (string = object.getData(DataKey.Companion.getCurrentDir(), "")) != null ? string : "";
            if (!StringsKt.isBlank((CharSequence)currentDir)) {
                envs.put("CurrentDir", currentDir);
            }
            object2 = host;
            object = Protocol.SFTPPty;
            long l = System.currentTimeMillis();
            Options options = Options.copy$default(host.getOptions(), null, null, HostKt.toPropertiesString(envs), null, 0, null, null, false, null, 507, null);
            host = Host.copy$default((Host)object2, null, null, (Protocol)((Object)object), null, 0, null, null, null, null, options, null, 0L, null, null, null, 0L, l, false, 196091, null);
        }
        openHostAction.actionPerformed(new OpenHostActionEvent((Object)this, host, evt));
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addTerminalTab(@NotNull TerminalTab tab, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.addTab(this.tabs.size(), tab, selected);
    }

    @Override
    public void addTerminalTab(int index, @NotNull TerminalTab tab, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.addTab(index, tab, selected);
    }

    @Override
    @Nullable
    public TerminalTab getSelectedTerminalTab() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.tabs.get(index);
    }

    @Override
    @NotNull
    public List<TerminalTab> getTerminalTabs() {
        return this.tabs;
    }

    @Override
    public void setSelectedTerminalTab(@NotNull TerminalTab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        int n = ((Collection)this.tabs).size();
        for (int index = 0; index < n; ++index) {
            if (!Intrinsics.areEqual((Object)this.tabs.get(index), (Object)tab)) continue;
            this.tabbedPane.setSelectedIndex(index);
            break;
        }
    }

    @Override
    public void closeTerminalTab(@NotNull TerminalTab tab, boolean disposable) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        int n = this.tabs.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this.tabs.get(i), (Object)tab)) continue;
            this.removeTabAt(i, disposable);
            break;
        }
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        if (Intrinsics.areEqual(dataKey, DataProviders.INSTANCE.getTerminalTab())) {
            this.dataProviderSupport.removeData(dataKey);
            if (this.tabbedPane.getSelectedIndex() >= 0 && this.tabs.size() > this.tabbedPane.getSelectedIndex()) {
                this.dataProviderSupport.addData(dataKey, this.tabs.get(this.tabbedPane.getSelectedIndex()));
            }
        }
        return this.dataProviderSupport.getData(dataKey);
    }

    private static final void iconListener$lambda$0(TerminalTabbed this$0, PropertyChangeEvent e) {
        int index;
        Object source = e.getSource();
        if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"icon") && source instanceof TerminalTab && (index = this$0.tabs.indexOf(source)) >= 0) {
            this$0.tabbedPane.setIconAt(index, ((TerminalTab)source).getIcon());
        }
    }

    private static final TerminalTabbedManager initView$lambda$1(TerminalTabbed this$0) {
        return this$0;
    }

    private static final void initEvents$lambda$2(TerminalTabbed this$0, JTabbedPane jTabbedPane, Integer i) {
        Intrinsics.checkNotNull((Object)i);
        this$0.removeTabAt(i, true);
    }

    private static final void initEvents$lambda$3(TerminalTabbed this$0, PropertyChangeEvent evt) {
        Object object = evt.getOldValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int oldIndex = (Integer)object;
        Object object2 = evt.getNewValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
        int newIndex = (Integer)object2;
        if (oldIndex >= 0 && this$0.tabs.size() > newIndex) {
            this$0.tabs.get(oldIndex).onLostFocus();
        }
        this$0.tabbedPane.getComponentAt(newIndex).requestFocusInWindow();
        if (newIndex >= 0 && this$0.tabs.size() > newIndex) {
            this$0.tabs.get(newIndex).onGrabFocus();
        }
    }

    private static final void showContextMenu$lambda$4(int $tabIndex, TerminalTabbed this$0, JMenuItem $rename, JComponent $c, ActionEvent it) {
        if ($tabIndex > 0) {
            Component component = SwingUtilities.getWindowAncestor(this$0);
            String string = $rename.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = this$0.tabbedPane.getTitleAt($tabIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitleAt(...)");
            String text = OptionPane.showInputDialog$default(OptionPane.INSTANCE, component, string, string2, null, 8, null);
            CharSequence charSequence = text;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                this$0.tabbedPane.setTitleAt($tabIndex, text);
                $c.putClientProperty(this$0.titleProperty, text);
            }
        }
    }

    private static final void showContextMenu$lambda$5(TerminalTab $tab, TerminalTabbed this$0, ActionEvent evt) {
        if ($tab instanceof HostTerminalTab) {
            Action action = this$0.actionManager.getAction("OpenHostAction");
            Host host = ((HostTerminalTab)$tab).getHost();
            Intrinsics.checkNotNull((Object)evt);
            action.actionPerformed(new OpenHostActionEvent((Object)this$0, host, (EventObject)evt));
        }
    }

    private static final void showContextMenu$lambda$6(TerminalTabbed this$0, TerminalTab $tab, Action $openHostAction, ActionEvent it) {
        HostTerminalTab hostTerminalTab = (HostTerminalTab)$tab;
        Intrinsics.checkNotNull((Object)it);
        this$0.openSFTPPtyTab(hostTerminalTab, $openHostAction, it);
    }

    private static final void showContextMenu$lambda$7(TerminalTabbed this$0, int $tabIndex, ActionEvent it) {
        block0: {
            BiConsumer biConsumer = this$0.tabbedPane.getTabCloseCallback();
            if (biConsumer == null) break block0;
            biConsumer.accept(this$0.tabbedPane, $tabIndex);
        }
    }

    private static final void showContextMenu$lambda$8(TerminalTabbed this$0, int $tabIndex, ActionEvent it) {
        int n = $tabIndex + 1;
        int i = this$0.tabbedPane.getTabCount() - 1;
        if (n <= i) {
            while (true) {
                BiConsumer biConsumer = this$0.tabbedPane.getTabCloseCallback();
                if (biConsumer != null) {
                    biConsumer.accept(this$0.tabbedPane, i);
                }
                if (i == n) break;
                --i;
            }
        }
        for (i = 1; i < $tabIndex; ++i) {
            BiConsumer biConsumer = this$0.tabbedPane.getTabCloseCallback();
            if (biConsumer == null) continue;
            biConsumer.accept(this$0.tabbedPane, $tabIndex - i);
        }
    }

    private static final void showContextMenu$lambda$9(TerminalTabbed this$0, ActionEvent it) {
        int n = this$0.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            BiConsumer biConsumer = this$0.tabbedPane.getTabCloseCallback();
            if (biConsumer == null) continue;
            biConsumer.accept(this$0.tabbedPane, this$0.tabbedPane.getTabCount() - 1);
        }
    }

    private static final void showContextMenu$lambda$10(int $tabIndex, TerminalTabbed this$0, ActionEvent it) {
        if ($tabIndex > 0) {
            this$0.tabs.get($tabIndex).reconnect();
        }
    }

    public static final /* synthetic */ void access$showContextMenu(TerminalTabbed $this, int tabIndex, MouseEvent e) {
        $this.showContextMenu(tabIndex, e);
    }

    public static final /* synthetic */ void access$removeTabAt(TerminalTabbed $this, int index, boolean disposable) {
        $this.removeTabAt(index, disposable);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lapp/termora/TerminalTabbed$CustomizeToolBarAWTEventListener;", "Ljava/awt/event/AWTEventListener;", "Lapp/termora/Disposable;", "<init>", "(Lapp/termora/TerminalTabbed;)V", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "showContextMenu", "Ljava/awt/event/MouseEvent;", "dispose", "termora"})
    private final class CustomizeToolBarAWTEventListener
    implements AWTEventListener,
    Disposable {
        public CustomizeToolBarAWTEventListener() {
            Disposer.register(TerminalTabbed.this, this);
        }

        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof MouseEvent) || ((MouseEvent)event).getID() != 500 || !SwingUtilities.isRightMouseButton((MouseEvent)event)) {
                return;
            }
            if (!TerminalTabbed.this.toolbar.isShowing()) {
                return;
            }
            if (!new Rectangle(TerminalTabbed.this.toolbar.getLocationOnScreen(), TerminalTabbed.this.toolbar.getSize()).contains(((MouseEvent)event).getLocationOnScreen())) {
                return;
            }
            this.showContextMenu((MouseEvent)event);
        }

        private final void showContextMenu(MouseEvent event) {
            FlatPopupMenu popupMenu = new FlatPopupMenu();
            popupMenu.add(I18n.INSTANCE.getString("termora.toolbar.customize-toolbar")).addActionListener(arg_0 -> CustomizeToolBarAWTEventListener.showContextMenu$lambda$0(TerminalTabbed.this, arg_0));
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }

        @Override
        public void dispose() {
            TerminalTabbed.this.getToolkit().removeAWTEventListener(this);
        }

        private static final void showContextMenu$lambda$0(TerminalTabbed this$0, ActionEvent it) {
            Window owner = SwingUtilities.getWindowAncestor(this$0);
            Intrinsics.checkNotNull((Object)owner);
            CustomizeToolBarDialog dialog = new CustomizeToolBarDialog(owner, this$0.windowScope, this$0.termoraToolBar);
            dialog.setLocationRelativeTo(owner);
            if (dialog.open()) {
                TermoraToolBar.Companion.rebuild();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/TerminalTabbed$SwitchFindEverywhereResult;", "Lapp/termora/findeverywhere/FindEverywhereResult;", "title", "", "icon", "Ljavax/swing/Icon;", "c", "Ljava/awt/Component;", "<init>", "(Lapp/termora/TerminalTabbed;Ljava/lang/String;Ljavax/swing/Icon;Ljava/awt/Component;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "getIcon", "isSelected", "", "toString", "termora"})
    private final class SwitchFindEverywhereResult
    implements FindEverywhereResult {
        @NotNull
        private final String title;
        @Nullable
        private final Icon icon;
        @NotNull
        private final Component c;

        public SwitchFindEverywhereResult(@Nullable String title, @NotNull Icon icon, Component c2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            this.title = title;
            this.icon = icon;
            this.c = c2;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TerminalTabbed.this.tabbedPane.setSelectedComponent(this.c);
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            if (isSelected && !FlatLaf.isLafDark() && this.icon instanceof DynamicIcon) {
                return (Icon)((Object)((DynamicIcon)((Object)this.icon)).getDark());
            }
            Icon icon = this.icon;
            if (icon == null) {
                icon = FindEverywhereResult.DefaultImpls.getIcon(this, isSelected);
            }
            return icon;
        }

        @NotNull
        public String toString() {
            return this.title;
        }

        @Override
        @NotNull
        public String getText(boolean isSelected) {
            return FindEverywhereResult.DefaultImpls.getText(this, isSelected);
        }
    }
}

