/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.DialogWrapper;
import app.termora.Host;
import app.termora.I18n;
import app.termora.OutlineComboBox;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.OhKeyPair;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010!\u001a\u00020\u001fH\u0014J\b\u0010\"\u001a\u00020\u001fH\u0014J\u0006\u0010#\u001a\u00020\u001bJ\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lapp/termora/RequestAuthenticationDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "host", "Lapp/termora/Host;", "<init>", "(Ljava/awt/Window;Lapp/termora/Host;)V", "authenticationTypeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/AuthenticationType;", "rememberCheckBox", "Ljavax/swing/JCheckBox;", "passwordPanel", "Ljavax/swing/JPanel;", "passwordPasswordField", "Lapp/termora/OutlinePasswordField;", "usernameTextField", "Lapp/termora/OutlineTextField;", "publicKeyComboBox", "Lapp/termora/OutlineComboBox;", "Lapp/termora/keymgr/OhKeyPair;", "keyManager", "Lapp/termora/keymgr/KeyManager;", "getKeyManager", "()Lapp/termora/keymgr/KeyManager;", "authentication", "Lapp/termora/Authentication;", "createCenterPanel", "Ljavax/swing/JComponent;", "switchPasswordComponent", "", "createSouthPanel", "doCancelAction", "doOKAction", "getAuthentication", "isRemembered", "", "getUsername", "", "termora"})
public final class RequestAuthenticationDialog
extends DialogWrapper {
    @NotNull
    private final FlatComboBox<AuthenticationType> authenticationTypeComboBox;
    @NotNull
    private final JCheckBox rememberCheckBox;
    @NotNull
    private final JPanel passwordPanel;
    @NotNull
    private final OutlinePasswordField passwordPasswordField;
    @NotNull
    private final OutlineTextField usernameTextField;
    @NotNull
    private final OutlineComboBox<OhKeyPair> publicKeyComboBox;
    @NotNull
    private Authentication authentication;

    public RequestAuthenticationDialog(@NotNull Window owner, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(owner);
        this.authenticationTypeComboBox = new FlatComboBox();
        this.rememberCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.new-host.general.remember"));
        this.passwordPanel = new JPanel(new BorderLayout());
        this.passwordPasswordField = new OutlinePasswordField(0, false, 3, null);
        this.usernameTextField = new OutlineTextField(0, 1, null);
        this.publicKeyComboBox = new OutlineComboBox();
        this.authentication = Authentication.Companion.getNo();
        this.setModal(true);
        this.setTitle("SSH User Authentication");
        this.setControlsVisible(false);
        this.init();
        this.pack();
        this.setSize(new Dimension(Math.max(380, this.getSize().width), this.getSize().height));
        this.setPreferredSize(this.getSize());
        this.setMinimumSize(this.getSize());
        this.publicKeyComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value instanceof OhKeyPair ? ((OhKeyPair)value).getName() : value, index, isSelected, cellHasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                return component;
            }
        });
        for (OhKeyPair keyPair : this.getKeyManager().getOhKeyPairs()) {
            this.publicKeyComboBox.addItem(keyPair);
        }
        this.authenticationTypeComboBox.addItemListener(arg_0 -> RequestAuthenticationDialog._init_$lambda$0(this, arg_0));
        if (host.getAuthentication().getType() != AuthenticationType.No) {
            this.authenticationTypeComboBox.setSelectedItem((Object)host.getAuthentication().getType());
        }
        this.usernameTextField.setText(host.getUsername());
    }

    private final KeyManager getKeyManager() {
        return KeyManager.Companion.getInstance();
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        this.authenticationTypeComboBox.addItem((Object)AuthenticationType.Password);
        this.authenticationTypeComboBox.addItem((Object)AuthenticationType.PublicKey);
        String formMargin = "7dlu";
        FormLayout layout = new FormLayout("left:pref, " + formMargin + ", default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref");
        this.switchPasswordComponent();
        JPanel jPanel = FormBuilder.create().padding(formMargin + ", " + formMargin + ", " + formMargin + ", " + formMargin, new Object[0]).layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.authentication") + ":", new Object[0]).xy(1, 1).add((Component)this.authenticationTypeComboBox).xy(3, 1).add(I18n.INSTANCE.getString("termora.new-host.general.username") + ":", new Object[0]).xy(1, 3).add((Component)((Object)this.usernameTextField)).xy(3, 3).add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, 5).add((Component)this.passwordPanel).xy(3, 5).build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    private final void switchPasswordComponent() {
        this.passwordPanel.removeAll();
        if (this.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.Password) {
            this.passwordPanel.add((Component)((Object)this.passwordPasswordField), "Center");
        } else if (this.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.PublicKey) {
            this.passwordPanel.add((Component)((Object)this.publicKeyComboBox), "Center");
        }
        this.passwordPanel.revalidate();
        this.passwordPanel.repaint();
    }

    @Override
    @Nullable
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        if (jComponent == null) {
            return null;
        }
        JComponent box = jComponent;
        this.rememberCheckBox.setFocusable(false);
        box.add((Component)this.rememberCheckBox, 0);
        return box;
    }

    @Override
    protected void doCancelAction() {
        this.authentication = Authentication.Companion.getNo();
        super.doCancelAction();
    }

    @Override
    protected void doOKAction() {
        String string;
        Object object = this.authenticationTypeComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
        AuthenticationType type = (AuthenticationType)((Object)object);
        if (type == AuthenticationType.Password) {
            char[] cArray = this.passwordPasswordField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            if (cArray.length == 0) {
                this.passwordPasswordField.requestFocusInWindow();
                return;
            }
        } else if (type == AuthenticationType.PublicKey && this.publicKeyComboBox.getSelectedItem() == null) {
            this.publicKeyComboBox.requestFocusInWindow();
            return;
        }
        if (type == AuthenticationType.Password) {
            char[] cArray = this.passwordPasswordField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            char[] cArray2 = cArray;
            string = new String(cArray2);
        } else {
            Object object2 = this.publicKeyComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type app.termora.keymgr.OhKeyPair");
            string = ((OhKeyPair)object2).getId();
        }
        this.authentication = this.authentication.copy(type, string);
        super.doOKAction();
    }

    @NotNull
    public final Authentication getAuthentication() {
        this.setModal(true);
        SwingUtilities.invokeLater(() -> RequestAuthenticationDialog.getAuthentication$lambda$1(this));
        this.setVisible(true);
        return this.authentication;
    }

    public final boolean isRemembered() {
        return this.rememberCheckBox.isSelected();
    }

    @NotNull
    public final String getUsername() {
        String string = this.usernameTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final void _init_$lambda$0(RequestAuthenticationDialog this$0, ItemEvent it) {
        if (it.getStateChange() == 1) {
            this$0.switchPasswordComponent();
        }
    }

    private static final void getAuthentication$lambda$1(RequestAuthenticationDialog this$0) {
        String string = this$0.usernameTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        boolean bl = StringsKt.isBlank((CharSequence)string) ? this$0.usernameTextField.requestFocusInWindow() : this$0.passwordPasswordField.requestFocusInWindow();
    }
}

