/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/termora/RSA;", "", "<init>", "()V", "TRANSFORMATION", "", "encrypt", "", "publicKey", "Ljava/security/PublicKey;", "data", "decrypt", "privateKey", "Ljava/security/PrivateKey;", "generatePublic", "generatePrivate", "generateKeyPair", "Ljava/security/KeyPair;", "keySize", "", "termora"})
public final class RSA {
    @NotNull
    public static final RSA INSTANCE = new RSA();
    @NotNull
    private static final String TRANSFORMATION = "RSA";

    private RSA() {
    }

    @NotNull
    public final byte[] encrypt(@NotNull PublicKey publicKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, publicKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, privateKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] encrypt(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, privateKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PublicKey publicKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, publicKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final PublicKey generatePublic(@NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        PublicKey publicKey2 = KeyFactory.getInstance(TRANSFORMATION).generatePublic(new X509EncodedKeySpec(publicKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
        return publicKey2;
    }

    @NotNull
    public final PrivateKey generatePrivate(@NotNull byte[] privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        PrivateKey privateKey2 = KeyFactory.getInstance(TRANSFORMATION).generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"generatePrivate(...)");
        return privateKey2;
    }

    @NotNull
    public final KeyPair generateKeyPair(int keySize) {
        KeyPairGenerator generator2 = KeyPairGenerator.getInstance(TRANSFORMATION);
        generator2.initialize(keySize);
        KeyPair keyPair = generator2.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateKeyPair$default(RSA rSA, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return rSA.generateKeyPair(n);
    }
}

