/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.DynamicColor;
import app.termora.DynamicIcon;
import com.formdev.flatlaf.FlatLaf;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0016J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lapp/termora/OptionsPane;", "Ljavax/swing/JPanel;", "<init>", "()V", "formMargin", "", "getFormMargin", "()Ljava/lang/String;", "tabListModel", "Ljavax/swing/DefaultListModel;", "Lapp/termora/OptionsPane$Option;", "getTabListModel", "()Ljavax/swing/DefaultListModel;", "tabList", "Ljavax/swing/JList;", "getTabList", "()Ljavax/swing/JList;", "cardLayout", "Ljava/awt/CardLayout;", "contentPanel", "loadedComponents", "", "Ljavax/swing/JComponent;", "initView", "", "selectOption", "option", "getSelectedOption", "getSelectedIndex", "", "setSelectedIndex", "index", "selectOptionJComponent", "c", "addOption", "removeOption", "setContentBorder", "border", "Ljavax/swing/border/Border;", "initEvents", "Option", "termora"})
public class OptionsPane
extends JPanel {
    @NotNull
    private final String formMargin;
    @NotNull
    private final DefaultListModel<Option> tabListModel;
    @NotNull
    private final JList<Option> tabList;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final Map<String, JComponent> loadedComponents;

    public OptionsPane() {
        super(new BorderLayout());
        this.formMargin = "7dlu";
        DefaultListModel<Option> defaultListModel = this.tabListModel = new DefaultListModel();
        this.tabList = new JList<Option>(this, defaultListModel){
            final /* synthetic */ OptionsPane this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Color getBackground() {
                Color color = this.this$0.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                return color;
            }
        };
        this.cardLayout = new CardLayout();
        this.contentPanel = new JPanel(this.cardLayout);
        this.loadedComponents = new LinkedHashMap();
        this.initView();
        this.initEvents();
    }

    @NotNull
    protected final String getFormMargin() {
        return this.formMargin;
    }

    @NotNull
    protected final DefaultListModel<Option> getTabListModel() {
        return this.tabListModel;
    }

    @NotNull
    protected final JList<Option> getTabList() {
        return this.tabList;
    }

    private final void initView() {
        this.tabList.setFixedCellHeight((int)((double)UIManager.getInt("Tree.rowHeight") * 1.2));
        this.tabList.setFixedCellWidth(170);
        this.tabList.setSelectionMode(0);
        this.tabList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(6, 6, 0, 6)));
        this.tabList.setCellRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ OptionsPane this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type app.termora.OptionsPane.Option");
                Option option = (Option)value;
                Component c2 = super.getListCellRendererComponent(list, option.getTitle(), index, isSelected, cellHasFocus);
                this.setIcon(option.getIcon(isSelected));
                if (isSelected && this.this$0.getTabList().hasFocus() && !FlatLaf.isLafDark() && this.getIcon() instanceof DynamicIcon) {
                    Icon icon = this.getIcon();
                    Intrinsics.checkNotNull((Object)icon, (String)"null cannot be cast to non-null type app.termora.DynamicIcon");
                    this.setIcon((Icon)((Object)((DynamicIcon)((Object)icon)).getDark()));
                }
                Intrinsics.checkNotNull((Object)c2);
                return c2;
            }
        });
        this.add((Component)this.tabList, "West");
        this.add((Component)this.contentPanel, "Center");
    }

    public final void selectOption(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        int index = this.tabListModel.indexOf(option);
        if (index < 0) {
            return;
        }
        this.setSelectedIndex(index);
    }

    @Nullable
    public final Option getSelectedOption() {
        int index = this.tabList.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.tabListModel.getElementAt(index);
    }

    public final int getSelectedIndex() {
        return this.tabList.getSelectedIndex();
    }

    public final void setSelectedIndex(int index) {
        this.tabList.setSelectedIndex(index);
    }

    public final void selectOptionJComponent(@NotNull JComponent c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Enumeration<Option> enumeration = this.tabListModel.elements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            Option element = (Option)iterator2.next();
            for (Container p = (Container)c2; p != null; p = p.getParent()) {
                if (!Intrinsics.areEqual((Object)p, (Object)element)) continue;
                Intrinsics.checkNotNull((Object)element);
                this.selectOption(element);
                return;
            }
        }
    }

    public final void addOption(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Enumeration<Option> enumeration = this.tabListModel.elements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            Option element = (Option)iterator2.next();
            if (!Intrinsics.areEqual((Object)element.getTitle(), (Object)option.getTitle())) continue;
            throw new UnsupportedOperationException("Title already exists");
        }
        this.tabListModel.addElement(option);
    }

    public final void removeOption(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        String title = option.getTitle();
        JComponent jComponent = this.loadedComponents.get(title);
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            this.contentPanel.remove(it);
            this.loadedComponents.remove(title);
        }
        this.tabListModel.removeElement(option);
    }

    public final void setContentBorder(@NotNull Border border) {
        Intrinsics.checkNotNullParameter((Object)border, (String)"border");
        this.contentPanel.setBorder(border);
    }

    private final void initEvents() {
        this.tabList.addListSelectionListener(arg_0 -> OptionsPane.initEvents$lambda$1(this, arg_0));
    }

    private static final void initEvents$lambda$1(OptionsPane this$0, ListSelectionEvent it) {
        if (this$0.tabList.getSelectedIndex() >= 0) {
            Option option = this$0.tabListModel.get(this$0.tabList.getSelectedIndex());
            String title = option.getTitle();
            if (!this$0.loadedComponents.containsKey(title)) {
                JComponent component = option.getJComponent();
                this$0.loadedComponents.put(title, component);
                this$0.contentPanel.add((Component)component, title);
                SwingUtilities.updateComponentTreeUI(component);
            }
            this$0.cardLayout.show(this$0.contentPanel, title);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lapp/termora/OptionsPane$Option;", "", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "termora"})
    public static interface Option {
        @NotNull
        public Icon getIcon(boolean var1);

        @NotNull
        public String getTitle();

        @NotNull
        public JComponent getJComponent();
    }
}

