/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Set<Disposable> myRootObjects = new HashSet<Disposable>();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = new HashMap<Disposable, ObjectNode>();
    private final Map<Disposable, Object> myDisposedObjects = new WeakHashMap<Disposable, Object>();
    private final Object treeLock = new Object();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        return this.myObject2NodeMap.get(object);
    }

    private void putNode(@NotNull Disposable object, @Nullable(value="null means remove") @Nullable(value="null means remove") ObjectNode node) {
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final RuntimeException register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == child) {
            return new IllegalArgumentException("Cannot register to itself: " + String.valueOf(parent));
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                return new IllegalStateException("Sorry but parent: " + String.valueOf(parent) + " has already been disposed (see the cause for stacktrace) so the child: " + String.valueOf(child) + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            this.myDisposedObjects.remove(child);
            ObjectNode parentNode = this.getNode(parent);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            RuntimeException e = ObjectTree.checkWasNotAddedAlready(parentNode, childNode);
            if (e != null) {
                return e;
            }
            parentNode.addChild(childNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private static RuntimeException checkWasNotAddedAlready(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        for (ObjectNode node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            return new IllegalStateException("'" + String.valueOf(childNode.getObject()) + "' was already added as a child of '" + String.valueOf(parentNode.getObject()) + "'");
        }
        return null;
    }

    @NotNull
    private ObjectNode createNodeFor(@NotNull Disposable object, @Nullable ObjectNode parentNode) {
        ObjectNode newNode = new ObjectNode(this, parentNode, object);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull Supplier<? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        boolean bl = needTrace = Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
        if (needTrace) {
            ourTopmostDisposeTrace.set(new Throwable());
        }
        Object object = this.treeLock;
        synchronized (object) {
            disposables = removeFromTreeAction.get();
        }
        ArrayList<Throwable> exceptions = null;
        for (int i = disposables.size() - 1; i >= 0; --i) {
            Disposable disposable = disposables.get(i);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(t);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(e);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAllChildren(@NotNull Disposable object, @Nullable Predicate<? super Disposable> predicate) {
        this.runWithTrace(() -> {
            ObjectNode node = this.getNode(object);
            if (node == null) {
                return Collections.emptyList();
            }
            ArrayList disposables = new ArrayList();
            node.getAndRemoveChildrenRecursively(disposables, predicate);
            return disposables;
        });
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        this.runWithTrace(() -> {
            ObjectNode node = this.getNode(object);
            if (node == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node == null) {
                if (this.rememberDisposedTrace(object) == null) {
                    disposables.add(object);
                }
            } else {
                node.getAndRemoveRecursively(disposables);
            }
            return disposables;
        });
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Map.Entry<Disposable, ObjectNode> entry : this.myObject2NodeMap.entrySet()) {
                Disposable key = entry.getKey();
                assert (key != disposable);
                ObjectNode node = entry.getValue();
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Disposable object2 : this.myRootObjects) {
                ObjectNode objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: '" + String.valueOf(object2) + "' of " + String.valueOf(object2.getClass()) + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (!throwError) continue;
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object rememberDisposedTrace(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            return this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.treeLock;
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value : this.myObject2NodeMap.values()) {
                value.clearTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <D extends Disposable> D findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull D object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObjectFromTree(@NotNull ObjectNode node) {
        Object object = this.treeLock;
        synchronized (object) {
            Disposable myObject = node.getObject();
            this.putNode(myObject, null);
            ObjectNode parent = node.getParent();
            if (parent == null) {
                this.myRootObjects.remove(myObject);
            } else {
                parent.removeChild(node);
            }
            node.myParent = null;
        }
    }
}

