/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Database;
import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.FilterableHostTreeModel;
import app.termora.Host;
import app.termora.HostTreeNode;
import app.termora.I18n;
import app.termora.NewHostTree;
import app.termora.SimpleTreeNode;
import app.termora.TreeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/NewHostTreeDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "hosts", "", "Lapp/termora/Host;", "getHosts", "()Ljava/util/List;", "setHosts", "(Ljava/util/List;)V", "allowMulti", "", "getAllowMulti", "()Z", "setAllowMulti", "(Z)V", "filter", "Ljava/util/function/Function;", "Lapp/termora/HostTreeNode;", "tree", "Lapp/termora/NewHostTree;", "setFilter", "", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "doOKAction", "setTreeName", "treeName", "", "termora"})
@SourceDebugExtension(value={"SMAP\nNewHostTreeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewHostTreeDialog.kt\napp/termora/NewHostTreeDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n1563#2:99\n1634#2,3:100\n*S KotlinDebug\n*F\n+ 1 NewHostTreeDialog.kt\napp/termora/NewHostTreeDialog\n*L\n72#1:96\n72#1:97,2\n73#1:99\n73#1:100,3\n*E\n"})
public final class NewHostTreeDialog
extends DialogWrapper {
    @NotNull
    private List<Host> hosts;
    private boolean allowMulti;
    @NotNull
    private Function<HostTreeNode, Boolean> filter;
    @NotNull
    private final NewHostTree tree;

    public NewHostTreeDialog(@NotNull Window owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.hosts = CollectionsKt.emptyList();
        this.allowMulti = true;
        this.filter = NewHostTreeDialog::filter$lambda$0;
        this.tree = new NewHostTree();
        this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 250, UIManager.getInt("Dialog.height") - 150));
        this.setModal(true);
        this.setResizable(false);
        this.setControlsVisible(false);
        this.setTitle(I18n.INSTANCE.getString("termora.transport.sftp.select-host"));
        this.tree.setContextmenu(false);
        this.tree.setDoubleClickConnection(false);
        this.tree.setDragEnabled(false);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    SimpleTreeNode<?> simpleTreeNode = tree.getLastSelectedPathNode();
                    if (simpleTreeNode == null) {
                        return;
                    }
                    SimpleTreeNode<?> node = simpleTreeNode;
                    if (node.isFolder()) {
                        return;
                    }
                    this.doOKAction();
                }
            }
        });
        this.init();
        this.setLocationRelativeTo(owner);
    }

    @NotNull
    public final List<Host> getHosts() {
        return this.hosts;
    }

    public final void setHosts(@NotNull List<Host> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.hosts = list;
    }

    public final boolean getAllowMulti() {
        return this.allowMulti;
    }

    public final void setAllowMulti(boolean bl) {
        this.allowMulti = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFilter(@NotNull Function<HostTreeNode, Boolean> filter) {
        void $this$setFilter_u24lambda_u242;
        FilterableHostTreeModel filterableHostTreeModel;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        FilterableHostTreeModel filterableHostTreeModel2 = filterableHostTreeModel = new FilterableHostTreeModel((JTree)((Object)this.tree), (Function0<Boolean>)((Function0)NewHostTreeDialog::setFilter$lambda$1));
        NewHostTree newHostTree = this.tree;
        boolean bl = false;
        $this$setFilter_u24lambda_u242.addFilter(filter);
        $this$setFilter_u24lambda_u242.refresh();
        newHostTree.setModel(filterableHostTreeModel);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.tree));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(4, 6, 4, 6)));
        return scrollPane;
    }

    @Override
    protected void doCancelAction() {
        this.hosts = CollectionsKt.emptyList();
        super.doCancelAction();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doOKAction() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        HostTreeNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.tree.getSelectionSimpleTreeNodes(true);
        NewHostTreeDialog newHostTreeDialog = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HostTreeNode)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = this.filter.apply(it);
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"apply(...)");
            if (!bl2.booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HostTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHost());
        }
        newHostTreeDialog.hosts = (List)destination$iv$iv;
        if (this.hosts.isEmpty()) {
            return;
        }
        if (!this.allowMulti && this.hosts.size() > 1) {
            return;
        }
        super.doOKAction();
    }

    public final void setTreeName(@NotNull String treeName) {
        Intrinsics.checkNotNullParameter((Object)treeName, (String)"treeName");
        Disposer.register(this.getDisposable(), new Disposable(treeName, this){
            private final String key;
            final /* synthetic */ NewHostTreeDialog this$0;
            {
                this.this$0 = $receiver;
                this.key = $treeName + ".state";
                TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)NewHostTreeDialog.access$getTree$p($receiver)), this.getProperties().getString(this.key, ""));
            }

            private final Database.Properties getProperties() {
                return Database.Companion.getDatabase().getProperties();
            }

            public void dispose() {
                this.getProperties().putString(this.key, TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)NewHostTreeDialog.access$getTree$p(this.this$0))));
            }
        });
    }

    private static final Boolean filter$lambda$0(HostTreeNode it) {
        return true;
    }

    private static final boolean setFilter$lambda$1() {
        return false;
    }
}

