/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0019J'\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001d\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/termora/I18n;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bundle", "Ljava/util/ResourceBundle;", "getBundle", "()Ljava/util/ResourceBundle;", "bundle$delegate", "Lkotlin/Lazy;", "substitutor", "Lorg/apache/commons/text/StringSubstitutor;", "getSubstitutor", "()Lorg/apache/commons/text/StringSubstitutor;", "substitutor$delegate", "supportedLanguages", "Ljava/util/SortedMap;", "", "containsLanguage", "locale", "Ljava/util/Locale;", "getLanguages", "", "getString", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "termora"})
public final class I18n {
    @NotNull
    public static final I18n INSTANCE = new I18n();
    private static final Logger log = LoggerFactory.getLogger(I18n.class);
    @NotNull
    private static final Lazy bundle$delegate = LazyKt.lazy(I18n::bundle_delegate$lambda$0);
    @NotNull
    private static final Lazy substitutor$delegate = LazyKt.lazy(I18n::substitutor_delegate$lambda$2);
    @NotNull
    private static final SortedMap<String, String> supportedLanguages;

    private I18n() {
    }

    private final ResourceBundle getBundle() {
        Lazy lazy = bundle$delegate;
        return (ResourceBundle)lazy.getValue();
    }

    private final StringSubstitutor getSubstitutor() {
        Lazy lazy = substitutor$delegate;
        return (StringSubstitutor)lazy.getValue();
    }

    @Nullable
    public final String containsLanguage(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        for (String key : supportedLanguages.keySet()) {
            Locale e = LocaleUtils.toLocale((String)key);
            if (!Intrinsics.areEqual((Object)LocaleUtils.toLocale((String)key), (Object)locale) && (!StringsKt.equals((String)e.getLanguage(), (String)locale.getLanguage(), (boolean)true) || !StringsKt.equals((String)e.getCountry(), (String)locale.getCountry(), (boolean)true))) continue;
            return key;
        }
        return null;
    }

    @NotNull
    public final Map<String, String> getLanguages() {
        return supportedLanguages;
    }

    @NotNull
    public final String getString(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String text = this.getString(key);
        if (!(args.length == 0)) {
            String string = MessageFormat.format(text, Arrays.copyOf(args, args.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        return text;
    }

    @NotNull
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String string = this.getSubstitutor().replace(this.getBundle().getString(key));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            return string;
        }
        catch (MissingResourceException e) {
            if (log.isWarnEnabled()) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            return key;
        }
    }

    private static final ResourceBundle bundle_delegate$lambda$0() {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/messages", Locale.getDefault());
        if (log.isInfoEnabled()) {
            String string = bundle.getBaseBundleName();
            if (string == null) {
                string = "null";
            }
            log.info("I18n: {}", (Object)string);
        }
        return bundle;
    }

    private static final String substitutor_delegate$lambda$2$lambda$1(String key) {
        Intrinsics.checkNotNull((Object)key);
        return INSTANCE.getString(key);
    }

    private static final StringSubstitutor substitutor_delegate$lambda$2() {
        return new StringSubstitutor(I18n::substitutor_delegate$lambda$2$lambda$1);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"en_US", (Object)"English"), TuplesKt.to((Object)"zh_CN", (Object)"\u7b80\u4f53\u4e2d\u6587"), TuplesKt.to((Object)"zh_TW", (Object)"\u7e41\u9ad4\u4e2d\u6587")};
        supportedLanguages = MapsKt.sortedMapOf((Pair[])pairArray);
    }
}

