/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.DeleteDataManager;
import app.termora.Host;
import app.termora.Protocol;
import app.termora.TermoraFrameKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\nJ\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\nR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/termora/HostManager;", "", "<init>", "()V", "database", "Lapp/termora/Database;", "getDatabase", "()Lapp/termora/Database;", "hosts", "", "", "Lapp/termora/Host;", "addHost", "", "host", "removeHost", "id", "", "getHost", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostManager.kt\napp/termora/HostManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n774#2:53\n865#2,2:54\n1869#2,2:56\n774#2:58\n865#2,2:59\n*S KotlinDebug\n*F\n+ 1 HostManager.kt\napp/termora/HostManager\n*L\n38#1:53\n38#1:54,2\n39#1:56,2\n41#1:58\n41#1:59,2\n*E\n"})
public final class HostManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, Host> hosts = new LinkedHashMap();

    private HostManager() {
    }

    private final Database getDatabase() {
        return Database.Companion.getDatabase();
    }

    public final void addHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        TermoraFrameKt.assertEventDispatchThread();
        if (host.getDeleted()) {
            this.removeHost(host.getId());
        } else {
            this.getDatabase().addHost(host);
            this.hosts.put(host.getId(), host);
        }
    }

    public final void removeHost(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.hosts.entrySet().removeIf(arg_0 -> HostManager.removeHost$lambda$1(arg_0 -> HostManager.removeHost$lambda$0(id, arg_0), arg_0));
        this.getDatabase().removeHost(id);
        DeleteDataManager.removeHost$default(DeleteDataManager.Companion.getInstance(), id, 0L, 2, null);
    }

    @NotNull
    public final List<Host> hosts() {
        Host it;
        Object element$iv$iv;
        Iterator iterator2;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        if (this.hosts.isEmpty()) {
            $this$filter$iv = this.getDatabase().getHosts();
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (Host)element$iv$iv;
                boolean bl = false;
                if (!(!it.getDeleted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Host it2 = (Host)element$iv;
                boolean bl = false;
                this.hosts.put(it2.getId(), it2);
            }
        }
        $this$filter$iv = this.hosts.values();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Host)element$iv$iv;
            boolean bl = false;
            if (!(!it.getDeleted())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Host it = (Host)a;
                boolean bl = false;
                Comparable comparable = it.getProtocol() == Protocol.Folder ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                it = (Host)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(it.getProtocol() == Protocol.Folder ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Host it = (Host)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getSort());
                    it = (Host)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSort()));
                }
                return n;
            }
        });
    }

    @Nullable
    public final Host getHost(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.hosts.get(id);
    }

    private static final boolean removeHost$lambda$0(String $id, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)((Host)it.getValue()).getId(), (Object)$id) || Intrinsics.areEqual((Object)((Host)it.getValue()).getParentId(), (Object)$id);
    }

    private static final boolean removeHost$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public /* synthetic */ HostManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/HostManager$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/HostManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HostManager getInstance() {
            return (HostManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(HostManager.class), Companion::getInstance$lambda$0);
        }

        private static final HostManager getInstance$lambda$0() {
            return new HostManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

