/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.HostOptionsPane;
import app.termora.Options;
import app.termora.Protocol;
import app.termora.Proxy;
import app.termora.SerialComm;
import app.termora.Tunneling;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/EditHostOptionsPane;", "Lapp/termora/HostOptionsPane;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/Host;)V", "getHost", "termora"})
@SourceDebugExtension(value={"SMAP\nEditHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditHostOptionsPane.kt\napp/termora/EditHostOptionsPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1208#2,2:78\n1236#2,4:80\n*S KotlinDebug\n*F\n+ 1 EditHostOptionsPane.kt\napp/termora/EditHostOptionsPane\n*L\n40#1:78,2\n40#1:80,4\n*E\n"})
public final class EditHostOptionsPane
extends HostOptionsPane {
    @NotNull
    private final Host host;

    /*
     * WARNING - void declaration
     */
    public EditHostOptionsPane(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.getGeneralOption().getPortTextField().setValue(this.host.getPort());
        this.getGeneralOption().getNameTextField().setText(this.host.getName());
        this.getGeneralOption().getProtocolTypeComboBox().setSelectedItem((Object)this.host.getProtocol());
        this.getGeneralOption().getUsernameTextField().setText(this.host.getUsername());
        this.getGeneralOption().getHostTextField().setText(this.host.getHost());
        this.getGeneralOption().getRemarkTextArea().setText(this.host.getRemark());
        this.getGeneralOption().getAuthenticationTypeComboBox().setSelectedItem((Object)this.host.getAuthentication().getType());
        if (this.host.getAuthentication().getType() == AuthenticationType.Password) {
            this.getGeneralOption().getPasswordTextField().setText(this.host.getAuthentication().getPassword());
        } else if (this.host.getAuthentication().getType() == AuthenticationType.PublicKey) {
            this.getGeneralOption().getPublicKeyComboBox().setSelectedItem(this.host.getAuthentication().getPassword());
        } else if (this.host.getAuthentication().getType() == AuthenticationType.SSHAgent) {
            this.getGeneralOption().getSshAgentComboBox().setSelectedItem(this.host.getAuthentication().getPassword());
        }
        this.getProxyOption().getProxyTypeComboBox().setSelectedItem((Object)this.host.getProxy().getType());
        this.getProxyOption().getProxyHostTextField().setText(this.host.getProxy().getHost());
        this.getProxyOption().getProxyPasswordTextField().setText(this.host.getProxy().getPassword());
        this.getProxyOption().getProxyUsernameTextField().setText(this.host.getProxy().getUsername());
        this.getProxyOption().getProxyPortTextField().setValue(this.host.getProxy().getPort());
        this.getProxyOption().getProxyAuthenticationTypeComboBox().setSelectedItem((Object)this.host.getProxy().getAuthenticationType());
        this.getTerminalOption().getCharsetComboBox().setSelectedItem(this.host.getOptions().getEncoding());
        this.getTerminalOption().getEnvironmentTextArea().setText(this.host.getOptions().getEnv());
        this.getTerminalOption().getStartupCommandTextField().setText(this.host.getOptions().getStartupCommand());
        this.getTerminalOption().getHeartbeatIntervalTextField().setValue(this.host.getOptions().getHeartbeatInterval());
        this.getTunnelingOption().getTunnelings().addAll((Collection<Tunneling>)this.host.getTunnelings());
        this.getTunnelingOption().getX11ForwardingCheckBox().setSelected(this.host.getOptions().getEnableX11Forwarding());
        this.getTunnelingOption().getX11ServerTextField().setText((String)StringUtils.defaultIfBlank((CharSequence)this.host.getOptions().getX11Forwarding(), (CharSequence)"localhost:0"));
        if (!((Collection)this.host.getOptions().getJumpHosts()).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = HostManager.Companion.getInstance().hosts();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Host host2 = (Host)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getId(), element$iv$iv);
            }
            Map hosts = destination$iv$iv;
            for (String id : this.host.getOptions().getJumpHosts()) {
                Host host3 = (Host)hosts.get(id);
                if (host3 == null) continue;
                this.getJumpHostsOption().getJumpHosts().add(host3);
            }
        }
        this.getJumpHostsOption().setFilter((Function1<? super Host, Boolean>)((Function1)arg_0 -> EditHostOptionsPane._init_$lambda$1(this, arg_0)));
        SerialComm serialComm = this.host.getOptions().getSerialComm();
        if (!StringsKt.isBlank((CharSequence)serialComm.getPort())) {
            this.getSerialCommOption().getSerialPortComboBox().setSelectedItem(serialComm.getPort());
        }
        this.getSerialCommOption().getBaudRateComboBox().setSelectedItem(serialComm.getBaudRate());
        this.getSerialCommOption().getDataBitsComboBox().setSelectedItem(serialComm.getDataBits());
        this.getSerialCommOption().getParityComboBox().setSelectedItem((Object)serialComm.getParity());
        this.getSerialCommOption().getStopBitsComboBox().setSelectedItem(serialComm.getStopBits());
        this.getSerialCommOption().getFlowControlComboBox().setSelectedItem((Object)serialComm.getFlowControl());
        this.getSftpOption().getDefaultDirectoryField().setText(this.host.getOptions().getSftpDefaultDirectory());
    }

    @Override
    @NotNull
    public Host getHost() {
        Host newHost = super.getHost();
        Host host = this.host;
        String string = newHost.getName();
        Protocol protocol = newHost.getProtocol();
        String string2 = newHost.getHost();
        int n = newHost.getPort();
        String string3 = newHost.getUsername();
        Authentication authentication = newHost.getAuthentication();
        Proxy proxy = newHost.getProxy();
        String string4 = newHost.getRemark();
        long l = System.currentTimeMillis();
        Options options = newHost.getOptions();
        List<Tunneling> list = newHost.getTunnelings();
        return Host.copy$default(host, null, string, protocol, string2, n, string3, string4, authentication, proxy, options, list, 0L, null, null, null, 0L, l, false, 194561, null);
    }

    private static final boolean _init_$lambda$1(EditHostOptionsPane this$0, Host it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getId(), (Object)this$0.host.getId());
    }
}

