/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.AES;
import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.PBKDF2;
import app.termora.PasswordWrongException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapp/termora/Doorman;", "Lapp/termora/Disposable;", "<init>", "()V", "properties", "Lapp/termora/Database$Properties;", "Lapp/termora/Database;", "getProperties", "()Lapp/termora/Database$Properties;", "key", "", "isWorking", "", "encrypt", "", "text", "decrypt", "work", "password", "", "convertKey", "checkIsWorking", "", "factor", "test", "dispose", "Companion", "termora"})
public final class Doorman
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] key = new byte[0];

    private Doorman() {
    }

    private final Database.Properties getProperties() {
        return Database.Companion.getDatabase().getProperties();
    }

    public final boolean isWorking() {
        return Boolean.parseBoolean(this.getProperties().getString("doorman", "false"));
    }

    @NotNull
    public final String encrypt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkIsWorking();
        String string = text;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return AES.INSTANCE.encodeBase64String(AES.ECB.INSTANCE.encrypt(this.key, byArray));
    }

    @NotNull
    public final String decrypt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkIsWorking();
        return StringsKt.decodeToString((byte[])AES.ECB.INSTANCE.decrypt(this.key, AES.INSTANCE.decodeBase64(text)));
    }

    @NotNull
    public final byte[] work(@NotNull char[] password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!(this.key.length == 0)) {
            throw new IllegalStateException("Working");
        }
        return this.work(this.convertKey(password));
    }

    @NotNull
    public final byte[] work(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String verify = this.getProperties().getString("doorman-verify");
        if (verify == null) {
            this.getProperties().putString("doorman-verify", AES.INSTANCE.encodeBase64String(AES.ECB.INSTANCE.encrypt(key, this.factor())));
        } else {
            try {
                if (!Arrays.equals(AES.ECB.INSTANCE.decrypt(key, AES.INSTANCE.decodeBase64(verify)), this.factor())) {
                    throw new PasswordWrongException();
                }
            }
            catch (Exception e) {
                throw new PasswordWrongException();
            }
        }
        this.key = key;
        this.getProperties().putString("doorman", "true");
        return this.key;
    }

    private final byte[] convertKey(char[] password) {
        return PBKDF2.generateSecret$default(PBKDF2.INSTANCE, password, this.factor(), 0, 0, 12, null);
    }

    private final void checkIsWorking() {
        if (this.key.length == 0 || !this.isWorking()) {
            throw new UnsupportedOperationException("Doorman is not working");
        }
    }

    private final byte[] factor() {
        String string = Application.INSTANCE.getName();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    public final boolean test(@NotNull char[] password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.checkIsWorking();
        return Arrays.equals(this.key, this.convertKey(password));
    }

    @Override
    public void dispose() {
        this.key = new byte[0];
    }

    public /* synthetic */ Doorman(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/Doorman$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/Doorman;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Doorman getInstance() {
            return (Doorman)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(Doorman.class), Companion::getInstance$lambda$0);
        }

        private static final Doorman getInstance$lambda$0() {
            return new Doorman(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

