/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Disposable;
import app.termora.ObjectTree;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(System.getProperty("idea.disposer.debug"));
    }

    private Disposer() {
    }

    @NotNull
    @Contract(pure=true, value="->new")
    public static Disposable newDisposable() {
        return Disposer.newDisposable("");
    }

    @NotNull
    @Contract(pure=true, value="_->new")
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    @Contract(pure=true, value="_,_->new")
    @NotNull
    public static Disposable newDisposable(@NotNull Disposable parentDisposable, @NotNull String debugName) {
        Disposable result = Disposer.newDisposable(debugName);
        Disposer.register(parentDisposable, result);
        return result;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        RuntimeException e = ourTree.register(parent, child);
        if (e != null) {
            throw e;
        }
    }

    public static boolean tryRegister(@NotNull Disposable parent, @NotNull Disposable child) {
        return ourTree.register(parent, child) == null;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, @NonNls @NotNull String key) {
        Disposer.register(parent, child);
        Disposable v = Disposer.get(key);
        if (v != null) {
            throw new IllegalArgumentException("Key " + key + " already registered: " + String.valueOf(v));
        }
        ourKeyDisposables.put(key, child);
        Disposer.register(child, new KeyDisposable(key));
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        return ourTree.getDisposalInfo(disposable) != null;
    }

    @Deprecated
    public static boolean isDisposing(@NotNull Disposable disposable) {
        return Disposer.isDisposed(disposable);
    }

    public static Disposable get(@NotNull String key) {
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        Disposer.dispose(disposable, true);
    }

    @ApiStatus.Internal
    public static void disposeChildren(@NotNull Disposable disposable, @Nullable Predicate<? super Disposable> predicate) {
        ourTree.executeAllChildren(disposable, predicate);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        ourTree.executeAll(disposable, processUnregistered);
    }

    @NotNull
    public static ObjectTree getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(System.getProperty("idea.disposer.debug"));
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (Disposer.getTree().getDisposalInfo(disposable) instanceof Throwable) {
            return (Throwable)((Object)disposable);
        }
        return null;
    }

    @ApiStatus.Internal
    public static void clearDisposalTraces() {
        ourTree.clearDisposedObjectTraces();
    }

    static {
        ourKeyDisposables = Collections.synchronizedMap(new WeakHashMap());
    }

    private static final class KeyDisposable
    implements Disposable {
        @NotNull
        private final String myKey;

        KeyDisposable(@NotNull String key) {
            this.myKey = key;
        }

        @Override
        public void dispose() {
            ourKeyDisposables.remove(this.myKey);
        }

        public String toString() {
            return "KeyDisposable (" + this.myKey + ")";
        }
    }
}

