/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.SwingUtils;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.native.osx.NativeMacLibrary;
import com.formdev.flatlaf.util.SystemInfo;
import com.jetbrains.JBR;
import com.jetbrains.WindowDecorations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000 D2\u00020\u0001:\u0003DEFB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010.\u001a\u00020/H\u0004J\n\u00100\u001a\u0004\u0018\u000101H\u0014J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0014J\b\u00105\u001a\u000204H\u0014J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0014J\n\u0010:\u001a\u0004\u0018\u00010;H\u0014J\u0012\u0010<\u001a\u00020/2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u000201H$J\b\u0010@\u001a\u00020/H\u0002J\b\u0010A\u001a\u00020/H\u0016J\b\u0010B\u001a\u00020/H\u0014J\b\u0010C\u001a\u00020/H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u001f@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0015R$\u0010+\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u0013\"\u0004\b-\u0010\u0015\u00a8\u0006G"}, d2={"Lapp/termora/DialogWrapper;", "Ljavax/swing/JDialog;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "titleLabel", "Ljavax/swing/JLabel;", "disposable", "Lapp/termora/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposable", "()Lapp/termora/Disposable;", "customTitleBar", "Lcom/jetbrains/WindowDecorations$CustomTitleBar;", "value", "", "controlsVisible", "getControlsVisible", "()Z", "setControlsVisible", "(Z)V", "fullWindowContent", "getFullWindowContent", "setFullWindowContent", "titleVisible", "getTitleVisible", "setTitleVisible", "titleIconVisible", "getTitleIconVisible", "setTitleIconVisible", "", "titleBarHeight", "getTitleBarHeight", "()I", "setTitleBarHeight", "(I)V", "lostFocusDispose", "getLostFocusDispose", "setLostFocusDispose", "escapeDispose", "getEscapeDispose", "setEscapeDispose", "processGlobalKeymap", "getProcessGlobalKeymap", "setProcessGlobalKeymap", "init", "", "createSouthPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/AbstractAction;", "createOkAction", "createJButtonForAction", "Ljavax/swing/JButton;", "action", "Ljavax/swing/Action;", "createTitlePanel", "Ljavax/swing/JPanel;", "setTitle", "title", "", "createCenterPanel", "initEvents", "addNotify", "doOKAction", "doCancelAction", "Companion", "OkAction", "CancelAction", "termora"})
public abstract class DialogWrapper
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JLabel titleLabel = new JLabel();
    @NotNull
    private final Disposable disposable;
    @Nullable
    private final WindowDecorations.CustomTitleBar customTitleBar;
    private boolean controlsVisible;
    private boolean fullWindowContent;
    private boolean titleVisible;
    private boolean titleIconVisible;
    private int titleBarHeight;
    private boolean lostFocusDispose;
    private boolean escapeDispose;
    @NotNull
    public static final String DEFAULT_ACTION = "DEFAULT_ACTION";
    @NotNull
    private static final String PROCESS_GLOBAL_KEYMAP = "PROCESS_GLOBAL_KEYMAP";

    public DialogWrapper(@Nullable Window owner) {
        super(owner);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.customTitleBar = SystemInfo.isMacOS && JBR.isWindowDecorationsSupported() ? JBR.getWindowDecorations().createCustomTitleBar() : null;
        this.controlsVisible = true;
        this.titleVisible = true;
        this.titleBarHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.escapeDispose = true;
        super.setDefaultCloseOperation(2);
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            this.rootPane.setWindowDecorationStyle(2);
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    protected final boolean getControlsVisible() {
        return this.controlsVisible;
    }

    protected final void setControlsVisible(boolean value) {
        this.controlsVisible = value;
        if (SystemInfo.isMacOS) {
            if (this.customTitleBar != null) {
                this.customTitleBar.putProperty("controls.visible", (Object)value);
            } else {
                NativeMacLibrary.INSTANCE.setControlsVisible(this, value);
            }
        } else {
            this.rootPane.putClientProperty("JRootPane.titleBarShowIconify", value);
            this.rootPane.putClientProperty("JRootPane.titleBarShowMaximize", value);
            this.rootPane.putClientProperty("JRootPane.titleBarShowClose", value);
        }
    }

    protected final boolean getFullWindowContent() {
        return this.fullWindowContent;
    }

    protected final void setFullWindowContent(boolean value) {
        this.fullWindowContent = value;
        this.rootPane.putClientProperty("FlatLaf.fullWindowContent", value);
    }

    protected final boolean getTitleVisible() {
        return this.titleVisible;
    }

    protected final void setTitleVisible(boolean value) {
        this.titleVisible = value;
        this.rootPane.putClientProperty("JRootPane.titleBarShowTitle", value);
    }

    protected final boolean getTitleIconVisible() {
        return this.titleIconVisible;
    }

    protected final void setTitleIconVisible(boolean value) {
        this.titleIconVisible = value;
        this.rootPane.putClientProperty("JRootPane.titleBarShowIcon", value);
    }

    protected final int getTitleBarHeight() {
        return this.titleBarHeight;
    }

    protected final void setTitleBarHeight(int value) {
        this.titleBarHeight = value;
        if (SystemInfo.isMacOS) {
            WindowDecorations.CustomTitleBar customTitleBar = this.customTitleBar;
            if (customTitleBar != null) {
                customTitleBar.setHeight((float)this.getHeight());
            }
        } else {
            this.rootPane.putClientProperty("JRootPane.titleBarHeight", value);
        }
    }

    protected final boolean getLostFocusDispose() {
        return this.lostFocusDispose;
    }

    protected final void setLostFocusDispose(boolean bl) {
        this.lostFocusDispose = bl;
    }

    protected final boolean getEscapeDispose() {
        return this.escapeDispose;
    }

    protected final void setEscapeDispose(boolean bl) {
        this.escapeDispose = bl;
    }

    public final boolean getProcessGlobalKeymap() {
        Object v = this.rootPane.getClientProperty(PROCESS_GLOBAL_KEYMAP);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return false;
    }

    protected final void setProcessGlobalKeymap(boolean value) {
        this.rootPane.putClientProperty(PROCESS_GLOBAL_KEYMAP, value);
    }

    protected final void init() {
        JComponent southPanel;
        this.initEvents();
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)this.createCenterPanel(), "Center");
        if (SystemInfo.isMacOS) {
            WindowDecorations.CustomTitleBar customTitleBar;
            this.rootPane.putClientProperty("apple.awt.windowTitleVisible", false);
            this.rootPane.putClientProperty("apple.awt.fullWindowContent", true);
            this.rootPane.putClientProperty("apple.awt.transparentTitleBar", true);
            this.rootPane.putClientProperty("FlatLaf.macOS.windowButtonsSpacing", "medium");
            JPanel titlePanel = this.createTitlePanel();
            if (titlePanel != null) {
                rootPanel.add((Component)titlePanel, "North");
            }
            if ((customTitleBar = this.customTitleBar) != null) {
                customTitleBar.putProperty("controls.visible", (Object)this.controlsVisible);
                customTitleBar.setHeight((float)this.titleBarHeight);
                JBR.getWindowDecorations().setCustomTitleBar((Dialog)this, customTitleBar);
            }
        }
        if ((southPanel = this.createSouthPanel()) != null) {
            rootPanel.add((Component)southPanel, "South");
        }
        this.rootPane.setContentPane(rootPanel);
    }

    @Nullable
    protected JComponent createSouthPanel() {
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(8, 12, 8, 12)));
        box.add(Box.createHorizontalGlue());
        List<AbstractAction> actions = this.createActions();
        for (int i = actions.size() - 1; -1 < i; --i) {
            box.add(this.createJButtonForAction(actions.get(i)));
            if (i == 0) continue;
            box.add(Box.createHorizontalStrut(8));
        }
        return box;
    }

    @NotNull
    protected List<AbstractAction> createActions() {
        Object[] objectArray = new AbstractAction[]{this.createOkAction(), new CancelAction()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected AbstractAction createOkAction() {
        return (AbstractAction)((Object)new OkAction(this, null, 1, null));
    }

    @NotNull
    protected JButton createJButtonForAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        JButton button = new JButton(action);
        Object value = action.getValue(DEFAULT_ACTION);
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.rootPane.setDefaultButton(button);
        }
        return button;
    }

    @Nullable
    protected JPanel createTitlePanel() {
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setText(this.getTitle());
        this.titleLabel.putClientProperty("FlatLaf.style", "font: bold");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.titleLabel, "Center");
        panel2.setPreferredSize(new Dimension(-1, this.titleBarHeight));
        return panel2;
    }

    @Override
    public void setTitle(@Nullable String title) {
        super.setTitle(title);
        this.titleLabel.setText(title);
    }

    @NotNull
    protected abstract JComponent createCenterPanel();

    private final void initEvents() {
        InputMap inputMap = this.rootPane.getInputMap(2);
        if (this.escapeDispose) {
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
        }
        inputMap.put(KeyStroke.getKeyStroke(87, this.getToolkit().getMenuShortcutKeyMaskEx()), "close");
        this.rootPane.getActionMap().put("close", (Action)((Object)new AnAction(this){
            final /* synthetic */ DialogWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Window window;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                Component c2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                Intrinsics.checkNotNull((Object)c2, (String)"null cannot be cast to non-null type java.awt.Container");
                List<JPopupMenu> list = SwingUtils.getDescendantsOfType(JPopupMenu.class, (Container)c2, true);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDescendantsOfType(...)");
                List<JPopupMenu> popups = list;
                boolean openPopup = false;
                for (JPopupMenu p : popups) {
                    p.setVisible(false);
                    openPopup = true;
                }
                Object object = c2;
                Window window2 = object instanceof Window ? (Window)object : null;
                if (window2 == null) {
                    window2 = SwingUtilities.windowForComponent(c2);
                }
                if ((window = window2) != null) {
                    Object[] windows = window.getOwnedWindows();
                    object = ArrayIteratorKt.iterator((Object[])windows);
                    while (object.hasNext()) {
                        Window w = (Window)object.next();
                        if (!w.isVisible()) continue;
                        String string = w.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string, (String)"HeavyWeightWindow", (boolean)false, (int)2, null)) continue;
                        openPopup = true;
                        w.dispose();
                    }
                }
                if (openPopup) {
                    return;
                }
                SwingUtilities.invokeLater(() -> initEvents.1.actionPerformed$lambda$0(this.this$0));
            }

            private static final void actionPerformed$lambda$0(DialogWrapper this$0) {
                this$0.doCancelAction();
            }
        }));
        this.addWindowFocusListener(new WindowAdapter(this){
            final /* synthetic */ DialogWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowLostFocus(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.getLostFocusDispose()) {
                    SwingUtilities.invokeLater(() -> initEvents.2.windowLostFocus$lambda$0(this.this$0));
                }
            }

            private static final void windowLostFocus$lambda$0(DialogWrapper this$0) {
                this$0.doCancelAction();
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Disposer.dispose(this.this$0.getDisposable());
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            this.setControlsVisible(this.controlsVisible);
            this.setTitleBarHeight(this.titleBarHeight);
            this.setTitleIconVisible(this.titleIconVisible);
            this.setTitleVisible(this.titleVisible);
            this.setFullWindowContent(this.fullWindowContent);
        }
    }

    protected void doOKAction() {
        this.dispose();
    }

    protected void doCancelAction() {
        this.dispose();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lapp/termora/DialogWrapper$CancelAction;", "Lapp/termora/actions/AnAction;", "<init>", "(Lapp/termora/DialogWrapper;)V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "termora"})
    protected final class CancelAction
    extends AnAction {
        public CancelAction() {
            super(I18n.INSTANCE.getString("termora.cancel"));
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            DialogWrapper.this.doCancelAction();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/DialogWrapper$Companion;", "", "<init>", "()V", "DEFAULT_ACTION", "", "PROCESS_GLOBAL_KEYMAP", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lapp/termora/DialogWrapper$OkAction;", "Lapp/termora/actions/AnAction;", "text", "", "<init>", "(Lapp/termora/DialogWrapper;Ljava/lang/String;)V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "termora"})
    protected final class OkAction
    extends AnAction {
        final /* synthetic */ DialogWrapper this$0;

        public OkAction(@NotNull DialogWrapper this$0, String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.this$0 = this$0;
            super(text);
            this.putValue(DialogWrapper.DEFAULT_ACTION, true);
        }

        public /* synthetic */ OkAction(DialogWrapper dialogWrapper, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = I18n.INSTANCE.getString("termora.confirm");
            }
            this(dialogWrapper, string);
        }

        @Override
        protected void actionPerformed(@NotNull AnActionEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            this.this$0.doOKAction();
        }
    }
}

