/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.BackgroundManager;
import app.termora.Database;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Doorman;
import app.termora.DoormanDialog;
import app.termora.DynamicColor;
import app.termora.HostKt;
import app.termora.I18n;
import app.termora.ScopeKt;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import app.termora.ThemeManager;
import app.termora.actions.ActionManager;
import app.termora.keymap.KeymapManager;
import app.termora.vfs2.sftp.MySftpFileProvider;
import com.formdev.flatlaf.extras.FlatDesktop;
import com.formdev.flatlaf.extras.FlatInspector;
import com.formdev.flatlaf.ui.FlatTableCellBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jthemedetecor.OsThemeDetector;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.SystemEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.WeakRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lapp/termora/ApplicationRunner;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "run", "", "clearTemporary", "openDoor", "startMainFrame", "setupSystemTray", "quitHandler", "loadSettings", "setupLaf", "setupMacOSDock", "printSystemInfo", "openDatabase", "enableAnalytics", "getAnalyticsUserID", "", "termora"})
@SourceDebugExtension(value={"SMAP\nApplicationRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationRunner.kt\napp/termora/ApplicationRunner\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n29#2,2:397\n29#2,3:399\n29#2,3:402\n29#2,3:405\n29#2,3:408\n29#2,3:411\n29#2,3:414\n29#2,3:417\n31#2:420\n1#3:421\n*S KotlinDebug\n*F\n+ 1 ApplicationRunner.kt\napp/termora/ApplicationRunner\n*L\n47#1:397,2\n50#1:399,3\n53#1:402,3\n56#1:405,3\n59#1:408,3\n78#1:411,3\n81#1:414,3\n87#1:417,3\n47#1:420\n*E\n"})
public final class ApplicationRunner {
    @NotNull
    private final Lazy log$delegate = LazyKt.lazy(ApplicationRunner::log_delegate$lambda$0);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void run() {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl2 = false;
        this.printSystemInfo();
        long printSystemInfo = System.currentTimeMillis() - start$iv2;
        boolean $i$f$measureTimeMillis3 = false;
        long start$iv3 = System.currentTimeMillis();
        boolean bl3 = false;
        this.openDatabase();
        long openDatabase = System.currentTimeMillis() - start$iv3;
        boolean $i$f$measureTimeMillis4 = false;
        long start$iv4 = System.currentTimeMillis();
        boolean bl4 = false;
        this.loadSettings();
        long loadSettings = System.currentTimeMillis() - start$iv4;
        boolean $i$f$measureTimeMillis5 = false;
        long start$iv5 = System.currentTimeMillis();
        boolean bl5 = false;
        this.enableAnalytics();
        long enableAnalytics2 = System.currentTimeMillis() - start$iv5;
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ActionManager.Companion.getInstance();
                        KeymapManager.Companion.getInstance();
                        DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();
                        fileSystemManager.addProvider("sftp", (FileProvider)new MySftpFileProvider());
                        fileSystemManager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
                        fileSystemManager.setFilesCache((FilesCache)new WeakRefFilesCache());
                        fileSystemManager.init();
                        VFS.setManager((FileSystemManager)((FileSystemManager)fileSystemManager));
                        BackgroundManager.Companion.getInstance().getBackgroundImage();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        boolean $i$f$measureTimeMillis6 = false;
        long start$iv6 = System.currentTimeMillis();
        boolean bl6 = false;
        this.setupLaf();
        long setupLaf = System.currentTimeMillis() - start$iv6;
        boolean $i$f$measureTimeMillis7 = false;
        long start$iv7 = System.currentTimeMillis();
        boolean bl7 = false;
        this.openDoor();
        long openDoor = System.currentTimeMillis() - start$iv7;
        this.clearTemporary();
        boolean $i$f$measureTimeMillis8 = false;
        long start$iv8 = System.currentTimeMillis();
        boolean bl8 = false;
        this.startMainFrame();
        long startMainFrame = System.currentTimeMillis() - start$iv8;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("printSystemInfo: {}ms", (Object)printSystemInfo);
            this.getLog().debug("openDatabase: {}ms", (Object)openDatabase);
            this.getLog().debug("loadSettings: {}ms", (Object)loadSettings);
            this.getLog().debug("enableAnalytics: {}ms", (Object)enableAnalytics2);
            this.getLog().debug("setupLaf: {}ms", (Object)setupLaf);
            this.getLog().debug("openDoor: {}ms", (Object)openDoor);
            this.getLog().debug("startMainFrame: {}ms", (Object)startMainFrame);
        }
        long it = System.currentTimeMillis() - start$iv;
        boolean bl9 = false;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("run: {}ms", (Object)it);
        }
    }

    private final void clearTemporary() {
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FileUtils.cleanDirectory((File)Application.INSTANCE.getTemporaryDir());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void openDoor() {
        if (Doorman.Companion.getInstance().isWorking() && !new DoormanDialog(null).open()) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void startMainFrame() {
        TermoraFrameManager.Companion.getInstance().createWindow().setVisible(true);
        if (SystemInfo.isMacOS) {
            SwingUtilities.invokeLater(() -> ApplicationRunner.startMainFrame$lambda$11(this));
        } else if (SystemInfo.isWindows) {
            SwingUtilities.invokeLater(() -> ApplicationRunner.startMainFrame$lambda$12(this));
        }
    }

    private final void setupSystemTray() {
        if (!SystemInfo.isWindows || !SystemTray.isSupported()) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        BufferedImage image = ImageIO.read(TermoraFrame.class.getResourceAsStream("/icons/termora_16x16.png"));
        TrayIcon trayIcon = new TrayIcon(image);
        PopupMenu popupMenu = new PopupMenu();
        trayIcon.setPopupMenu(popupMenu);
        trayIcon.setToolTip(Application.INSTANCE.getName());
        MenuItem exitMenu = new MenuItem("Exit");
        exitMenu.addActionListener(arg_0 -> ApplicationRunner.setupSystemTray$lambda$14(this, arg_0));
        popupMenu.add(exitMenu);
        trayIcon.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TermoraFrameManager.Companion.getInstance().tick();
            }
        });
        tray.add(trayIcon);
        Disposer.register(ApplicationScope.Companion.forApplicationScope(), new Disposable(tray, trayIcon){
            final /* synthetic */ SystemTray $tray;
            final /* synthetic */ TrayIcon $trayIcon;
            {
                this.$tray = $tray;
                this.$trayIcon = $trayIcon;
            }

            public void dispose() {
                this.$tray.remove(this.$trayIcon);
            }
        });
    }

    private final void quitHandler() {
        for (TermoraFrame frame : TermoraFrameManager.Companion.getInstance().getWindows()) {
            frame.dispatchEvent(new WindowEvent(frame, 202));
        }
        Disposer.dispose(TermoraFrameManager.Companion.getInstance());
    }

    private final void loadSettings() {
        Object object;
        Object $this$loadSettings_u24lambda_u2415;
        String language = Database.Companion.getDatabase().getAppearance().getLanguage();
        Object object2 = this;
        try {
            $this$loadSettings_u24lambda_u2415 = object2;
            boolean bl = false;
            $this$loadSettings_u24lambda_u2415 = Result.constructor-impl((Object)LocaleUtils.toLocale((String)language));
        }
        catch (Throwable bl) {
            $this$loadSettings_u24lambda_u2415 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$loadSettings_u24lambda_u2415;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = Locale.getDefault();
        }
        Locale locale = (Locale)object;
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Language: {} , Locale: {}", (Object)language, (Object)locale);
        }
        Locale.setDefault(locale);
    }

    private final void setupLaf() {
        System.setProperty("flatlaf.useWindowDecorations", String.valueOf(SystemInfo.isLinux || SystemInfo.isWindows));
        System.setProperty("flatlaf.useRoundedPopupBorder", "false");
        if (SystemInfo.isLinux) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        ThemeManager themeManager = ThemeManager.Companion.getInstance();
        Database.Appearance appearance = Database.Companion.getDatabase().getAppearance();
        String theme = appearance.getTheme();
        if (appearance.getFollowSystem()) {
            theme = OsThemeDetector.getDetector().isDark() ? appearance.getDarkTheme() : appearance.getLightTheme();
        }
        themeManager.change(theme, true);
        if (Application.INSTANCE.isUnknownVersion()) {
            FlatInspector.install((String)"ctrl shift alt X");
        }
        UIManager.put("FlatLaf.fullWindowContent", true);
        UIManager.put("JRootPane.useWindowDecorations", false);
        UIManager.put("TitlePane.useWindowDecorations", false);
        UIManager.put("Component.arc", 5);
        UIManager.put("TextComponent.arc", UIManager.getInt("Component.arc"));
        UIManager.put("Component.hideMnemonics", false);
        UIManager.put("TitleBar.height", 36);
        UIManager.put("Dialog.width", 650);
        UIManager.put("Dialog.height", 550);
        Object object = SystemInfo.isMacOS ? UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height")) : (SystemInfo.isLinux ? UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height") - 4) : UIManager.put("TabbedPane.tabHeight", UIManager.getInt("TitleBar.height") - 6));
        if (SystemInfo.isLinux) {
            UIManager.put("TitlePane.centerTitle", true);
            UIManager.put("TitlePane.showIcon", false);
            UIManager.put("TitlePane.showIconInDialogs", false);
        }
        UIManager.put("Table.rowHeight", 24);
        UIManager.put("Table.focusCellHighlightBorder", new FlatTableCellBorder.Default());
        UIManager.put("Table.focusSelectedCellHighlightBorder", new FlatTableCellBorder.Default());
        UIManager.put("Table.selectionArc", UIManager.getInt("Component.arc"));
        UIManager.put("Tree.rowHeight", 24);
        UIManager.put("Tree.background", new DynamicColor("window"));
        UIManager.put("Tree.selectionArc", UIManager.getInt("Component.arc"));
        UIManager.put("Tree.showCellFocusIndicator", false);
        UIManager.put("Tree.repaintWholeRow", true);
        UIManager.put("List.selectionArc", UIManager.getInt("Component.arc"));
    }

    private final void setupMacOSDock() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Class<?> cls = Class.forName("com.apple.eawt.Application");
        Object app = cls.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        Object[] objectArray = new Class[]{SystemEventListener.class};
        Method addAppEventListener = cls.getMethod("addAppEventListener", (Class<?>[])objectArray);
        objectArray = new Object[]{new AppReopenedListener(){

            public void appReopened(AppReopenedEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TermoraFrameManager manager = TermoraFrameManager.Companion.getInstance();
                if (manager.getWindows().length == 0) {
                    manager.createWindow().setVisible(true);
                }
            }
        }};
        addAppEventListener.invoke(app, objectArray);
        Disposer.register(ApplicationScope.Companion.forApplicationScope(), new Disposable(countDownLatch){
            final /* synthetic */ CountDownLatch $countDownLatch;
            {
                this.$countDownLatch = $countDownLatch;
            }

            public void dispose() {
                this.$countDownLatch.countDown();
            }
        });
        Thread.ofPlatform().daemon(false).priority(1).start(() -> ApplicationRunner.setupMacOSDock$lambda$17(countDownLatch));
    }

    private final void printSystemInfo() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Welcome to " + Application.INSTANCE.getName() + " " + Application.INSTANCE.getVersion() + "!");
            Object[] objectArray = new Object[]{SystemUtils.JAVA_VM_NAME, SystemUtils.JAVA_VM_VENDOR, SystemUtils.JAVA_VM_VERSION};
            this.getLog().debug("JVM name: {} , vendor: {} , version: {}", objectArray);
            objectArray = new Object[]{SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH};
            this.getLog().debug("OS name: {} , version: {} , arch: {}", objectArray);
            this.getLog().debug("Base config dir: " + Application.INSTANCE.getBaseDataDir().getAbsolutePath());
        }
    }

    private final void openDatabase() {
        try {
            Database.Companion.getDatabase();
        }
        catch (Exception e) {
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error(e.getMessage(), (Throwable)e);
            }
            JOptionPane.showMessageDialog(null, "Unable to open database", I18n.INSTANCE.getString("termora.title"), 0);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void enableAnalytics() {
        if (Application.INSTANCE.isUnknownVersion()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ApplicationRunner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            JSONObject properties = new JSONObject();
                            properties.put("os", (Object)SystemUtils.OS_NAME);
                            if (SystemInfo.isLinux) {
                                properties.put("platform", (Object)"Linux");
                            } else if (SystemInfo.isWindows) {
                                properties.put("platform", (Object)"Windows");
                            } else if (SystemInfo.isMacOS) {
                                properties.put("platform", (Object)"macOS");
                            }
                            properties.put("version", (Object)Application.INSTANCE.getVersion());
                            properties.put("language", (Object)Locale.getDefault().toString());
                            JSONObject message = new MessageBuilder("0871335f59ee6d0eb246b008a20f9d1c").event(ApplicationRunner.access$getAnalyticsUserID(this.this$0), "launch", properties);
                            ClientDelivery delivery = new ClientDelivery();
                            delivery.addMessage(message);
                            String[] stringArray = new String[]{"https://api-eu.mixpanel.com", "https://api-in.mixpanel.com", "https://api.mixpanel.com", "http://api.mixpanel.com"};
                            List endpoints = CollectionsKt.listOf((Object[])stringArray);
                            for (String endpoint : endpoints) {
                                try {
                                    new MixpanelAPI(endpoint + "/track", endpoint + "/engage", endpoint + "/groups").deliver(delivery, true);
                                    return Unit.INSTANCE;
                                }
                                catch (Exception e) {
                                    if (!ApplicationRunner.access$getLog(this.this$0).isErrorEnabled()) continue;
                                    ApplicationRunner.access$getLog(this.this$0).error(e.getMessage(), (Throwable)e);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            if (!ApplicationRunner.access$getLog(this.this$0).isErrorEnabled()) return Unit.INSTANCE;
                            ApplicationRunner.access$getLog(this.this$0).error(e.getMessage(), (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final String getAnalyticsUserID() {
        String id = Database.Companion.getDatabase().getProperties().getString("AnalyticsUserID");
        CharSequence charSequence = id;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            id = HostKt.toSimpleString(uUID);
            Database.Companion.getDatabase().getProperties().putString("AnalyticsUserID", id);
        }
        return id;
    }

    private static final Logger log_delegate$lambda$0() {
        return LoggerFactory.getLogger(ApplicationRunner.class);
    }

    private static final void startMainFrame$lambda$11$lambda$10(ApplicationRunner this$0, FlatDesktop.QuitResponse it) {
        this$0.quitHandler();
    }

    private static final void startMainFrame$lambda$11(ApplicationRunner this$0) {
        block2: {
            try {
                this$0.setupMacOSDock();
            }
            catch (Exception e) {
                if (!this$0.getLog().isErrorEnabled()) break block2;
                this$0.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        FlatDesktop.setQuitHandler(arg_0 -> ApplicationRunner.startMainFrame$lambda$11$lambda$10(this$0, arg_0));
    }

    private static final void startMainFrame$lambda$12(ApplicationRunner this$0) {
        this$0.setupSystemTray();
    }

    private static final void setupSystemTray$lambda$14$lambda$13(ApplicationRunner this$0) {
        this$0.quitHandler();
    }

    private static final void setupSystemTray$lambda$14(ApplicationRunner this$0, ActionEvent it) {
        SwingUtilities.invokeLater(() -> ApplicationRunner.setupSystemTray$lambda$14$lambda$13(this$0));
    }

    private static final void setupMacOSDock$lambda$17(CountDownLatch $countDownLatch) {
        $countDownLatch.await();
    }

    public static final /* synthetic */ String access$getAnalyticsUserID(ApplicationRunner $this) {
        return $this.getAnalyticsUserID();
    }

    public static final /* synthetic */ Logger access$getLog(ApplicationRunner $this) {
        return $this.getLog();
    }
}

