/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.I18n;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"formatBytes", "", "bytes", "", "formatSeconds", "seconds", "termora"})
public final class ApplicationKt {
    @NotNull
    public static final String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        String[] units = stringArray;
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        double value = (double)bytes / Math.pow(1024.0, exp);
        String string = "%.2f%s";
        Object[] objectArray = new Object[]{value, units[exp]};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String formatSeconds(long seconds) {
        String string;
        long days = seconds / (long)86400;
        long hours = seconds % (long)86400 / (long)3600;
        long minutes = seconds % (long)3600 / (long)60;
        long remainingSeconds = seconds % (long)60;
        if (days > 0L) {
            Object[] objectArray = new Object[]{days, hours, minutes, remainingSeconds};
            string = I18n.INSTANCE.getString("termora.transport.jobs.table.estimated-time-days-format", objectArray);
        } else if (hours > 0L) {
            Object[] objectArray = new Object[]{hours, minutes, remainingSeconds};
            string = I18n.INSTANCE.getString("termora.transport.jobs.table.estimated-time-hours-format", objectArray);
        } else if (minutes > 0L) {
            Object[] objectArray = new Object[]{minutes, remainingSeconds};
            string = I18n.INSTANCE.getString("termora.transport.jobs.table.estimated-time-minutes-format", objectArray);
        } else {
            Object[] objectArray = new Object[]{remainingSeconds};
            string = I18n.INSTANCE.getString("termora.transport.jobs.table.estimated-time-seconds-format", objectArray);
        }
        return string;
    }
}

