/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationRunner;
import app.termora.ApplicationSingleton;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tinylog.configuration.Configuration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lapp/termora/ApplicationInitializr;", "", "<init>", "()V", "run", "", "setupNativeLibraries", "setupTinylog", "checkSingleton", "termora"})
public final class ApplicationInitializr {
    public final void run() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.setupNativeLibraries();
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            System.setProperty("apple.awt.application.name", Application.INSTANCE.getName());
        }
        this.setupTinylog();
        this.checkSingleton();
        new ApplicationRunner().run();
    }

    private final void setupNativeLibraries() {
        String[] stringArray;
        File restart4j;
        String[] stringArray2;
        File jSerialComm;
        String[] stringArray3;
        File pty4j;
        if (!SystemUtils.IS_OS_MAC_OSX) {
            return;
        }
        String appPath = Application.INSTANCE.getAppPath();
        if (StringUtils.isBlank((CharSequence)appPath)) {
            return;
        }
        File file = new File(appPath).getParentFile();
        if (file == null || (file = file.getParentFile()) == null) {
            return;
        }
        File contents = file;
        String[] stringArray4 = new String[]{"app", "dylib"};
        File dylib = FileUtils.getFile((File)contents, (String[])stringArray4);
        if (!dylib.exists()) {
            return;
        }
        String[] stringArray5 = new String[]{"jna"};
        File jna = FileUtils.getFile((File)dylib, (String[])stringArray5);
        if (jna.exists()) {
            System.setProperty("jna.boot.library.path", jna.getAbsolutePath());
        }
        if ((pty4j = FileUtils.getFile((File)dylib, (String[])(stringArray3 = new String[]{"pty4j"}))).exists()) {
            System.setProperty("pty4j.preferred.native.folder", pty4j.getAbsolutePath());
        }
        if ((jSerialComm = FileUtils.getFile((File)dylib, (String[])(stringArray2 = new String[]{"jSerialComm"}))).exists()) {
            System.setProperty("jSerialComm.library.path", jSerialComm.getAbsolutePath());
        }
        if ((restart4j = FileUtils.getFile((File)dylib, (String[])(stringArray = new String[]{"restart4j", "restarter"}))).exists()) {
            System.setProperty("restarter.path", restart4j.getAbsolutePath());
        }
    }

    private final void setupTinylog() {
        if (SystemInfo.isWindows) {
            File dir = new File(Application.INSTANCE.getBaseDataDir(), "logs");
            FileUtils.forceMkdir((File)dir);
            String string = dir.getAbsolutePath();
            String string2 = Application.INSTANCE.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Configuration.set((String)"writer_file.latest", (String)(string + "/" + string2 + ".log"));
            Configuration.set((String)"writer_file.file", (String)(dir.getAbsolutePath() + "/{date:yyyy}-{date:MM}-{date:dd}.log"));
        }
    }

    private final void checkSingleton() {
        if (ApplicationSingleton.Companion.getInstance().isSingleton()) {
            return;
        }
        System.err.println("Program is already running");
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

