/*
 * Decompiled with CFR 0.152.
 */
package cash.z.ecc.android.bip39;

import cash.z.ecc.android.bip39.MnemonicsKt;
import cash.z.ecc.android.bip39.ToSha256Kt;
import cash.z.ecc.android.bip39.WordList;
import cash.z.ecc.android.common.Closeable;
import cash.z.ecc.android.random.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0015\u0016\u0017\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u00a8\u0006\u001a"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics;", "", "<init>", "()V", "PBE_ALGORITHM", "", "DEFAULT_PASSPHRASE", "INTERATION_COUNT", "", "KEY_SIZE", "DEFAULT_LANGUAGE_CODE", "secureRandom", "Lcash/z/ecc/android/random/SecureRandom;", "getSecureRandom$bip39_lib", "()Lcash/z/ecc/android/random/SecureRandom;", "cachedList", "Lcash/z/ecc/android/bip39/WordList;", "getCachedList$annotations", "getCachedWords", "", "languageCode", "MnemonicCode", "WordCount", "ChecksumException", "WordCountException", "InvalidWordException", "bip39-lib"})
public final class Mnemonics {
    @NotNull
    public static final Mnemonics INSTANCE = new Mnemonics();
    @NotNull
    public static final String PBE_ALGORITHM = "PBKDF2WithHmacSHA512";
    @NotNull
    public static final String DEFAULT_PASSPHRASE = "mnemonic";
    public static final int INTERATION_COUNT = 2048;
    public static final int KEY_SIZE = 512;
    @NotNull
    public static final String DEFAULT_LANGUAGE_CODE = "en";
    @NotNull
    private static final SecureRandom secureRandom = new SecureRandom();
    @NotNull
    private static WordList cachedList = new WordList(null, 1, null);

    private Mnemonics() {
    }

    @NotNull
    public final SecureRandom getSecureRandom$bip39_lib() {
        return secureRandom;
    }

    private static /* synthetic */ void getCachedList$annotations() {
    }

    @NotNull
    public final List<String> getCachedWords(@NotNull String languageCode) {
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        if (!Intrinsics.areEqual((Object)cachedList.getLanguageCode(), (Object)languageCode)) {
            cachedList = new WordList(languageCode);
        }
        return cachedList.getWords();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$ChecksumException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "bip39-lib"})
    public static final class ChecksumException
    extends RuntimeException {
        @NotNull
        public static final ChecksumException INSTANCE = new ChecksumException();

        private ChecksumException() {
            super("Error: The checksum failed. Verify that none of the words have been transposed.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\n"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$InvalidWordException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "index", "", "<init>", "(I)V", "word", "", "(Ljava/lang/String;)V", "bip39-lib"})
    public static final class InvalidWordException
    extends RuntimeException {
        public InvalidWordException(int index) {
            super("Error: invalid word encountered at index " + index + ".");
        }

        public InvalidWordException(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            super("Error: <" + word + "> was not found in the word list.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0005\u0018\u0000 &2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001&B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\rB\u001b\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u001e\u001a\u00020\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0096\u0002J\u0006\u0010#\u001a\u00020\u0016J\u0006\u0010$\u001a\u00020\fJ\u0006\u0010%\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$MnemonicCode;", "Lcash/z/ecc/android/common/Closeable;", "", "", "chars", "", "languageCode", "<init>", "([CLjava/lang/String;)V", "phrase", "(Ljava/lang/String;Ljava/lang/String;)V", "entropy", "", "([BLjava/lang/String;)V", "wordCount", "Lcash/z/ecc/android/bip39/Mnemonics$WordCount;", "(Lcash/z/ecc/android/bip39/Mnemonics$WordCount;Ljava/lang/String;)V", "getChars", "()[C", "getLanguageCode", "()Ljava/lang/String;", "close", "", "", "getWordCount", "()I", "words", "", "getWords", "()Ljava/util/List;", "clear", "isEmpty", "", "iterator", "", "validate", "validateChecksum", "toEntropy", "Companion", "bip39-lib"})
    @SourceDebugExtension(value={"SMAP\nMnemonics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$MnemonicCode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,378:1\n12806#2,3:379\n13554#2,3:383\n18817#2,2:388\n13554#2,2:390\n13556#2:395\n1#3:382\n37#4,2:386\n774#5:392\n865#5,2:393\n1863#5,2:396\n*S KotlinDebug\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$MnemonicCode\n*L\n64#1:379,3\n75#1:383,3\n112#1:388,2\n120#1:390,2\n120#1:395\n112#1:386,2\n128#1:392\n128#1:393,2\n167#1:396,2\n*E\n"})
    public static final class MnemonicCode
    implements Closeable,
    Iterable<String>,
    KMappedMarker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final char[] chars;
        @NotNull
        private final String languageCode;

        public MnemonicCode(@NotNull char[] chars, @NotNull String languageCode) {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
            this.chars = chars;
            this.languageCode = languageCode;
        }

        public /* synthetic */ MnemonicCode(char[] cArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = Mnemonics.DEFAULT_LANGUAGE_CODE;
            }
            this(cArray, string);
        }

        @NotNull
        public final char[] getChars() {
            return this.chars;
        }

        @NotNull
        public final String getLanguageCode() {
            return this.languageCode;
        }

        public MnemonicCode(@NotNull String phrase, @NotNull String languageCode) {
            Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
            Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
            char[] cArray = phrase.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            this(cArray, languageCode);
        }

        public /* synthetic */ MnemonicCode(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = Mnemonics.DEFAULT_LANGUAGE_CODE;
            }
            this(string, string2);
        }

        public MnemonicCode(@NotNull byte[] entropy, @NotNull String languageCode) {
            Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
            Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
            this(Companion.computeSentence$default(Companion, entropy, null, 2, null), languageCode);
        }

        public /* synthetic */ MnemonicCode(byte[] byArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = Mnemonics.DEFAULT_LANGUAGE_CODE;
            }
            this(byArray, string);
        }

        public MnemonicCode(@NotNull WordCount wordCount, @NotNull String languageCode) {
            Intrinsics.checkNotNullParameter((Object)((Object)wordCount), (String)"wordCount");
            Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
            this(Companion.computeSentence$default(Companion, MnemonicsKt.toEntropy(wordCount), null, 2, null), languageCode);
        }

        public /* synthetic */ MnemonicCode(WordCount wordCount, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = Mnemonics.DEFAULT_LANGUAGE_CODE;
            }
            this(wordCount, string);
        }

        @Override
        public void close() {
            this.clear();
        }

        public final int getWordCount() {
            char[] $this$count$iv = this.chars;
            boolean $i$f$count = false;
            int count$iv = 0;
            int n = $this$count$iv.length;
            for (int i = 0; i < n; ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv[i];
                boolean bl = false;
                if (!(it == ' ')) continue;
                ++count$iv;
            }
            int it = count$iv;
            boolean bl = false;
            return it == 0 ? it : it + 1;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<char[]> getWords() {
            ArrayList<char[]> arrayList;
            ArrayList<char[]> $this$_get_words__u24lambda_u243 = arrayList = new ArrayList<char[]>(this.getWordCount());
            boolean bl = false;
            int cursor = 0;
            char[] $this$forEachIndexed$iv = this.chars;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (char item$iv : $this$forEachIndexed$iv) {
                void c;
                int n = index$iv++;
                char c2 = item$iv;
                int i = n;
                boolean bl2 = false;
                if (c != 32 && i != ArraysKt.getLastIndex((char[])this.chars)) continue;
                char[] cArray = this.chars;
                int n2 = cursor;
                int n3 = CharsKt.isWhitespace((char)this.chars[i]) ? i : i + 1;
                $this$_get_words__u24lambda_u243.add(ArraysKt.copyOfRange((char[])cArray, (int)n2, (int)n3));
                cursor = i + 1;
            }
            return arrayList;
        }

        public final void clear() {
            ArraysKt.fill$default((char[])this.chars, (char)'\u0000', (int)0, (int)0, (int)6, null);
        }

        public final boolean isEmpty() {
            return this.chars.length == 0;
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return new Iterator<String>(this){
                private int cursor;
                final /* synthetic */ MnemonicCode this$0;
                {
                    this.this$0 = $receiver;
                }

                public final int getCursor() {
                    return this.cursor;
                }

                public final void setCursor(int n) {
                    this.cursor = n;
                }

                public boolean hasNext() {
                    return this.cursor < this.this$0.getChars().length - 1;
                }

                public String next() {
                    int nextSpaceIndex = this.nextSpaceIndex();
                    String word = StringsKt.concatToString((char[])this.this$0.getChars(), (int)this.cursor, (int)(this.cursor + (nextSpaceIndex - this.cursor)));
                    this.cursor = nextSpaceIndex + 1;
                    return word;
                }

                private final int nextSpaceIndex() {
                    for (int i = this.cursor; i < this.this$0.getChars().length - 1; ++i) {
                        if (!CharsKt.isWhitespace((char)this.this$0.getChars()[i])) continue;
                        return i;
                    }
                    return this.this$0.getChars().length;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public final void validate() {
            boolean bl;
            int wordCount;
            block6: {
                wordCount = this.getWordCount();
                boolean bl2 = false;
                Collection $this$toTypedArray$iv = (Collection)WordCount.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                WordCount[] $this$none$iv = thisCollection$iv.toArray(new WordCount[0]);
                boolean $i$f$none = false;
                int n = $this$none$iv.length;
                for (int i = 0; i < n; ++i) {
                    WordCount element$iv;
                    WordCount it = element$iv = $this$none$iv[i];
                    boolean bl3 = false;
                    if (!(it.getCount() == wordCount)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            if (bl) {
                throw new WordCountException(wordCount);
            }
            Ref.ObjectRef sublist = new Ref.ObjectRef();
            sublist.element = INSTANCE.getCachedWords(this.languageCode);
            int nextLetter = 0;
            char[] $this$forEachIndexed$iv = this.chars;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (char item$iv : $this$forEachIndexed$iv) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void c;
                int n = index$iv++;
                char it = item$iv;
                int i = n;
                boolean bl4 = false;
                if (c == 32) {
                    sublist.element = INSTANCE.getCachedWords(this.languageCode);
                    nextLetter = 0;
                    continue;
                }
                Iterable iterable = (Iterable)sublist.element;
                Ref.ObjectRef objectRef = sublist;
                boolean $i$f$filter = false;
                void var15_21 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl5 = false;
                    if (!(it2.length() > nextLetter && it2.charAt(nextLetter) == c)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                objectRef.element = (List)destination$iv$iv;
                if (((List)sublist.element).isEmpty()) {
                    throw new InvalidWordException(i);
                }
                int n2 = nextLetter;
                nextLetter = n2 + 1;
            }
            this.validateChecksum();
        }

        @NotNull
        public final byte[] validateChecksum() {
            return this.toEntropy();
        }

        @NotNull
        public final byte[] toEntropy() {
            int it = this.getWordCount();
            boolean bl = false;
            if (it <= 0 || it % 3 > 0) {
                throw new WordCountException(this.getWordCount());
            }
            int totalLengthBits = this.getWordCount() * 11;
            int checksumLengthBits = totalLengthBits / 33;
            byte[] entropy = new byte[(totalLengthBits - checksumLengthBits) / 8];
            List checksumBits = new ArrayList();
            List<String> words = INSTANCE.getCachedWords(this.languageCode);
            int bitsProcessed = 0;
            byte nextByte = 0;
            Iterable $this$forEach$iv = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl2 = false;
                int phraseIndex = CollectionsKt.binarySearch$default(words, (Comparable)((Comparable)((Object)it2)), (int)0, (int)0, (int)6, null);
                boolean bl3 = false;
                if (phraseIndex < 0) {
                    throw new InvalidWordException(it2);
                }
                for (int i = 10; -1 < i; --i) {
                    boolean bit;
                    boolean bl4 = bit = (phraseIndex & 1 << i) != 0;
                    if (bit) {
                        nextByte = (byte)(nextByte | (byte)(1 << 7 - bitsProcessed % 8));
                    }
                    int entropyIndex = (++bitsProcessed - 1) / 8;
                    if (bitsProcessed % 8 == 0 && entropyIndex < entropy.length) {
                        entropy[entropyIndex] = nextByte;
                        nextByte = 0;
                        continue;
                    }
                    if (entropyIndex < entropy.length) continue;
                    checksumBits.add(bit);
                }
            }
            List hashFirstByteBits = MnemonicsKt.access$toBits(ToSha256Kt.toSha256(entropy)[0]);
            boolean bl5 = false;
            int n = 0;
            while (n < checksumLengthBits) {
                int i = n++;
                boolean bl6 = false;
                if (((Boolean)hashFirstByteBits.get(i)).booleanValue() == ((Boolean)checksumBits.get(i)).booleanValue()) continue;
                throw ChecksumException.INSTANCE;
            }
            return entropy;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$MnemonicCode$Companion;", "", "<init>", "()V", "computeSentence", "", "entropy", "", "languageCode", "", "bip39-lib"})
        @SourceDebugExtension(value={"SMAP\nMnemonics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$MnemonicCode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,378:1\n1863#2,2:379\n1#3:381\n1179#4,2:382\n*S KotlinDebug\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$MnemonicCode$Companion\n*L\n252#1:379,2\n240#1:382,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final char[] computeSentence(byte[] entropy, String languageCode) {
                char[] cArray;
                ArrayList<Character> arrayList;
                Ref.IntRef index = new Ref.IntRef();
                Ref.IntRef bitsProcessed = new Ref.IntRef();
                List<String> words = INSTANCE.getCachedWords(languageCode);
                byte checksum = ToSha256Kt.toSha256(entropy)[0];
                List bits = MnemonicsKt.access$toBits(ArraysKt.plus((byte[])entropy, (byte)checksum));
                boolean bl = false;
                ArrayList<Character> chars = arrayList = new ArrayList<Character>(entropy.length * 3 / 4);
                boolean bl2 = false;
                Iterable $this$forEach$iv = bits;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl3 = false;
                    cash.z.ecc.android.bip39.Mnemonics$MnemonicCode$Companion.computeSentence$processBit(index, bitsProcessed, words, it, chars);
                }
                chars.remove(CollectionsKt.getLastIndex((List)chars));
                ArrayList<Character> result = arrayList;
                boolean bl4 = false;
                char[] it = cArray = CollectionsKt.toCharArray((Collection)result);
                boolean bl5 = false;
                result.clear();
                return cArray;
            }

            static /* synthetic */ char[] computeSentence$default(Companion companion, byte[] byArray, String string, int n, Object object) {
                if ((n & 2) != 0) {
                    string = Mnemonics.DEFAULT_LANGUAGE_CODE;
                }
                return companion.computeSentence(byArray, string);
            }

            private static final void computeSentence$processBit(Ref.IntRef index, Ref.IntRef bitsProcessed, List<String> words, boolean bit, ArrayList<Character> chars) {
                index.element <<= 1;
                if (bit) {
                    index.element |= 1;
                }
                ++bitsProcessed.element;
                if (bitsProcessed.element % 11 == 0) {
                    CharSequence $this$forEach$iv = words.get(index.element);
                    boolean $i$f$forEach = false;
                    for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$forEach$iv.charAt(i);
                        boolean bl = false;
                        chars.add(Character.valueOf(it));
                    }
                    chars.add(Character.valueOf(' '));
                    index.element = 0;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u0010"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$WordCount;", "", "count", "", "<init>", "(Ljava/lang/String;II)V", "getCount", "()I", "COUNT_12", "COUNT_15", "COUNT_18", "COUNT_21", "COUNT_24", "bitLength", "getBitLength", "Companion", "bip39-lib"})
    public static final class WordCount
    extends Enum<WordCount> {
        @NotNull
        public static final Companion Companion;
        private final int count;
        private final int bitLength;
        public static final /* enum */ WordCount COUNT_12;
        public static final /* enum */ WordCount COUNT_15;
        public static final /* enum */ WordCount COUNT_18;
        public static final /* enum */ WordCount COUNT_21;
        public static final /* enum */ WordCount COUNT_24;
        private static final /* synthetic */ WordCount[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private WordCount(int count) {
            this.count = count;
            this.bitLength = this.count / 3 * 32;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getBitLength() {
            return this.bitLength;
        }

        public static WordCount[] values() {
            return (WordCount[])$VALUES.clone();
        }

        public static WordCount valueOf(String value) {
            return Enum.valueOf(WordCount.class, value);
        }

        @NotNull
        public static EnumEntries<WordCount> getEntries() {
            return $ENTRIES;
        }

        static {
            COUNT_12 = new WordCount(12);
            COUNT_15 = new WordCount(15);
            COUNT_18 = new WordCount(18);
            COUNT_21 = new WordCount(21);
            COUNT_24 = new WordCount(24);
            $VALUES = wordCountArray = new WordCount[]{WordCount.COUNT_12, WordCount.COUNT_15, WordCount.COUNT_18, WordCount.COUNT_21, WordCount.COUNT_24};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$WordCount$Companion;", "", "<init>", "()V", "valueOf", "Lcash/z/ecc/android/bip39/Mnemonics$WordCount;", "count", "", "bip39-lib"})
        @SourceDebugExtension(value={"SMAP\nMnemonics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$WordCount$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,378:1\n1863#2,2:379\n*S KotlinDebug\n*F\n+ 1 Mnemonics.kt\ncash/z/ecc/android/bip39/Mnemonics$WordCount$Companion\n*L\n289#1:379,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final WordCount valueOf(int count) {
                Iterable $this$forEach$iv = (Iterable)WordCount.getEntries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WordCount it = (WordCount)((Object)element$iv);
                    boolean bl = false;
                    if (it.getCount() != count) continue;
                    return it;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcash/z/ecc/android/bip39/Mnemonics$WordCountException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "count", "", "<init>", "(I)V", "bip39-lib"})
    public static final class WordCountException
    extends RuntimeException {
        public WordCountException(int count) {
            super("Error: " + count + " is an invalid word count.");
        }
    }
}

