/*
 * Decompiled with CFR 0.152.
 */
package jnafilechooser.api;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.awt.Window;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jnafilechooser.win32.Comdlg32;

public class WindowsFileChooser {
    public static final int MAX_PATH = 260;
    protected File selectedFile;
    protected File currentDirectory;
    protected ArrayList<String[]> filters = new ArrayList();
    protected String defaultFilename = "";
    protected String dialogTitle = "";
    private int filterIndex = 1;
    private boolean addToRecent = false;
    private boolean multipleSelection = false;
    private int maxNumberOfFiles = 10000;
    private File[] selectedFiles = null;

    public WindowsFileChooser() {
    }

    public WindowsFileChooser(File currentDirectory) {
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    public WindowsFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath != null ? new File(currentDirectoryPath) : null);
    }

    void setFilters(ArrayList<String[]> filters) {
        this.filters = filters;
    }

    public void addFilter(String name, String ... filter) {
        if (filter.length < 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(name);
        Collections.addAll(parts, filter);
        this.filters.add(parts.toArray(new String[0]));
    }

    public void setTitle(String title) {
        this.dialogTitle = title;
    }

    public boolean showOpenDialog(Window parent) {
        return this.showDialog(parent, true);
    }

    public boolean showSaveDialog(Window parent) {
        return this.showDialog(parent, false);
    }

    boolean showDialog(Window parent, boolean open) {
        Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
        params.Flags = 0x88000C;
        Pointer pointer = params.hwndOwner = parent == null ? null : Native.getWindowPointer((Window)parent);
        if (!this.addToRecent) {
            params.Flags |= 0x2000000;
        }
        if (this.multipleSelection) {
            params.Flags |= 0x200;
        }
        int bufferLength = this.multipleSelection ? this.maxNumberOfFiles * 260 : 260;
        int bufferSize = 4 * bufferLength + 1;
        params.lpstrFile = new Memory((long)bufferSize);
        if (!this.defaultFilename.isEmpty()) {
            params.lpstrFile.setWideString(0L, this.defaultFilename);
        } else {
            params.lpstrFile.clear((long)bufferSize);
        }
        if (!this.dialogTitle.isEmpty()) {
            params.lpstrTitle = new WString(this.dialogTitle);
        }
        params.nMaxFile = bufferLength;
        if (this.currentDirectory != null) {
            params.lpstrInitialDir = new WString(this.currentDirectory.getAbsolutePath());
        }
        if (!this.filters.isEmpty()) {
            params.lpstrFilter = new WString(this.buildFilterString());
            params.nFilterIndex = this.filterIndex;
        }
        boolean approved = open ? Comdlg32.GetOpenFileNameW((Comdlg32.OpenFileName)params) : Comdlg32.GetSaveFileNameW((Comdlg32.OpenFileName)params);
        this.selectedFiles = null;
        if (approved) {
            this.filterIndex = params.nFilterIndex;
            if (this.multipleSelection) {
                byte[] bytes = params.lpstrFile.getByteArray(0L, bufferSize);
                List<String> filePaths = WindowsFileChooser.bytesToFilePaths(bytes);
                if (filePaths.size() == 1) {
                    this.selectedFile = new File(filePaths.get(0));
                    this.currentDirectory = this.selectedFile.getParentFile();
                    this.selectedFiles = new File[1];
                    this.selectedFiles[0] = this.selectedFile;
                } else if (filePaths.size() > 1) {
                    this.selectedFiles = new File[filePaths.size() - 1];
                    this.currentDirectory = new File(filePaths.get(0));
                    for (int i = 1; i < filePaths.size(); ++i) {
                        this.selectedFiles[i - 1] = new File(this.currentDirectory, filePaths.get(i));
                    }
                    this.selectedFile = this.selectedFiles[0];
                }
            } else {
                String filePath = params.lpstrFile.getWideString(0L);
                this.selectedFile = new File(filePath);
                this.currentDirectory = this.selectedFile.getParentFile();
                this.selectedFiles = new File[1];
                this.selectedFiles[0] = this.selectedFile;
            }
        } else {
            int errCode = Comdlg32.CommDlgExtendedError();
            if (errCode != 0) {
                throw new RuntimeException("GetOpenFileName failed with error " + errCode);
            }
        }
        return approved;
    }

    private String buildFilterString() {
        StringBuilder filterStr = new StringBuilder();
        for (String[] spec : this.filters) {
            String label = spec[0];
            filterStr.append(label);
            filterStr.append('\u0000');
            for (int i = 1; i < spec.length; ++i) {
                filterStr.append("*.");
                filterStr.append(spec[i]);
                filterStr.append(';');
            }
            filterStr.deleteCharAt(filterStr.length() - 1);
            filterStr.append('\u0000');
        }
        filterStr.append('\u0000');
        return filterStr.toString();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setDefaultFilename(String defaultFilename) {
        this.defaultFilename = defaultFilename;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public void setFilterIndex(int filterIndex) {
        this.filterIndex = filterIndex;
    }

    public boolean isAddToRecent() {
        return this.addToRecent;
    }

    public void setAddToRecent(boolean addToRecent) {
        this.addToRecent = addToRecent;
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultiSelectionEnabled(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public int getMaxNumberOfFiles() {
        return this.maxNumberOfFiles;
    }

    public void setMaxNumberOfFiles(int maxNumberOfFiles) {
        this.maxNumberOfFiles = maxNumberOfFiles;
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public static List<String> bytesToFilePaths(byte[] bytes) {
        ArrayList<String> filePaths = new ArrayList<String>();
        int from = 0;
        for (int i = 0; i < bytes.length - 1; i += 2) {
            if (bytes[i] != 0 || bytes[i + 1] != 0) continue;
            if (i <= from) break;
            filePaths.add(new String(Arrays.copyOfRange(bytes, from, i), StandardCharsets.UTF_16LE));
            from = i + 2;
        }
        return filePaths;
    }
}

