/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.util.PtyUtil;
import com.pty4j.windows.conpty.WinEx;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0013"}, d2={"Lcom/pty4j/windows/conpty/ConPtyLibrary;", "Lcom/sun/jna/Library;", "CreatePseudoConsole", "Lcom/sun/jna/platform/win32/WinNT$HRESULT;", "size", "Lcom/pty4j/windows/conpty/WinEx$COORDByValue;", "hInput", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "hOutput", "dwFlags", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "phPC", "Lcom/pty4j/windows/conpty/WinEx$HPCONByReference;", "ClosePseudoConsole", "", "hPC", "Lcom/pty4j/windows/conpty/WinEx$HPCON;", "ResizePseudoConsole", "Companion", "pty4j"})
public interface ConPtyLibrary
extends Library {
    @NotNull
    public static final Companion Companion = com.pty4j.windows.conpty.ConPtyLibrary$Companion.$$INSTANCE;

    @NotNull
    public WinNT.HRESULT CreatePseudoConsole(@NotNull WinEx.COORDByValue var1, @NotNull WinNT.HANDLE var2, @NotNull WinNT.HANDLE var3, @NotNull WinDef.DWORD var4, @NotNull WinEx.HPCONByReference var5);

    public void ClosePseudoConsole(@NotNull WinEx.HPCON var1);

    @NotNull
    public WinNT.HRESULT ResizePseudoConsole(@NotNull WinEx.HPCON var1, @NotNull WinEx.COORDByValue var2);

    @NotNull
    public static ConPtyLibrary getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u00020\t8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/pty4j/windows/conpty/ConPtyLibrary$Companion;", "", "<init>", "()V", "CONPTY", "", "KERNEL32", "DISABLE_BUNDLED_CONPTY_PROP_NAME", "instance", "Lcom/pty4j/windows/conpty/ConPtyLibrary;", "getInstance$annotations", "getInstance", "()Lcom/pty4j/windows/conpty/ConPtyLibrary;", "instance$delegate", "Lkotlin/Lazy;", "shouldUseSystemConPty", "", "osName", "pty4j"})
    @SourceDebugExtension(value={"SMAP\nConPtyLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConPtyLibrary.kt\ncom/pty4j/windows/conpty/ConPtyLibrary$Companion\n+ 2 logger.kt\ncom/pty4j/util/LoggerKt\n*L\n1#1,59:1\n6#2:60\n6#2:61\n6#2:62\n*S KotlinDebug\n*F\n+ 1 ConPtyLibrary.kt\ncom/pty4j/windows/conpty/ConPtyLibrary$Companion\n*L\n36#1:60\n40#1:61\n48#1:62\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String CONPTY = "conpty.dll";
        @NotNull
        private static final String KERNEL32 = "kernel32";
        @NotNull
        private static final String DISABLE_BUNDLED_CONPTY_PROP_NAME = "com.pty4j.windows.disable.bundled.conpty";
        @NotNull
        private static final Lazy<ConPtyLibrary> instance$delegate;

        private Companion() {
        }

        @NotNull
        public final ConPtyLibrary getInstance() {
            Lazy<ConPtyLibrary> lazy = instance$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (ConPtyLibrary)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final boolean shouldUseSystemConPty(String osName) {
            String string = osName;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String lowerCasedOsName = string2;
            return Intrinsics.areEqual((Object)"windows server 2019", (Object)lowerCasedOsName) || Intrinsics.areEqual((Object)"windows server 2016", (Object)lowerCasedOsName);
        }

        private static final ConPtyLibrary instance_delegate$lambda$0() {
            ConPtyLibrary conPtyLibrary;
            String osName = System.getProperty("os.name");
            Intrinsics.checkNotNull((Object)osName);
            if ($$INSTANCE.shouldUseSystemConPty(osName)) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.info("Loading bundled conpty.dll is disabled on " + osName + " due to missing icu.dll");
                return (ConPtyLibrary)Native.load((String)KERNEL32, ConPtyLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            }
            if (Boolean.parseBoolean(System.getProperty(DISABLE_BUNDLED_CONPTY_PROP_NAME))) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Loading bundled conpty.dll is disabled by 'com.pty4j.windows.disable.bundled.conpty'");
                return (ConPtyLibrary)Native.load((String)KERNEL32, ConPtyLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            }
            try {
                File file = PtyUtil.resolveNativeFile(CONPTY);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveNativeFile(...)");
                File bundledConptyDll = file;
                conPtyLibrary = (ConPtyLibrary)Native.load((String)bundledConptyDll.getAbsolutePath(), ConPtyLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            }
            catch (Throwable e) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Failed to load bundled conpty.dll, fallback to kernel32", e);
                conPtyLibrary = (ConPtyLibrary)Native.load((String)KERNEL32, ConPtyLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            }
            return conPtyLibrary;
        }

        static {
            $$INSTANCE = new Companion();
            instance$delegate = LazyKt.lazy(Companion::instance_delegate$lambda$0);
        }
    }
}

