/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;

public class JarFileObject
extends ZipFileObject {
    private final JarFileSystem fs;
    private Attributes attributes;

    protected JarFileObject(AbstractFileName fileName, ZipEntry entry, JarFileSystem fileSystem, boolean zipExists) throws FileSystemException {
        super(fileName, entry, fileSystem, zipExists);
        if (entry != null) {
            ((JarEntry)entry).getCertificates();
        }
        this.fs = fileSystem;
        try {
            this.getAttributes();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    private void addAll(Attributes src, Map<String, Object> dest) {
        src.forEach((? super K k, ? super V v) -> dest.put(String.valueOf(k), v));
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        JarFileSystem fs = (JarFileSystem)this.getFileSystem();
        this.addAll(fs.getAttributes(), attrs);
        this.addAll(this.getAttributes(), attrs);
        return attrs;
    }

    @Override
    protected Certificate[] doGetCertificates() {
        if (this.entry == null) {
            return null;
        }
        return ((JarEntry)this.entry).getCertificates();
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            if (this.entry == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = ((JarEntry)this.entry).getAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    Manifest getManifest() throws IOException {
        if (this.fs.getZipFile() == null) {
            return null;
        }
        return ((JarFile)this.fs.getZipFile()).getManifest();
    }
}

