/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;

    protected FileObject findFile(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(fileName, "/");
        return this.getFileSystem(rootName, fileSystemOptions).resolveFile(fileName);
    }

    @Override
    public FileObject findFile(FileObject baseFileObject, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFileObject != null ? baseFileObject.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    protected synchronized FileSystem getFileSystem(FileName rootFileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fs = this.findFileSystem(rootFileName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootFileName, fileSystemOptions);
            this.addFileSystem(rootFileName, fs);
        }
        return fs;
    }
}

